/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;

public class ToggleStepFiltersActionDelegate
extends AbstractDebugActionDelegate
implements IActionDelegate2,
IPropertyChangeListener {
    protected void doAction(Object element) {
    }

    public void init(IAction action) {
        this.setAction(action);
        action.setChecked(this.isUseStepFilters());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private boolean isUseStepFilters() {
        return DebugUIPlugin.getDefault().getStepFilterManager().isUseStepFilters();
    }

    private IPreferenceStore getPreferenceStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IInternalDebugUIConstants.PREF_USE_STEP_FILTERS)) {
            Object newValue = event.getNewValue();
            if (newValue instanceof Boolean) {
                this.getAction().setChecked(((Boolean)newValue).booleanValue());
            } else if (newValue instanceof String) {
                this.getAction().setChecked(Boolean.getBoolean((String)newValue));
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void run(IAction action) {
        DebugUITools.setUseStepFilters(action.isChecked());
    }

    protected boolean initialize(IAction action, ISelection selection) {
        boolean res = super.initialize(action, selection);
        this.init(action);
        return res;
    }

    protected void update(IAction action, ISelection s) {
        IStructuredSelection ss;
        boolean enabled = true;
        if (s != null && !s.isEmpty() && s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).size() == 1 && ss.getFirstElement() instanceof IDebugElement) {
            IDebugElement element = (IDebugElement)ss.getFirstElement();
            IDebugTarget target = element.getDebugTarget();
            if (target instanceof IStepFilters) {
                IStepFilters filters = (IStepFilters)target;
                enabled = filters.supportsStepFilters();
            } else {
                enabled = false;
            }
        }
        action.setEnabled(enabled);
    }
}

