/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.build;

import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.build.BuildEntry;
import org.eclipse.pde.internal.core.build.BuildObject;

public class Build
extends BuildObject
implements IBuild {
    protected Vector entries = new Vector();

    public void add(IBuildEntry entry) throws CoreException {
        this.ensureModelEditable();
        this.entries.add(entry);
        ((BuildEntry)entry).setInTheModel(true);
        this.getModel().fireModelChanged(new ModelChangedEvent(this.getModel(), 1, new Object[]{entry}, null));
    }

    public IBuildEntry[] getBuildEntries() {
        Object[] result = new IBuildEntry[this.entries.size()];
        this.entries.copyInto(result);
        return result;
    }

    public IBuildEntry getEntry(String name) {
        int i = 0;
        while (i < this.entries.size()) {
            IBuildEntry entry = (IBuildEntry)this.entries.elementAt(i);
            if (entry.getName().equals(name)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public void processEntry(String name, String value) {
        BuildEntry entry = (BuildEntry)this.getModel().getFactory().createEntry(name);
        this.entries.add(entry);
        entry.processEntry(value);
    }

    public void remove(IBuildEntry entry) throws CoreException {
        this.ensureModelEditable();
        this.entries.remove(entry);
        this.getModel().fireModelChanged(new ModelChangedEvent(this.getModel(), 2, new Object[]{entry}, null));
    }

    public void reset() {
        this.entries.clear();
    }

    public void write(String indent, PrintWriter writer) {
        int i = 0;
        while (i < this.entries.size()) {
            IBuildEntry entry = (IBuildEntry)this.entries.elementAt(i);
            entry.write("", writer);
            ++i;
        }
    }
}

