/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.PseudoJavaChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

class ChangeElementLabelProvider
extends LabelProvider {
    private Map fDescriptorImageMap = new HashMap();
    private boolean fShowQualification = true;
    static /* synthetic */ Class class$0;

    public void setShowQualification(boolean showQualification) {
        this.fShowQualification = showQualification;
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
        this.fireLabelProviderChanged(event);
    }

    public Image getImage(Object object) {
        if (object instanceof DefaultChangeElement) {
            Change element = ((DefaultChangeElement)object).getChange();
            return this.doGetImage(element);
        }
        if (object instanceof TextEditChangeElement) {
            TextEditChangeGroup element = ((TextEditChangeElement)object).getTextEditChange();
            return this.doGetImage(element);
        }
        if (object instanceof PseudoJavaChangeElement) {
            IWorkbenchAdapter adapter;
            PseudoJavaChangeElement element = (PseudoJavaChangeElement)object;
            IJavaElement jElement = element.getJavaElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)jElement.getAdapter((Class)clazz)) != null) {
                return this.manageImageDescriptor(adapter.getImageDescriptor((Object)jElement));
            }
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof DefaultChangeElement) {
            Change change = ((DefaultChangeElement)object).getChange();
            if (!this.fShowQualification) {
                return change.getName();
            }
            if (change instanceof TextFileChange) {
                IFile file = ((TextFileChange)change).getFile();
                return RefactoringUIMessages.getFormattedString("PreviewWizardPage.changeElementLabelProvider.textFormat", new String[]{file.getName(), this.getPath(file)});
            }
            return change.getName();
        }
        if (object instanceof TextEditChangeElement) {
            TextEditChangeElement element = (TextEditChangeElement)object;
            String result = element.getTextEditChange().getName();
            return result;
        }
        if (object instanceof PseudoJavaChangeElement) {
            IWorkbenchAdapter adapter;
            PseudoJavaChangeElement element = (PseudoJavaChangeElement)object;
            IJavaElement jElement = element.getJavaElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)jElement.getAdapter((Class)clazz)) != null) {
                return adapter.getLabel((Object)jElement);
            }
        }
        return super.getText(object);
    }

    public void dispose() {
        Iterator iter = this.fDescriptorImageMap.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        super.dispose();
    }

    private Image doGetImage(Object element) {
        ImageDescriptor descriptor = null;
        if (descriptor == null) {
            descriptor = element instanceof TextEditChangeElement ? RefactoringPluginImages.DESC_OBJS_TEXT_EDIT : (element instanceof CompositeChange ? RefactoringPluginImages.DESC_OBJS_COMPOSITE_CHANGE : (element instanceof TextFileChange ? RefactoringPluginImages.DESC_OBJS_FILE_CHANGE : RefactoringPluginImages.DESC_OBJS_DEFAULT_CHANGE));
        }
        return this.manageImageDescriptor(descriptor);
    }

    private Image manageImageDescriptor(ImageDescriptor descriptor) {
        Image image = (Image)this.fDescriptorImageMap.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.fDescriptorImageMap.put(descriptor, image);
        }
        return image;
    }

    private String getPath(IFile file) {
        StringBuffer result = new StringBuffer(file.getProject().getName());
        String projectRelativePath = file.getParent().getProjectRelativePath().toString();
        if (projectRelativePath.length() > 0) {
            result.append('/');
            result.append(projectRelativePath);
        }
        return result.toString();
    }
}

