/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.io.File;
import java.net.URL;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;

public abstract class AbstractVMInstall
implements IVMInstall {
    private IVMInstallType fType;
    private String fId;
    private String fName;
    private File fInstallLocation;
    private LibraryLocation[] fSystemLibraryDescriptions;
    private URL fJavadocLocation;
    private String[] fVMArgs;
    private boolean fNotify = true;

    public AbstractVMInstall(IVMInstallType type, String id) {
        if (type == null) {
            throw new IllegalArgumentException(LaunchingMessages.getString("vmInstall.assert.typeNotNull"));
        }
        if (id == null) {
            throw new IllegalArgumentException(LaunchingMessages.getString("vmInstall.assert.idNotNull"));
        }
        this.fType = type;
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        if (!name.equals(this.fName)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, IVMInstallChangedListener.PROPERTY_NAME, this.fName, name);
            this.fName = name;
            if (this.fNotify) {
                JavaRuntime.fireVMChanged(event);
            }
        }
    }

    public File getInstallLocation() {
        return this.fInstallLocation;
    }

    public void setInstallLocation(File installLocation) {
        if (!installLocation.equals(this.fInstallLocation)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, IVMInstallChangedListener.PROPERTY_INSTALL_LOCATION, this.fInstallLocation, installLocation);
            this.fInstallLocation = installLocation;
            if (this.fNotify) {
                JavaRuntime.fireVMChanged(event);
            }
        }
    }

    public IVMInstallType getVMInstallType() {
        return this.fType;
    }

    public IVMRunner getVMRunner(String mode) {
        return null;
    }

    public LibraryLocation[] getLibraryLocations() {
        return this.fSystemLibraryDescriptions;
    }

    public void setLibraryLocations(LibraryLocation[] locations) {
        LibraryLocation[] prevLocations;
        if (locations == this.fSystemLibraryDescriptions) {
            return;
        }
        LibraryLocation[] newLocations = locations;
        if (newLocations == null) {
            newLocations = this.getVMInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        }
        if ((prevLocations = this.fSystemLibraryDescriptions) == null) {
            prevLocations = this.getVMInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        }
        if (newLocations.length == prevLocations.length) {
            int i = 0;
            boolean equal = true;
            while (i < newLocations.length && equal) {
                equal = newLocations[i].equals(prevLocations[i]);
                ++i;
            }
            if (equal) {
                return;
            }
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, IVMInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS, prevLocations, newLocations);
        this.fSystemLibraryDescriptions = locations;
        if (this.fNotify) {
            JavaRuntime.fireVMChanged(event);
        }
    }

    public URL getJavadocLocation() {
        return this.fJavadocLocation;
    }

    public void setJavadocLocation(URL url) {
        if (url == this.fJavadocLocation) {
            return;
        }
        if (url != null && this.fJavadocLocation != null && url.equals(this.fJavadocLocation)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, IVMInstallChangedListener.PROPERTY_JAVADOC_LOCATION, this.fJavadocLocation, url);
        this.fJavadocLocation = url;
        if (this.fNotify) {
            JavaRuntime.fireVMChanged(event);
        }
    }

    protected void setNotify(boolean notify) {
        this.fNotify = notify;
    }

    public boolean equals(Object object) {
        if (object instanceof IVMInstall) {
            IVMInstall vm = (IVMInstall)object;
            return this.getVMInstallType().equals(vm.getVMInstallType()) && this.getId().equals(vm.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getVMInstallType().hashCode() + this.getId().hashCode();
    }

    public String[] getVMArguments() {
        return this.fVMArgs;
    }

    public void setVMArguments(String[] vmArgs) {
        this.fVMArgs = vmArgs;
    }
}

