/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CharsetManager
implements IManager {
    protected final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    public static final String ENCODING_PREF_NODE = "encoding";
    private static final String PROJECT_KEY = "<project>";
    CharsetManagerJob job;
    private IResourceChangeListener listener;
    Workspace workspace;

    public CharsetManager(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getCharsetFor(IPath resourcePath) {
        return this.getCharsetFor(resourcePath, false);
    }

    public String getCharsetFor(IPath resourcePath, boolean recurse) {
        Assert.isLegal(resourcePath.segmentCount() >= 1);
        IProject project = this.workspace.getRoot().getProject(resourcePath.segment(0));
        Preferences encodingSettings = this.getPreferences(project);
        return this.internalGetCharsetFor(resourcePath, encodingSettings, recurse);
    }

    /*
     * Unable to fully structure code
     */
    private String internalGetCharsetFor(IPath resourcePath, Preferences encodingSettings, boolean recurse) {
        charset = encodingSettings.get(this.getKeyFor(resourcePath), null);
        if (recurse) ** GOTO lbl6
        return charset;
lbl-1000:
        // 1 sources

        {
            resourcePath = resourcePath.removeLastSegments(1);
            charset = encodingSettings.get(this.getKeyFor(resourcePath), null);
lbl6:
            // 2 sources

            ** while (charset == null && resourcePath.segmentCount() > 1)
        }
lbl7:
        // 1 sources

        return charset == null ? ResourcesPlugin.getEncoding() : charset;
    }

    String getKeyFor(IPath resourcePath) {
        return resourcePath.segmentCount() > 1 ? resourcePath.removeFirstSegments(1).toString() : PROJECT_KEY;
    }

    Preferences getPreferences(IProject project) {
        return new ProjectScope(project).getNode("org.eclipse.core.resources").node(ENCODING_PREF_NODE);
    }

    public void setCharsetFor(IPath resourcePath, String newCharset) throws CoreException {
        Assert.isLegal(resourcePath.segmentCount() >= 1);
        IProject project = this.workspace.getRoot().getProject(resourcePath.segment(0));
        Preferences encodingSettings = this.getPreferences(project);
        if (newCharset == null || newCharset.trim().length() == 0) {
            encodingSettings.remove(this.getKeyFor(resourcePath));
        } else {
            encodingSettings.put(this.getKeyFor(resourcePath), newCharset);
        }
        try {
            encodingSettings.flush();
        }
        catch (BackingStoreException e) {
            String message = Policy.bind("resources.savingEncoding");
            throw new ResourceException(382, project.getFullPath(), message, e);
        }
    }

    public void shutdown(IProgressMonitor monitor) {
        this.workspace.removeResourceChangeListener(this.listener);
    }

    public void startup(IProgressMonitor monitor) throws CoreException {
        this.job = new CharsetManagerJob();
        this.listener = new Listener();
        this.workspace.addResourceChangeListener(this.listener, 1);
    }

    private class CharsetManagerJob
    extends Job {
        private List asyncChanges = new ArrayList();

        public CharsetManagerJob() {
            super("Charset Updater");
            this.setSystem(true);
            this.setPriority(10);
        }

        public void addChanges(Set newChanges) {
            if (newChanges.isEmpty()) {
                return;
            }
            List list = this.asyncChanges;
            synchronized (list) {
                this.asyncChanges.addAll(newChanges);
                this.asyncChanges.notify();
            }
            this.schedule();
        }

        public IProject getNextChange() {
            List list = this.asyncChanges;
            synchronized (list) {
                return this.asyncChanges.isEmpty() ? null : (IProject)this.asyncChanges.remove(this.asyncChanges.size() - 1);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            IProject next;
            MultiStatus result = new MultiStatus("org.eclipse.core.resources", 382, Policy.bind("resources.updatingEncoding"), null);
            while ((next = this.getNextChange()) != null) {
                if (CharsetManager.this.systemBundle.getState() != 32) {
                    return Status.OK_STATUS;
                }
                try {
                    CharsetManager.this.getPreferences(next).flush();
                }
                catch (BackingStoreException e) {
                    String message = Policy.bind("resources.savingEncoding");
                    result.add((IStatus)new ResourceStatus(382, next.getFullPath(), message, e));
                }
            }
            return result;
        }

        public boolean shouldRun() {
            List list = this.asyncChanges;
            synchronized (list) {
                return !this.asyncChanges.isEmpty();
            }
        }
    }

    class Listener
    implements IResourceChangeListener {
        Listener() {
        }

        private void processEntryChanges(IResourceDelta projectDelta, Set projectsToSave) {
            String[] affectedResources;
            boolean resourceChanges = false;
            IProject currentProject = (IProject)projectDelta.getResource();
            Preferences projectPrefs = CharsetManager.this.getPreferences(currentProject);
            try {
                affectedResources = projectPrefs.keys();
            }
            catch (BackingStoreException e) {
                String message = Policy.bind("resources.readingEncoding");
                ResourcesPlugin.getPlugin().getLog().log((IStatus)new ResourceStatus(383, currentProject.getFullPath(), message, e));
                return;
            }
            int i = 0;
            while (i < affectedResources.length) {
                IResourceDelta memberDelta = projectDelta.findMember((IPath)new Path(affectedResources[i]));
                if (memberDelta != null && memberDelta.getKind() == 2) {
                    resourceChanges = true;
                    String currentValue = projectPrefs.get(affectedResources[i], null);
                    projectPrefs.remove(affectedResources[i]);
                    if ((memberDelta.getFlags() & 0x2000) != 0) {
                        IProject targetProject = CharsetManager.this.workspace.getRoot().getProject(memberDelta.getMovedToPath().segment(0));
                        Preferences targetPrefs = CharsetManager.this.getPreferences(targetProject);
                        targetPrefs.put(CharsetManager.this.getKeyFor(memberDelta.getMovedToPath()), currentValue);
                        if (targetProject != currentProject) {
                            projectsToSave.add(targetProject);
                        }
                    }
                }
                ++i;
            }
            if (resourceChanges) {
                projectsToSave.add(currentProject);
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] projectDeltas = delta.getAffectedChildren();
            HashSet projectsToSave = new HashSet();
            int i = 0;
            while (i < projectDeltas.length) {
                if (projectDeltas[i].getKind() == 4 && (projectDeltas[i].getFlags() & 0x4000) == 0) {
                    this.processEntryChanges(projectDeltas[i], projectsToSave);
                }
                ++i;
            }
            CharsetManager.this.job.addChanges(projectsToSave);
        }
    }
}

