/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.junit.util.SWTUtil;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.internal.junit.wizards.MethodStubsSelectionButtonGroup;
import org.eclipse.jdt.internal.junit.wizards.UpdateTestSuite;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewTestSuiteCreationWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewTestSuiteCreationWizardPage";
    private static final String CLASSES_IN_SUITE = "NewTestSuiteCreationWizardPage.classesinsuite";
    private static final String SUITE_NAME = "NewTestSuiteCreationWizardPage.suitename";
    protected static final String STORE_GENERATE_MAIN = "NewTestSuiteCreationWizardPage.GENERATE_MAIN";
    protected static final String STORE_USE_TESTRUNNER = "NewTestSuiteCreationWizardPage.USE_TESTRUNNER";
    protected static final String STORE_TESTRUNNER_TYPE = "NewTestSuiteCreationWizardPage.TESTRUNNER_TYPE";
    public static final String START_MARKER = "//$JUnit-BEGIN$";
    public static final String END_MARKER = "//$JUnit-END$";
    private CheckboxTableViewer fClassesInSuiteTable;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Label fSelectedClassesLabel;
    private Label fSuiteNameLabel;
    private Text fSuiteNameText;
    private String fSuiteNameTextInitialValue = "";
    private MethodStubsSelectionButtonGroup fMethodStubsButtons;
    private boolean fUpdatedExistingClassButton;
    protected IStatus fClassesInSuiteStatus;
    protected IStatus fSuiteNameStatus = new JUnitStatus();

    public NewTestSuiteCreationWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(WizardMessages.getString("NewTestSuiteWizPage.title"));
        this.setDescription(WizardMessages.getString("NewTestSuiteWizPage.description"));
        String[] buttonNames = new String[]{"public static void main(Strin&g[] args)", WizardMessages.getString("NewTestClassWizPage.methodStub.testRunner")};
        this.fMethodStubsButtons = new MethodStubsSelectionButtonGroup(32, buttonNames, 1);
        this.fMethodStubsButtons.setLabelText(WizardMessages.getString("NewTestClassWizPage2.method.Stub.label"));
        this.fMethodStubsButtons.setUseSuiteInMainForTextRunner(true);
        this.fClassesInSuiteStatus = new JUnitStatus();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createSuiteNameControl(composite, nColumns);
        this.setTypeName("AllTests", true);
        this.createSeparator(composite, nColumns);
        this.createClassesInSuiteControl(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.junit.new_testsuite_wizard_page2_context");
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getLabelControl(composite), nColumns);
        LayoutUtil.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getSelectionButtonsGroup(composite), nColumns - 1);
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
        this.fMethodStubsButtons.setSelection(0, false);
        this.fMethodStubsButtons.setSelection(1, false);
        this.fMethodStubsButtons.setEnabled(1, false);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName.equals("NewTypeWizardPage.package") || fieldName.equals("NewContainerWizardPage.container")) {
            if (fieldName.equals("NewTypeWizardPage.package")) {
                this.fPackageStatus = this.packageChanged();
            }
            this.updateClassesInSuiteTable();
        } else if (fieldName.equals(CLASSES_IN_SUITE)) {
            this.fClassesInSuiteStatus = this.classesInSuiteChanged();
            this.fSuiteNameStatus = this.testSuiteChanged();
            this.updateSelectedClassesLabel();
        } else if (fieldName.equals(SUITE_NAME)) {
            this.fSuiteNameStatus = this.testSuiteChanged();
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fSuiteNameStatus, this.fClassesInSuiteStatus};
        this.updateStatus(status);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
            this.updateClassesInSuiteTable();
            this.handleAllFieldsChanged();
        }
    }

    private void handleAllFieldsChanged() {
        this.handleFieldChanged("NewTypeWizardPage.package");
        this.handleFieldChanged("NewContainerWizardPage.container");
        this.handleFieldChanged(CLASSES_IN_SUITE);
        this.handleFieldChanged(SUITE_NAME);
    }

    protected void updateClassesInSuiteTable() {
        if (this.fClassesInSuiteTable != null) {
            IPackageFragment pack = this.getPackageFragment();
            if (pack == null) {
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                if (root != null) {
                    pack = root.getPackageFragment("");
                } else {
                    return;
                }
            }
            this.fClassesInSuiteTable.setInput((Object)pack);
            this.fClassesInSuiteTable.setAllChecked(true);
            this.updateSelectedClassesLabel();
        }
    }

    protected void createClassesInSuiteControl(Composite parent, int nColumns) {
        if (this.fClassesInSuiteTable == null) {
            Label label = new Label(parent, 16384);
            label.setText(WizardMessages.getString("NewTestSuiteWizPage.classes_in_suite.label"));
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = nColumns;
            label.setLayoutData((Object)gd);
            this.fClassesInSuiteTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
            gd = new GridData(1808);
            gd.heightHint = 80;
            gd.horizontalSpan = nColumns - 1;
            this.fClassesInSuiteTable.getTable().setLayoutData((Object)gd);
            this.fClassesInSuiteTable.setContentProvider((IContentProvider)new ClassesInSuitContentProvider());
            this.fClassesInSuiteTable.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
            this.fClassesInSuiteTable.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    NewTestSuiteCreationWizardPage.this.handleFieldChanged(NewTestSuiteCreationWizardPage.CLASSES_IN_SUITE);
                }
            });
            Composite buttonContainer = new Composite(parent, 0);
            gd = new GridData(1040);
            buttonContainer.setLayoutData((Object)gd);
            GridLayout buttonLayout = new GridLayout();
            buttonLayout.marginWidth = 0;
            buttonLayout.marginHeight = 0;
            buttonContainer.setLayout((Layout)buttonLayout);
            this.fSelectAllButton = new Button(buttonContainer, 8);
            this.fSelectAllButton.setText(WizardMessages.getString("NewTestSuiteWizPage.selectAll"));
            GridData bgd = new GridData(770);
            bgd.heightHint = SWTUtil.getButtonHeigthHint(this.fSelectAllButton);
            bgd.widthHint = SWTUtil.getButtonWidthHint(this.fSelectAllButton);
            this.fSelectAllButton.setLayoutData((Object)bgd);
            this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewTestSuiteCreationWizardPage.this.fClassesInSuiteTable.setAllChecked(true);
                    NewTestSuiteCreationWizardPage.this.handleFieldChanged(NewTestSuiteCreationWizardPage.CLASSES_IN_SUITE);
                }
            });
            this.fDeselectAllButton = new Button(buttonContainer, 8);
            this.fDeselectAllButton.setText(WizardMessages.getString("NewTestSuiteWizPage.deselectAll"));
            bgd = new GridData(770);
            bgd.heightHint = SWTUtil.getButtonHeigthHint(this.fDeselectAllButton);
            bgd.widthHint = SWTUtil.getButtonWidthHint(this.fDeselectAllButton);
            this.fDeselectAllButton.setLayoutData((Object)bgd);
            this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewTestSuiteCreationWizardPage.this.fClassesInSuiteTable.setAllChecked(false);
                    NewTestSuiteCreationWizardPage.this.handleFieldChanged(NewTestSuiteCreationWizardPage.CLASSES_IN_SUITE);
                }
            });
            this.fSelectedClassesLabel = new Label(parent, 16448);
            this.fSelectedClassesLabel.setFont(parent.getFont());
            this.updateSelectedClassesLabel();
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.fSelectedClassesLabel.setLayoutData((Object)gd);
        }
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.writeImports(imports);
        if (this.fMethodStubsButtons.isEnabled() && this.fMethodStubsButtons.isSelected(0)) {
            this.createMain(type);
        }
        type.createMethod(this.getSuiteMethodString(), null, false, null);
    }

    protected void createMain(IType type) throws JavaModelException {
        type.createMethod(this.fMethodStubsButtons.getMainMethod(this.getTypeName()), null, false, null);
    }

    public String getSuiteMethodString() {
        IPackageFragment pack = this.getPackageFragment();
        String packName = pack.getElementName();
        StringBuffer suite = new StringBuffer("public static Test suite () {TestSuite suite= new TestSuite(\"Test for " + (packName.equals("") ? "default package" : packName) + "\");\n");
        suite.append(this.getUpdatableString());
        suite.append("\nreturn suite;}");
        return suite.toString();
    }

    public static String getUpdatableString(Object[] selectedClasses) {
        StringBuffer suite = new StringBuffer();
        suite.append("//$JUnit-BEGIN$\n");
        int i = 0;
        while (i < selectedClasses.length) {
            if (selectedClasses[i] instanceof IType) {
                IType testType = (IType)selectedClasses[i];
                IMethod suiteMethod = testType.getMethod("suite", new String[0]);
                if (!suiteMethod.exists()) {
                    suite.append("suite.addTestSuite(" + testType.getElementName() + ".class);");
                } else {
                    suite.append("suite.addTest(" + testType.getElementName() + ".suite());");
                }
            }
            ++i;
        }
        suite.append("\n//$JUnit-END$");
        return suite.toString();
    }

    private String getUpdatableString() {
        return NewTestSuiteCreationWizardPage.getUpdatableString(this.fClassesInSuiteTable.getCheckedElements());
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    NewTestSuiteCreationWizardPage.this.updateExistingClass(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    protected void updateExistingClass(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IPackageFragment pack = this.getPackageFragment();
        ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(this.getTypeName()) + ".java");
        if (!cu.exists()) {
            this.createType(monitor);
            this.fUpdatedExistingClassButton = false;
            return;
        }
        if (!UpdateTestSuite.checkValidateEditStatus(cu, this.getShell())) {
            return;
        }
        IType suiteType = cu.getType(this.getTypeName());
        monitor.beginTask(WizardMessages.getString("NewTestSuiteWizPage.createType.beginTask"), 10);
        IMethod suiteMethod = suiteType.getMethod("suite", new String[0]);
        monitor.worked(1);
        String lineDelimiter = JUnitStubUtility.getLineDelimiterUsed((IJavaElement)cu);
        if (suiteMethod.exists()) {
            ISourceRange range = suiteMethod.getSourceRange();
            if (range != null) {
                IBuffer buf = cu.getBuffer();
                String originalContent = buf.getText(range.getOffset(), range.getLength());
                StringBuffer source = new StringBuffer(originalContent);
                int start = source.toString().indexOf(START_MARKER);
                if (start > -1) {
                    int end = source.toString().indexOf(END_MARKER, start);
                    if (end > -1) {
                        monitor.subTask(WizardMessages.getString("NewTestSuiteWizPage.createType.updating.suite_method"));
                        monitor.worked(1);
                        source.replace(start, end += END_MARKER.length(), this.getUpdatableString());
                        buf.replace(range.getOffset(), range.getLength(), source.toString());
                        cu.reconcile();
                        originalContent = buf.getText(0, buf.getLength());
                        monitor.worked(1);
                        String formattedContent = JUnitStubUtility.codeFormat(originalContent, 0, lineDelimiter);
                        buf.replace(0, buf.getLength(), formattedContent);
                        monitor.worked(1);
                        cu.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
                    } else {
                        this.cannotUpdateSuiteError();
                    }
                } else {
                    this.cannotUpdateSuiteError();
                }
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)WizardMessages.getString("NewTestSuiteWizPage.createType.updateErrorDialog.title"), (String)WizardMessages.getString("NewTestSuiteWizPage.createType.updateErrorDialog.message"));
            }
        } else {
            suiteType.createMethod(this.getSuiteMethodString(), null, true, monitor);
            ISourceRange range = cu.getSourceRange();
            IBuffer buf = cu.getBuffer();
            String originalContent = buf.getText(range.getOffset(), range.getLength());
            monitor.worked(2);
            String formattedContent = JUnitStubUtility.codeFormat(originalContent, 0, lineDelimiter);
            buf.replace(range.getOffset(), range.getLength(), formattedContent);
            monitor.worked(1);
            cu.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
        }
        monitor.done();
        this.fUpdatedExistingClassButton = true;
    }

    public boolean hasUpdatedExistingClass() {
        return this.fUpdatedExistingClassButton;
    }

    private IStatus classesInSuiteChanged() {
        JUnitStatus status = new JUnitStatus();
        if (this.fClassesInSuiteTable.getCheckedElements().length <= 0) {
            status.setWarning(WizardMessages.getString("NewTestSuiteWizPage.classes_in_suite.error.no_testclasses_selected"));
        }
        return status;
    }

    private void updateSelectedClassesLabel() {
        int noOfClassesChecked = this.fClassesInSuiteTable.getCheckedElements().length;
        String key = noOfClassesChecked == 1 ? "NewTestClassWizPage.treeCaption.classSelected" : "NewTestClassWizPage.treeCaption.classesSelected";
        this.fSelectedClassesLabel.setText(WizardMessages.getFormattedString(key, new Integer(noOfClassesChecked)));
    }

    protected void createSuiteNameControl(Composite composite, int nColumns) {
        this.fSuiteNameLabel = new Label(composite, 16448);
        this.fSuiteNameLabel.setFont(composite.getFont());
        this.fSuiteNameLabel.setText(WizardMessages.getString("NewTestSuiteWizPage.suiteName.text"));
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.fSuiteNameLabel.setLayoutData((Object)gd);
        this.fSuiteNameText = new Text(composite, 2052);
        this.fSuiteNameText.setEnabled(true);
        this.fSuiteNameText.setFont(composite.getFont());
        this.fSuiteNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTestSuiteCreationWizardPage.this.handleFieldChanged(NewTestSuiteCreationWizardPage.SUITE_NAME);
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        this.fSuiteNameText.setLayoutData((Object)gd);
        Label space = new Label(composite, 16384);
        space.setText(" ");
        gd = new GridData();
        gd.horizontalSpan = 1;
        space.setLayoutData((Object)gd);
    }

    public String getTypeName() {
        return this.fSuiteNameText == null ? this.fSuiteNameTextInitialValue : this.fSuiteNameText.getText();
    }

    public void setTypeName(String name, boolean canBeModified) {
        if (this.fSuiteNameText == null) {
            this.fSuiteNameTextInitialValue = name;
        } else {
            this.fSuiteNameText.setText(name);
            this.fSuiteNameText.setEnabled(canBeModified);
        }
    }

    protected IStatus testSuiteChanged() {
        ICompilationUnit cu;
        JUnitStatus recursiveSuiteInclusionStatus;
        JUnitStatus status = new JUnitStatus();
        String typeName = this.getTypeName();
        if (typeName.length() == 0) {
            status.setError(WizardMessages.getString("NewTestSuiteWizPage.typeName.error.name_empty"));
            return status;
        }
        if (typeName.indexOf(46) != -1) {
            status.setError(WizardMessages.getString("NewTestSuiteWizPage.typeName.error.name_qualified"));
            return status;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)typeName);
        if (val.getSeverity() == 4) {
            status.setError(String.valueOf(WizardMessages.getString("NewTestSuiteWizPage.typeName.error.name_not_valid")) + val.getMessage());
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(String.valueOf(WizardMessages.getString("NewTestSuiteWizPage.typeName.error.name.name_discouraged")) + val.getMessage());
        }
        if (!(recursiveSuiteInclusionStatus = this.checkRecursiveTestSuiteInclusion()).isOK()) {
            return recursiveSuiteInclusionStatus;
        }
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null && (cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java")).exists()) {
            status.setWarning(WizardMessages.getString("NewTestSuiteWizPage.typeName.warning.already_exists"));
            this.fMethodStubsButtons.setEnabled(false);
            return status;
        }
        this.fMethodStubsButtons.setEnabled(true);
        return status;
    }

    private JUnitStatus checkRecursiveTestSuiteInclusion() {
        if (this.fClassesInSuiteTable == null) {
            return new JUnitStatus();
        }
        String typeName = this.getTypeName();
        JUnitStatus status = new JUnitStatus();
        Object[] checkedClasses = this.fClassesInSuiteTable.getCheckedElements();
        int i = 0;
        while (i < checkedClasses.length) {
            IType checkedClass = (IType)checkedClasses[i];
            if (checkedClass.getElementName().equals(typeName)) {
                status.setWarning(WizardMessages.getString("NewTestSuiteCreationWizardPage.infinite_recursion"));
                return status;
            }
            ++i;
        }
        return new JUnitStatus();
    }

    protected void setFocus() {
        this.fSuiteNameText.setFocus();
    }

    public void setCheckedElements(Object[] elements) {
        this.fClassesInSuiteTable.setCheckedElements(elements);
    }

    protected void cannotUpdateSuiteError() {
        MessageDialog.openError((Shell)this.getShell(), (String)WizardMessages.getString("NewTestSuiteWizPage.cannotUpdateDialog.title"), (String)WizardMessages.getFormattedString("NewTestSuiteWizPage.cannotUpdateDialog.message", new String[]{START_MARKER, END_MARKER}));
    }

    private void writeImports(NewTypeWizardPage.ImportsManager imports) {
        imports.addImport("junit.framework.Test");
        imports.addImport("junit.framework.TestSuite");
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            boolean generateMain = settings.getBoolean(STORE_GENERATE_MAIN);
            this.fMethodStubsButtons.setSelection(0, generateMain);
            this.fMethodStubsButtons.setEnabled(1, generateMain);
            this.fMethodStubsButtons.setSelection(1, settings.getBoolean(STORE_USE_TESTRUNNER));
            this.fMethodStubsButtons.setEnabled(!this.fMethodStubsButtons.isEnabled());
            this.fMethodStubsButtons.setEnabled(!this.fMethodStubsButtons.isEnabled());
            try {
                this.fMethodStubsButtons.setComboSelection(settings.getInt(STORE_TESTRUNNER_TYPE));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_GENERATE_MAIN, this.fMethodStubsButtons.isSelected(0));
            settings.put(STORE_USE_TESTRUNNER, this.fMethodStubsButtons.isSelected(1));
            settings.put(STORE_TESTRUNNER_TYPE, this.fMethodStubsButtons.getComboSelection());
        }
    }

    static class ClassesInSuitContentProvider
    implements IStructuredContentProvider {
        ClassesInSuitContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (!(parent instanceof IPackageFragment)) {
                return new Object[0];
            }
            IPackageFragment pack = (IPackageFragment)parent;
            if (!pack.exists()) {
                return new Object[0];
            }
            try {
                ICompilationUnit[] cuArray = pack.getCompilationUnits();
                ArrayList<IType> typesArrayList = new ArrayList<IType>();
                int i = 0;
                while (i < cuArray.length) {
                    ICompilationUnit cu = cuArray[i];
                    IType[] types = cu.getTypes();
                    int j = 0;
                    while (j < types.length) {
                        IType type = types[j];
                        if (type.isClass() && !Flags.isAbstract((int)type.getFlags()) && TestSearchEngine.isTestImplementor(type)) {
                            typesArrayList.add(types[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                return typesArrayList.toArray();
            }
            catch (JavaModelException e) {
                JUnitPlugin.log(e);
                return new Object[0];
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

