/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.build.BuildInputContext;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdvancedPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureInputContext;
import org.eclipse.pde.internal.ui.editor.feature.FeatureInputContextManager;
import org.eclipse.pde.internal.ui.editor.feature.FeatureOutlinePage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureReferencePage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureSourcePage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureUndoManager;
import org.eclipse.pde.internal.ui.editor.feature.InfoFormPage;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class FeatureEditor
extends MultiSourceEditor {
    public static final String UNRESOLVED_TITLE = "FeatureEditor.Unresolved.title";
    public static final String VERSION_TITLE = "FeatureEditor.Version.title";
    public static final String VERSION_MESSAGE = "FeatureEditor.Version.message";
    public static final String VERSION_EXISTS = "FeatureEditor.Version.exists";
    public static final String UNRESOLVED_MESSAGE = "FeatureEditor.Unresolved.message";
    public static final String FEATURE_PAGE_TITLE = "FeatureEditor.FeaturePage.title";
    public static final String REFERENCE_PAGE_TITLE = "FeatureEditor.ReferencePage.title";
    public static final String ADVANCED_PAGE_TITLE = "FeatureEditor.AdvancedPage.title";
    public static final String INFO_PAGE_TITLE = "FeatureEditor.InfoPage.title";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        FileEditorInput in;
        IFile file = input.getFile();
        IProject project = file.getProject();
        IFile buildFile = null;
        IFile featureFile = null;
        String name = file.getName().toLowerCase();
        if (name.equals("feature.xml")) {
            featureFile = file;
            buildFile = project.getFile("build.properties");
        } else if (name.equals("build.properties")) {
            buildFile = file;
            featureFile = this.createFeatureFile(project);
        }
        if (featureFile.exists()) {
            in = new FileEditorInput(featureFile);
            manager.putContext((IEditorInput)in, new FeatureInputContext(this, (IEditorInput)in, file == featureFile));
        }
        if (buildFile.exists()) {
            in = new FileEditorInput(buildFile);
            manager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, file == buildFile));
        }
        manager.monitorFile(featureFile);
        manager.monitorFile(buildFile);
    }

    protected InputContextManager createInputContextManager() {
        FeatureInputContextManager manager = new FeatureInputContextManager(this);
        manager.setUndoManager(new FeatureUndoManager(this));
        return manager;
    }

    public void monitoredFileAdded(IFile file) {
        String name = file.getName();
        if (!name.equalsIgnoreCase("feature.xml") && name.equalsIgnoreCase("build.properties") && !this.inputContextManager.hasContext("build-context")) {
            FileEditorInput in = new FileEditorInput(file);
            this.inputContextManager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, false));
        }
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void contextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    public void contextRemoved(InputContext context) {
        if (context.isPrimary()) {
            this.close(true);
            return;
        }
        IFormPage page = this.findPage(context.getId());
        if (page != null) {
            this.removePage(context.getId());
        }
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        SystemFileEditorInput in;
        File dir;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        File file = (File)input.getAdapter(clazz);
        File buildFile = null;
        File featureFile = null;
        String name = file.getName().toLowerCase();
        if (name.equals("feature.xml")) {
            featureFile = file;
            dir = file.getParentFile();
            buildFile = new File(dir, "build.properties");
        } else if (name.equals("build.properties")) {
            buildFile = file;
            dir = file.getParentFile();
            featureFile = this.createFeatureFile(dir);
        }
        if (featureFile.exists()) {
            in = new SystemFileEditorInput(featureFile);
            manager.putContext((IEditorInput)in, new FeatureInputContext(this, (IEditorInput)in, file == featureFile));
        }
        if (buildFile.exists()) {
            in = new SystemFileEditorInput(buildFile);
            manager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, file == buildFile));
        }
    }

    private File createFeatureFile(File dir) {
        File pluginFile = new File(dir, "plugin.xml");
        return pluginFile;
    }

    private IFile createFeatureFile(IProject project) {
        IFile featureFile = project.getFile("feature.xml");
        return featureFile;
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        String name = input.getName().toLowerCase();
        if (name.equals("build.properties")) {
            manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
        } else if (name.startsWith("feature.xml")) {
            manager.putContext((IEditorInput)input, new FeatureInputContext(this, (IEditorInput)input, true));
        }
    }

    public boolean canCopy(ISelection selection) {
        return true;
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new FeatureFormPage(this, PDEPlugin.getResourceString(FEATURE_PAGE_TITLE)));
            this.addPage((IFormPage)new InfoFormPage(this, PDEPlugin.getResourceString(INFO_PAGE_TITLE)));
            this.addPage((IFormPage)new FeatureReferencePage(this, PDEPlugin.getResourceString(REFERENCE_PAGE_TITLE)));
            this.addPage((IFormPage)new FeatureAdvancedPage(this, PDEPlugin.getResourceString(ADVANCED_PAGE_TITLE)));
            if (this.inputContextManager.hasContext("build-context")) {
                this.addPage((IFormPage)new BuildPage(this));
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("feature-context");
        this.addSourcePage("build-context");
    }

    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            InputContext primary = this.inputContextManager.getPrimaryContext();
            if (primary.getId().equals("feature-context")) {
                firstPageId = "feature";
            }
            if (firstPageId == null) {
                firstPageId = "feature";
            }
        }
        return firstPageId;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        if (contextId.equals("feature-context")) {
            return new FeatureSourcePage(editor, title, name);
        }
        if (contextId.equals("build-context")) {
            return new BuildSourcePage(editor, title, name);
        }
        return super.createSourcePage(editor, title, name, contextId);
    }

    protected IContentOutlinePage createContentOutline() {
        return new FeatureOutlinePage(this);
    }

    protected IPropertySheetPage getPropertySheet(PDEFormPage page) {
        return null;
    }

    public String getTitle() {
        if (!this.isModelCorrect(this.getAggregateModel())) {
            return super.getTitle();
        }
        IFeatureModel model = (IFeatureModel)this.getAggregateModel();
        String name = this.getTitleText(model.getFeature());
        if (name == null) {
            return super.getTitle();
        }
        return model.getResourceString(name);
    }

    public String getTitleProperty() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("Preferences.MainPage.showObjects");
        if (pref != null && pref.equals("useNames")) {
            return "label";
        }
        return "id";
    }

    private String getTitleText(IFeature feature) {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("Preferences.MainPage.showObjects");
        if (pref != null && pref.equals("useNames")) {
            return feature.getLabel();
        }
        return feature.getId();
    }

    protected boolean isModelCorrect(Object model) {
        return model != null ? ((IFeatureModel)model).isValid() : false;
    }

    protected boolean hasKnownTypes() {
        try {
            TransferData[] types = this.getClipboard().getAvailableTypes();
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
            int i = 0;
            while (i < types.length) {
                int j = 0;
                while (j < transfers.length) {
                    if (transfers[j].isSupportedType(types[i])) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (SWTError sWTError) {}
        return false;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return null;
        }
        return super.getAdapter(key);
    }
}

