/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureReferencePage;
import org.eclipse.pde.internal.ui.editor.feature.InfoFormPage;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;

public class FeatureOutlinePage
extends FormOutlinePage {
    private static final String KEY_REFERENCED_PLUGINS = "FeatureEditor.Outline.referencedPlugins";
    private static final String KEY_REQUIRED_PLUGINS = "FeatureEditor.Outline.requiredPlugins";
    private NamedElement referencedPlugins;
    private NamedElement requiredPlugins;

    public FeatureOutlinePage(PDEFormEditor editor) {
        super(editor);
        Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        this.requiredPlugins = new NamedElement(PDEPlugin.getResourceString(KEY_REQUIRED_PLUGINS), folderImage);
        this.referencedPlugins = new NamedElement(PDEPlugin.getResourceString(KEY_REFERENCED_PLUGINS), folderImage);
    }

    protected ITreeContentProvider createContentProvider() {
        return new ContentProvider();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IFeatureModel model = (IFeatureModel)this.editor.getAggregateModel();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        super.dispose();
        IFeatureModel model = (IFeatureModel)this.editor.getAggregateModel();
        model.removeModelChangedListener((IModelChangedListener)this);
    }

    public String getParentPageId(Object item) {
        if (item instanceof IFeatureURLElement) {
            return "feature";
        }
        if (item.equals(this.requiredPlugins) || item.equals(this.referencedPlugins) || item instanceof IFeaturePlugin || item instanceof IFeatureImport) {
            return "reference";
        }
        if (item instanceof IFeatureInfo) {
            return "info";
        }
        if (item instanceof IFeatureData) {
            return "advanced";
        }
        return super.getParentPageId(item);
    }

    private Object[] getInfos() {
        IFeatureModel model = (IFeatureModel)this.editor.getAggregateModel();
        IFeature feature = model.getFeature();
        Vector<IFeatureInfo> result = new Vector<IFeatureInfo>();
        int i = 0;
        while (i < 3) {
            IFeatureInfo info = feature.getFeatureInfo(i);
            if (info != null) {
                result.add(info);
            }
            ++i;
        }
        return result.toArray();
    }

    private Object[] getReferences() {
        IFeatureModel model = (IFeatureModel)this.editor.getAggregateModel();
        IFeature feature = model.getFeature();
        return feature.getPlugins();
    }

    private Object[] getImports() {
        IFeatureModel model = (IFeatureModel)this.editor.getAggregateModel();
        IFeature feature = model.getFeature();
        return feature.getImports();
    }

    private Object[] getURLs() {
        IFeatureModel model = (IFeatureModel)this.editor.getAggregateModel();
        IFeature feature = model.getFeature();
        IFeatureURL url = feature.getURL();
        if (url == null) {
            return new Object[0];
        }
        IFeatureURLElement[] updates = url.getUpdates();
        IFeatureURLElement[] discoveries = url.getDiscoveries();
        int size = updates.length + discoveries.length;
        Object[] result = new Object[size];
        System.arraycopy(updates, 0, result, 0, updates.length);
        System.arraycopy(discoveries, 0, result, updates.length, discoveries.length);
        return result;
    }

    public Object getParent(Object object) {
        if (object instanceof IFeaturePlugin) {
            return this.referencedPlugins;
        }
        if (object instanceof IFeatureImport) {
            return this.requiredPlugins;
        }
        return this.editor.findPage(this.getParentPageId(object));
    }

    public void modelChanged(IModelChangedEvent event) {
        String property;
        if (event.getChangeType() == 99) {
            this.treeViewer.refresh();
            return;
        }
        Object object = event.getChangedObjects()[0];
        if (object instanceof IFeature && event.getChangeType() == 3 && ((property = event.getChangedProperty()).equals("description") || property.equals("copyright") || property.equals("license"))) {
            IFormPage page = this.editor.findPage("info");
            this.treeViewer.refresh((Object)page);
            return;
        }
        if (object instanceof IFeatureImport || object instanceof IFeatureInfo || object instanceof IFeaturePlugin || object instanceof IFeatureData || object instanceof IFeatureURLElement) {
            if (event.getChangeType() == 3) {
                this.treeViewer.update(object, null);
            } else {
                Object parent = null;
                parent = this.getParent(object);
                if (parent != null) {
                    if (event.getChangeType() == 1) {
                        this.treeViewer.add(parent, event.getChangedObjects());
                    } else {
                        this.treeViewer.remove(event.getChangedObjects());
                    }
                } else {
                    this.treeViewer.refresh();
                    this.treeViewer.expandAll();
                }
            }
        }
    }

    class ContentProvider
    extends FormOutlinePage.BasicContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            IFeatureModel model = (IFeatureModel)FeatureOutlinePage.this.editor.getAggregateModel();
            if (model.isValid()) {
                if (parent instanceof FeatureFormPage) {
                    return FeatureOutlinePage.this.getURLs();
                }
                if (parent instanceof InfoFormPage) {
                    return FeatureOutlinePage.this.getInfos();
                }
                if (parent instanceof FeatureReferencePage) {
                    return new Object[]{FeatureOutlinePage.this.referencedPlugins, FeatureOutlinePage.this.requiredPlugins};
                }
                if (parent.equals(FeatureOutlinePage.this.requiredPlugins)) {
                    return FeatureOutlinePage.this.getImports();
                }
                if (parent.equals(FeatureOutlinePage.this.referencedPlugins)) {
                    return FeatureOutlinePage.this.getReferences();
                }
            }
            return super.getChildren(parent);
        }

        public Object getParent(Object child) {
            String pageId = FeatureOutlinePage.this.getParentPageId(child);
            if (pageId != null) {
                return FeatureOutlinePage.this.editor.findPage(pageId);
            }
            return super.getParent(child);
        }
    }
}

