/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.PrintWriter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.PluginExportJob;
import org.eclipse.pde.internal.ui.wizards.exports.PluginExportWizardPage;
import org.eclipse.ui.progress.IProgressConstants;

public class PluginExportWizard
extends BaseExportWizard {
    private static final String KEY_WTITLE = "ExportWizard.Plugin.wtitle";
    private static final String STORE_SECTION = "PluginExportWizard";

    public PluginExportWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN_EXPORT_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
    }

    protected BaseExportWizardPage createPage1() {
        return new PluginExportWizardPage(this.getSelection());
    }

    public IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    protected void scheduleExportJob() {
        PluginExportJob job = new PluginExportJob(this.page1.getExportType(), this.page1.doExportSource(), this.page1.getDestination(), this.page1.getFileName(), this.page1.getSelectedItems());
        job.setUser(true);
        job.schedule();
        job.setProperty(IProgressConstants.ICON_PROPERTY, PDEPluginImages.DESC_PLUGIN_OBJ);
    }

    protected void generateAntTask(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<project name=\"build\" default=\"plugin_export\">");
        writer.println("\t<target name=\"plugin_export\">");
        writer.print("\t\t<pde.exportPlugins plugins=\"" + this.getPluginIDs() + "\" destination=\"" + this.page1.getDestination() + "\" ");
        String filename = this.page1.getFileName();
        if (filename != null) {
            writer.print("filename=\"" + filename + "\" ");
        }
        writer.print("exportType=\"" + this.getExportOperation() + "\" ");
        writer.println("exportSource=\"" + (this.page1.doExportSource() ? "true" : "false") + "\"/>");
        writer.println("\t</target>");
        writer.println("</project>");
    }

    private String getPluginIDs() {
        StringBuffer buffer = new StringBuffer();
        Object[] objects = this.page1.getSelectedItems();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof IPluginModelBase) {
                buffer.append(((IPluginModelBase)object).getPluginBase().getId());
                if (i < objects.length - 1) {
                    buffer.append(",");
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

