/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.html.FormattedHTMLElement;
import org.eclipse.ui.internal.intro.impl.html.HTMLElement;
import org.eclipse.ui.internal.intro.impl.html.HTMLUtil;
import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHTML;
import org.eclipse.ui.internal.intro.impl.model.IntroHead;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.eclipse.ui.internal.intro.impl.util.Log;

public class IntroHTMLGenerator {
    private AbstractIntroPage introPage;

    public HTMLElement generateHTMLforPage(AbstractIntroPage page) {
        if (page == null) {
            return null;
        }
        this.introPage = page;
        return this.generateHTMLElement();
    }

    private HTMLElement generateEncoding() {
        HTMLElement encoding = new HTMLElement("");
        return encoding;
    }

    private HTMLElement generateHTMLElement() {
        int indentLevel = 0;
        FormattedHTMLElement html = new FormattedHTMLElement("HTML", indentLevel, true);
        HTMLElement head = this.generateHeadElement(indentLevel + 1);
        HTMLElement body = this.generateBodyElement(indentLevel + 1);
        html.addContent(head);
        html.addContent(body);
        return html;
    }

    private HTMLElement generateHeadElement(int indentLevel) {
        FormattedHTMLElement head = new FormattedHTMLElement("HEAD", indentLevel, true);
        head.addContent(this.generateTitleElement(null, indentLevel + 1));
        String basePath = HTMLUtil.getResolvedBundleLocation(this.introPage.getBundle());
        HTMLElement base = this.generateBaseElement(indentLevel + 1, basePath);
        if (base != null) {
            head.addContent(base);
        }
        head.addContent(this.generateStyleElement(indentLevel + 1));
        String style = IntroPlugin.getDefault().getIntroModelRoot().getPresentation().getImplementationStyle();
        if (style != null) {
            head.addContent(this.generateLinkElement(style, indentLevel + 1));
        }
        if ((style = this.introPage.getStyle()) != null) {
            head.addContent(this.generateLinkElement(style, indentLevel + 1));
        }
        String[] pageStyles = this.introPage.getStyles();
        int i = 0;
        while (i < pageStyles.length) {
            style = pageStyles[i];
            if (style != null) {
                head.addContent(this.generateLinkElement(style, indentLevel + 1));
            }
            ++i;
        }
        StringBuffer content = null;
        IntroHead introHead = IntroPlugin.getDefault().getIntroModelRoot().getPresentation().getHead();
        if (introHead != null && (content = this.readFromFile(introHead.getSrc())) != null) {
            head.addContent(content);
        }
        IntroHead[] htmlHeads = this.introPage.getHTMLHeads();
        int i2 = 0;
        while (i2 < htmlHeads.length) {
            introHead = htmlHeads[i2];
            if (introHead != null && (content = this.readFromFile(introHead.getSrc())) != null) {
                head.addContent(content);
            }
            ++i2;
        }
        return head;
    }

    private HTMLElement generateBodyElement(int indentLevel) {
        FormattedHTMLElement body = new FormattedHTMLElement("BODY", indentLevel, true);
        String pageId = this.introPage.getId() != null ? this.introPage.getId() : "page";
        HTMLElement pageContentDiv = this.generateDivElement(pageId, indentLevel + 1);
        if (this.introPage.getStyleId() != null) {
            pageContentDiv.addAttribute("class", this.introPage.getStyleId());
        }
        AbstractIntroElement[] children = this.introPage.getChildren();
        int i = 0;
        while (i < children.length) {
            AbstractIntroElement child = children[i];
            HTMLElement childElement = this.generateIntroElement(child, indentLevel + 2);
            if (childElement != null) {
                pageContentDiv.addContent(childElement);
            }
            ++i;
        }
        body.addContent(pageContentDiv);
        return body;
    }

    private HTMLElement generateIntroElement(AbstractIntroElement element, int indentLevel) {
        if (element == null) {
            return null;
        }
        if (this.filteredFromPresentation(element)) {
            return null;
        }
        switch (element.getType()) {
            case 16: {
                return this.generateIntroDiv((IntroGroup)element, indentLevel);
            }
            case 64: {
                return this.generateIntroLink((IntroLink)element, indentLevel);
            }
            case 32: {
                return this.generateIntroHTML((IntroHTML)element, indentLevel);
            }
            case 128: {
                return this.generateIntroImage((IntroImage)element, indentLevel);
            }
            case 512: {
                return this.generateIntroText((IntroText)element, indentLevel);
            }
            case 4096: {
                return this.generateIntroTitle((IntroPageTitle)element, indentLevel);
            }
        }
        return null;
    }

    private HTMLElement generateIntroDiv(IntroGroup element, int indentLevel) {
        HTMLElement divElement = this.generateDivElement(element.getId(), indentLevel);
        if (element.getStyleId() != null) {
            divElement.addAttribute("class", element.getStyleId());
        }
        if (element.getLabel() != null) {
            HTMLElement divLabel = this.generateTextElement("H4", null, "div-label", element.getLabel(), indentLevel + 1);
            divElement.addContent(divLabel);
        }
        AbstractIntroElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            AbstractIntroElement child = children[i];
            HTMLElement childElement = this.generateIntroElement(child, indentLevel + 1);
            if (childElement != null) {
                divElement.addContent(childElement);
            }
            ++i;
        }
        return divElement;
    }

    private HTMLElement generateIntroLink(IntroLink element, int indentLevel) {
        HTMLElement text;
        IntroText linkText;
        HTMLElement img;
        HTMLElement anchor = this.generateAnchorElement(element, indentLevel);
        String blankImageURL = IntroModelRoot.getPluginLocation("icons/blank.gif", "org.eclipse.ui.intro");
        if (blankImageURL != null) {
            anchor.addContent(this.generateImageElement(blankImageURL, null, "background-image", indentLevel + 1));
        }
        if (element.getImg() != null && (img = this.generateIntroElement(element.getImg(), indentLevel + 1)) != null) {
            anchor.addContent(img);
        }
        if (element.getLabel() != null) {
            HTMLElement label = this.generateSpanElement("link-label", indentLevel + 1);
            label.addContent(element.getLabel());
            anchor.addContent(label);
        }
        if ((linkText = element.getIntroText()) != null && linkText.getText() != null && (text = this.generateIntroElement(linkText, indentLevel + 1)) != null) {
            anchor.addContent(text);
        }
        return anchor;
    }

    private HTMLElement generateIntroHTML(IntroHTML element, int indentLevel) {
        if (element.isInlined()) {
            return this.generateInlineIntroHTML(element, indentLevel);
        }
        return this.generateEmbeddedIntroHTML(element, indentLevel);
    }

    private HTMLElement generateIntroImage(IntroImage element, int indentLevel) {
        HTMLElement imageElement = this.generateImageElement(element.getSrc(), element.getAlt(), element.getStyleId(), indentLevel);
        if (element.getId() != null) {
            imageElement.addAttribute("id", element.getId());
        }
        return imageElement;
    }

    private HTMLElement generateIntroText(IntroText element, int indentLevel) {
        String spanClass = element.getStyleId() != null ? element.getStyleId() : "text";
        HTMLElement textElement = this.generateTextElement("P", element.getId(), spanClass, element.getText(), indentLevel);
        return textElement;
    }

    private HTMLElement generateIntroTitle(IntroPageTitle element, int indentLevel) {
        HTMLElement titleElement = this.generateHeaderDiv(element.getId(), element.getStyleId(), "H1", element.getTitle(), indentLevel);
        return titleElement;
    }

    private HTMLElement generateInlineIntroHTML(IntroHTML element, int indentLevel) {
        StringBuffer content = this.readFromFile(element.getSrc());
        if (content != null && content.length() > 0) {
            String divClass = element.getStyleId() != null ? element.getStyleId() : "inline-html";
            HTMLElement divElement = this.generateDivElement(element.getId(), divClass, indentLevel);
            divElement.addContent(content);
            return divElement;
        }
        return null;
    }

    private HTMLElement generateEmbeddedIntroHTML(IntroHTML element, int indentLevel) {
        HTMLElement img;
        IntroText htmlText;
        FormattedHTMLElement objectElement = new FormattedHTMLElement("OBJECT", indentLevel, true);
        objectElement.addAttribute("type", "text/html");
        if (element.getId() != null) {
            objectElement.addAttribute("id", element.getId());
        }
        if (element.getSrc() != null) {
            objectElement.addAttribute("data", element.getSrc());
        }
        if (element.getStyleId() != null) {
            objectElement.addAttribute("class", element.getStyleId());
        }
        if ((htmlText = element.getIntroText()) != null && htmlText.getText() != null) {
            String textClass = htmlText.getStyleId() != null ? htmlText.getStyleId() : "text";
            HTMLElement text = this.generateTextElement("P", htmlText.getId(), textClass, element.getText(), indentLevel);
            if (text != null) {
                objectElement.addContent(text);
            }
        }
        if (element.getIntroImage() != null && (img = this.generateIntroImage(element.getIntroImage(), indentLevel)) != null) {
            objectElement.addContent(img);
        }
        return objectElement;
    }

    private HTMLElement generateBaseElement(int indentLevel, String baseURL) {
        FormattedHTMLElement base = new FormattedHTMLElement("BASE", indentLevel, true, false);
        if (baseURL != null) {
            base.addAttribute("href", baseURL);
        }
        return base;
    }

    private HTMLElement generateStyleElement(int indentLevel) {
        FormattedHTMLElement style = new FormattedHTMLElement("STYLE", indentLevel, false);
        style.addAttribute("type", "text/css");
        style.addContent("HTML, BODY, IMG { border: 0px; }");
        return style;
    }

    private HTMLElement generateTitleElement(String title, int indentLevel) {
        FormattedHTMLElement titleElement = new FormattedHTMLElement("TITLE", indentLevel, false);
        if (title != null) {
            titleElement.addContent(title);
        }
        return titleElement;
    }

    private HTMLElement generateLinkElement(String href, int indentLevel) {
        FormattedHTMLElement link = new FormattedHTMLElement("LINK", indentLevel, true, false);
        link.addAttribute("rel", "stylesheet");
        link.addAttribute("style", "text/css");
        if (href != null) {
            link.addAttribute("href", href);
        }
        return link;
    }

    private HTMLElement generateAnchorElement(IntroLink link, int indentLevel) {
        FormattedHTMLElement anchor = new FormattedHTMLElement("A", indentLevel, true);
        if (link.getId() != null) {
            anchor.addAttribute("id", link.getId());
        }
        if (link.getUrl() != null) {
            anchor.addAttribute("href", link.getUrl());
        }
        if (link.getStyleId() != null) {
            anchor.addAttribute("class", link.getStyleId());
        } else {
            anchor.addAttribute("class", "link");
        }
        return anchor;
    }

    private HTMLElement generateHeaderDiv(String divId, String divClass, String headerType, String spanContent, int indentLevel) {
        HTMLElement text = this.generateTextElement(headerType, null, null, spanContent, indentLevel + 1);
        HTMLElement div = this.generateDivElement(divId, divClass, indentLevel);
        div.addContent(text);
        return div;
    }

    private HTMLElement generateTextElement(String type, String spanID, String spanClass, String spanContent, int indentLevel) {
        HTMLElement span = new HTMLElement("SPAN");
        if (spanID != null) {
            span.addAttribute("id", spanID);
        }
        if (spanClass != null) {
            span.addAttribute("class", spanClass);
        }
        if (spanContent != null) {
            span.addContent(spanContent);
        }
        FormattedHTMLElement text = new FormattedHTMLElement(type, indentLevel, false);
        text.addContent(span);
        return text;
    }

    private HTMLElement generateDivElement(String divId, String divClass, int indentLevel) {
        HTMLElement div = this.generateDivElement(divId, indentLevel);
        div.addAttribute("class", divClass);
        return div;
    }

    private HTMLElement generateDivElement(String divId, int indentLevel) {
        FormattedHTMLElement div = new FormattedHTMLElement("DIV", indentLevel, true);
        if (divId != null) {
            div.addAttribute("id", divId);
        }
        return div;
    }

    private HTMLElement generateImageElement(String imageSrc, String altText, String imageClass, int indentLevel) {
        FormattedHTMLElement image = new FormattedHTMLElement("IMG", indentLevel, true, false);
        image.addAttribute("src", imageSrc);
        if (altText == null) {
            altText = "";
        }
        image.addAttribute("alt", altText);
        if (imageClass != null) {
            image.addAttribute("class", imageClass);
        }
        return image;
    }

    private HTMLElement generateSpanElement(String spanClass, int indentLevel) {
        FormattedHTMLElement span = new FormattedHTMLElement("SPAN", indentLevel, false);
        span.addAttribute("class", spanClass);
        return span;
    }

    private boolean filteredFromPresentation(AbstractIntroElement element) {
        if (element.isOfType(4861)) {
            return ((AbstractBaseIntroElement)element).isFiltered();
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuffer readFromFile(String src) {
        if (src == null) {
            return null;
        }
        InputStream stream = null;
        StringBuffer content = new StringBuffer();
        BufferedReader reader = null;
        try {
            try {
                int character;
                URL url = new URL(src);
                stream = url.openStream();
                reader = new BufferedReader(new InputStreamReader(stream));
                while ((character = reader.read()) != -1) {
                    if (character == 36) {
                        PluginIdParser parser = new PluginIdParser(character, reader);
                        String text = parser.parsePluginId();
                        if (text == null) continue;
                        content.append(text);
                        continue;
                    }
                    if (character > 0 && character < 65535) {
                        content.append((char)character);
                        continue;
                    }
                    content.append(character);
                }
            }
            catch (Exception exception) {
                Log.error("Error reading from file", exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                Log.error("Error closing input stream", e);
                return null;
            }
        }
        {
            Object var9_12 = null;
        }
        try {}
        catch (IOException e) {
            Log.error("Error closing input stream", e);
            return null;
        }
        if (reader != null) {
            reader.close();
        }
        if (stream == null) return content;
        stream.close();
        return content;
    }

    private static class PluginIdParser {
        private BufferedReader reader;
        private static final char SUBSTITUTION_BEGIN = '$';
        private static final char SUBSTITUTION_END = '$';
        private StringBuffer tokenContent;
        private StringBuffer pluginId;

        protected PluginIdParser(char tokenBegin, BufferedReader bufferedreader) {
            this.reader = bufferedreader;
            this.tokenContent = new StringBuffer(tokenBegin);
            this.pluginId = new StringBuffer();
        }

        protected PluginIdParser(int tokenBegin, BufferedReader bufferedreader) {
            this.reader = bufferedreader;
            this.tokenContent = new StringBuffer();
            this.pluginId = new StringBuffer();
            if (tokenBegin > 0 && tokenBegin < 65535) {
                this.tokenContent.append((char)tokenBegin);
            }
        }

        protected String parsePluginId() {
            if (this.reader == null || this.tokenContent == null || this.pluginId == null) {
                return null;
            }
            try {
                this.reader.mark(1024);
                if (this.findValidPluginSegment()) {
                    String pluginPath = this.getPluginPath();
                    if (pluginPath == null) {
                        return this.tokenContent.toString();
                    }
                    return pluginPath;
                }
                this.reader.reset();
                return this.tokenContent.toString();
            }
            catch (IOException exception) {
                Log.error("Error reading from file", exception);
                return this.tokenContent.toString();
            }
        }

        private boolean findValidPluginSegment() {
            char[] PLUGIN_SEGMENT = new char[]{'p', 'l', 'u', 'g', 'i', 'n', ':'};
            char[] streamContent = new char[PLUGIN_SEGMENT.length];
            try {
                int peek = this.reader.read(streamContent, 0, PLUGIN_SEGMENT.length);
                if (peek == PLUGIN_SEGMENT.length && HTMLUtil.equalCharArrayContent(streamContent, PLUGIN_SEGMENT)) {
                    this.tokenContent.append(streamContent);
                    return true;
                }
                return false;
            }
            catch (IOException exception) {
                Log.error("Error reading from file", exception);
                return false;
            }
        }

        private String getPluginPath() {
            try {
                while (true) {
                    int nextChar;
                    if ((nextChar = this.reader.read()) == -1) {
                        return null;
                    }
                    if (nextChar == 36) {
                        String path = HTMLUtil.getResolvedBundleLocation(this.pluginId.toString());
                        if (path == null) {
                            this.reader.reset();
                        }
                        return path;
                    }
                    this.reader.mark(1024);
                    if (nextChar > 0 && nextChar < 65535) {
                        this.tokenContent.append((char)nextChar);
                        if (Character.isWhitespace((char)nextChar)) continue;
                        this.pluginId.append((char)nextChar);
                        continue;
                    }
                    this.tokenContent.append(nextChar);
                    this.pluginId.append(nextChar);
                }
            }
            catch (IOException exception) {
                Log.error("Error reading from file", exception);
                return null;
            }
        }
    }
}

