/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.AuthorizationHandler;
import org.eclipse.core.internal.runtime.DataArea;
import org.eclipse.core.internal.runtime.FindSupport;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.Product;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProductProvider;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.datalocation.FileManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public final class InternalPlatform {
    private BundleContext context;
    private IExtensionRegistry registry;
    private Plugin runtimeInstance;
    private ServiceTracker userLocation = null;
    private ServiceTracker instanceLocation = null;
    private ServiceTracker configurationLocation = null;
    private ServiceTracker installLocation = null;
    private ServiceTracker debugTracker = null;
    private DebugOptions options = null;
    private static IAdapterManager adapterManager;
    private static final InternalPlatform singleton;
    static EnvironmentInfo infoService;
    static URLConverter urlConverter;
    static FrameworkLog frameworkLog;
    static PackageAdmin packageAdmin;
    private static ArrayList logListeners;
    private static Map logs;
    private static PlatformLogWriter platformLog;
    private static DataArea metaArea;
    private static boolean initialized;
    private static Runnable endOfInitializationHandler;
    private static String password;
    private static String keyringFile;
    private static String[] allArgs;
    private static String[] appArgs;
    private static String[] frameworkArgs;
    private static boolean splashDown;
    public static String pluginCustomizationFile;
    private ArrayList groupProviders = new ArrayList(3);
    private IProduct product;
    private FileManager runtimeFileManager;
    private Path cachedInstanceLocation;
    private static final String OPTION_DEBUG = "org.eclipse.core.runtime/debug";
    private static final String OPTION_DEBUG_SYSTEM_CONTEXT = "org.eclipse.core.runtime/debug/context";
    private static final String OPTION_DEBUG_SHUTDOWN = "org.eclipse.core.runtime/timing/shutdown";
    private static final String OPTION_DEBUG_REGISTRY = "org.eclipse.core.runtime/registry/debug";
    private static final String OPTION_DEBUG_REGISTRY_DUMP = "org.eclipse.core.runtime/registry/debug/dump";
    private static final String OPTION_DEBUG_PREFERENCES = "org.eclipse.core.runtime/preferences/debug";
    private static final String PRODUCT = "-product";
    private static final String APPLICATION = "-application";
    private static final String KEYRING = "-keyring";
    private static final String PASSWORD = "-password";
    private static final String NO_REGISTRY_CACHE = "-noregistrycache";
    private static final String NO_LAZY_REGISTRY_CACHE_LOADING = "-noLazyRegistryCacheLoading";
    private static final String PLUGIN_CUSTOMIZATION = "-plugincustomization";
    private static final String NO_PACKAGE_PREFIXES = "-noPackagePrefixes";
    private static final String CLASSLOADER_PROPERTIES = "-classloaderProperties";
    private static final String BOOT = "-boot";
    private static final String PLUGINS = "-plugins";
    private static final String FIRST_USE = "-firstUse";
    private static final String NO_UPDATE = "-noUpdate";
    private static final String NEW_UPDATES = "-newUpdates";
    private static final String UPDATE = "-update";
    private static final String FEATURE = "-feature";
    public static boolean DEBUG;
    public static boolean DEBUG_CONTEXT;
    public static boolean DEBUG_REGISTRY;
    public static boolean DEBUG_STARTUP;
    public static boolean DEBUG_SHUTDOWN;
    public static String DEBUG_REGISTRY_DUMP;
    public static boolean DEBUG_PREFERENCES;
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final String PLUGIN_PATH = ".plugin-path";
    public static final String PROP_PRODUCT = "eclipse.product";
    public static final String PROP_APPLICATION = "eclipse.application";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    public static final String PROP_NO_REGISTRY_CACHE = "eclipse.noRegistryCache";
    public static final String PROP_NO_LAZY_CACHE_LOADING = "eclipse.noLazyRegistryCacheLoading";
    public static final String PROP_NO_REGISTRY_FLUSHING = "eclipse.noRegistryFlushing";
    public static final String PROP_EXITCODE = "eclipse.exitcode";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    public static final String PROP_USER_AREA = "osgi.user.area";
    public static final String PROP_MANIFEST_CACHE = "osgi.manifest.cache";
    public static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_CONSOLE = "osgi.console";
    public static final String PROP_CONSOLE_CLASS = "osgi.consoleClass";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_ADAPTOR = "osgi.adaptor";
    public static final String PROP_SYSPATH = "osgi.syspath";
    private static final String[] ARCH_LIST;
    private static final String[] OS_LIST;
    private static final String[] WS_LIST;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        singleton = new InternalPlatform();
        logListeners = new ArrayList(5);
        logs = new HashMap(5);
        platformLog = null;
        endOfInitializationHandler = null;
        password = "";
        allArgs = new String[0];
        appArgs = new String[0];
        frameworkArgs = new String[0];
        splashDown = false;
        pluginCustomizationFile = null;
        DEBUG = false;
        DEBUG_CONTEXT = false;
        DEBUG_REGISTRY = false;
        DEBUG_STARTUP = false;
        DEBUG_SHUTDOWN = false;
        DEBUG_REGISTRY_DUMP = null;
        DEBUG_PREFERENCES = false;
        ARCH_LIST = new String[]{"PA_RISC", "ppc", "sparc", "x86", "amd64", "ia64"};
        OS_LIST = new String[]{"aix", "hpux", "linux", "macosx", "qnx", "solaris", "win32"};
        WS_LIST = new String[]{"carbon", "gtk", "motif", "photon", "win32"};
    }

    private InternalPlatform() {
    }

    public static InternalPlatform getDefault() {
        return singleton;
    }

    public void addLogListener(ILogListener listener) {
        this.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            logListeners.remove(listener);
            logListeners.add(listener);
        }
    }

    public URL asLocalURL(URL url) throws IOException {
        URL result = url;
        if (result.getProtocol().equals("platform")) {
            result = this.asActualURL(url);
        }
        if (result.getProtocol().startsWith("bundle")) {
            if (urlConverter == null) {
                throw new IOException("url.noaccess");
            }
            result = urlConverter.convertToFileURL(result);
        }
        return result;
    }

    private URL asActualURL(URL url) throws IOException {
        if (!url.getProtocol().equals("platform")) {
            return url;
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof PlatformURLConnection) {
            return ((PlatformURLConnection)connection).getResolvedURL();
        }
        return url;
    }

    private void assertInitialized() {
        if (!initialized) {
            Assert.isTrue(false, Policy.bind("meta.appNotInit"));
        }
    }

    public void endSplash() {
        String startString;
        if (DEBUG && (startString = System.getProperty("eclipse.startTime")) != null) {
            try {
                long start = Long.parseLong(startString);
                long end = System.currentTimeMillis();
                System.out.println("Startup complete: " + (end - start) + "ms");
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (splashDown) {
            return;
        }
        splashDown = true;
        this.run(endOfInitializationHandler);
    }

    public IAdapterManager getAdapterManager() {
        this.assertInitialized();
        if (adapterManager == null) {
            adapterManager = new AdapterManager();
        }
        return adapterManager;
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String value = this.getOption(option);
        return value != null && value.equalsIgnoreCase("true") || defaultValue;
    }

    public int getIntegerOption(String option, int defaultValue) {
        String value = this.getOption(option);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public String[] getCommandLineArgs() {
        return allArgs;
    }

    public String getOption(String option) {
        if (this.options != null) {
            return this.options.getOption(option);
        }
        return null;
    }

    public IJobManager getJobManager() {
        return JobManager.getInstance();
    }

    public IPath getLogFileLocation() {
        return this.getMetaArea().getLogLocation();
    }

    public IPath getLocation() throws IllegalStateException {
        if (this.cachedInstanceLocation == null) {
            Location location = this.getInstanceLocation();
            if (location == null) {
                return null;
            }
            File file = new File(location.getURL().getFile());
            this.cachedInstanceLocation = new Path(file.toString());
        }
        return this.cachedInstanceLocation;
    }

    public ILog getLog(Bundle bundle) {
        ILog result = (ILog)logs.get(bundle);
        if (result != null) {
            return result;
        }
        result = new Log(bundle);
        logs.put(bundle, result);
        return result;
    }

    private void initializeAuthorizationHandler() {
        AuthorizationHandler.setKeyringFile(keyringFile);
        AuthorizationHandler.setPassword(password);
    }

    public DataArea getMetaArea() {
        if (metaArea != null) {
            return metaArea;
        }
        metaArea = new DataArea();
        return metaArea;
    }

    private void handleException(ISafeRunnable code, Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            Status status;
            String pluginId = "org.eclipse.core.runtime";
            String message = Policy.bind("meta.pluginProblems", pluginId);
            if (e instanceof CoreException) {
                status = new MultiStatus(pluginId, 2, message, e);
                status.merge(((CoreException)e).getStatus());
            } else {
                status = new Status(4, pluginId, 2, message, e);
            }
            if (initialized) {
                this.log(status);
            } else {
                e.printStackTrace();
            }
        }
        code.handleException(e);
    }

    public boolean hasLogWriter() {
        return platformLog != null && logListeners.contains(platformLog);
    }

    public IExtensionRegistry getRegistry() {
        return this.registry;
    }

    public void start(BundleContext runtimeContext) throws IOException {
        this.context = runtimeContext;
        this.initializeLocationTrackers();
        ResourceTranslator.start();
        endOfInitializationHandler = this.getSplashHandler();
        this.processCommandLine(infoService.getNonFrameworkArgs());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.debugTracker = new ServiceTracker(this.context, clazz.getName(), null);
        this.debugTracker.open();
        this.options = (DebugOptions)this.debugTracker.getService();
        this.initializeDebugFlags();
        initialized = true;
        this.getMetaArea();
        this.initializeAuthorizationHandler();
        platformLog = new PlatformLogWriter();
        this.addLogListener(platformLog);
        this.initializeRuntimeFileManager();
    }

    private void initializeRuntimeFileManager() throws IOException {
        File controlledDir = new File(String.valueOf(InternalPlatform.getDefault().getConfigurationLocation().getURL().getPath()) + '/' + "org.eclipse.core.runtime");
        controlledDir.mkdirs();
        this.runtimeFileManager = new FileManager(controlledDir, InternalPlatform.getDefault().getConfigurationLocation().isReadOnly() ? "none" : null);
        this.runtimeFileManager.open(true);
    }

    private Runnable getSplashHandler() {
        ServiceReference[] ref;
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Runnable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ref = this.context.getServiceReferences(clazz.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        int i = 0;
        while (i < ref.length) {
            String name = (String)ref[i].getProperty("name");
            if (name != null && name.equals("splashscreen")) {
                Runnable result = (Runnable)this.context.getService(ref[i]);
                this.context.ungetService(ref[i]);
                return result;
            }
            ++i;
        }
        return null;
    }

    public void stop(BundleContext bundleContext) {
        this.assertInitialized();
        JobManager.shutdown();
        this.debugTracker.close();
        ResourceTranslator.stop();
        initialized = false;
        this.context = null;
    }

    void initializeDebugFlags() {
        DEBUG = this.getBooleanOption(OPTION_DEBUG, false);
        if (DEBUG) {
            DEBUG_CONTEXT = this.getBooleanOption(OPTION_DEBUG_SYSTEM_CONTEXT, false);
            DEBUG_SHUTDOWN = this.getBooleanOption(OPTION_DEBUG_SHUTDOWN, false);
            DEBUG_REGISTRY = this.getBooleanOption(OPTION_DEBUG_REGISTRY, false);
            DEBUG_REGISTRY_DUMP = this.getOption(OPTION_DEBUG_REGISTRY_DUMP);
            DEBUG_PREFERENCES = this.getBooleanOption(OPTION_DEBUG_PREFERENCES, false);
        }
    }

    public void log(final IStatus status) {
        ILogListener[] listeners;
        this.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            listeners = logListeners.toArray(new ILogListener[logListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            final ILogListener listener = listeners[i];
            ISafeRunnable code = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.logging(status, "org.eclipse.core.runtime");
                }

                public void handleException(Throwable e) {
                }
            };
            this.run(code);
            ++i;
        }
    }

    private String[] processCommandLine(String[] args) {
        if (args == null) {
            return args;
        }
        allArgs = args;
        if (args.length == 0) {
            return args;
        }
        int[] configArgs = new int[args.length];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(NO_REGISTRY_CACHE)) {
                System.setProperty(PROP_NO_REGISTRY_CACHE, "true");
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_LAZY_REGISTRY_CACHE_LOADING)) {
                System.setProperty(PROP_NO_LAZY_CACHE_LOADING, "true");
                found = true;
            }
            if (args[i].equalsIgnoreCase(CLASSLOADER_PROPERTIES)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_PACKAGE_PREFIXES)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(PLUGINS)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(FIRST_USE)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_UPDATE)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(NEW_UPDATES)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(UPDATE)) {
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(KEYRING)) {
                    keyringFile = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(PASSWORD)) {
                    password = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(PRODUCT) || args[i - 1].equalsIgnoreCase(FEATURE)) {
                    System.setProperty(PROP_PRODUCT, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(APPLICATION)) {
                    System.setProperty(PROP_APPLICATION, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(PLUGIN_CUSTOMIZATION)) {
                    pluginCustomizationFile = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(CLASSLOADER_PROPERTIES)) {
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(BOOT)) {
                    found = true;
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            appArgs = args;
            return args;
        }
        appArgs = new String[args.length - configArgIndex];
        frameworkArgs = new String[configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int k = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                InternalPlatform.frameworkArgs[k++] = args[i2];
                ++configArgIndex;
            } else {
                InternalPlatform.appArgs[j++] = args[i2];
            }
            ++i2;
        }
        return appArgs;
    }

    public void removeLogListener(ILogListener listener) {
        this.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            logListeners.remove(listener);
        }
    }

    public URL resolve(URL url) throws IOException {
        URL result = this.asActualURL(url);
        if (!result.getProtocol().startsWith("bundle")) {
            return result;
        }
        if (urlConverter == null) {
            throw new IOException("url.noaccess");
        }
        result = urlConverter.convertToLocalURL(result);
        return result;
    }

    public void run(ISafeRunnable code) {
        Assert.isNotNull(code);
        try {
            code.run();
        }
        catch (Exception e) {
            this.handleException(code, e);
        }
        catch (LinkageError e) {
            this.handleException(code, e);
        }
    }

    private void run(Runnable handler) {
        if (handler == null) {
            return;
        }
        final Runnable finalHandler = handler;
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                finalHandler.run();
            }

            public void handleException(Throwable e) {
            }
        };
        this.run(code);
    }

    public void setOption(String option, String value) {
        if (this.options != null) {
            this.options.setOption(option, value);
        }
    }

    public Properties getPreferenceTranslator(String uniqueIdentifier, String basePrefFileName) {
        return new Properties();
    }

    public IPreferencesService getPreferencesService() {
        return PreferencesService.getDefault();
    }

    public String translatePreference(String value, Properties props) {
        value = value.trim();
        if (props == null || value.startsWith(KEY_DOUBLE_PREFIX)) {
            return value;
        }
        if (value.startsWith(KEY_PREFIX)) {
            int ix = value.indexOf(" ");
            String key = ix == -1 ? value : value.substring(0, ix);
            String dflt = ix == -1 ? value : value.substring(ix + 1);
            return props.getProperty(key.substring(1), dflt);
        }
        return value;
    }

    public void applyPrimaryFeaturePluginDefaultOverrides(String id, Preferences preferences) {
    }

    public void applyCommandLinePluginDefaultOverrides(String id, Preferences preferences) {
        if (pluginCustomizationFile == null) {
            if (DEBUG_PREFERENCES) {
                Policy.debug("Command line argument -pluginCustomization not used.");
            }
            return;
        }
        try {
            URL pluginCustomizationURL = new File(pluginCustomizationFile).toURL();
            if (DEBUG_PREFERENCES) {
                Policy.debug("Loading preferences from " + pluginCustomizationURL);
            }
            this.applyPluginDefaultOverrides(pluginCustomizationURL, id, preferences, null);
        }
        catch (MalformedURLException e) {
            if (DEBUG_PREFERENCES) {
                Policy.debug("MalformedURLException creating URL for plugin customization file " + pluginCustomizationFile);
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyPluginDefaultOverrides(URL propertiesURL, String id, Preferences preferences, Properties props) {
        block24: {
            block23: {
                block22: {
                    block21: {
                        overrides = new Properties();
                        in = null;
                        try {
                            try {
                                inFile = new File(propertiesURL.getFile());
                                if (!inFile.exists()) {
                                    if (InternalPlatform.DEBUG_PREFERENCES) {
                                        Policy.debug("Preference file " + propertiesURL + " not found.");
                                    }
                                    var8_9 = null;
                                    break block21;
                                }
                                in = new BufferedInputStream(new FileInputStream(inFile));
                                if (in == null) {
                                    if (InternalPlatform.DEBUG_PREFERENCES) {
                                        Policy.debug("Failed to open " + propertiesURL);
                                    }
                                    break block22;
                                }
                                overrides.load(in);
                                break block23;
                            }
                            catch (IOException e) {
                                if (InternalPlatform.DEBUG_PREFERENCES) {
                                    Policy.debug("IOException reading preference file " + propertiesURL);
                                    e.printStackTrace();
                                }
                                var8_11 = null;
                                try {
                                    if (in == null) return;
                                    in.close();
                                    return;
                                }
                                catch (IOException e) {
                                    if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                                    Policy.debug("IOException closing preference file " + propertiesURL);
                                    e.printStackTrace();
                                }
                                return;
                            }
                        }
                        catch (Throwable var9_21) {
                            var8_12 = null;
                            ** try [egrp 2[TRYBLOCK] [5 : 179->192)] { 
lbl39:
                            // 1 sources

                            if (in == null) throw var9_21;
                            in.close();
                            throw var9_21;
lbl42:
                            // 1 sources

                            catch (IOException e) {
                                if (InternalPlatform.DEBUG_PREFERENCES == false) throw var9_21;
                                Policy.debug("IOException closing preference file " + propertiesURL);
                                e.printStackTrace();
                            }
                            throw var9_21;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [5 : 179->192)] { 
lbl49:
                    // 1 sources

                    if (in == null) return;
                    in.close();
                    return;
lbl52:
                    // 1 sources

                    catch (IOException e) {
                        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                        Policy.debug("IOException closing preference file " + propertiesURL);
                        e.printStackTrace();
                    }
                    return;
                }
                var8_10 = null;
                ** try [egrp 2[TRYBLOCK] [5 : 179->192)] { 
lbl60:
                // 1 sources

                if (in == null) return;
                in.close();
                return;
lbl63:
                // 1 sources

                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                    Policy.debug("IOException closing preference file " + propertiesURL);
                    e.printStackTrace();
                }
                return;
            }
            var8_13 = null;
            ** try [egrp 2[TRYBLOCK] [5 : 179->192)] { 
lbl71:
            // 1 sources

            if (in != null) {
                in.close();
            }
            break block24;
lbl74:
            // 1 sources

            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block24;
                Policy.debug("IOException closing preference file " + propertiesURL);
                e.printStackTrace();
            }
        }
        it = overrides.entrySet().iterator();
        while (true) {
            if (!it.hasNext()) break;
            entry = it.next();
            qualifiedKey = (String)entry.getKey();
            s = qualifiedKey.indexOf(47);
            if (s < 0 || s == 0 || s == qualifiedKey.length() - 1 || !(pluginId = qualifiedKey.substring(0, s)).equals(id)) continue;
            propertyName = qualifiedKey.substring(s + 1);
            value = (String)entry.getValue();
            value = this.translatePreference(value, props);
            preferences.setDefault(propertyName, value);
        }
        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
        Policy.debug("Preferences now set as follows:");
        prefNames = preferences.propertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) break;
            value = preferences.getString(prefNames[i]);
            Policy.debug("\t" + prefNames[i] + " = " + value);
            ++i;
        }
        prefNames = preferences.defaultPropertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) {
                return;
            }
            value = preferences.getDefaultString(prefNames[i]);
            Policy.debug("\tDefault values: " + prefNames[i] + " = " + value);
            ++i;
        }
    }

    public void setExtensionRegistry(IExtensionRegistry value) {
        this.registry = value;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public Bundle getBundle(String symbolicName) {
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public Bundle[] getBundles(String symbolicName, String version) {
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, version);
        if (bundles == null) {
            return null;
        }
        if (bundles.length == 1 && (bundles[0].getState() & 3) == 0) {
            return bundles;
        }
        Bundle[] selectedBundles = new Bundle[bundles.length];
        int added = 0;
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                selectedBundles[added++] = bundles[i];
            }
            ++i;
        }
        if (added == 0) {
            return null;
        }
        Bundle[] results = new Bundle[added];
        System.arraycopy(selectedBundles, 0, results, 0, added);
        return results;
    }

    public boolean isFragment(Bundle bundle) {
        return (packageAdmin.getBundleType(bundle) & 1) > 0;
    }

    public Bundle[] getHosts(Bundle bundle) {
        return packageAdmin.getHosts(bundle);
    }

    public Bundle[] getFragments(Bundle bundle) {
        return packageAdmin.getFragments(bundle);
    }

    public URL getInstallURL() {
        Location location = this.getInstallLocation();
        if (location == null) {
            throw new IllegalStateException("The installation location must not be null");
        }
        return location.getURL();
    }

    public EnvironmentInfo getEnvironmentInfoService() {
        return infoService;
    }

    public URLConverter getURLConverter() {
        return urlConverter;
    }

    public FrameworkLog getFrameworkLog() {
        return frameworkLog;
    }

    public boolean isRunning() {
        try {
            return initialized && this.context.getBundle().getState() == 32;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL[] getPluginPath(URL pluginPathLocation) {
        InputStream input = null;
        if (pluginPathLocation == null) {
            return null;
        }
        try {
            input = pluginPathLocation.openStream();
        }
        catch (IOException iOException) {}
        if (input == null) {
            try {
                URL url = new URL("platform:/base/.plugin-path");
                input = url.openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        if (input == null) {
            return null;
        }
        URL[] result = null;
        try {
            try {
                result = this.readPluginPath(input);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                input.close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                input.close();
                return result;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    private URL[] readPluginPath(InputStream input) {
        Properties ini = new Properties();
        try {
            ini.load(input);
        }
        catch (IOException iOException) {
            return null;
        }
        Vector<URL> result = new Vector<URL>(5);
        Enumeration<?> groups = ini.propertyNames();
        while (groups.hasMoreElements()) {
            String group = (String)groups.nextElement();
            StringTokenizer entries = new StringTokenizer(ini.getProperty(group), ";");
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (entry.equals("")) continue;
                try {
                    result.addElement(new URL(entry));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(Policy.bind("ignore.plugin", entry));
                }
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    public Location getConfigurationLocation() {
        this.assertInitialized();
        return (Location)this.configurationLocation.getService();
    }

    public IContentTypeManager getContentTypeManager() {
        return ContentTypeManager.getInstance();
    }

    private void initializeLocationTrackers() {
        Filter filter = null;
        try {
            filter = this.context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.configuration.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.configurationLocation = new ServiceTracker(this.context, filter, null);
        this.configurationLocation.open();
        try {
            filter = this.context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.user.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.userLocation = new ServiceTracker(this.context, filter, null);
        this.userLocation.open();
        try {
            filter = this.context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.instance.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.instanceLocation = new ServiceTracker(this.context, filter, null);
        this.instanceLocation.open();
        try {
            filter = this.context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.install.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.installLocation = new ServiceTracker(this.context, filter, null);
        this.installLocation.open();
    }

    public Location getUserLocation() {
        this.assertInitialized();
        return (Location)this.userLocation.getService();
    }

    public IPath getStateLocation(Bundle bundle, boolean create) throws IllegalStateException {
        this.assertInitialized();
        IPath result = this.getMetaArea().getStateLocation(bundle);
        if (create) {
            result.toFile().mkdirs();
        }
        return result;
    }

    public URL find(Bundle b, IPath path) {
        return FindSupport.find(b, path);
    }

    public URL find(Bundle bundle, IPath path, Map override) {
        return FindSupport.find(bundle, path, override);
    }

    public IPath getStateLocation(Bundle bundle) {
        return this.getStateLocation(bundle, true);
    }

    public ResourceBundle getResourceBundle(Bundle bundle) {
        return ResourceTranslator.getResourceBundle(bundle);
    }

    public String getResourceString(Bundle bundle, String value) {
        return ResourceTranslator.getResourceString(bundle, value);
    }

    public String getResourceString(Bundle bundle, String value, ResourceBundle resourceBundle) {
        return ResourceTranslator.getResourceString(bundle, value, resourceBundle);
    }

    public String getOSArch() {
        return System.getProperty(PROP_ARCH);
    }

    public String getNL() {
        return System.getProperty(PROP_NL);
    }

    public String getOS() {
        return System.getProperty(PROP_OS);
    }

    public String getWS() {
        return System.getProperty(PROP_WS);
    }

    public String[] getApplicationArgs() {
        return appArgs;
    }

    public void setRuntimeInstance(Plugin runtime) {
        this.runtimeInstance = runtime;
    }

    public Plugin getRuntimeInstance() {
        return this.runtimeInstance;
    }

    public long getStateTimeStamp() {
        ServiceReference platformAdminReference;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((platformAdminReference = this.context.getServiceReference(clazz.getName())) == null) {
            return -1L;
        }
        return ((PlatformAdmin)this.context.getService(platformAdminReference)).getState(false).getTimeStamp();
    }

    public PlatformAdmin getPlatformAdmin() {
        ServiceReference platformAdminReference;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((platformAdminReference = this.context.getServiceReference(clazz.getName())) == null) {
            return null;
        }
        return (PlatformAdmin)this.context.getService(platformAdminReference);
    }

    public void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException {
        AuthorizationHandler.addAuthorizationInfo(serverUrl, realm, authScheme, info);
    }

    public void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        AuthorizationHandler.addProtectionSpace(resourceUrl, realm);
    }

    public void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        AuthorizationHandler.flushAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        return AuthorizationHandler.getAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public String getProtectionSpace(URL resourceUrl) {
        return AuthorizationHandler.getProtectionSpace(resourceUrl);
    }

    public Location getInstanceLocation() {
        this.assertInitialized();
        return (Location)this.instanceLocation.getService();
    }

    public Location getInstallLocation() {
        this.assertInitialized();
        return (Location)this.installLocation.getService();
    }

    public IBundleGroupProvider[] getBundleGroupProviders() {
        return this.groupProviders.toArray(new IBundleGroupProvider[this.groupProviders.size()]);
    }

    public IProduct getProduct() {
        if (this.product != null) {
            return this.product;
        }
        String productId = System.getProperty(PROP_PRODUCT);
        if (productId == null) {
            return null;
        }
        IConfigurationElement[] entries = this.getRegistry().getConfigurationElementsFor("org.eclipse.core.runtime", "products", productId);
        if (entries.length > 0) {
            this.product = new Product(productId, entries[0]);
            return this.product;
        }
        IConfigurationElement[] elements = this.getRegistry().getConfigurationElementsFor("org.eclipse.core.runtime", "products");
        ArrayList<FrameworkLogEntry> logEntries = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equalsIgnoreCase("provider")) {
                try {
                    IProductProvider provider = (IProductProvider)element.createExecutableExtension("run");
                    IProduct[] products = provider.getProducts();
                    int j = 0;
                    while (j < products.length) {
                        IProduct provided = products[j];
                        if (provided.getId().equalsIgnoreCase(productId)) {
                            this.product = provided;
                            return this.product;
                        }
                        ++j;
                    }
                }
                catch (CoreException e) {
                    if (logEntries == null) {
                        logEntries = new ArrayList<FrameworkLogEntry>(3);
                    }
                    logEntries.add(new FrameworkLogEntry("org.eclipse.core.runtime", Policy.bind("provider.invalid", element.getParent().toString()), 0, (Throwable)e, null));
                }
            }
            ++i;
        }
        if (logEntries != null) {
            this.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.core.runtime", Policy.bind("provider.invalid.general"), 0, null, (FrameworkLogEntry[])logEntries.toArray()));
        }
        return null;
    }

    public void registerBundleGroupProvider(IBundleGroupProvider provider) {
        this.groupProviders.add(provider);
    }

    public void unregisterBundleGroupProvider(IBundleGroupProvider provider) {
        this.groupProviders.remove(provider);
    }

    public FileManager getRuntimeFileManager() {
        return this.runtimeFileManager;
    }

    public String[] knownOSArchValues() {
        return ARCH_LIST;
    }

    public String[] knownOSValues() {
        return OS_LIST;
    }

    public String[] knownWSValues() {
        return WS_LIST;
    }
}

