/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.variants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.ISynchronizerChangeListener;
import org.eclipse.team.core.variants.PersistantResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.subscribers.BatchingLock;
import org.eclipse.team.internal.core.subscribers.SyncByteConverter;

public class ThreeWaySynchronizer
implements BatchingLock.IFlushOperation {
    private static final byte[] IGNORED_BYTES = "i".getBytes();
    private ILock lock = Platform.getJobManager().newLock();
    private BatchingLock batchingLock = new BatchingLock();
    private ResourceVariantByteStore cache;
    private Set listeners = new HashSet();

    public ThreeWaySynchronizer(QualifiedName name) {
        this(new PersistantResourceVariantByteStore(name));
    }

    public ThreeWaySynchronizer(ResourceVariantByteStore store) {
        this.cache = store;
    }

    public void addListener(ISynchronizerChangeListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ISynchronizerChangeListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public byte[] getBaseBytes(IResource resource) throws TeamException {
        byte[] baseBytes;
        block5: {
            byte[] syncBytes;
            block4: {
                try {
                    this.beginOperation();
                    syncBytes = this.internalGetSyncBytes(resource);
                    if (syncBytes != null) break block4;
                    byte[] byArray = null;
                    Object var4_6 = null;
                    this.endOperation();
                    return byArray;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    this.endOperation();
                    throw throwable;
                }
            }
            baseBytes = this.getSlot(syncBytes, 1);
            if (baseBytes != null && baseBytes.length != 0) break block5;
            byte[] byArray = null;
            Object var4_7 = null;
            this.endOperation();
            return byArray;
        }
        byte[] byArray = baseBytes;
        Object var4_8 = null;
        this.endOperation();
        return byArray;
    }

    /*
     * Exception decompiling
     */
    public void setBaseBytes(IResource resource, byte[] baseBytes) throws TeamException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 105->111)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isLocallyModified(IResource resource) throws TeamException {
        return this.internalGetSyncBytes(resource) == null && !this.isIgnored(resource) || this.getLocalTimestamp(resource) != resource.getModificationStamp() || this.getBaseBytes(resource) != null && !resource.exists();
    }

    public byte[] getRemoteBytes(IResource resource) throws TeamException {
        byte[] remoteBytes;
        block5: {
            byte[] syncBytes;
            block4: {
                try {
                    this.beginOperation();
                    syncBytes = this.internalGetSyncBytes(resource);
                    if (syncBytes != null) break block4;
                    byte[] byArray = null;
                    Object var4_6 = null;
                    this.endOperation();
                    return byArray;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    this.endOperation();
                    throw throwable;
                }
            }
            remoteBytes = this.getSlot(syncBytes, 2);
            if (remoteBytes != null && remoteBytes.length != 0) break block5;
            byte[] byArray = null;
            Object var4_7 = null;
            this.endOperation();
            return byArray;
        }
        byte[] byArray = remoteBytes;
        Object var4_8 = null;
        this.endOperation();
        return byArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setRemoteBytes(IResource resource, byte[] remoteBytes) throws TeamException {
        Assert.isNotNull(remoteBytes);
        rule = null;
        try {
            rule = this.beginBatching((ISchedulingRule)resource, null);
            try {
                block8: {
                    this.beginOperation();
                    syncBytes = this.internalGetSyncBytes(resource);
                    if (syncBytes != null) break block8;
                    slots = new String[]{"", "", new String(remoteBytes)};
                    syncBytes = this.toBytes(slots);
                    ** GOTO lbl30
                }
                currentRemote = this.getSlot(syncBytes, 2);
                if (this.equals(remoteBytes, currentRemote)) {
                    var6_7 = null;
                    this.endOperation();
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var7_13) {
                var6_9 = null;
                this.endOperation();
                throw var7_13;
            }
            var8_10 = null;
            if (rule == null) return false;
            this.endBatching(rule, null);
            return false;
lbl-1000:
            // 1 sources

            {
                syncBytes = this.setSlot(syncBytes, 2, remoteBytes);
lbl30:
                // 2 sources

                this.internalSetSyncBytes(resource, syncBytes);
                this.batchingLock.resourceChanged(resource);
                var6_8 = null;
                this.endOperation();
            }
        }
        catch (Throwable var9_14) {
            var8_12 = null;
            if (rule == null) throw var9_14;
            this.endBatching(rule, null);
            throw var9_14;
        }
        var8_11 = null;
        if (rule == null) return true;
        this.endBatching(rule, null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeRemoteBytes(IResource resource) throws TeamException {
        ISchedulingRule rule = null;
        try {
            block6: {
                byte[] syncBytes;
                block7: {
                    rule = this.beginBatching((ISchedulingRule)resource, null);
                    try {
                        this.beginOperation();
                        syncBytes = this.internalGetSyncBytes(resource);
                        if (syncBytes == null) break block6;
                        String currentRemote = new String(this.getSlot(syncBytes, 2));
                        if (currentRemote.length() != 0) break block7;
                        Object var5_5 = null;
                        this.endOperation();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        this.endOperation();
                        throw throwable;
                    }
                    Object var7_9 = null;
                    if (rule == null) return false;
                    this.endBatching(rule, null);
                    return false;
                }
                syncBytes = this.setSlot(syncBytes, 2, new byte[0]);
                this.internalSetSyncBytes(resource, syncBytes);
                this.batchingLock.resourceChanged(resource);
                Object var5_6 = null;
                this.endOperation();
                Object var7_10 = null;
                if (rule == null) return true;
                this.endBatching(rule, null);
                return true;
            }
            Object var5_7 = null;
            this.endOperation();
            Object var7_11 = null;
            if (rule == null) return false;
            this.endBatching(rule, null);
            return false;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (rule == null) throw throwable;
            this.endBatching(rule, null);
            throw throwable;
        }
    }

    public boolean hasSyncBytes(IResource resource) throws TeamException {
        return this.internalGetSyncBytes(resource) != null;
    }

    public boolean isIgnored(IResource resource) throws TeamException {
        byte[] bytes = this.cache.getBytes(resource);
        return bytes != null && this.equals(bytes, IGNORED_BYTES);
    }

    public void setIgnored(IResource resource) throws TeamException {
        this.internalSetSyncBytes(resource, IGNORED_BYTES);
    }

    public IResource[] members(IResource resource) throws TeamException {
        if (resource.getType() == 1) {
            return new IResource[0];
        }
        try {
            HashSet<IResource> potentialChildren = new HashSet<IResource>();
            IContainer container = (IContainer)resource;
            if (container.exists()) {
                potentialChildren.addAll(Arrays.asList(container.members()));
            }
            potentialChildren.addAll(Arrays.asList(this.cache.members(resource)));
            ArrayList<IResource> result = new ArrayList<IResource>();
            Iterator iter = potentialChildren.iterator();
            while (iter.hasNext()) {
                IResource child = (IResource)iter.next();
                if (!child.exists() && !this.hasSyncBytes(child)) continue;
                result.add(child);
            }
            return result.toArray(new IResource[result.size()]);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public void flush(IResource resource, int depth) throws TeamException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 52->58)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IResource resourceRule, IWorkspaceRunnable runnable, IProgressMonitor monitor) throws TeamException {
        block6: {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100);
            ISchedulingRule rule = this.beginBatching((ISchedulingRule)resourceRule, Policy.subMonitorFor(monitor, 10));
            try {
                try {
                    this.cache.run(resourceRule, runnable, Policy.subMonitorFor(monitor, 80));
                }
                catch (CoreException e) {
                    throw TeamException.asTeamException(e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (rule != null) {
                    this.endBatching(rule, Policy.subMonitorFor(monitor, 10));
                }
                monitor.done();
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (rule == null) break block6;
                this.endBatching(rule, Policy.subMonitorFor(monitor, 10));
            }
        }
        monitor.done();
    }

    public void flush(BatchingLock.ThreadInfo info, IProgressMonitor monitor) throws TeamException {
        if (info != null && !info.isEmpty()) {
            this.broadcastSyncChanges(info.getChangedResources());
        }
    }

    private void broadcastSyncChanges(final IResource[] resources) {
        ISynchronizerChangeListener[] allListeners;
        Set set = this.listeners;
        synchronized (set) {
            allListeners = this.listeners.toArray(new ISynchronizerChangeListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < allListeners.length) {
            final ISynchronizerChangeListener listener = allListeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.syncStateChanged(resources);
                }
            });
            ++i;
        }
    }

    private byte[] internalGetSyncBytes(IResource resource) throws TeamException {
        byte[] bytes = this.cache.getBytes(resource);
        if (bytes != null && this.equals(bytes, IGNORED_BYTES)) {
            return null;
        }
        return bytes;
    }

    private boolean internalSetSyncBytes(IResource resource, byte[] syncBytes) throws TeamException {
        return this.cache.setBytes(resource, syncBytes);
    }

    private byte[] getSlot(byte[] syncBytes, int i) {
        return SyncByteConverter.getSlot(syncBytes, i, false);
    }

    private byte[] setSlot(byte[] syncBytes, int i, byte[] insertBytes) throws TeamException {
        return SyncByteConverter.setSlot(syncBytes, i, insertBytes);
    }

    private byte[] toBytes(String[] slots) {
        return SyncByteConverter.toBytes(slots);
    }

    private long getLocalTimestamp(IResource resource) throws TeamException {
        byte[] bytes;
        block6: {
            byte[] syncBytes;
            block5: {
                try {
                    this.beginOperation();
                    syncBytes = this.internalGetSyncBytes(resource);
                    if (syncBytes != null) break block5;
                    Object var4_3 = null;
                    this.endOperation();
                    return 0L;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.endOperation();
                    throw throwable;
                }
            }
            bytes = this.getSlot(syncBytes, 0);
            if (bytes != null) {
                if (bytes.length != 0) break block6;
            }
            Object var4_4 = null;
            this.endOperation();
            return 0L;
        }
        long l = Long.parseLong(new String(bytes));
        Object var4_5 = null;
        this.endOperation();
        return l;
    }

    private boolean equals(byte[] syncBytes, byte[] oldBytes) {
        if (syncBytes.length != oldBytes.length) {
            return false;
        }
        int i = 0;
        while (i < oldBytes.length) {
            if (oldBytes[i] != syncBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void beginOperation() {
        if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
            return;
        }
        this.lock.acquire();
    }

    private void endOperation() {
        if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
            return;
        }
        this.lock.release();
    }

    private ISchedulingRule beginBatching(ISchedulingRule resourceRule, IProgressMonitor monitor) {
        return this.batchingLock.acquire(resourceRule, this, monitor);
    }

    private void endBatching(ISchedulingRule rule, IProgressMonitor monitor) throws TeamException {
        this.batchingLock.release(rule, monitor);
    }
}

