/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.ColorManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIAdapterFactory;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPropertiesAdapterFactory;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.StepFilterManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectiveManager;
import org.eclipse.debug.internal.ui.preferences.IDebugPreferenceConstants;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocumentManager;
import org.eclipse.debug.internal.ui.views.memory.IMemoryBlockViewSynchronizer;
import org.eclipse.debug.internal.ui.views.memory.MemoryBlockViewSynchronizer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;

public class DebugUIPlugin
extends AbstractUIPlugin
implements ILaunchListener {
    private static final String PI_DEBUG_UI = "org.eclipse.debug.ui";
    private static DebugUIPlugin fgDebugUIPlugin = null;
    protected static IDebugModelPresentation fgPresentation = null;
    private static DefaultLabelProvider fgDefaultLabelProvider;
    public static String ATTR_LAUNCHING_CONFIG_HANDLE;
    private boolean fTrace = false;
    private ConsoleDocumentManager fConsoleDocumentManager = null;
    private PerspectiveManager fPerspectiveManager = null;
    private LaunchConfigurationManager fLaunchConfigurationManager = null;
    private StepFilterManager fStepFilterManager = null;
    private MemoryBlockViewSynchronizer fMemBlkViewSynchronizer = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        ATTR_LAUNCHING_CONFIG_HANDLE = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + "launching_config_handle";
    }

    public boolean isTraceMode() {
        return this.fTrace;
    }

    public static void logTraceMessage(String message) {
        if (DebugUIPlugin.getDefault().isTraceMode()) {
            Status s = new Status(2, IDebugUIConstants.PLUGIN_ID, 120, message, null);
            DebugUIPlugin.getDefault().getLog().log((IStatus)s);
        }
    }

    public DebugUIPlugin() {
        fgDebugUIPlugin = this;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static DebugUIPlugin getDefault() {
        return fgDebugUIPlugin;
    }

    public static String getUniqueIdentifier() {
        return PI_DEBUG_UI;
    }

    public static IDebugModelPresentation getModelPresentation() {
        if (fgPresentation == null) {
            fgPresentation = new DelegatingModelPresentation();
        }
        return fgPresentation;
    }

    public LaunchConfigurationManager getLaunchConfigurationManager() {
        if (this.fLaunchConfigurationManager == null) {
            this.fLaunchConfigurationManager = new LaunchConfigurationManager();
        }
        return this.fLaunchConfigurationManager;
    }

    public IMemoryBlockViewSynchronizer getMemoryBlockViewSynchronizer() {
        if (this.fMemBlkViewSynchronizer == null) {
            this.fMemBlkViewSynchronizer = new MemoryBlockViewSynchronizer();
        }
        return this.fMemBlkViewSynchronizer;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getShell() {
        if (DebugUIPlugin.getActiveWorkbenchWindow() != null) {
            return DebugUIPlugin.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public static ILabelProvider getDefaultLabelProvider() {
        if (fgDefaultLabelProvider == null) {
            fgDefaultLabelProvider = new DefaultLabelProvider();
        }
        return fgDefaultLabelProvider;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
        if (bundle.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    protected ImageRegistry createImageRegistry() {
        return DebugPluginImages.initializeImageRegistry();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fPerspectiveManager != null) {
                this.fPerspectiveManager.shutdown();
            }
            if (this.fLaunchConfigurationManager != null) {
                this.fLaunchConfigurationManager.shutdown();
            }
            if (this.fConsoleDocumentManager != null) {
                this.fConsoleDocumentManager.shutdown();
            }
            if (this.fStepFilterManager != null) {
                this.fStepFilterManager.shutdown();
            }
            ColorManager.getDefault().dispose();
            if (fgPresentation != null) {
                fgPresentation.dispose();
            }
            if (this.fMemBlkViewSynchronizer != null) {
                this.fMemBlkViewSynchronizer.shutdown();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        IAdapterManager manager = Platform.getAdapterManager();
        DebugUIPropertiesAdapterFactory propertiesFactory = new DebugUIPropertiesAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDebugElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)propertiesFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.core.model.IProcess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)propertiesFactory, (Class)clazz2);
        DebugUIAdapterFactory uiFactory = new DebugUIAdapterFactory();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.debug.core.ILaunchConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)uiFactory, (Class)clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.debug.core.ILaunchConfigurationType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)uiFactory, (Class)clazz4);
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                SelectedResourceManager.getDefault();
            }
        });
    }

    protected void initializeDefaultPreferences(IPreferenceStore prefs) {
        prefs.setDefault(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH, true);
        prefs.setDefault(IInternalDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH, "prompt");
        prefs.setDefault(IDebugUIConstants.PREF_SHOW_DEBUG_PERSPECTIVE_DEFAULT, IDebugUIConstants.ID_DEBUG_PERSPECTIVE);
        prefs.setDefault(IDebugUIConstants.PREF_SHOW_RUN_PERSPECTIVE_DEFAULT, "perspective_none");
        prefs.setDefault(IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES, true);
        prefs.setDefault(IDebugUIConstants.PREF_ACTIVATE_WORKBENCH, true);
        prefs.setDefault(IInternalDebugUIConstants.PREF_ACTIVATE_DEBUG_VIEW, true);
        prefs.setDefault(IInternalDebugUIConstants.PREF_SWITCH_TO_PERSPECTIVE, "never");
        prefs.setDefault(IInternalDebugUIConstants.PREF_SWITCH_PERSPECTIVE_ON_SUSPEND, "prompt");
        prefs.setDefault(IInternalDebugUIConstants.PREF_WAIT_FOR_BUILD, "always");
        prefs.setDefault(IDebugUIConstants.PREF_REUSE_EDITOR, true);
        prefs.setDefault(IDebugUIConstants.PREF_SKIP_BREAKPOINTS_DURING_RUN_TO_LINE, false);
        prefs.setDefault(IInternalDebugUIConstants.PREF_RELAUNCH_IN_DEBUG_MODE, "never");
        prefs.setDefault(IInternalDebugUIConstants.PREF_CONTINUE_WITH_COMPILE_ERROR, "prompt");
        prefs.setDefault(IInternalDebugUIConstants.PREF_CONSOLE_SCROLL_LOCK, false);
        prefs.setDefault(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES, IDebugUIConstants.ID_DEBUG_PERSPECTIVE);
        prefs.setDefault(IInternalDebugUIConstants.PREF_TRACK_VIEWS, true);
        prefs.setDefault("Console.wrap", false);
        prefs.setDefault("Console.width", 80);
        prefs.setDefault("DEBUG.consoleOpenOnOut", true);
        prefs.setDefault("DEBUG.consoleOpenOnErr", true);
        prefs.setDefault("Console.limitConsoleOutput", true);
        prefs.setDefault("Console.lowWaterMark", 80000);
        prefs.setDefault("Console.highWaterMark", 100000);
        prefs.setDefault("Console.console_tab_width", 8);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.debug.ui.outColor", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.debug.ui.inColor", (RGB)new RGB(0, 200, 125));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.debug.ui.errorColor", (RGB)new RGB(255, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)IDebugPreferenceConstants.MEMORY_VIEW_UNBUFFERED_LINE_COLOR, (RGB)new RGB(114, 119, 129));
        prefs.setDefault(IDebugUIConstants.PREF_MAX_HISTORY_SIZE, 10);
        prefs.setDefault("Variables.detail.orientation", "Variables.detail.orientation.underneath");
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.debug.ui.changedVariableColor", (RGB)new RGB(255, 0, 0));
        prefs.setDefault(IDebugPreferenceConstants.PREF_DETAIL_PANE_WORD_WRAP, false);
        prefs.setDefault("Registers.detail.orientation", "Variables.detail.orientation.underneath");
        prefs.setDefault("org.eclipse.debug.ui.VariableView+org.eclipse.debug.ui.ShowDetailPaneAction", true);
        prefs.setDefault("org.eclipse.debug.ui.ExpressionView+org.eclipse.debug.ui.ShowDetailPaneAction", true);
        prefs.setDefault("org.eclipse.debug.ui.VariableView+org.eclipse.debug.ui.ShowTypeNamesAction", false);
        prefs.setDefault("org.eclipse.debug.ui.ExpressionView+org.eclipse.debug.ui.ShowTypeNamesAction", false);
        prefs.setDefault(IInternalDebugUIConstants.PREF_USE_STEP_FILTERS, false);
        prefs.setDefault("org.eclipse.debug.ui.memory.columnSize", 4);
    }

    protected IProcess getProcessFromInput(Object input) {
        IProcess processInput = null;
        if (input instanceof IProcess) {
            processInput = (IProcess)input;
        } else if (input instanceof ILaunch) {
            IDebugTarget target = ((ILaunch)input).getDebugTarget();
            if (target != null) {
                processInput = target.getProcess();
            } else {
                IProcess[] processes = ((ILaunch)input).getProcesses();
                if (processes != null && processes.length > 0) {
                    processInput = processes[0];
                }
            }
        } else if (input instanceof IDebugElement) {
            processInput = ((IDebugElement)input).getDebugTarget().getProcess();
        }
        return processInput;
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "Error within Debug UI: ", t);
            DebugUIPlugin.log(status);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static void log(IStatus status) {
        DebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Error logged from Debug UI: ", t));
    }

    public static void logDebugMessage(String message) {
        if (DebugUIPlugin.getDefault().isDebugging()) {
            DebugUIPlugin.logErrorMessage(message);
        }
    }

    public static void logErrorMessage(String message) {
        DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Internal message logged from Debug UI: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, message, exception);
    }

    protected static boolean saveAllEditors(boolean confirm) {
        if (DebugUIPlugin.getActiveWorkbenchWindow() == null) {
            return false;
        }
        return PlatformUI.getWorkbench().saveAllEditors(confirm);
    }

    public static boolean saveAndBuild() {
        boolean status = true;
        String saveDirty = DebugUIPlugin.getDefault().getPreferenceStore().getString(IInternalDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH);
        boolean buildBeforeLaunch = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH);
        if (saveDirty.equals("never")) {
            if (buildBeforeLaunch) {
                return DebugUIPlugin.doBuild();
            }
        } else {
            status = DebugUIPlugin.saveAllEditors(saveDirty.equals("prompt"));
            if (status && buildBeforeLaunch) {
                status = DebugUIPlugin.doBuild();
            }
        }
        return status;
    }

    private static boolean doBuild() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ResourcesPlugin.getWorkspace().build(10, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            String title = DebugUIMessages.getString("DebugUIPlugin.Run/Debug_1");
            String message = DebugUIMessages.getString("DebugUIPlugin.Build_error._Check_log_for_details._2");
            Throwable t = e.getTargetException();
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), title, message, t);
            return false;
        }
        return true;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Color getPreferenceColor(String type) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)DebugUIPlugin.getDefault().getPreferenceStore(), (String)type));
    }

    public ConsoleDocumentManager getConsoleDocumentManager() {
        if (this.fConsoleDocumentManager == null) {
            this.fConsoleDocumentManager = new ConsoleDocumentManager();
        }
        return this.fConsoleDocumentManager;
    }

    public static String serializeDocument(Document doc) throws TransformerException, IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static IStructuredSelection resolveSelection(IWorkbenchWindow window) {
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            selection = null;
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return null;
            }
            IEditorPart editor = page.getActiveEditor();
            IEditorInput element = null;
            if (editor != null) {
                element = editor.getEditorInput();
            }
            if (selection == null && element != null) {
                selection = new StructuredSelection((Object)element);
            }
        }
        return (IStructuredSelection)selection;
    }

    public void launchAdded(ILaunch launch) {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.getConsoleDocumentManager().startup();
        if (this.fPerspectiveManager == null) {
            PerspectiveManager manager = this.getPerspectiveManager();
            manager.launchAdded(launch);
        }
        if (this.fStepFilterManager == null) {
            this.getStepFilterManager().launchAdded(launch);
        }
        this.getLaunchConfigurationManager().startup();
    }

    public PerspectiveManager getPerspectiveManager() {
        if (this.fPerspectiveManager == null) {
            this.fPerspectiveManager = new PerspectiveManager();
            this.fPerspectiveManager.startup();
        }
        return this.fPerspectiveManager;
    }

    public StepFilterManager getStepFilterManager() {
        if (this.fStepFilterManager == null) {
            this.fStepFilterManager = new StepFilterManager();
        }
        return this.fStepFilterManager;
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    public static boolean preLaunchSave() {
        String saveDirty = DebugUIPlugin.getDefault().getPreferenceStore().getString(IInternalDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH);
        if (saveDirty.equals("never")) {
            return true;
        }
        return DebugUIPlugin.saveAllEditors(saveDirty.equals("prompt"));
    }

    public static ILaunch buildAndLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean buildBeforeLaunch = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH);
        IProgressMonitor subMonitor = monitor;
        String message = MessageFormat.format("{0}...", configuration.getName());
        if (buildBeforeLaunch) {
            monitor.beginTask(message, 200);
            return configuration.launch(mode, monitor, true);
        }
        subMonitor = monitor;
        subMonitor.beginTask(message, 100);
        return configuration.launch(mode, subMonitor);
    }

    public static void launchInForeground(final ILaunchConfiguration configuration, final String mode) {
        if (!DebugUIPlugin.preLaunchSave()) {
            return;
        }
        final IJobManager jobManager = Platform.getJobManager();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean wait = false;
        if (jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0 || jobManager.find(ResourcesPlugin.FAMILY_MANUAL_BUILD).length > 0) {
            String waitForBuild = store.getString(IInternalDebugUIConstants.PREF_WAIT_FOR_BUILD);
            if (waitForBuild.equals("prompt")) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)DebugUIPlugin.getShell(), (String)DebugUIMessages.getString("DebugUIPlugin.23"), (String)DebugUIMessages.getString("DebugUIPlugin.24"), null, (boolean)false, (IPreferenceStore)store, (String)IInternalDebugUIConstants.PREF_WAIT_FOR_BUILD);
                switch (dialog.getReturnCode()) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        wait = false;
                        break;
                    }
                    case 3: {
                        wait = true;
                    }
                }
            } else if (waitForBuild.equals("always")) {
                wait = true;
            }
        }
        if (wait) {
            IWorkbench workbench = DebugUIPlugin.getDefault().getWorkbench();
            IProgressService progressService = workbench.getProgressService();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                        jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (!monitor.isCanceled()) {
                        try {
                            DebugUIPlugin.buildAndLaunch(configuration, mode, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            };
            try {
                progressService.busyCursorWhile(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e2) {
                DebugUIPlugin.handleInvocationTargetException(e2, configuration, mode);
            }
        } else {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        DebugUIPlugin.buildAndLaunch(configuration, mode, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e) {
                DebugUIPlugin.handleInvocationTargetException(e, configuration, mode);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void handleInvocationTargetException(InvocationTargetException e, ILaunchConfiguration configuration, String mode) {
        Throwable targetException = e.getTargetException();
        Throwable t = e;
        if (targetException instanceof CoreException) {
            t = targetException;
        }
        if (t instanceof CoreException) {
            ILaunchGroup group;
            CoreException ce = (CoreException)t;
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(ce.getStatus());
            if (handler != null && (group = DebugUITools.getLaunchGroup(configuration, mode)) != null) {
                DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection((Object)configuration), group.getIdentifier(), ce.getStatus());
                return;
            }
        }
        DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIMessages.getString("DebugUITools.Error_1"), DebugUIMessages.getString("DebugUITools.Exception_occurred_during_launch_2"), t);
    }

    public static void launchInBackground(final ILaunchConfiguration configuration, final String mode) {
        if (!DebugUIPlugin.preLaunchSave()) {
            return;
        }
        final IJobManager jobManager = Platform.getJobManager();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean wait = jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0 || jobManager.find(ResourcesPlugin.FAMILY_MANUAL_BUILD).length > 0;
        String waitPref = store.getString(IInternalDebugUIConstants.PREF_WAIT_FOR_BUILD);
        if (wait) {
            if (waitPref.equals("prompt")) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)DebugUIPlugin.getShell(), (String)DebugUIMessages.getString("DebugUIPlugin.23"), (String)DebugUIMessages.getString("DebugUIPlugin.24"), null, (boolean)false, (IPreferenceStore)store, (String)IInternalDebugUIConstants.PREF_WAIT_FOR_BUILD);
                switch (dialog.getReturnCode()) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        wait = true;
                        break;
                    }
                    case 3: {
                        wait = false;
                    }
                }
            } else {
                wait = waitPref.equals("always");
            }
        }
        final boolean waitInJob = wait;
        Job job = new Job(DebugUIMessages.getString("DebugUITools.3")){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    if (waitInJob) {
                        try {
                            jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                            jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!monitor.isCanceled()) {
                        DebugUIPlugin.buildAndLaunch(configuration, mode, monitor);
                    }
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
                    if (handler == null) {
                        return status;
                    }
                    ILaunchGroup group = DebugUITools.getLaunchGroup(configuration, mode);
                    if (group == null) {
                        return status;
                    }
                    Runnable r = new Runnable(this, configuration, group, status){
                        final /* synthetic */ 6 this$1;
                        private final /* synthetic */ ILaunchConfiguration val$configuration;
                        private final /* synthetic */ ILaunchGroup val$group;
                        private final /* synthetic */ IStatus val$status;
                        {
                            this.this$1 = var1_1;
                            this.val$configuration = iLaunchConfiguration;
                            this.val$group = iLaunchGroup;
                            this.val$status = iStatus;
                        }

                        public void run() {
                            DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection((Object)this.val$configuration), this.val$group.getIdentifier(), this.val$status);
                        }
                    };
                    DebugUIPlugin.getStandardDisplay().asyncExec(r);
                }
                return Status.OK_STATUS;
            }
        };
        IWorkbench workbench = DebugUIPlugin.getDefault().getWorkbench();
        IProgressService progressService = workbench.getProgressService();
        job.setPriority(10);
        job.setName(DebugUIMessages.getString("DebugUITools.8"));
        if (wait) {
            progressService.showInDialog(workbench.getActiveWorkbenchWindow().getShell(), job);
        }
        job.schedule();
    }

    public static String removeAccelerators(String label) {
        String title = label;
        if (title != null) {
            int index = title.indexOf(38);
            if (index == 0) {
                title = title.substring(1);
            } else if (index > 0 && index < title.length() - 1) {
                String first = title.substring(0, index);
                String last = title.substring(index + 1);
                title = String.valueOf(first) + last;
            }
        }
        return title;
    }
}

