/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.views.console.ConsoleViewer;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class FollowHyperlinkAction
extends SelectionProviderAction {
    public FollowHyperlinkAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, ActionMessages.getString("FollowHyperlinkAction.&Open_Link_1"));
        this.setToolTipText(ActionMessages.getString("FollowHyperlinkAction.Follow_the_selected_hyperlink._2"));
        ISharedImages images = DebugUIPlugin.getDefault().getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_OPEN_MARKER"));
        WorkbenchHelp.setHelp((IAction)this, (String)IDebugHelpContextIds.FOLLOW_CONSOLE_HYPERLINK_ACTION);
    }

    public IConsoleHyperlink getHyperLink() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider instanceof ConsoleViewer) {
            ITextSelection textSelection = (ITextSelection)selectionProvider.getSelection();
            ConsoleViewer consoleViewer = (ConsoleViewer)selectionProvider;
            if (textSelection != null) {
                return consoleViewer.getHyperlink(textSelection.getOffset());
            }
        }
        return null;
    }

    public void run() {
        IConsoleHyperlink link = this.getHyperLink();
        if (link != null) {
            link.linkActivated();
        }
    }
}

