/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class AbstractJavaElementRenameChange
extends JDTChange {
    private String fNewName;
    private String fOldName;
    private IPath fResourcePath;

    protected AbstractJavaElementRenameChange(IPath resourcePath, String oldName, String newName) {
        Assert.isNotNull(newName, "new name");
        Assert.isNotNull(oldName, "old name");
        this.fResourcePath = resourcePath;
        this.fOldName = oldName;
        this.fNewName = newName;
    }

    protected IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public Object getModifiedElement() {
        return JavaCore.create((IResource)this.getResource());
    }

    protected abstract Change createUndoChange() throws JavaModelException;

    protected abstract void doRename(IProgressMonitor var1) throws CoreException;

    public final Change perform(IProgressMonitor pm) throws CoreException {
        Change change;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("AbstractRenameChange.Renaming"), 1);
            Change result = this.createUndoChange();
            this.doRename((IProgressMonitor)new SubProgressMonitor(pm, 1));
            change = result;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    protected String getNewName() {
        return this.fNewName;
    }

    protected IPath getResourcePath() {
        return this.fResourcePath;
    }

    protected String getOldName() {
        return this.fOldName;
    }

    protected static RefactoringStatus checkIfModifiable(IPackageFragmentRoot root, IProgressMonitor pm) throws CoreException {
        if (root == null) {
            return null;
        }
        if (!root.exists()) {
            return null;
        }
        if (root.isArchive()) {
            return null;
        }
        if (root.isExternal()) {
            return null;
        }
        IResource resource = root.getCorrespondingResource();
        if (!(resource instanceof IFolder)) {
            return null;
        }
        if (resource.isLinked()) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        JDTChange.checkIfModifiable(result, resource, false, false);
        return result;
    }
}

