/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.code.SnippetFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractMethodRefactoring
extends Refactoring {
    private ICompilationUnit fCUnit;
    private ImportRewrite fImportRewriter;
    private int fSelectionStart;
    private int fSelectionLength;
    private AST fAST;
    private OldASTRewrite fRewriter;
    private ExtractMethodAnalyzer fAnalyzer;
    private int fVisibility;
    private String fMethodName;
    private boolean fThrowRuntimeExceptions;
    private List fParameterInfos;
    private Set fUsedNames;
    private boolean fGenerateJavadoc;
    private boolean fReplaceDuplicates;
    private SnippetFinder.Match[] fDuplicates;
    private ASTNode fDestination;
    private ASTNode[] fDestinations;
    private static final String EMPTY = "";
    static /* synthetic */ Class class$0;

    private ExtractMethodRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) throws CoreException {
        Assert.isNotNull(cu);
        Assert.isNotNull(settings);
        this.fCUnit = cu;
        this.fImportRewriter = new ImportRewrite(cu);
        this.fMethodName = "extracted";
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fVisibility = -1;
    }

    public static boolean isAvailable(ASTNode[] selectedNodes) {
        if (selectedNodes == null || selectedNodes.length == 0) {
            return false;
        }
        if (selectedNodes.length == 1) {
            return selectedNodes[0] instanceof Statement || Checks.isExtractableExpression(selectedNodes[0]);
        }
        int i = 0;
        while (i < selectedNodes.length) {
            if (!(selectedNodes[i] instanceof Statement)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ExtractMethodRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) throws CoreException {
        return new ExtractMethodRefactoring(cu, selectionStart, selectionLength, settings);
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.name", new String[]{this.fMethodName, this.fCUnit.getElementName()});
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fSelectionStart < 0 || this.fSelectionLength == 0) {
            return this.mergeTextSelectionStatus(result);
        }
        result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit}), this.getValidationContext()));
        if (result.hasFatalError()) {
            return result;
        }
        CompilationUnit root = new RefactoringASTParser(2).parse(this.fCUnit, true, pm);
        this.fAST = root.getAST();
        root.accept(this.createVisitor());
        result.merge(this.fAnalyzer.checkActivation());
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fVisibility == -1) {
            this.setVisibility(2);
        }
        this.initializeParameterInfos();
        this.initializeUsedNames();
        this.initializeDuplicates();
        this.initializeDestinations();
        return result;
    }

    private ASTVisitor createVisitor() throws JavaModelException {
        this.fAnalyzer = new ExtractMethodAnalyzer(this.fCUnit, Selection.createFromStartLength(this.fSelectionStart, this.fSelectionLength));
        return this.fAnalyzer;
    }

    public void setMethodName(String name) {
        this.fMethodName = name;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public List getParameterInfos() {
        return this.fParameterInfos;
    }

    public void setThrowRuntimeExceptions(boolean throwRuntimeExceptions) {
        this.fThrowRuntimeExceptions = throwRuntimeExceptions;
    }

    public RefactoringStatus checkMethodName() {
        return Checks.checkMethodName(this.fMethodName);
    }

    public ASTNode[] getDestinations() {
        return this.fDestinations;
    }

    public void setDestination(int index) {
        this.fDestination = this.fDestinations[index];
    }

    public RefactoringStatus checkParameterNames() {
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo parameter = (ParameterInfo)iter.next();
            result.merge(Checks.checkIdentifier(parameter.getNewName()));
            Iterator others = this.fParameterInfos.iterator();
            while (others.hasNext()) {
                ParameterInfo other = (ParameterInfo)others.next();
                if (parameter == other || !other.getNewName().equals(parameter.getNewName())) continue;
                result.addError(RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.error.sameParameter", other.getNewName()));
                return result;
            }
            if (!parameter.isRenamed() || !this.fUsedNames.contains(parameter.getNewName())) continue;
            result.addError(RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.error.nameInUse", parameter.getNewName()));
            return result;
        }
        return result;
    }

    public Set getUsedNames() {
        return this.fUsedNames;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.getString("ExtractMethodRefactoring.checking_new_name"), 2);
        pm.subTask(EMPTY);
        RefactoringStatus result = this.checkMethodName();
        result.merge(this.checkParameterNames());
        pm.worked(1);
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        BodyDeclaration node = this.fAnalyzer.getEnclosingBodyDeclaration();
        if (node != null) {
            this.fAnalyzer.checkInput(result, this.fMethodName, this.fCUnit.getJavaProject(), this.fAST);
            pm.worked(1);
        }
        pm.done();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fMethodName == null) {
            return null;
        }
        this.fAnalyzer.aboutToCreateChange();
        BodyDeclaration declaration = this.fAnalyzer.getEnclosingBodyDeclaration();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        TypeDeclaration type = (TypeDeclaration)ASTNodes.getParent((ASTNode)declaration, clazz);
        this.fRewriter = new OldASTRewrite((ASTNode)type);
        String sourceMethodName = declaration.getNodeType() == 31 ? ((MethodDeclaration)declaration).getName().getIdentifier() : EMPTY;
        CompilationUnitChange result = new CompilationUnitChange(RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.change_name", new String[]{this.fMethodName, sourceMethodName}), this.fCUnit);
        result.setSaveMode(1);
        MultiTextEdit root = new MultiTextEdit();
        result.setEdit((TextEdit)root);
        TextBuffer buffer = null;
        try {
            List container;
            buffer = TextBuffer.acquire((IFile)WorkingCopyUtil.getOriginal(this.fCUnit).getResource());
            ASTNode[] selectedNodes = this.fAnalyzer.getSelectedNodes();
            ASTNodes.expandRange(selectedNodes, buffer, this.fSelectionStart, this.fSelectionLength);
            ASTNode target = this.getTargetNode(selectedNodes);
            MethodDeclaration mm = this.createNewMethod(this.fMethodName, true, target, buffer.getLineDelimiter());
            TextEditGroup insertDesc = new TextEditGroup(RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.add_method", this.fMethodName));
            result.addTextEditGroup(insertDesc);
            this.fRewriter.markAsInserted((ASTNode)mm, insertDesc);
            if (this.fDestination == this.fDestinations[0]) {
                container = ASTNodes.getContainingList((ASTNode)declaration);
                container.add(container.indexOf(declaration) + 1, mm);
            } else {
                container = ASTNodes.getBodyDeclarations(this.fDestination);
                int index = ASTNodes.getInsertionIndex((BodyDeclaration)mm, container);
                container.add(index, mm);
            }
            TextEditGroup description = new TextEditGroup(RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.substitute_with_call", this.fMethodName));
            result.addTextEditGroup(description);
            ASTNode[] callNodes = this.createCallNodes(null);
            this.fRewriter.replace(target, callNodes[0], description);
            if (callNodes.length > 1) {
                List container2 = ASTNodes.getContainingList(target);
                int index = container2.indexOf(target);
                int i = 1;
                while (i < callNodes.length) {
                    ASTNode node = callNodes[i];
                    container2.add(index + i, node);
                    this.fRewriter.markAsInserted(node, description);
                    ++i;
                }
            }
            this.replaceDuplicates(result);
            if (!this.fImportRewriter.isEmpty()) {
                TextEdit edit = this.fImportRewriter.createEdit(buffer.getDocument());
                root.addChild(edit);
                result.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.getString("ExtractMethodRefactoring.organize_imports"), new TextEdit[]{edit}));
            }
            MultiTextEdit changes = new MultiTextEdit();
            this.fRewriter.rewriteNode(buffer, (TextEdit)changes);
            root.addChild((TextEdit)changes);
            this.fRewriter.removeModifications();
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            TextBuffer.release(buffer);
            throw throwable;
        }
        {
            Object var18_21 = null;
        }
        TextBuffer.release(buffer);
        return result;
    }

    public String getSignature() {
        return this.getSignature(this.fMethodName);
    }

    public String getSignature(String methodName) {
        MethodDeclaration method = null;
        try {
            method = this.createNewMethod(methodName, false, null, String.valueOf('\n'));
        }
        catch (CoreException coreException) {
            Assert.isTrue(false);
        }
        method.setBody(this.fAST.newBlock());
        ASTFlattener flattener = new ASTFlattener(){

            public boolean visit(Block node) {
                return false;
            }
        };
        method.accept((ASTVisitor)flattener);
        return flattener.getResult();
    }

    public int getNumberOfDuplicates() {
        if (this.fDuplicates == null) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < this.fDuplicates.length) {
            if (!this.fDuplicates[i].isMethodBody()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public boolean getReplaceDuplicates() {
        return this.fReplaceDuplicates;
    }

    public void setReplaceDuplicates(boolean replace) {
        this.fReplaceDuplicates = replace;
    }

    public void setGenerateJavadoc(boolean generate) {
        this.fGenerateJavadoc = generate;
    }

    public boolean getGenerateJavadoc() {
        return this.fGenerateJavadoc;
    }

    private void initializeParameterInfos() {
        IVariableBinding[] arguments = this.fAnalyzer.getArguments();
        this.fParameterInfos = new ArrayList(arguments.length);
        BodyDeclaration root = this.fAnalyzer.getEnclosingBodyDeclaration();
        int i = 0;
        while (i < arguments.length) {
            IVariableBinding argument = arguments[i];
            if (argument != null) {
                VariableDeclaration declaration = ASTNodes.findVariableDeclaration(argument, (ASTNode)root);
                ParameterInfo info = new ParameterInfo(argument, this.getType(declaration), argument.getName(), i);
                info.setData(argument);
                this.fParameterInfos.add(info);
            }
            ++i;
        }
    }

    private void initializeUsedNames() {
        this.fUsedNames = UsedNamesCollector.perform(this.fAnalyzer.getSelectedNodes());
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo parameter = (ParameterInfo)iter.next();
            this.fUsedNames.remove(parameter.getOldName());
        }
    }

    private void initializeDuplicates() {
        BodyDeclaration start = this.fAnalyzer.getEnclosingBodyDeclaration();
        while (!(start instanceof TypeDeclaration) && !(start instanceof AnonymousClassDeclaration)) {
            start = start.getParent();
        }
        this.fDuplicates = SnippetFinder.perform((ASTNode)start, this.fAnalyzer.getSelectedNodes());
        this.fReplaceDuplicates = this.fDuplicates.length > 0 && !this.fAnalyzer.isLiteralNodeSelected();
    }

    private void initializeDestinations() {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        BodyDeclaration decl = this.fAnalyzer.getEnclosingBodyDeclaration();
        ASTNode current = this.getNextParent((ASTNode)decl);
        result.add(current);
        if (decl instanceof MethodDeclaration) {
            ITypeBinding binding = this.resolveBinding(current);
            ASTNode next = this.getNextParent(current);
            while (next != null && binding != null && binding.isNested() && !Modifier.isStatic((int)binding.getDeclaredModifiers())) {
                result.add(next);
                current = next;
                binding = this.resolveBinding(current);
                next = this.getNextParent(next);
            }
        }
        this.fDestinations = result.toArray(new ASTNode[result.size()]);
        this.fDestination = this.fDestinations[0];
    }

    private ASTNode getNextParent(ASTNode node) {
        while ((node = node.getParent()) != null && !(node instanceof TypeDeclaration) && !(node instanceof AnonymousClassDeclaration)) {
        }
        return node;
    }

    private ITypeBinding resolveBinding(ASTNode node) {
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).resolveBinding();
        }
        if (node instanceof AnonymousClassDeclaration) {
            return ((AnonymousClassDeclaration)node).resolveBinding();
        }
        return null;
    }

    private RefactoringStatus mergeTextSelectionStatus(RefactoringStatus status) {
        status.addFatalError(RefactoringCoreMessages.getString("ExtractMethodRefactoring.no_set_of_statements"));
        return status;
    }

    private String getType(VariableDeclaration declaration) {
        return ASTNodes.asString((ASTNode)ASTNodeFactory.newType(declaration.getAST(), declaration));
    }

    private ASTNode getTargetNode(ASTNode[] nodes) {
        if (nodes.length == 1) {
            return nodes[0];
        }
        ASTNode first = nodes[0];
        List container = ASTNodes.getContainingList(first);
        ASTNode result = this.fRewriter.collapseNodes(container, container.indexOf(first), nodes.length);
        return result;
    }

    private ASTNode[] createCallNodes(SnippetFinder.Match duplicate) {
        MethodInvocation call;
        ArrayList<Object> result = new ArrayList<Object>(2);
        IVariableBinding[] locals = this.fAnalyzer.getCallerLocals();
        int i = 0;
        while (i < locals.length) {
            result.add(this.createDeclaration(locals[i], null));
            ++i;
        }
        MethodInvocation invocation = this.fAST.newMethodInvocation();
        invocation.setName(this.fAST.newSimpleName(this.fMethodName));
        List arguments = invocation.arguments();
        int i2 = 0;
        while (i2 < this.fParameterInfos.size()) {
            ParameterInfo parameter = (ParameterInfo)this.fParameterInfos.get(i2);
            arguments.add(ASTNodeFactory.newName(this.fAST, this.getMappedName(duplicate, parameter)));
            ++i2;
        }
        int returnKind = this.fAnalyzer.getReturnKind();
        switch (returnKind) {
            case 2: {
                IVariableBinding binding = this.fAnalyzer.getReturnLocal();
                if (binding != null) {
                    VariableDeclarationStatement decl = this.createDeclaration(this.getMappedBinding(duplicate, binding), (Expression)invocation);
                    call = decl;
                    break;
                }
                Assignment assignment = this.fAST.newAssignment();
                assignment.setLeftHandSide((Expression)ASTNodeFactory.newName(this.fAST, this.getMappedBinding(duplicate, this.fAnalyzer.getReturnValue()).getName()));
                assignment.setRightHandSide((Expression)invocation);
                call = assignment;
                break;
            }
            case 4: {
                ReturnStatement rs = this.fAST.newReturnStatement();
                rs.setExpression((Expression)invocation);
                call = rs;
                break;
            }
            default: {
                call = invocation;
            }
        }
        if (call instanceof Expression && !this.fAnalyzer.isExpressionSelected()) {
            call = this.fAST.newExpressionStatement((Expression)call);
        }
        result.add(call);
        if (returnKind == 3 && !this.fAnalyzer.isLastStatementSelected()) {
            result.add(this.fAST.newReturnStatement());
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    private IVariableBinding getMappedBinding(SnippetFinder.Match duplicate, IVariableBinding org) {
        if (duplicate == null) {
            return org;
        }
        return duplicate.getMappedBinding(org);
    }

    private String getMappedName(SnippetFinder.Match duplicate, ParameterInfo paramter) {
        if (duplicate == null) {
            return paramter.getOldName();
        }
        return duplicate.getMappedName(paramter.getOldBinding()).getIdentifier();
    }

    private void replaceDuplicates(CompilationUnitChange result) {
        int numberOf = this.getNumberOfDuplicates();
        if (numberOf == 0 || !this.fReplaceDuplicates) {
            return;
        }
        String label = null;
        label = numberOf == 1 ? RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.duplicates.single", this.fMethodName) : RefactoringCoreMessages.getFormattedString("ExtractMethodRefactoring.duplicates.multi", this.fMethodName);
        TextEditGroup description = new TextEditGroup(label);
        result.addTextEditGroup(description);
        int d = 0;
        while (d < this.fDuplicates.length) {
            SnippetFinder.Match duplicate = this.fDuplicates[d];
            if (!duplicate.isMethodBody()) {
                ASTNode target = this.getTargetNode(duplicate.getNodes());
                ASTNode[] callNodes = this.createCallNodes(duplicate);
                this.fRewriter.replace(target, callNodes[0], description);
                if (callNodes.length > 1) {
                    List container = ASTNodes.getContainingList(target);
                    int index = container.indexOf(target);
                    int n = 1;
                    while (n < callNodes.length) {
                        ASTNode node = callNodes[n];
                        container.add(index + n, node);
                        this.fRewriter.markAsInserted(node, description);
                        ++n;
                    }
                }
            }
            ++d;
        }
    }

    private MethodDeclaration createNewMethod(String name, boolean code, ASTNode selection, String lineDelimiter) throws CoreException {
        MethodDeclaration result = this.fAST.newMethodDeclaration();
        int modifiers = this.fVisibility;
        if (Modifier.isStatic((int)this.fAnalyzer.getEnclosingBodyDeclaration().getModifiers()) || this.fAnalyzer.getForceStatic()) {
            modifiers |= 8;
        }
        result.setModifiers(modifiers);
        if (this.fAnalyzer.isExpressionSelected()) {
            String type = this.fImportRewriter.addImport(ASTNodes.asString((ASTNode)this.fAnalyzer.getReturnType()));
            result.setReturnType(ASTNodeFactory.newType(this.fAST, type));
        } else {
            result.setReturnType((Type)ASTNode.copySubtree((AST)this.fAST, (ASTNode)this.fAnalyzer.getReturnType()));
        }
        result.setName(this.fAST.newSimpleName(name));
        List parameters = result.parameters();
        int i = 0;
        while (i < this.fParameterInfos.size()) {
            ParameterInfo info = (ParameterInfo)this.fParameterInfos.get(i);
            VariableDeclaration infoDecl = this.getVariableDeclaration(info);
            SingleVariableDeclaration parameter = this.fAST.newSingleVariableDeclaration();
            parameter.setModifiers(ASTNodes.getModifiers(infoDecl));
            parameter.setType(ASTNodeFactory.newType(this.fAST, infoDecl));
            parameter.setName(this.fAST.newSimpleName(info.getNewName()));
            parameters.add(parameter);
            ++i;
        }
        List exceptions = result.thrownExceptions();
        ITypeBinding[] exceptionTypes = this.fAnalyzer.getExceptions(this.fThrowRuntimeExceptions, this.fAST);
        int i2 = 0;
        while (i2 < exceptionTypes.length) {
            ITypeBinding exceptionType = exceptionTypes[i2];
            exceptions.add(ASTNodeFactory.newName(this.fAST, this.fImportRewriter.addImport(exceptionType)));
            ++i2;
        }
        if (code) {
            result.setBody(this.createMethodBody(selection));
            if (this.fGenerateJavadoc) {
                TypeDeclaration enclosingType;
                String string;
                BodyDeclaration bodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((string = CodeGeneration.getMethodComment(this.fCUnit, (enclosingType = (TypeDeclaration)ASTNodes.getParent((ASTNode)bodyDeclaration, clazz)).getName().getIdentifier(), result, null, lineDelimiter)) != null) {
                    Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string, 29);
                    result.setJavadoc(javadoc);
                }
            }
        }
        return result;
    }

    private Block createMethodBody(ASTNode selection) {
        Block result = this.fAST.newBlock();
        List statements = result.statements();
        IVariableBinding[] methodLocals = this.fAnalyzer.getMethodLocals();
        int i = 0;
        while (i < methodLocals.length) {
            if (methodLocals[i] != null) {
                result.statements().add(this.createDeclaration(methodLocals[i], null));
            }
            ++i;
        }
        ASTNode[] selected = this.fAnalyzer.getSelectedNodes();
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo parameter = (ParameterInfo)iter.next();
            if (!parameter.isRenamed()) continue;
            int n = 0;
            while (n < selected.length) {
                SimpleName[] oldNames = LinkedNodeFinder.findByBinding(selected[n], (IBinding)parameter.getData());
                int i2 = 0;
                while (i2 < oldNames.length) {
                    this.fRewriter.replace((ASTNode)oldNames[i2], (ASTNode)this.fAST.newSimpleName(parameter.getNewName()), null);
                    ++i2;
                }
                ++n;
            }
        }
        boolean extractsExpression = this.fAnalyzer.isExpressionSelected();
        if (extractsExpression) {
            ITypeBinding binding = this.fAnalyzer.getExpressionBinding();
            if (!(binding == null || binding.isPrimitive() && "void".equals(binding.getName()))) {
                ReturnStatement rs = this.fAST.newReturnStatement();
                rs.setExpression((Expression)this.fRewriter.createCopyTarget(selection));
                this.fRewriter.markAsInserted((ASTNode)rs);
                statements.add(rs);
            } else {
                ExpressionStatement st = this.fAST.newExpressionStatement((Expression)this.fRewriter.createCopyTarget(selection));
                this.fRewriter.markAsInserted((ASTNode)st);
                statements.add(st);
            }
        } else {
            statements.add(this.fRewriter.createCopyTarget(selection));
            IVariableBinding returnValue = this.fAnalyzer.getReturnValue();
            if (returnValue != null) {
                ReturnStatement rs = this.fAST.newReturnStatement();
                rs.setExpression((Expression)this.fAST.newSimpleName(this.getName(returnValue)));
                statements.add(rs);
            }
        }
        return result;
    }

    private String getName(IVariableBinding binding) {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!Bindings.equals((IBinding)binding, (IBinding)info.getOldBinding())) continue;
            return info.getNewName();
        }
        return binding.getName();
    }

    private VariableDeclaration getVariableDeclaration(ParameterInfo parameter) {
        return ASTNodes.findVariableDeclaration((IVariableBinding)parameter.getData(), (ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
    }

    private VariableDeclarationStatement createDeclaration(IVariableBinding binding, Expression intilizer) {
        VariableDeclaration original = ASTNodes.findVariableDeclaration(binding, (ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
        VariableDeclarationFragment fragment = this.fAST.newVariableDeclarationFragment();
        fragment.setName((SimpleName)ASTNode.copySubtree((AST)this.fAST, (ASTNode)original.getName()));
        fragment.setInitializer(intilizer);
        VariableDeclarationStatement result = this.fAST.newVariableDeclarationStatement(fragment);
        result.setModifiers(ASTNodes.getModifiers(original));
        result.setType(ASTNodeFactory.newType(this.fAST, original));
        return result;
    }

    private static class UsedNamesCollector
    extends ASTVisitor {
        private Set result = new HashSet();
        private Set fIgnore = new HashSet();

        UsedNamesCollector() {
        }

        public static Set perform(ASTNode[] nodes) {
            UsedNamesCollector collector = new UsedNamesCollector();
            int i = 0;
            while (i < nodes.length) {
                nodes[i].accept((ASTVisitor)collector);
                ++i;
            }
            return collector.result;
        }

        public boolean visit(FieldAccess node) {
            Expression exp = node.getExpression();
            if (exp != null) {
                this.fIgnore.add(node.getName());
            }
            return true;
        }

        public void endVisit(FieldAccess node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(MethodInvocation node) {
            Expression exp = node.getExpression();
            if (exp != null) {
                this.fIgnore.add(node.getName());
            }
            return true;
        }

        public void endVisit(MethodInvocation node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(QualifiedName node) {
            this.fIgnore.add(node.getName());
            return true;
        }

        public void endVisit(QualifiedName node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(SimpleName node) {
            if (!this.fIgnore.contains(node)) {
                this.result.add(node.getIdentifier());
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            this.result.add(node.getName().getIdentifier());
            return false;
        }
    }
}

