/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassInfo;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jface.text.Assert;

public class NLSHint {
    private String fAccessorName;
    private IPackageFragment fAccessorPackage;
    private String fResourceBundleName;
    private IPackageFragment fResourceBundlePackage;
    private NLSSubstitution[] fSubstitutions;

    public NLSHint(ICompilationUnit cu, CompilationUnit astRoot) {
        Assert.isNotNull((Object)cu);
        Assert.isNotNull((Object)astRoot);
        IPackageFragment cuPackage = (IPackageFragment)cu.getAncestor(4);
        this.fAccessorName = "Messages";
        this.fAccessorPackage = cuPackage;
        this.fResourceBundleName = NLSRefactoring.getDefaultPropertiesFilename();
        this.fResourceBundlePackage = cuPackage;
        IJavaProject project = cu.getJavaProject();
        NLSLine[] lines = NLSHint.createRawLines(cu);
        AccessorClassInfo firstAccessInfo = NLSHint.findFirstClassInfo(lines, astRoot);
        Properties props = firstAccessInfo != null ? NLSHintHelper.getProperties(project, firstAccessInfo.getBinding()) : new Properties();
        this.fSubstitutions = this.createSubstitutions(lines, props, astRoot);
        if (firstAccessInfo != null) {
            this.fAccessorName = firstAccessInfo.getName();
            ITypeBinding accessorClassBinding = firstAccessInfo.getBinding();
            try {
                String fullBundleName;
                IPackageFragment accessorPack = NLSHintHelper.getPackageOfAccessorClass(project, accessorClassBinding);
                if (accessorPack != null) {
                    this.fAccessorPackage = accessorPack;
                }
                if ((fullBundleName = NLSHintHelper.getResourceBundleName(project, accessorClassBinding)) != null) {
                    this.fResourceBundleName = String.valueOf(Signature.getSimpleName((String)fullBundleName)) + ".properties";
                    String packName = Signature.getQualifier((String)fullBundleName);
                    IPackageFragment pack = NLSHintHelper.getResourceBundlePackage(project, packName, this.fResourceBundleName);
                    if (pack != null) {
                        this.fResourceBundlePackage = pack;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private NLSSubstitution[] createSubstitutions(NLSLine[] lines, Properties props, CompilationUnit astRoot) {
        ArrayList<NLSSubstitution> result = new ArrayList<NLSSubstitution>();
        int i = 0;
        while (i < lines.length) {
            NLSElement[] elements = lines[i].getElements();
            int j = 0;
            while (j < elements.length) {
                NLSElement nlsElement = elements[j];
                if (nlsElement.hasTag()) {
                    AccessorClassInfo accessorClassInfo = NLSHintHelper.getAccessorClassInfo(astRoot, nlsElement);
                    if (accessorClassInfo == null) {
                        result.add(new NLSSubstitution(1, NLSHint.stripQuotes(nlsElement.getValue()), nlsElement));
                    } else {
                        String key = NLSHint.stripQuotes(nlsElement.getValue());
                        String value = props.getProperty(key);
                        result.add(new NLSSubstitution(0, key, value, nlsElement, accessorClassInfo));
                    }
                } else {
                    result.add(new NLSSubstitution(2, NLSHint.stripQuotes(nlsElement.getValue()), nlsElement));
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new NLSSubstitution[result.size()]);
    }

    private static AccessorClassInfo findFirstClassInfo(NLSLine[] lines, CompilationUnit astRoot) {
        int i = 0;
        while (i < lines.length) {
            NLSElement[] elements = lines[i].getElements();
            int j = 0;
            while (j < elements.length) {
                AccessorClassInfo accessorClassInfo;
                NLSElement nlsElement = elements[j];
                if (nlsElement.hasTag() && (accessorClassInfo = NLSHintHelper.getAccessorClassInfo(astRoot, nlsElement)) != null) {
                    return accessorClassInfo;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static String stripQuotes(String str) {
        return str.substring(1, str.length() - 1);
    }

    private static NLSLine[] createRawLines(ICompilationUnit cu) {
        try {
            return NLSScanner.scan(cu);
        }
        catch (JavaModelException javaModelException) {
            return new NLSLine[0];
        }
        catch (InvalidInputException invalidInputException) {
            return new NLSLine[0];
        }
    }

    public String getAccessorClassName() {
        return this.fAccessorName;
    }

    public IPackageFragment getAccessorClassPackage() {
        return this.fAccessorPackage;
    }

    public String getResourceBundleName() {
        return this.fResourceBundleName;
    }

    public IPackageFragment getResourceBundlePackage() {
        return this.fResourceBundlePackage;
    }

    public NLSSubstitution[] getSubstitutions() {
        return this.fSubstitutions;
    }
}

