/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;

public class NLSScanner {
    private NLSScanner() {
    }

    public static NLSLine[] scan(ICompilationUnit cu) throws JavaModelException, InvalidInputException {
        return NLSScanner.scan(cu.getBuffer().getCharacters());
    }

    public static NLSLine[] scan(String s) throws InvalidInputException {
        return NLSScanner.scan(s.toCharArray());
    }

    private static NLSLine[] scan(char[] content) throws InvalidInputException {
        ArrayList<NLSLine> lines = new ArrayList<NLSLine>();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        scanner.setSource(content);
        int token = scanner.getNextToken();
        int currentLineNr = -1;
        int previousLineNr = -1;
        NLSLine currentLine = null;
        int nlsElementIndex = 0;
        while (token != 158) {
            switch (token) {
                case 45: {
                    currentLineNr = scanner.getLineNumber(scanner.getCurrentTokenStartPosition());
                    if (currentLineNr != previousLineNr) {
                        currentLine = new NLSLine(currentLineNr - 1);
                        lines.add(currentLine);
                        previousLineNr = currentLineNr;
                        nlsElementIndex = 0;
                    }
                    String value = new String(scanner.getCurrentTokenSource());
                    currentLine.add(new NLSElement(value, scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition() + 1 - scanner.getCurrentTokenStartPosition(), nlsElementIndex++));
                    break;
                }
                case 1001: {
                    if (currentLineNr != scanner.getLineNumber(scanner.getCurrentTokenStartPosition())) break;
                    NLSScanner.parseTags(currentLine, scanner);
                }
            }
            token = scanner.getNextToken();
        }
        NLSLine[] result = lines.toArray(new NLSLine[lines.size()]);
        TextBuffer buffer = TextBuffer.create(new String(scanner.getSource()));
        int i = 0;
        while (i < result.length) {
            NLSScanner.setTagPositions(buffer, result[i]);
            ++i;
        }
        return result;
    }

    private static void parseTags(NLSLine line, IScanner scanner) {
        String s = new String(scanner.getCurrentTokenSource());
        int pos = s.indexOf("//$NON-NLS-");
        while (pos != -1) {
            int start = pos + NLSElement.TAG_PREFIX_LENGTH;
            int end = s.indexOf("$", start);
            if (end < 0) {
                return;
            }
            String index = s.substring(start, end);
            int i = 0;
            try {
                i = Integer.parseInt(index) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (!line.exists(i)) {
                return;
            }
            NLSElement element = line.get(i);
            element.setTagPosition(scanner.getCurrentTokenStartPosition() + pos, end - pos + 1);
            pos = s.indexOf("//$NON-NLS-", start);
        }
    }

    private static void setTagPositions(TextBuffer buffer, NLSLine line) {
        TextRegion info = buffer.getLineInformation(line.getLineNumber());
        int defaultValue = info.getOffset() + info.getLength();
        NLSElement[] elements = line.getElements();
        int i = 0;
        while (i < elements.length) {
            NLSElement element = elements[i];
            if (!element.hasTag()) {
                element.setTagPosition(NLSScanner.computeInsertOffset(elements, i, defaultValue), 0);
            }
            ++i;
        }
    }

    private static int computeInsertOffset(NLSElement[] elements, int index, int defaultValue) {
        NLSElement previousTagged = NLSScanner.findPreviousTagged(index, elements);
        if (previousTagged != null) {
            return previousTagged.getTagPosition().getOffset() + previousTagged.getTagPosition().getLength();
        }
        NLSElement nextTagged = NLSScanner.findNextTagged(index, elements);
        if (nextTagged != null) {
            return nextTagged.getTagPosition().getOffset();
        }
        return defaultValue;
    }

    private static NLSElement findPreviousTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex - 1;
        while (i >= 0) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            --i;
        }
        return null;
    }

    private static NLSElement findNextTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex + 1;
        while (i < elements.length) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }
}

