/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class MoveInnerToTopRefactoring
extends Refactoring {
    private static final String THIS_KEYWORD = "this";
    private ImportRewriteManager fImportManager;
    private final CodeGenerationSettings fCodeGenerationSettings;
    private IType fType;
    private TextChangeManager fChangeManager;
    private String fEnclosingInstanceFieldName;
    private boolean fMarkInstanceFieldAsFinal;
    private boolean fCreateInstanceField;
    private String fNewSourceOfInputType;
    private String fNameForEnclosingInstanceConstructorParameter;
    private CompilationUnit fDeclaringCuNode;
    private boolean fIsInstanceFieldCreationPossible;
    private boolean fIsInstanceFieldCreationMandatory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private MoveInnerToTopRefactoring(IType type, CodeGenerationSettings codeGenerationSettings) throws JavaModelException {
        Assert.isNotNull(type);
        Assert.isNotNull(codeGenerationSettings);
        this.fType = type;
        this.fCodeGenerationSettings = codeGenerationSettings;
        this.fMarkInstanceFieldAsFinal = true;
    }

    public static MoveInnerToTopRefactoring create(IType type, CodeGenerationSettings codeGenerationSettings) throws JavaModelException {
        if (!MoveInnerToTopRefactoring.isAvailable(type)) {
            return null;
        }
        return new MoveInnerToTopRefactoring(type, codeGenerationSettings);
    }

    public static boolean isAvailable(IType type) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)type) && !Checks.isTopLevel(type) && !Checks.isInsideLocalType(type);
    }

    public boolean isInstanceFieldMarkedFinal() {
        return this.fMarkInstanceFieldAsFinal;
    }

    public void setMarkInstanceFieldAsFinal(boolean mark) {
        this.fMarkInstanceFieldAsFinal = mark;
    }

    public boolean isCreatingInstanceFieldPossible() {
        return this.fIsInstanceFieldCreationPossible;
    }

    public boolean isCreatingInstanceFieldMandatory() {
        return this.fIsInstanceFieldCreationMandatory;
    }

    public boolean getCreateInstanceField() {
        return this.fCreateInstanceField;
    }

    public void setCreateInstanceField(boolean create) {
        Assert.isTrue(this.fIsInstanceFieldCreationPossible);
        Assert.isTrue(!this.fIsInstanceFieldCreationMandatory);
        this.fCreateInstanceField = create;
    }

    private String getInitialNameForEnclosingInstanceField() {
        IType enclosingType = this.getEnclosingType();
        if (enclosingType == null) {
            return "";
        }
        String qualifiedTypeName = this.getTypeOfEnclosingInstanceField();
        String packageName = enclosingType.getPackageFragment().getElementName();
        String[] suggestedNames = NamingConventions.suggestFieldNames((IJavaProject)enclosingType.getJavaProject(), (String)packageName, (String)qualifiedTypeName, (int)0, (int)this.getEnclosingInstanceAccessModifiers(), (String[])MoveInnerToTopRefactoring.getFieldNames(this.fType));
        if (suggestedNames.length > 0) {
            return suggestedNames[0];
        }
        String name = enclosingType.getElementName();
        if (name.equals("")) {
            return "";
        }
        return String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
    }

    private static String[] getFieldNames(IType type) {
        try {
            IField[] fields = type.getFields();
            ArrayList<String> result = new ArrayList<String>(fields.length);
            int i = 0;
            while (i < fields.length) {
                result.add(fields[i].getElementName());
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IType getInputType() {
        return this.fType;
    }

    private IType getEnclosingType() {
        return this.fType.getDeclaringType();
    }

    public String getEnclosingInstanceName() {
        return this.fEnclosingInstanceFieldName;
    }

    public RefactoringStatus checkEnclosingInstanceName(String name) {
        if (!this.fCreateInstanceField) {
            return new RefactoringStatus();
        }
        RefactoringStatus result = Checks.checkFieldName(name);
        if (!Checks.startsWithLowerCase(name)) {
            result.addWarning(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.names_start_lowercase"));
        }
        if (this.fType.getField(name).exists()) {
            Object[] keys = new String[]{name, this.fType.getElementName()};
            String msg = RefactoringCoreMessages.getFormattedString("MoveInnerToTopRefactoring.already_declared", keys);
            result.addError(msg, JavaStatusContext.create((IMember)this.fType.getField(name)));
        }
        return result;
    }

    public void setEnclosingInstanceName(String name) {
        Assert.isNotNull(name);
        this.fEnclosingInstanceFieldName = name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        this.fImportManager = new ImportRewriteManager(this.fCodeGenerationSettings);
        this.fEnclosingInstanceFieldName = this.getInitialNameForEnclosingInstanceField();
        this.fDeclaringCuNode = new RefactoringASTParser(2).parse(this.getDeclaringCu(), true, pm);
        this.fIsInstanceFieldCreationPossible = !JdtFlags.isStatic((IMember)this.fType);
        this.fCreateInstanceField = this.fIsInstanceFieldCreationMandatory = this.fIsInstanceFieldCreationPossible && this.isInstanceFieldCreationMandatory();
        IType orig = (IType)WorkingCopyUtil.getOriginal((IMember)this.fType);
        if (orig == null || !orig.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("MoveInnerToTopRefactoring.deleted", new String[]{this.getInputTypeCu().getElementName()});
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        this.fType = orig;
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 2);
        try {
            RefactoringStatus result = new RefactoringStatus();
            if (this.isInputTypeStatic()) {
                result.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
            }
            if (this.getInputTypePackage().getCompilationUnit(this.getNameForNewCu()).exists()) {
                String message = RefactoringCoreMessages.getFormattedString("MoveInnerToTopRefactoring.compilation_Unit_exists", new String[]{this.getNameForNewCu(), this.getInputTypePackage().getElementName()});
                result.addFatalError(message);
            }
            result.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
            result.merge(Checks.checkCompilationUnitName(this.getNameForNewCu()));
            result.merge(this.checkConstructorParameterNames());
            result.merge(this.checkTypeNameInPackage());
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            result.merge(this.validateModifiesFiles());
            refactoringStatus = result;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkTypeNameInPackage() throws JavaModelException {
        IType type = Checks.findTypeInPackage(this.getInputTypePackage(), this.fType.getElementName());
        if (type == null || !type.exists()) {
            return null;
        }
        String message = RefactoringCoreMessages.getFormattedString("MoveInnerToTopRefactoring.type_exists", new String[]{this.fType.getElementName(), this.getInputTypePackage().getElementName()});
        return RefactoringStatus.createErrorStatus((String)message);
    }

    private RefactoringStatus checkConstructorParameterNames() {
        RefactoringStatus result = new RefactoringStatus();
        CompilationUnit cuNode = new RefactoringASTParser(2).parse(this.getInputTypeCu(), false);
        TypeDeclaration type = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, cuNode);
        MethodDeclaration[] nodes = this.getConstructorDeclarationNodes(type);
        int i = 0;
        while (i < nodes.length) {
            MethodDeclaration constructor = nodes[i];
            Iterator iter = constructor.parameters().iterator();
            while (iter.hasNext()) {
                SingleVariableDeclaration param = (SingleVariableDeclaration)iter.next();
                if (!this.fEnclosingInstanceFieldName.equals(param.getName().getIdentifier())) continue;
                String msg = RefactoringCoreMessages.getFormattedString("MoveInnerToTopRefactoring.name_used", new String[]{param.getName().getIdentifier(), this.fType.getElementName()});
                result.addError(msg, JavaStatusContext.create(this.getInputTypeCu(), (ASTNode)param));
            }
            ++i;
        }
        return result;
    }

    private boolean isInputTypeStatic() throws JavaModelException {
        return JdtFlags.isStatic((IMember)this.fType);
    }

    private IPackageFragment getInputTypePackage() {
        return this.fType.getPackageFragment();
    }

    public String getName() {
        return RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.name");
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.creating_preview"), 1);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.move_to_Top"));
            result.addAll((Change[])this.fChangeManager.getAllChanges());
            result.add(this.createCompilationUnitForMovedType((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            DynamicValidationStateChange dynamicValidationStateChange = result;
            Object var3_4 = null;
            this.fImportManager.clear();
            return dynamicValidationStateChange;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.fImportManager.clear();
            throw throwable;
        }
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        Map constructorReferences;
        pm.beginTask(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.29"), 2);
        TextChangeManager manager = new TextChangeManager();
        Map typeReferences = this.createTypeReferencesMapping((IProgressMonitor)new SubProgressMonitor(pm, 1), status);
        if (this.isInputTypeStatic()) {
            constructorReferences = new HashMap(0);
            pm.worked(1);
        } else {
            constructorReferences = this.createConstructorReferencesMapping((IProgressMonitor)new SubProgressMonitor(pm, 1), status);
        }
        ICompilationUnit declaringCu = this.getDeclaringCu();
        Iterator iter = MoveInnerToTopRefactoring.getMergedSet(typeReferences.keySet(), constructorReferences.keySet()).iterator();
        while (iter.hasNext()) {
            ICompilationUnit processedCu = (ICompilationUnit)iter.next();
            OldASTRewrite rewrite = this.createRewrite(typeReferences, constructorReferences, declaringCu, processedCu, false);
            if (processedCu.equals(declaringCu)) {
                this.fNewSourceOfInputType = this.getNewSourceForInputType(processedCu, rewrite);
                rewrite.removeModifications();
                rewrite = this.createRewrite(typeReferences, constructorReferences, declaringCu, processedCu, true);
            }
            this.addTextEditFromRewrite(manager, processedCu, rewrite);
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        pm.done();
        return manager;
    }

    private ICompilationUnit getDeclaringCu() {
        return this.fType.getCompilationUnit();
    }

    private String getNewSourceForInputType(ICompilationUnit processedCu, OldASTRewrite rewrite) throws CoreException, JavaModelException {
        CompilationUnitChange ch = new CompilationUnitChange("", processedCu);
        TextEdit edit = this.getRewriteTextEdit(processedCu, rewrite);
        TextChangeCompatibility.addTextEdit((TextChange)ch, "", edit);
        String newSource = ch.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        ASTParser p = ASTParser.newParser((int)2);
        p.setSource(newSource.toCharArray());
        CompilationUnit cuNode = (CompilationUnit)p.createAST(null);
        TypeDeclaration td = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, cuNode);
        return newSource.substring(td.getStartPosition(), ASTNodes.getExclusiveEnd((ASTNode)td));
    }

    private OldASTRewrite createRewrite(Map typeReferences, Map constructorReferences, ICompilationUnit declaringCu, ICompilationUnit processedCu, boolean removeTypeDeclaration) throws CoreException {
        CompilationUnit cuNode = this.getAST(processedCu);
        OldASTRewrite rewrite = new OldASTRewrite((ASTNode)cuNode);
        if (processedCu.equals(declaringCu)) {
            TypeDeclaration td = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, cuNode);
            if (!removeTypeDeclaration && !this.isInputTypeStatic() && this.fCreateInstanceField) {
                if (this.typeHasNoConstructors()) {
                    this.createConstructor(td, rewrite);
                } else {
                    this.modifyConstructors(td, rewrite);
                }
                this.addEnclosingInstanceDeclaration(td, rewrite);
            }
            this.modifyAccessesToMembersFromEnclosingInstance(td, rewrite);
            if (removeTypeDeclaration) {
                rewrite.remove((ASTNode)td, null);
            } else {
                this.removeUnusedTypeModifiers(td, rewrite);
            }
        }
        ASTNode[] typeRefs = MoveInnerToTopRefactoring.getReferenceNodesIn(cuNode, typeReferences, processedCu);
        int i = 0;
        while (i < typeRefs.length) {
            this.updateTypeReference(typeRefs[i], rewrite, processedCu);
            ++i;
        }
        ASTNode[] constructorsRefs = MoveInnerToTopRefactoring.getReferenceNodesIn(cuNode, constructorReferences, processedCu);
        int i2 = 0;
        while (i2 < constructorsRefs.length) {
            this.updateConstructorReference(constructorsRefs[i2], rewrite, processedCu);
            ++i2;
        }
        return rewrite;
    }

    private CompilationUnit getAST(ICompilationUnit processedCu) {
        if (processedCu.equals(this.getDeclaringCu())) {
            return this.fDeclaringCuNode;
        }
        return new RefactoringASTParser(2).parse(processedCu, true);
    }

    private boolean typeHasNoConstructors() throws JavaModelException {
        return JavaElementUtil.getAllConstructors(this.fType).length == 0;
    }

    private boolean isInstanceFieldCreationMandatory() {
        TypeDeclaration td = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, this.fDeclaringCuNode);
        MemberAccessNodeCollector collector = new MemberAccessNodeCollector(this.getEnclosingType());
        td.accept((ASTVisitor)collector);
        return MoveInnerToTopRefactoring.containsNonStatic(collector.getFieldAccesses()) || MoveInnerToTopRefactoring.containsNonStatic(collector.getMethodInvocations()) || MoveInnerToTopRefactoring.containsNonStatic(collector.getSimpleFieldNames());
    }

    private static boolean containsNonStatic(SimpleName[] fieldNames) {
        int i = 0;
        while (i < fieldNames.length) {
            if (!MoveInnerToTopRefactoring.isStaticFieldName(fieldNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean containsNonStatic(MethodInvocation[] invocations) {
        int i = 0;
        while (i < invocations.length) {
            if (!MoveInnerToTopRefactoring.isStatic(invocations[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean containsNonStatic(FieldAccess[] accesses) {
        int i = 0;
        while (i < accesses.length) {
            if (!MoveInnerToTopRefactoring.isStatic(accesses[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isStatic(MethodInvocation invocation) {
        IMethodBinding methodBinding = invocation.resolveMethodBinding();
        if (methodBinding == null) {
            return false;
        }
        return JdtFlags.isStatic(methodBinding);
    }

    private static boolean isStatic(FieldAccess access) {
        IVariableBinding fieldBinding = access.resolveFieldBinding();
        if (fieldBinding == null) {
            return false;
        }
        return JdtFlags.isStatic(fieldBinding);
    }

    private static boolean isStaticFieldName(SimpleName name) {
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        if (!variableBinding.isField()) {
            return false;
        }
        return JdtFlags.isStatic(variableBinding);
    }

    private static TypeDeclaration findTypeDeclaration(IType type, CompilationUnit cuNode) {
        List types = MoveInnerToTopRefactoring.getDeclaringTypes(type);
        types.add(type);
        TypeDeclaration[] declarations = cuNode.types().toArray(new TypeDeclaration[cuNode.types().size()]);
        TypeDeclaration td = null;
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            IType enclosing = (IType)iter.next();
            td = MoveInnerToTopRefactoring.findTypeDeclaration(enclosing, declarations);
            Assert.isNotNull(td);
            declarations = td.getTypes();
        }
        Assert.isNotNull(td);
        return td;
    }

    private static TypeDeclaration findTypeDeclaration(IType enclosing, TypeDeclaration[] declarations) {
        String typeName = enclosing.getElementName();
        int i = 0;
        while (i < declarations.length) {
            TypeDeclaration declaration = declarations[i];
            if (declaration.getName().getIdentifier().equals(typeName)) {
                return declaration;
            }
            ++i;
        }
        return null;
    }

    private static List getDeclaringTypes(IType type) {
        IType declaringType = type.getDeclaringType();
        if (declaringType == null) {
            return new ArrayList(0);
        }
        List result = MoveInnerToTopRefactoring.getDeclaringTypes(declaringType);
        result.add(declaringType);
        return result;
    }

    private static Set getMergedSet(Set s1, Set s2) {
        HashSet result = new HashSet();
        result.addAll(s1);
        result.addAll(s2);
        return result;
    }

    private Map createTypeReferencesMapping(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fType, (int)3);
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fType);
        SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, scope, pm, status);
        return MoveInnerToTopRefactoring.createSearchResultMapping(groups);
    }

    private Map createConstructorReferencesMapping(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchResultGroup[] groups = ConstructorReferenceFinder.getConstructorReferences(this.fType, pm, status);
        return MoveInnerToTopRefactoring.createSearchResultMapping(groups);
    }

    private static Map createSearchResultMapping(SearchResultGroup[] groups) {
        HashMap<ICompilationUnit, SearchMatch[]> result = new HashMap<ICompilationUnit, SearchMatch[]>();
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.put(cu, group.getSearchResults());
            }
            ++i;
        }
        return result;
    }

    private static ASTNode[] getReferenceNodesIn(CompilationUnit cuNode, Map references, ICompilationUnit cu) {
        SearchMatch[] results = (SearchMatch[])references.get(cu);
        if (results == null) {
            return new ASTNode[0];
        }
        return ASTNodeSearchUtil.getAstNodes(results, cuNode);
    }

    private void addTextEditFromRewrite(TextChangeManager manager, ICompilationUnit cu, OldASTRewrite rewrite) throws CoreException {
        TextChange textChange = manager.get(cu);
        TextEdit resultingEdit = this.getRewriteTextEdit(cu, rewrite);
        TextChangeCompatibility.addTextEdit(textChange, RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.30"), resultingEdit);
        rewrite.removeModifications();
    }

    private TextEdit getRewriteTextEdit(ICompilationUnit cu, OldASTRewrite rewrite) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(cu.getBuffer().getContents());
        MultiTextEdit resultingEdit = new MultiTextEdit();
        rewrite.rewriteNode(textBuffer, (TextEdit)resultingEdit);
        if (this.fImportManager.hasImportEditFor(cu)) {
            ImportRewrite importRewrite = this.fImportManager.getImportRewrite(cu);
            resultingEdit.addChild(importRewrite.createEdit(textBuffer.getDocument()));
        }
        return resultingEdit;
    }

    private void modifyAccessesToMembersFromEnclosingInstance(TypeDeclaration typeDeclaration, OldASTRewrite rewrite) {
        MemberAccessNodeCollector collector = new MemberAccessNodeCollector(this.getEnclosingType());
        typeDeclaration.accept((ASTVisitor)collector);
        this.modifyAccessToMethodsFromEnclosingInstance(rewrite, collector.getMethodInvocations(), typeDeclaration);
        this.modifyAccessToFieldsFromEnclosingInstance(rewrite, collector.getFieldAccesses(), typeDeclaration);
        this.modifyAccessToFieldsFromEnclosingInstance(rewrite, collector.getSimpleFieldNames(), typeDeclaration);
    }

    private void modifyAccessToFieldsFromEnclosingInstance(OldASTRewrite rewrite, SimpleName[] simpleNames, TypeDeclaration inputType) {
        int i = 0;
        while (i < simpleNames.length) {
            SimpleName simpleName = simpleNames[i];
            IBinding vb = simpleName.resolveBinding();
            if (vb != null) {
                Expression newExpression = this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)simpleName, vb, inputType);
                FieldAccess access = simpleName.getAST().newFieldAccess();
                access.setExpression(newExpression);
                access.setName(simpleName.getAST().newSimpleName(simpleName.getIdentifier()));
                rewrite.replace((ASTNode)simpleName, (ASTNode)access, null);
            }
            ++i;
        }
    }

    private void modifyAccessToFieldsFromEnclosingInstance(OldASTRewrite rewrite, FieldAccess[] fieldAccesses, TypeDeclaration inputType) {
        int i = 0;
        while (i < fieldAccesses.length) {
            IVariableBinding vb;
            FieldAccess fieldAccess = fieldAccesses[i];
            Assert.isNotNull(fieldAccess.getExpression());
            if (fieldAccess.getExpression() instanceof ThisExpression && ((ThisExpression)fieldAccess.getExpression()).getQualifier() != null && (vb = MoveInnerToTopRefactoring.resolveFieldBinding(fieldAccess)) != null) {
                Expression newExpression = this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)fieldAccess, (IBinding)vb, inputType);
                rewrite.replace((ASTNode)fieldAccess.getExpression(), (ASTNode)newExpression, null);
            }
            ++i;
        }
    }

    private void modifyAccessToMethodsFromEnclosingInstance(OldASTRewrite rewrite, MethodInvocation[] methodInvocations, TypeDeclaration inputType) {
        int i = 0;
        while (i < methodInvocations.length) {
            MethodInvocation methodInvocation = methodInvocations[i];
            IMethodBinding mb = methodInvocation.resolveMethodBinding();
            if (mb != null) {
                Expression newExpression;
                Expression invocExpression = methodInvocation.getExpression();
                if (invocExpression == null) {
                    newExpression = this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)methodInvocation, (IBinding)mb, inputType);
                    methodInvocation.setExpression(newExpression);
                    rewrite.markAsInserted((ASTNode)newExpression);
                } else if (methodInvocation.getExpression() instanceof ThisExpression && ((ThisExpression)methodInvocation.getExpression()).getQualifier() != null) {
                    newExpression = this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)methodInvocation, (IBinding)mb, inputType);
                    rewrite.replace((ASTNode)invocExpression, (ASTNode)newExpression, null);
                }
            }
            ++i;
        }
    }

    private static boolean isStatic(IBinding binding) {
        return Modifier.isStatic((int)binding.getModifiers());
    }

    private Expression createAccessExpressionToEnclosingInstanceFieldText(ASTNode node, IBinding binding, TypeDeclaration inputType) {
        if (MoveInnerToTopRefactoring.isStatic(binding)) {
            return this.getNameOfTypeOfEnclosingInstanceField(node.getAST());
        }
        if (this.isInTypeNestedInInputType(node, inputType)) {
            return this.createQualifiedReadAccessExpressionForEnclosingInstance(node.getAST());
        }
        return this.createReadAccessExpressionForEnclosingInstance(node.getAST());
    }

    private boolean isInTypeNestedInInputType(ASTNode node, TypeDeclaration inputType) {
        return this.isInAnonymousTypeInsideInputType(node, inputType) || this.isInLocalTypeInsideInputType(node, inputType) || this.isInNonStaticMemberTypeInsideInputType(node, inputType);
    }

    private boolean isInLocalTypeInsideInputType(ASTNode node, TypeDeclaration inputType) {
        TypeDeclarationStatement localType;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclarationStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (localType = (TypeDeclarationStatement)ASTNodes.getParent(node, clazz)) != null && ASTNodes.isParent((ASTNode)localType, (ASTNode)inputType);
    }

    private boolean isInNonStaticMemberTypeInsideInputType(ASTNode node, TypeDeclaration inputType) {
        TypeDeclaration nested;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (nested = (TypeDeclaration)ASTNodes.getParent(node, clazz)) != null && !inputType.equals((Object)nested) && !Modifier.isStatic((int)nested.getFlags()) && ASTNodes.isParent((ASTNode)nested, (ASTNode)inputType);
    }

    private boolean isInAnonymousTypeInsideInputType(ASTNode node, TypeDeclaration inputType) {
        AnonymousClassDeclaration anon;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (anon = (AnonymousClassDeclaration)ASTNodes.getParent(node, clazz)) != null && ASTNodes.isParent((ASTNode)anon, (ASTNode)inputType);
    }

    private void modifyConstructors(TypeDeclaration td, OldASTRewrite rewrite) throws CoreException {
        MethodDeclaration[] constructorNodes = this.getConstructorDeclarationNodes(td);
        int i = 0;
        while (i < constructorNodes.length) {
            MethodDeclaration decl = constructorNodes[i];
            Assert.isTrue(decl.isConstructor());
            this.addParameterToConstructor(rewrite, decl);
            this.setEnclosingInstanceFieldInConstructor(rewrite, decl);
            ++i;
        }
    }

    private void setEnclosingInstanceFieldInConstructor(OldASTRewrite rewrite, MethodDeclaration decl) throws JavaModelException {
        Block body = decl.getBody();
        List statements = body.statements();
        AST ast = decl.getAST();
        if (statements.isEmpty()) {
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide(this.createReadAccessExpressionForEnclosingInstance(ast));
            assignment.setRightHandSide((Expression)this.createNameNodeForEnclosingInstanceConstructorParameter(ast));
            ExpressionStatement initialization = ast.newExpressionStatement((Expression)assignment);
            statements.add(0, initialization);
            rewrite.markAsInserted((ASTNode)initialization);
        } else {
            Statement first = (Statement)statements.get(0);
            if (first instanceof ConstructorInvocation) {
                ConstructorInvocation ci = (ConstructorInvocation)first;
                SimpleName newArg = ast.newSimpleName(this.fEnclosingInstanceFieldName);
                ci.arguments().add(0, newArg);
                rewrite.markAsInserted((ASTNode)newArg);
            } else {
                Assignment assignment = ast.newAssignment();
                assignment.setLeftHandSide(this.createReadAccessExpressionForEnclosingInstance(ast));
                assignment.setRightHandSide((Expression)this.createNameNodeForEnclosingInstanceConstructorParameter(ast));
                ExpressionStatement initialization = ast.newExpressionStatement((Expression)assignment);
                statements.add(1, initialization);
                rewrite.markAsInserted((ASTNode)initialization);
            }
        }
    }

    private void addParameterToConstructor(OldASTRewrite rewrite, MethodDeclaration declaration) throws JavaModelException {
        AST ast = declaration.getAST();
        String newParamName = this.getNameForEnclosingInstanceConstructorParameter();
        SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
        Type paramType = this.getTypeOfEnclosingInstanceField(ast);
        SimpleName paramName = ast.newSimpleName(newParamName);
        param.setType(paramType);
        param.setName(paramName);
        declaration.parameters().add(0, param);
        rewrite.markAsInserted((ASTNode)param);
        JavadocUtil.addParamJavadoc(newParamName, declaration, rewrite, this.fType.getJavaProject(), null);
    }

    private void createConstructor(TypeDeclaration declaration, OldASTRewrite rewrite) throws CoreException {
        BodyDeclaration newConst = (BodyDeclaration)rewrite.createStringPlaceholder(this.formatConstructorSource(this.getNewConstructorSource(), 0), 31);
        declaration.bodyDeclarations().add(0, newConst);
        rewrite.markAsInserted((ASTNode)newConst);
    }

    private String getNewConstructorSource() throws CoreException {
        String lineDelimiter = this.getLineSeperator();
        String bodyStatement = this.createEnclosingInstanceInitialization();
        String constructorBody = CodeGeneration.getMethodBodyContent(this.fType.getCompilationUnit(), this.fType.getElementName(), this.fType.getElementName(), true, bodyStatement, lineDelimiter);
        if (constructorBody == null) {
            constructorBody = "";
        }
        return String.valueOf(this.getNewConstructorComment()) + this.fType.getElementName() + '(' + this.createDeclarationForEnclosingInstanceConstructorParameter() + "){" + lineDelimiter + constructorBody + lineDelimiter + '}';
    }

    private String getNewConstructorComment() throws CoreException {
        if (!this.fCodeGenerationSettings.createComments) {
            return "";
        }
        String comment = CodeGeneration.getMethodComment(this.getInputTypeCu(), this.fType.getElementName(), this.fType.getElementName(), this.getNewConstructorParameterNames(), new String[0], null, null, this.getLineSeperator());
        if (comment == null) {
            return "";
        }
        return String.valueOf(comment) + this.getLineSeperator();
    }

    private String[] getNewConstructorParameterNames() throws JavaModelException {
        if (!this.fCreateInstanceField) {
            return new String[0];
        }
        return new String[]{this.getNameForEnclosingInstanceConstructorParameter()};
    }

    private void addEnclosingInstanceDeclaration(TypeDeclaration type, OldASTRewrite rewrite) {
        VariableDeclarationFragment fragment = type.getAST().newVariableDeclarationFragment();
        fragment.setName(type.getAST().newSimpleName(this.fEnclosingInstanceFieldName));
        FieldDeclaration newField = type.getAST().newFieldDeclaration(fragment);
        newField.setModifiers(this.getEnclosingInstanceAccessModifiers());
        newField.setType(ASTNodeFactory.newType(type.getAST(), this.getTypeOfEnclosingInstanceField()));
        type.bodyDeclarations().add(0, newField);
        rewrite.markAsInserted((ASTNode)newField);
    }

    private int getEnclosingInstanceAccessModifiers() {
        if (this.fMarkInstanceFieldAsFinal) {
            return 18;
        }
        return 2;
    }

    private void removeUnusedTypeModifiers(TypeDeclaration type, OldASTRewrite rewrite) {
        int newModifiers = JdtFlags.clearFlag(14, type.getModifiers());
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS_PROPERTY, new Integer(newModifiers), null);
    }

    private void updateTypeReference(ASTNode node, OldASTRewrite rewrite, ICompilationUnit cu) throws CoreException {
        ImportDeclaration enclosingImport = MoveInnerToTopRefactoring.getEnclosingImportDeclaration(node);
        if (enclosingImport != null) {
            this.updateReferenceInImport(enclosingImport, node, cu);
        } else {
            boolean updated = this.updateReference(node, rewrite);
            if (updated && !this.getInputTypePackage().equals(cu.getParent())) {
                this.fImportManager.addImportTo(this.getNewFullyQualifiedNameOfInputType(), cu);
            }
        }
    }

    private void updateReferenceInImport(ImportDeclaration enclosingImport, ASTNode node, ICompilationUnit cu) throws CoreException {
        IBinding importBinding = enclosingImport.resolveBinding();
        if (!(importBinding instanceof ITypeBinding)) {
            return;
        }
        this.fImportManager.removeImportTo(this.getSourceOfImport(enclosingImport, importBinding), cu);
        this.fImportManager.addImportTo(this.getSourceForModifiedImport(node, cu), cu);
    }

    private String getSourceOfImport(ImportDeclaration enclosingImport, IBinding importBinding) {
        String fullyQualifiedTypeName = MoveInnerToTopRefactoring.getFullyQualifiedImportName((ITypeBinding)importBinding);
        if (enclosingImport.isOnDemand()) {
            return String.valueOf(fullyQualifiedTypeName) + ".*";
        }
        return fullyQualifiedTypeName;
    }

    private String getSourceForModifiedImport(ASTNode node, ICompilationUnit cu) throws JavaModelException {
        ImportDeclaration enclosingImport = MoveInnerToTopRefactoring.getEnclosingImportDeclaration(node);
        int start = enclosingImport.getName().getStartPosition();
        int end = ASTNodes.getExclusiveEnd((ASTNode)enclosingImport);
        String rawImportSource = cu.getBuffer().getText(start, end - start);
        String newFullyQualifiedName = new StringBuffer(rawImportSource).replace(0, ASTNodes.getExclusiveEnd(node) - start, this.getNewFullyQualifiedNameOfInputType()).toString();
        return newFullyQualifiedName.substring(0, newFullyQualifiedName.length() - 1);
    }

    private static ImportDeclaration getEnclosingImportDeclaration(ASTNode node) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.ImportDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ImportDeclaration)ASTNodes.getParent(node, clazz);
    }

    private boolean updateReference(ASTNode node, OldASTRewrite rewrite) {
        if (node.getNodeType() == 40) {
            return this.updateNameReference((Name)((QualifiedName)node), rewrite);
        }
        if (node.getNodeType() == 43) {
            return this.updateNameReference(((SimpleType)node).getName(), rewrite);
        }
        return false;
    }

    private boolean updateNameReference(Name name, OldASTRewrite rewrite) {
        if (name instanceof SimpleName) {
            return false;
        }
        if (this.isFullyQualifiedName(name)) {
            rewrite.replace((ASTNode)name, (ASTNode)name.getAST().newName(Strings.splitByToken(this.getNewFullyQualifiedNameOfInputType(), ".")), null);
            return true;
        }
        rewrite.replace((ASTNode)name, (ASTNode)name.getAST().newSimpleName(this.fType.getElementName()), null);
        return true;
    }

    private boolean isFullyQualifiedName(Name name) {
        return ASTNodes.asString((ASTNode)name).equals(this.fType.getFullyQualifiedName('.'));
    }

    private String getNewFullyQualifiedNameOfInputType() {
        return String.valueOf(this.fType.getPackageFragment().getElementName()) + '.' + this.fType.getElementName();
    }

    private ICompilationUnit getInputTypeCu() {
        return this.fType.getCompilationUnit();
    }

    private Change createCompilationUnitForMovedType(IProgressMonitor pm) throws CoreException {
        CreateTextFileChange createTextFileChange;
        block2: {
            ICompilationUnit newCuWC = null;
            try {
                newCuWC = WorkingCopyUtil.getNewWorkingCopy(this.getInputTypePackage(), this.getNameForNewCu());
                String source = this.createSourceForNewCu(newCuWC, pm);
                createTextFileChange = new CreateTextFileChange(this.createPathForNewCu(), source, null, "java");
                Object var4_5 = null;
                if (newCuWC == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_6 = null;
                    if (newCuWC == null) break block3;
                    newCuWC.discardWorkingCopy();
                }
                throw throwable;
            }
            newCuWC.discardWorkingCopy();
        }
        return createTextFileChange;
    }

    private String createSourceForNewCu(ICompilationUnit newCu, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        newCu.getBuffer().setContents(CodeGeneration.getCompilationUnitContent(newCu, null, this.createTypeSource().toString(), this.getLineSeperator()));
        this.addImportsToNewCu(newCu, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
        return newCu.getSource();
    }

    private void addImportsToNewCu(ICompilationUnit newCu, IProgressMonitor pm) throws CoreException, JavaModelException {
        ImportsStructure is = new ImportsStructure(newCu, this.fCodeGenerationSettings.importOrder, this.fCodeGenerationSettings.importThreshold, true);
        IType[] typesReferencedInInputType = ReferenceFinderUtil.getTypesReferencedIn(new IJavaElement[]{this.fType}, pm);
        int i = 0;
        while (i < typesReferencedInInputType.length) {
            is.addImport(JavaModelUtil.getFullyQualifiedName(typesReferencedInInputType[i]));
            ++i;
        }
        is.create(false, pm);
    }

    private String createTypeSource() {
        return this.alignSourceBlock(this.fNewSourceOfInputType);
    }

    private String alignSourceBlock(String typeCodeBlock) {
        String[] lines = Strings.convertIntoLines(typeCodeBlock);
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
        return Strings.concatenate(lines, this.getLineSeperator());
    }

    private IPath createPathForNewCu() {
        return ResourceUtil.getFile(this.getInputTypeCu()).getFullPath().removeLastSegments(1).append(this.getNameForNewCu());
    }

    private String getNameForNewCu() {
        return String.valueOf(this.fType.getElementName()) + ".java";
    }

    private String getLineSeperator() {
        try {
            return StubUtility.getLineDelimiterUsed((IJavaElement)this.fType);
        }
        catch (JavaModelException javaModelException) {
            return System.getProperty("line.separator", "\n");
        }
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext());
    }

    private void updateConstructorReference(ASTNode refNode, OldASTRewrite rewrite, ICompilationUnit cu) throws CoreException {
        if (refNode instanceof SuperConstructorInvocation) {
            this.updateConstructorReference((SuperConstructorInvocation)refNode, rewrite, cu);
        } else if (refNode instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)refNode, rewrite, cu);
        } else if (refNode.getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)refNode.getParent(), rewrite, cu);
        }
    }

    private void updateConstructorReference(SuperConstructorInvocation sci, OldASTRewrite rewrite, ICompilationUnit cu) throws CoreException {
        if (this.fCreateInstanceField) {
            this.insertExpressionAsParameter(sci, rewrite, cu);
        }
        if (sci.getExpression() != null) {
            rewrite.remove((ASTNode)sci.getExpression(), null);
        }
    }

    private void updateConstructorReference(ClassInstanceCreation cic, OldASTRewrite rewrite, ICompilationUnit cu) throws JavaModelException {
        if (this.fCreateInstanceField) {
            this.insertExpressionAsParameter(cic, rewrite, cu);
        }
        if (cic.getExpression() != null) {
            rewrite.remove((ASTNode)cic.getExpression(), null);
        }
    }

    private MethodDeclaration[] getConstructorDeclarationNodes(TypeDeclaration declaration) {
        MethodDeclaration[] methodDeclarations = declaration.getMethods();
        ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(2);
        int i = 0;
        while (i < methodDeclarations.length) {
            MethodDeclaration method = methodDeclarations[i];
            if (method.isConstructor()) {
                result.add(method);
            }
            ++i;
        }
        return result.toArray(new MethodDeclaration[result.size()]);
    }

    private boolean insertExpressionAsParameter(ClassInstanceCreation cic, OldASTRewrite rewrite, ICompilationUnit cu) throws JavaModelException {
        return MoveInnerToTopRefactoring.addAsFirstArgument(rewrite, this.createEnclosingInstanceCreationString((ASTNode)cic, cu), cic.arguments());
    }

    private boolean insertExpressionAsParameter(SuperConstructorInvocation sci, OldASTRewrite rewrite, ICompilationUnit cu) throws JavaModelException {
        return MoveInnerToTopRefactoring.addAsFirstArgument(rewrite, this.createEnclosingInstanceCreationString((ASTNode)sci, cu), sci.arguments());
    }

    private static boolean addAsFirstArgument(OldASTRewrite rewrite, String expression, List arguments) {
        if (expression == null) {
            return false;
        }
        Expression newArgument = (Expression)rewrite.createStringPlaceholder(expression, 32);
        arguments.add(0, newArgument);
        rewrite.markAsInserted((ASTNode)newArgument);
        return true;
    }

    private String createEnclosingInstanceCreationString(ASTNode node, ICompilationUnit cu) throws JavaModelException {
        Assert.isTrue(node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation);
        Expression expression = node instanceof ClassInstanceCreation ? ((ClassInstanceCreation)node).getExpression() : ((SuperConstructorInvocation)node).getExpression();
        if (expression != null) {
            return this.getExpressionString(expression, cu);
        }
        if (this.isInputTypeStatic()) {
            return null;
        }
        if (this.isInsideSubclassOfDeclaringType(node)) {
            return THIS_KEYWORD;
        }
        if (this.isInsideInputType(node)) {
            return this.createReadAccessForEnclosingInstance();
        }
        if (this.isInsideTypeNestedInDeclaringType(node)) {
            return String.valueOf(this.getEnclosingType().getElementName()) + '.' + THIS_KEYWORD;
        }
        return null;
    }

    private String getExpressionString(Expression expression, ICompilationUnit compilationUnit) throws JavaModelException {
        return compilationUnit.getBuffer().getText(expression.getStartPosition(), expression.getLength());
    }

    private boolean isInsideSubclassOfDeclaringType(ASTNode node) {
        AnonymousClassDeclaration anon;
        boolean isAnonymous;
        Assert.isTrue(node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation);
        TypeDeclaration typeDeclar = MoveInnerToTopRefactoring.getInnerMostTypeDeclaration(node);
        Assert.isNotNull(typeDeclar);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean bl = isAnonymous = (anon = (AnonymousClassDeclaration)ASTNodes.getParent(node, clazz)) != null && ASTNodes.isParent((ASTNode)anon, (ASTNode)typeDeclar);
        if (isAnonymous) {
            return this.isSubclassBindingOfEnclosingType(anon.resolveBinding());
        }
        return this.isSubclassBindingOfEnclosingType(typeDeclar.resolveBinding());
    }

    private boolean isSubclassBindingOfEnclosingType(ITypeBinding binding) {
        while (binding != null) {
            if (this.isEnclosingTypeBinding(binding)) {
                return true;
            }
            binding = binding.getSuperclass();
        }
        return false;
    }

    private boolean isInsideTypeNestedInDeclaringType(ASTNode node) {
        Assert.isTrue(node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation);
        TypeDeclaration typeDeclar = MoveInnerToTopRefactoring.getInnerMostTypeDeclaration(node);
        Assert.isNotNull(typeDeclar);
        ITypeBinding enclosing = typeDeclar.resolveBinding();
        while (enclosing != null) {
            if (this.isEnclosingTypeBinding(enclosing)) {
                return true;
            }
            enclosing = enclosing.getDeclaringClass();
        }
        return false;
    }

    private boolean isInsideInputType(ASTNode node) throws JavaModelException {
        Assert.isTrue(node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation);
        ISourceRange range = this.fType.getSourceRange();
        return node.getStartPosition() >= range.getOffset() && ASTNodes.getExclusiveEnd(node) <= range.getOffset() + range.getLength();
    }

    private static TypeDeclaration getInnerMostTypeDeclaration(ASTNode node) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TypeDeclaration)ASTNodes.getParent(node, clazz);
    }

    private boolean isEnclosingTypeBinding(ITypeBinding binding) {
        return MoveInnerToTopRefactoring.isCorrespondingTypeBinding(binding, this.getEnclosingType());
    }

    private static boolean isCorrespondingTypeBinding(ITypeBinding binding, IType type) {
        if (binding == null) {
            return false;
        }
        return Bindings.getFullyQualifiedName(binding).equals(JavaElementUtil.createSignature((IMember)type));
    }

    private Expression createQualifiedReadAccessExpressionForEnclosingInstance(AST ast) {
        ThisExpression thisE = ast.newThisExpression();
        thisE.setQualifier(ast.newName(new String[]{this.fType.getElementName()}));
        FieldAccess fa = ast.newFieldAccess();
        fa.setExpression((Expression)thisE);
        fa.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
        return fa;
    }

    private Expression createReadAccessExpressionForEnclosingInstance(AST ast) {
        FieldAccess fa = ast.newFieldAccess();
        fa.setExpression((Expression)ast.newThisExpression());
        fa.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
        return fa;
    }

    private String createReadAccessForEnclosingInstance() {
        return "this." + this.fEnclosingInstanceFieldName;
    }

    private String createEnclosingInstanceInitialization() throws JavaModelException {
        return String.valueOf(this.createReadAccessForEnclosingInstance()) + '=' + this.getNameForEnclosingInstanceConstructorParameter() + ';';
    }

    private String getNameForEnclosingInstanceConstructorParameter() throws JavaModelException {
        if (this.fNameForEnclosingInstanceConstructorParameter != null) {
            return this.fNameForEnclosingInstanceConstructorParameter;
        }
        IType enclosingType = this.getEnclosingType();
        String[] excludedNames = MoveInnerToTopRefactoring.getParameterNamesOfAllConstructors(this.fType);
        String qualifiedTypeName = this.getTypeOfEnclosingInstanceField();
        String packageName = enclosingType.getPackageFragment().getElementName();
        String[] suggestedNames = NamingConventions.suggestArgumentNames((IJavaProject)enclosingType.getJavaProject(), (String)packageName, (String)qualifiedTypeName, (int)0, (String[])excludedNames);
        this.fNameForEnclosingInstanceConstructorParameter = suggestedNames.length > 0 ? suggestedNames[0] : this.fEnclosingInstanceFieldName;
        return this.fNameForEnclosingInstanceConstructorParameter;
    }

    private Name createNameNodeForEnclosingInstanceConstructorParameter(AST ast) throws JavaModelException {
        return ast.newSimpleName(this.getNameForEnclosingInstanceConstructorParameter());
    }

    private static String[] getParameterNamesOfAllConstructors(IType type) throws JavaModelException {
        IMethod[] constructors = JavaElementUtil.getAllConstructors(type);
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        while (i < constructors.length) {
            result.addAll(Arrays.asList(constructors[i].getParameterNames()));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private String createDeclarationForEnclosingInstanceConstructorParameter() throws JavaModelException {
        return String.valueOf(this.getTypeOfEnclosingInstanceField()) + ' ' + this.getNameForEnclosingInstanceConstructorParameter();
    }

    private Type getTypeOfEnclosingInstanceField(AST ast) {
        return ast.newSimpleType(this.getNameOfTypeOfEnclosingInstanceField(ast));
    }

    private Name getNameOfTypeOfEnclosingInstanceField(AST ast) {
        return ast.newName(Strings.splitByToken(this.getTypeOfEnclosingInstanceField(), "."));
    }

    private String getTypeOfEnclosingInstanceField() {
        return JavaModelUtil.getTypeQualifiedName(this.getEnclosingType());
    }

    private static ITypeBinding getDeclaringTypeBinding(MethodInvocation methodInvocation) {
        IMethodBinding binding = methodInvocation.resolveMethodBinding();
        if (binding == null) {
            return null;
        }
        return binding.getDeclaringClass();
    }

    private static ITypeBinding getDeclaringTypeBinding(FieldAccess fieldAccess) {
        IVariableBinding varBinding = MoveInnerToTopRefactoring.resolveFieldBinding(fieldAccess);
        if (varBinding == null) {
            return null;
        }
        return varBinding.getDeclaringClass();
    }

    private static IVariableBinding resolveFieldBinding(FieldAccess fieldAccess) {
        return fieldAccess.resolveFieldBinding();
    }

    private String formatConstructorSource(String src, int indentationLevel) {
        return CodeFormatterUtil.format(4, src, indentationLevel, null, this.getLineSeperator(), this.fType.getJavaProject());
    }

    private static String getFullyQualifiedImportName(ITypeBinding type) {
        if (type.isArray()) {
            return Bindings.getFullyQualifiedName(type.getElementType());
        }
        if (type.isAnonymous()) {
            return MoveInnerToTopRefactoring.getFullyQualifiedImportName(type.getSuperclass());
        }
        return Bindings.getFullyQualifiedName(type);
    }

    private static class MemberAccessNodeCollector
    extends ASTVisitor {
        private final List fMethodAccesses = new ArrayList(0);
        private final List fFieldAccesses = new ArrayList(0);
        private final List fSimpleNames = new ArrayList(0);
        private final IType fType;

        MemberAccessNodeCollector(IType type) {
            this.fType = type;
        }

        MethodInvocation[] getMethodInvocations() {
            return this.fMethodAccesses.toArray(new MethodInvocation[this.fMethodAccesses.size()]);
        }

        FieldAccess[] getFieldAccesses() {
            return this.fFieldAccesses.toArray(new FieldAccess[this.fFieldAccesses.size()]);
        }

        SimpleName[] getSimpleFieldNames() {
            return this.fSimpleNames.toArray(new SimpleName[this.fSimpleNames.size()]);
        }

        public boolean visit(MethodInvocation node) {
            ITypeBinding declaringClassBinding = MoveInnerToTopRefactoring.getDeclaringTypeBinding(node);
            if (declaringClassBinding != null && MoveInnerToTopRefactoring.isCorrespondingTypeBinding(declaringClassBinding, this.fType)) {
                this.fMethodAccesses.add(node);
            }
            return super.visit(node);
        }

        public boolean visit(FieldAccess node) {
            ITypeBinding declaringClassBinding = MoveInnerToTopRefactoring.getDeclaringTypeBinding(node);
            if (declaringClassBinding != null && MoveInnerToTopRefactoring.isCorrespondingTypeBinding(declaringClassBinding, this.fType)) {
                this.fFieldAccesses.add(node);
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(SimpleName node) {
            IVariableBinding vb;
            if (node.getParent() instanceof QualifiedName) {
                return super.visit(node);
            }
            IBinding binding = node.resolveBinding();
            if (binding instanceof IVariableBinding && (vb = (IVariableBinding)binding).isField() && MoveInnerToTopRefactoring.isCorrespondingTypeBinding(vb.getDeclaringClass(), this.fType)) {
                this.fSimpleNames.add(node);
                return false;
            }
            return super.visit(node);
        }
    }
}

