/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.surround.ISurroundWithTryCatchQuery;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryCatchAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class SurroundWithTryCatchRefactoring
extends Refactoring {
    private Selection fSelection;
    private ISurroundWithTryCatchQuery fQuery;
    private SurroundWithTryCatchAnalyzer fAnalyzer;
    private boolean fLeaveDirty;
    private ICompilationUnit fCUnit;
    private CompilationUnit fRootNode;
    private OldASTRewrite fRewriter;
    private ImportRewrite fImportRewrite;
    private CodeScopeBuilder.Scope fScope;
    private ASTNode fSelectedNode;
    private List fStatementsOfSelectedNode;
    private List fTryBody;

    private SurroundWithTryCatchRefactoring(ICompilationUnit cu, Selection selection, CodeGenerationSettings settings, ISurroundWithTryCatchQuery query) {
        this.fCUnit = cu;
        this.fSelection = selection;
        this.fQuery = query;
        this.fLeaveDirty = false;
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit cu, ITextSelection selection, CodeGenerationSettings settings, ISurroundWithTryCatchQuery query) {
        return new SurroundWithTryCatchRefactoring(cu, Selection.createFromStartLength(selection.getOffset(), selection.getLength()), settings, query);
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit cu, int offset, int length, CodeGenerationSettings settings, ISurroundWithTryCatchQuery query) {
        return new SurroundWithTryCatchRefactoring(cu, Selection.createFromStartLength(offset, length), settings, query);
    }

    public void setLeaveDirty(boolean leaveDirty) {
        this.fLeaveDirty = leaveDirty;
    }

    public boolean stopExecution() {
        if (this.fAnalyzer == null) {
            return true;
        }
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        return exceptions == null || exceptions.length == 0;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("SurroundWithTryCatchRefactoring.name");
    }

    public RefactoringStatus checkActivationBasics(CompilationUnit rootNode) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        this.fRootNode = rootNode;
        this.fAnalyzer = new SurroundWithTryCatchAnalyzer(this.fCUnit, this.fSelection, this.fQuery);
        this.fRootNode.accept((ASTVisitor)this.fAnalyzer);
        result.merge(this.fAnalyzer.getStatus());
        return result;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        CompilationUnit rootNode = new RefactoringASTParser(2).parse(this.fCUnit, true, pm);
        return this.checkActivationBasics(rootNode);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        return Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit}), this.getValidationContext());
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        CompilationUnitChange compilationUnitChange;
        block11: {
            TextBuffer buffer = null;
            try {
                CompilationUnitChange result = new CompilationUnitChange(this.getName(), this.fCUnit);
                if (this.fLeaveDirty) {
                    result.setSaveMode(4);
                }
                MultiTextEdit root = new MultiTextEdit();
                result.setEdit((TextEdit)root);
                buffer = TextBuffer.acquire(this.getFile());
                ASTNodes.expandRange(this.fAnalyzer.getSelectedNodes(), buffer, this.fSelection.getOffset(), this.fSelection.getLength());
                this.fRewriter = new OldASTRewrite((ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
                this.fImportRewrite = new ImportRewrite(this.fCUnit);
                this.fScope = CodeScopeBuilder.perform(this.fAnalyzer.getEnclosingBodyDeclaration(), this.fSelection).findScope(this.fSelection.getOffset(), this.fSelection.getLength());
                this.fScope.setCursor(this.fSelection.getOffset());
                this.computeTargetNode();
                this.fTryBody = new ArrayList(2);
                List newStatements = this.createLocals();
                newStatements.add(this.createTryCatchStatement(buffer.getLineDelimiter()));
                if (newStatements.size() == 1) {
                    this.fRewriter.replace(this.fSelectedNode, (ASTNode)newStatements.get(0), null);
                } else {
                    List container = this.getSelectedNodeContainer();
                    if (this.selectedNodeIsDeclaration()) {
                        int index = container.indexOf(this.fSelectedNode);
                        Iterator iter = newStatements.iterator();
                        while (iter.hasNext()) {
                            ASTNode element = (ASTNode)iter.next();
                            this.fRewriter.markAsInserted(element);
                            container.add(++index, element);
                        }
                    } else if (newStatements.isEmpty()) {
                        this.fRewriter.remove(this.fSelectedNode, null);
                    } else {
                        Statement[] collapsedTargetStatements = newStatements.toArray(new Statement[newStatements.size()]);
                        this.fRewriter.replace(this.fSelectedNode, (ASTNode)this.fRewriter.getCollapseTargetPlaceholder(collapsedTargetStatements), null);
                    }
                }
                if (!this.fImportRewrite.isEmpty()) {
                    TextEdit edit = this.fImportRewrite.createEdit(buffer.getDocument());
                    root.addChild(edit);
                    result.addTextEditGroup(new TextEditGroup("", new TextEdit[]{edit}));
                }
                MultiTextEdit change = new MultiTextEdit();
                this.fRewriter.rewriteNode(buffer, (TextEdit)change);
                root.addChild((TextEdit)change);
                result.addTextEditGroup(new TextEditGroup("", new TextEdit[]{change}));
                compilationUnitChange = result;
                Object var10_12 = null;
                this.fRewriter.removeModifications();
                if (buffer == null) break block11;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var10_13 = null;
                    this.fRewriter.removeModifications();
                    if (buffer == null) break block12;
                    TextBuffer.release(buffer);
                }
                throw throwable;
            }
            TextBuffer.release(buffer);
        }
        return compilationUnitChange;
    }

    private AST getAST() {
        return this.fRootNode.getAST();
    }

    private void computeTargetNode() {
        ASTNode[] nodes = this.fAnalyzer.getSelectedNodes();
        if (nodes.length == 1) {
            this.fSelectedNode = nodes[0];
        } else {
            List container = ASTNodes.getContainingList(nodes[0]);
            this.fSelectedNode = this.fRewriter.collapseNodes(container, container.indexOf(nodes[0]), nodes.length);
        }
    }

    private List getStatementsOfSelectedNode() {
        if (this.fStatementsOfSelectedNode != null) {
            return this.fStatementsOfSelectedNode;
        }
        if (this.fRewriter.isCollapsed(this.fSelectedNode)) {
            this.fStatementsOfSelectedNode = ((Block)this.fSelectedNode).statements();
        } else {
            this.fStatementsOfSelectedNode = ASTNodes.getContainingList(this.fSelectedNode);
            if (this.fStatementsOfSelectedNode == null) {
                Block block = this.getAST().newBlock();
                this.fStatementsOfSelectedNode = block.statements();
                this.fStatementsOfSelectedNode.add(this.fRewriter.createCopyTarget(this.fSelectedNode));
                this.fRewriter.remove(this.fSelectedNode, null);
            }
        }
        return this.fStatementsOfSelectedNode;
    }

    private List getSelectedNodeContainer() {
        List result = ASTNodes.getContainingList(this.fSelectedNode);
        if (result != null) {
            return result;
        }
        return this.getStatementsOfSelectedNode();
    }

    private List createLocals() {
        ArrayList result = new ArrayList(3);
        ArrayList<VariableDeclaration> locals = new ArrayList<VariableDeclaration>(Arrays.asList(this.fAnalyzer.getAffectedLocals()));
        if (locals.size() > 0) {
            VariableDeclarationStatement[] statements = this.getStatements(locals);
            int i = 0;
            while (i < statements.length) {
                VariableDeclarationStatement st = statements[i];
                result.addAll(this.handle(st, locals));
                ++i;
            }
        }
        return result;
    }

    private VariableDeclarationStatement[] getStatements(List locals) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(locals.size());
        int i = 0;
        while (i < locals.size()) {
            ASTNode parent = ((ASTNode)locals.get(i)).getParent();
            if (parent instanceof VariableDeclarationStatement && !result.contains(parent)) {
                result.add(parent);
            }
            ++i;
        }
        return result.toArray(new VariableDeclarationStatement[result.size()]);
    }

    private List handle(VariableDeclarationStatement statement, List locals) {
        boolean isSelectedNode = statement == this.fSelectedNode;
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        List fragments = statement.fragments();
        result.add(this.fRewriter.createCopyTarget((ASTNode)statement));
        AST ast = this.getAST();
        ArrayList<ExpressionStatement> newAssignments = new ArrayList<ExpressionStatement>(2);
        Iterator iter = fragments.iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            Expression initializer = fragment.getInitializer();
            if (initializer == null) continue;
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)fragment.getName()));
            assignment.setRightHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)initializer));
            this.fRewriter.remove((ASTNode)initializer, null);
            ExpressionStatement es = ast.newExpressionStatement((Expression)assignment);
            if (isSelectedNode) {
                this.fTryBody.add(es);
                continue;
            }
            newAssignments.add(es);
        }
        if (newAssignments.isEmpty()) {
            this.fRewriter.remove((ASTNode)statement, null);
        } else {
            Statement[] collapsedTargetStatements = newAssignments.toArray(new Statement[newAssignments.size()]);
            this.fRewriter.replace((ASTNode)statement, (ASTNode)this.fRewriter.getCollapseTargetPlaceholder(collapsedTargetStatements), null);
        }
        return result;
    }

    private TryStatement createTryCatchStatement(String lineDelimiter) throws CoreException {
        TryStatement tryStatement = this.getAST().newTryStatement();
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        int i = 0;
        while (i < exceptions.length) {
            ITypeBinding exception = exceptions[i];
            String type = this.fImportRewrite.addImport(exception);
            CatchClause catchClause = this.getAST().newCatchClause();
            tryStatement.catchClauses().add(catchClause);
            SingleVariableDeclaration decl = this.getAST().newSingleVariableDeclaration();
            String varName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.exception.name");
            String name = this.fScope.createName(varName, false);
            decl.setName(this.getAST().newSimpleName(name));
            decl.setType(ASTNodeFactory.newType(this.getAST(), type));
            catchClause.setException(decl);
            Statement st = this.getCatchBody(type, name, lineDelimiter);
            if (st != null) {
                catchClause.getBody().statements().add(st);
            }
            ++i;
        }
        List statements = tryStatement.getBody().statements();
        if (this.selectedNodeIsDeclaration()) {
            statements.addAll(this.fTryBody);
        } else {
            statements.add(this.fRewriter.createCopyTarget(this.fSelectedNode));
        }
        return tryStatement;
    }

    private Statement getCatchBody(String type, String name, String lineSeparator) throws CoreException {
        String s = StubUtility.getCatchBodyContent(this.fCUnit, type, name, lineSeparator);
        if (s == null) {
            return null;
        }
        return (Statement)this.fRewriter.createStringPlaceholder(s, 41);
    }

    private IFile getFile() {
        return (IFile)JavaModelUtil.toOriginal(this.fCUnit).getResource();
    }

    private boolean selectedNodeIsDeclaration() {
        return this.fTryBody.size() > 0;
    }
}

