/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CopyRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.ui.actions.AddMethodStubAction;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDropAdapter;
import org.eclipse.jdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SelectionTransferDropAdapter
extends JdtViewerDropAdapter
implements TransferDropTargetListener {
    private List fElements;
    private JavaMoveProcessor fMoveProcessor;
    private int fCanMoveElements;
    private CopyRefactoring fCopyRefactoring2;
    private int fCanCopyElements;
    private ISelection fSelection;
    private AddMethodStubAction fAddMethodStubAction = new AddMethodStubAction();
    private static final long DROP_TIME_DIFF_TRESHOLD = 150L;

    public SelectionTransferDropAdapter(StructuredViewer viewer) {
        super(viewer, 24);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.fElements = null;
        this.fSelection = null;
        this.fMoveProcessor = null;
        this.fCanMoveElements = 0;
        this.fCopyRefactoring2 = null;
        this.fCanCopyElements = 0;
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        if (this.tooFast(event)) {
            return;
        }
        this.initializeSelection();
        try {
            switch (operation) {
                case 16: {
                    event.detail = this.handleValidateDefault(target, event);
                    break;
                }
                case 1: {
                    event.detail = this.handleValidateCopy(target, event);
                    break;
                }
                case 2: {
                    event.detail = this.handleValidateMove(target, event);
                    break;
                }
                case 4: {
                    event.detail = this.handleValidateLink(target, event);
                }
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.getString("SelectionTransferDropAdapter.error.title"), PackagesMessages.getString("SelectionTransferDropAdapter.error.message"));
            event.detail = 0;
        }
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        this.fSelection = s;
        this.fElements = ((IStructuredSelection)s).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    private boolean tooFast(DropTargetEvent event) {
        return Math.abs(LocalSelectionTransfer.getInstance().getSelectionSetTime() - ((long)event.time & 0xFFFFFFFFL)) < 150L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drop(Object target, DropTargetEvent event) {
        try {
            try {
                switch (event.detail) {
                    case 2: {
                        this.handleDropMove(target, event);
                        break;
                    }
                    case 1: {
                        this.handleDropCopy(target, event);
                        break;
                    }
                    case 4: {
                        this.handleDropLink(target, event);
                        break;
                    }
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.getString("SelectionTransferDropAdapter.error.title"), PackagesMessages.getString("SelectionTransferDropAdapter.error.message"));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            event.detail = 0;
            throw throwable;
        }
        {
            Object var4_7 = null;
            event.detail = 0;
            return;
        }
    }

    private int handleValidateDefault(Object target, DropTargetEvent event) throws JavaModelException {
        if (target == null) {
            return 0;
        }
        return this.handleValidateMove(target, event);
    }

    private int handleValidateMove(Object target, DropTargetEvent event) throws JavaModelException {
        if (target == null) {
            return 0;
        }
        if (this.fMoveProcessor == null) {
            IResource[] resources = ReorgUtils.getResources(this.fElements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
            this.fMoveProcessor = JavaMoveProcessor.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        if (target instanceof IResource && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IResource)target).isOK()) {
            return 2;
        }
        if (target instanceof IJavaElement && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IJavaElement)target).isOK()) {
            return 2;
        }
        return 0;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (this.fMoveProcessor == null) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private void handleDropLink(Object target, DropTargetEvent event) {
        if (this.fAddMethodStubAction.init((IType)target, this.getSelection())) {
            this.fAddMethodStubAction.run();
        }
    }

    private int handleValidateLink(Object target, DropTargetEvent event) {
        if (target instanceof IType && AddMethodStubAction.canActionBeAdded((IType)target, this.getSelection())) {
            return 4;
        }
        return 0;
    }

    private void handleDropMove(Object target, DropTargetEvent event) throws JavaModelException, InvocationTargetException, InterruptedException {
        IJavaElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
        IResource[] resources = ReorgUtils.getResources(this.fElements);
        ReorgMoveStarter starter = null;
        if (target instanceof IResource) {
            starter = ReorgMoveStarter.create(javaElements, resources, (IResource)target);
        } else if (target instanceof IJavaElement) {
            starter = ReorgMoveStarter.create(javaElements, resources, (IJavaElement)target);
        }
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private int handleValidateCopy(Object target, DropTargetEvent event) throws JavaModelException {
        if (this.fCopyRefactoring2 == null) {
            IResource[] resources = ReorgUtils.getResources(this.fElements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
            this.fCopyRefactoring2 = CopyRefactoring.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
        }
        if (!this.canCopyElements()) {
            return 0;
        }
        if (target instanceof IResource && this.fCopyRefactoring2 != null && this.fCopyRefactoring2.setDestination((IResource)target).isOK()) {
            return 1;
        }
        if (target instanceof IJavaElement && this.fCopyRefactoring2 != null && this.fCopyRefactoring2.setDestination((IJavaElement)target).isOK()) {
            return 1;
        }
        return 0;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (this.fCopyRefactoring2 == null) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private void handleDropCopy(Object target, DropTargetEvent event) throws JavaModelException, InvocationTargetException, InterruptedException {
        IJavaElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
        IResource[] resources = ReorgUtils.getResources(this.fElements);
        ReorgCopyStarter starter = null;
        if (target instanceof IResource) {
            starter = ReorgCopyStarter.create(javaElements, resources, (IResource)target);
        } else if (target instanceof IJavaElement) {
            starter = ReorgCopyStarter.create(javaElements, resources, (IJavaElement)target);
        }
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

