/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuildPathsPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private static final String PAGE_SETTINGS = "BuildPathsPropertyPage";
    private static final String INDEX = "pageIndex";
    private BuildPathsBlock fBuildPathsBlock;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IProject project = this.getProject();
        Control result = project == null || !this.isJavaProject(project) ? this.createWithoutJava(parent) : (!project.isOpen() ? this.createForClosedProject(parent) : this.createWithJava(parent, project));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.build_path_property_page_context");
    }

    private IDialogSettings getSettings() {
        IDialogSettings javaSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = javaSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = javaSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 3);
        }
        return pageSettings;
    }

    public void setVisible(boolean visible) {
        if (this.fBuildPathsBlock != null) {
            if (!visible) {
                if (this.fBuildPathsBlock.hasChangesInDialog()) {
                    String title = PreferencesMessages.getString("BuildPathsPropertyPage.unsavedchanges.title");
                    String message = PreferencesMessages.getString("BuildPathsPropertyPage.unsavedchanges.message");
                    String[] buttonLabels = new String[]{PreferencesMessages.getString("BuildPathsPropertyPage.unsavedchanges.button.save"), PreferencesMessages.getString("BuildPathsPropertyPage.unsavedchanges.button.discard"), PreferencesMessages.getString("BuildPathsPropertyPage.unsavedchanges.button.ignore")};
                    MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
                    int res = dialog.open();
                    if (res == 0) {
                        this.performOk();
                    } else if (res == 1) {
                        this.fBuildPathsBlock.init(JavaCore.create((IProject)this.getProject()), null, null);
                    } else {
                        this.fBuildPathsBlock.initializeTimeStamps();
                    }
                }
            } else if (!this.fBuildPathsBlock.hasChangesInDialog() && this.fBuildPathsBlock.hasChangesInClasspathFile()) {
                this.fBuildPathsBlock.init(JavaCore.create((IProject)this.getProject()), null, null);
            }
        }
        super.setVisible(visible);
    }

    private Control createWithJava(Composite parent, IProject project) {
        this.fBuildPathsBlock = new BuildPathsBlock(this, this.getSettings().getInt(INDEX));
        this.fBuildPathsBlock.init(JavaCore.create((IProject)project), null, null);
        return this.fBuildPathsBlock.createControl(parent);
    }

    private Control createWithoutJava(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.getString("BuildPathsPropertyPage.no_java_project.message"));
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.getString("BuildPathsPropertyPage.closed_project.message"));
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable != null) {
            IJavaElement elem;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((elem = (IJavaElement)adaptable.getAdapter((Class)clazz)) instanceof IJavaProject) {
                return ((IJavaProject)elem).getProject();
            }
        }
        return null;
    }

    private boolean isJavaProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fBuildPathsBlock != null) {
            this.getSettings().put(INDEX, this.fBuildPathsBlock.getPageIndex());
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                    BuildPathsPropertyPage.this.fBuildPathsBlock.configureJavaProject(monitor);
                }
            };
            WorkbenchRunnableAdapter op = new WorkbenchRunnableAdapter(runnable);
            op.runAsUserJob(PreferencesMessages.getString("BuildPathsPropertyPage.job.title"), null);
        }
        return true;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public boolean performCancel() {
        if (this.fBuildPathsBlock != null) {
            this.getSettings().put(INDEX, this.fBuildPathsBlock.getPageIndex());
        }
        return super.performCancel();
    }
}

