/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.TemplateEditorSourceViewerConfiguration;
import org.eclipse.jdt.internal.ui.text.template.preferences.TemplateVariableProcessor;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class EditTemplateDialog
extends StatusDialog {
    private final Template fTemplate;
    private Text fNameText;
    private Text fDescriptionText;
    private Combo fContextCombo;
    private SourceViewer fPatternEditor;
    private Button fInsertVariableButton;
    private boolean fIsNameModifiable;
    private StatusInfo fValidationStatus;
    private boolean fSuppressError = true;
    private Map fGlobalActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(3);
    private String[][] fContextTypes;
    private ContextTypeRegistry fContextTypeRegistry;
    private final TemplateVariableProcessor fTemplateProcessor = new TemplateVariableProcessor();

    public EditTemplateDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String title = edit ? PreferencesMessages.getString("EditTemplateDialog.title.edit") : PreferencesMessages.getString("EditTemplateDialog.title.new");
        this.setTitle(title);
        this.fTemplate = template;
        this.fIsNameModifiable = isNameModifiable;
        ArrayList<String[]> contexts = new ArrayList<String[]>();
        Iterator it = registry.contextTypes();
        while (it.hasNext()) {
            TemplateContextType type = (TemplateContextType)it.next();
            contexts.add(new String[]{type.getId(), type.getName(), ""});
        }
        this.fContextTypes = (String[][])contexts.toArray((T[])new String[contexts.size()][]);
        this.fValidationStatus = new StatusInfo();
        this.fContextTypeRegistry = registry;
        TemplateContextType type = this.fContextTypeRegistry.getContextType(template.getContextTypeId());
        this.fTemplateProcessor.setContextType(type);
    }

    public void create() {
        boolean valid;
        super.create();
        boolean bl = valid = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
        if (!valid) {
            StatusInfo status = new StatusInfo();
            status.setError(PreferencesMessages.getString("EditTemplateDialog.error.noname"));
            this.updateButtonsEnableState(status);
        }
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTemplateDialog.this.doTextWidgetChanged(e.widget);
            }
        };
        if (this.fIsNameModifiable) {
            EditTemplateDialog.createLabel(parent, PreferencesMessages.getString("EditTemplateDialog.name"));
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            this.fNameText = EditTemplateDialog.createText(composite);
            this.fNameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (EditTemplateDialog.this.fSuppressError) {
                        EditTemplateDialog.this.fSuppressError = false;
                        EditTemplateDialog.this.updateButtons();
                    }
                }
            });
            EditTemplateDialog.createLabel(composite, PreferencesMessages.getString("EditTemplateDialog.context"));
            this.fContextCombo = new Combo(composite, 8);
            int i = 0;
            while (i < this.fContextTypes.length) {
                this.fContextCombo.add(this.fContextTypes[i][1]);
                ++i;
            }
            this.fContextCombo.addModifyListener(listener);
        }
        EditTemplateDialog.createLabel(parent, PreferencesMessages.getString("EditTemplateDialog.description"));
        int descFlags = this.fIsNameModifiable ? 2048 : 2056;
        this.fDescriptionText = new Text(parent, descFlags);
        this.fDescriptionText.setLayoutData((Object)new GridData(768));
        this.fDescriptionText.addModifyListener(listener);
        Label patternLabel = EditTemplateDialog.createLabel(parent, PreferencesMessages.getString("EditTemplateDialog.pattern"));
        patternLabel.setLayoutData((Object)new GridData(2));
        this.fPatternEditor = this.createEditor(parent);
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData());
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        this.fInsertVariableButton = new Button(composite, 0);
        this.fInsertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData(this.fInsertVariableButton));
        this.fInsertVariableButton.setText(PreferencesMessages.getString("EditTemplateDialog.insert.variable"));
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.fPatternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fDescriptionText.setText(this.fTemplate.getDescription());
        if (this.fIsNameModifiable) {
            this.fNameText.setText(this.fTemplate.getName());
            this.fNameText.addModifyListener(listener);
            this.fContextCombo.select(this.getIndex(this.fTemplate.getContextTypeId()));
        } else {
            this.fPatternEditor.getControl().setFocus();
        }
        this.initializeActions();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void doTextWidgetChanged(Widget w) {
        if (w == this.fNameText) {
            this.fSuppressError = false;
            String name = this.fNameText.getText();
            this.fTemplate.setName(name);
            this.updateButtons();
        } else if (w == this.fContextCombo) {
            String name = this.fContextCombo.getText();
            String contextId = this.getContextId(name);
            this.fTemplate.setContextTypeId(contextId);
            this.fTemplateProcessor.setContextType(this.fContextTypeRegistry.getContextType(contextId));
        } else if (w == this.fDescriptionText) {
            String desc = this.fDescriptionText.getText();
            this.fTemplate.setDescription(desc);
        }
    }

    private String getContextId(String name) {
        if (name == null) {
            return name;
        }
        int i = 0;
        while (i < this.fContextTypes.length) {
            if (name.equals(this.fContextTypes[i][1])) {
                return this.fContextTypes[i][0];
            }
            ++i;
        }
        return name;
    }

    protected void doSourceChanged(IDocument document) {
        String text = document.get();
        String prefix = this.getPrefix();
        this.fTemplate.setPattern(text.substring(prefix.length(), text.length()));
        this.fValidationStatus.setOK();
        TemplateContextType contextType = this.fContextTypeRegistry.getContextType(this.fTemplate.getContextTypeId());
        if (contextType != null) {
            try {
                contextType.validate(text);
            }
            catch (TemplateException e) {
                this.fValidationStatus.setError(e.getLocalizedMessage());
            }
        }
        this.updateUndoAction();
        this.updateButtons();
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        data.heightHint = SWTUtil.getButtonHeightHint(button);
        return data;
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private SourceViewer createEditor(Composite parent) {
        String prefix = this.getPrefix();
        Document document = new Document(String.valueOf(prefix) + this.fTemplate.getPattern());
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        JavaSourceViewer viewer = new JavaSourceViewer(parent, null, null, false, 2816, store);
        TemplateEditorSourceViewerConfiguration configuration = new TemplateEditorSourceViewerConfiguration(tools.getColorManager(), store, null, this.fTemplateProcessor);
        viewer.configure(configuration);
        viewer.setEditable(true);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        int nLines = document.getNumberOfLines();
        if (nLines < 5) {
            nLines = 5;
        } else if (nLines > 12) {
            nLines = 12;
        }
        Control control = viewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(nLines);
        control.setLayoutData((Object)data);
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (event.getDocumentEvent() != null) {
                    EditTemplateDialog.this.doSourceChanged(event.getDocumentEvent().getDocument());
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditTemplateDialog.this.updateSelectionDependentActions();
            }
        });
        viewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                EditTemplateDialog.this.handleVerifyKeyPressed(event);
            }
        });
        return viewer;
    }

    private String getPrefix() {
        int idx = this.getIndex(this.fTemplate.getContextTypeId());
        String prefix = idx != -1 ? this.fContextTypes[idx][2] : "";
        return prefix;
    }

    private void handleVerifyKeyPressed(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.stateMask != SWT.MOD1) {
            return;
        }
        switch (event.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                event.doit = false;
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
                event.doit = false;
            }
        }
    }

    private void initializeActions() {
        TextViewerAction action = new TextViewerAction((ITextViewer)this.fPatternEditor, 1);
        action.setText(PreferencesMessages.getString("EditTemplateDialog.undo"));
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 3);
        action.setText(PreferencesMessages.getString("EditTemplateDialog.cut"));
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 4);
        action.setText(PreferencesMessages.getString("EditTemplateDialog.copy"));
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 5);
        action.setText(PreferencesMessages.getString("EditTemplateDialog.paste"));
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 7);
        action.setText(PreferencesMessages.getString("EditTemplateDialog.select.all"));
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 13);
        action.setText(PreferencesMessages.getString("EditTemplateDialog.content.assist"));
        this.fGlobalActions.put("ContentAssistProposal", action);
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditTemplateDialog.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this.fPatternEditor.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.appendToGroup("group.generate", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateUndoAction() {
        IAction action = (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private int getIndex(String contextid) {
        if (contextid == null) {
            return -1;
        }
        int i = 0;
        while (i < this.fContextTypes.length) {
            if (contextid.equals(this.fContextTypes[i][0])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private void updateButtons() {
        StatusInfo status;
        boolean valid;
        boolean bl = valid = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
        if (!valid) {
            status = new StatusInfo();
            if (!this.fSuppressError) {
                status.setError(PreferencesMessages.getString("EditTemplateDialog.error.noname"));
            }
        } else {
            status = this.fValidationStatus;
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.edit_template_dialog_context");
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

