/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import mergedoc.MergeDocException;
import mergedoc.ui.ComponentFactory;

public class FileChooserField
extends JPanel {
    private JLabel label = new JLabel();
    private JTextField textField = new JTextField();
    private JButton button = new JButton();
    private JComboBox combo = new JComboBox();
    private static Set charsets;
    private static int comboWidth;
    private static final String DEFAULT_ENCODING;
    private JFileChooser chooser = new JFileChooser();
    private ActionListener chooseListener;

    public FileChooserField() throws MergeDocException {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.label);
        this.add(ComponentFactory.createSpacer(10, 0));
        int n = (int)ComponentFactory.createMaxDimension().getWidth();
        this.textField.setMaximumSize(new Dimension(n, 20));
        this.add(this.textField);
        ComponentFactory.ensureSize(this.button, 20, 18);
        this.button.setText("...");
        this.add(this.button);
        this.add(ComponentFactory.createSpacer(5, 0));
        this.initCharsets();
        ComponentFactory.ensureSize(this.combo, comboWidth, 20);
        this.combo.setModel(new DefaultComboBoxModel<Object>(charsets.toArray()));
        this.setCharset(Charset.forName(DEFAULT_ENCODING));
        this.add(this.combo);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FileChooserField.this.chooser.showOpenDialog(new JFrame());
                if (n == 0) {
                    FileChooserField.this.textField.setText(FileChooserField.this.chooser.getSelectedFile().getPath());
                    if (FileChooserField.this.chooseListener != null) {
                        FileChooserField.this.chooseListener.actionPerformed(actionEvent);
                    }
                }
            }
        });
        this.setDirectoryOnly(false);
    }

    private void initCharsets() {
        if (charsets != null) {
            return;
        }
        charsets = new TreeSet();
        charsets.add(Charset.forName("EUC-JP"));
        charsets.add(Charset.forName("ISO-2022-JP"));
        charsets.add(Charset.forName("MS932"));
        charsets.add(Charset.forName("Shift_JIS"));
        charsets.add(Charset.forName("UTF-16"));
        charsets.add(Charset.forName("UTF-16BE"));
        charsets.add(Charset.forName("UTF-16LE"));
        charsets.add(Charset.forName("UTF-8"));
        charsets.add(Charset.forName(DEFAULT_ENCODING));
        FontMetrics fontMetrics = this.getFontMetrics(this.combo.getFont());
        Iterator iterator = charsets.iterator();
        while (iterator.hasNext()) {
            int n = fontMetrics.stringWidth(iterator.next().toString());
            if (comboWidth >= n) continue;
            comboWidth = n;
        }
        comboWidth += 30;
    }

    public void setDirectoryOnly(boolean bl) {
        if (bl) {
            this.chooser = new JFileChooser();
            this.chooser.setFileSelectionMode(1);
            this.chooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }

                public String getDescription() {
                    return "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u307f";
                }
            });
        } else {
            this.chooser.setFileSelectionMode(0);
            this.chooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".zip") || file.getName().endsWith(".jar");
                }

                public String getDescription() {
                    return "*.zip, *.jar";
                }
            });
        }
    }

    public void setChooseListener(ActionListener actionListener) {
        this.chooseListener = actionListener;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setFile(File file) {
        this.textField.setText(file.getPath());
        this.chooser.setCurrentDirectory(file.getParentFile());
        this.chooser.setSelectedFile(file);
    }

    public File getFile() {
        return new File(this.textField.getText());
    }

    public void setCharset(Charset charset) {
        this.combo.setSelectedItem(charset);
    }

    public Charset getCharset() {
        return (Charset)this.combo.getSelectedItem();
    }

    static {
        DEFAULT_ENCODING = System.getProperty("file.encoding");
    }
}

