/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Color;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import mergedoc.MergeDocException;
import mergedoc.core.StringUtils;
import mergedoc.ui.EntryCheckBox;
import mergedoc.ui.MessageDialog;
import mergedoc.xml.ConfigManager;
import mergedoc.xml.ReplaceEntry;

public class PreviewScrollPane
extends JScrollPane {
    private final String originPreviewText;
    private final JTextPane textPane = new JTextPane();
    private final MessageDialog dialog;

    public PreviewScrollPane(MessageDialog messageDialog) throws MergeDocException {
        this.dialog = messageDialog;
        JViewport jViewport = this.getViewport();
        jViewport.setScrollMode(2);
        jViewport.setView(this.textPane);
        this.textPane.setEnabled(false);
        this.originPreviewText = ConfigManager.getInstance().getPrevewTemplate();
    }

    public void updatePreview(List list) {
        Object object;
        String string = this.originPreviewText;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntryCheckBox entryCheckBox = (EntryCheckBox)iterator.next();
            if (!entryCheckBox.isSelected()) continue;
            object = entryCheckBox.getReplaceEntry();
            try {
                string = ((ReplaceEntry)object).replace(string);
            }
            catch (RuntimeException runtimeException) {
                this.dialog.showErrorMessage(runtimeException.getMessage());
            }
        }
        string = StringUtils.optimizeLineSeparator(string);
        object = new char[4];
        Arrays.fill((char[])object, '#');
        string = string.replaceAll("\\t", String.valueOf((char[])object));
        this.textPane.setText(string);
        final JScrollBar jScrollBar = this.getVerticalScrollBar();
        final int n = jScrollBar.getValue();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jScrollBar.setValue(n);
            }
        });
        this.updateColor("(?s)(/\\*[^\\*].+?\\*/)", new Color(63, 127, 95));
        this.updateColor("(?s)(/\\*\\*.+?\\*/)", new Color(63, 95, 191));
        this.updateColor("(class|public|private|void|extends|super)", new Color(127, 0, 85));
        this.updateColor("(?m).*?[ #](//.*)", new Color(63, 127, 95));
        this.updateColor(" (\".*?\")", new Color(42, 0, 255));
        this.updateColor(" (@\\w*) ", new Color(127, 159, 191));
        StyledDocument styledDocument = this.textPane.getStyledDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Color color = new Color(255, 255, 200);
        StyleConstants.setForeground(simpleAttributeSet, color);
        StyleConstants.setBackground(simpleAttributeSet, color);
        Pattern pattern = Pattern.compile("#{4}");
        Matcher matcher = pattern.matcher(this.textPane.getText());
        while (matcher.find()) {
            int n2 = matcher.start();
            int n3 = matcher.end() - n2;
            styledDocument.setCharacterAttributes(n2, n3, simpleAttributeSet, false);
        }
    }

    private void updateColor(String string, Color color) {
        StyledDocument styledDocument = this.textPane.getStyledDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(this.textPane.getText());
        while (matcher.find()) {
            int n = matcher.start(1);
            int n2 = matcher.end(1) - n;
            StyleConstants.setForeground(simpleAttributeSet, color);
            styledDocument.setCharacterAttributes(n, n2, simpleAttributeSet, false);
        }
    }
}

