/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mergedoc.core.FastStringUtils;
import mergedoc.core.PatternCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Signature {
    private static final Log log = LogFactory.getLog(Signature.class);
    private String shortClassName;
    private String methodName;
    private String arguments;
    private boolean declareInnerClass;

    public Signature(String className, String sig) {
        String declaClassName;
        sig = sig.replace('\n', ' ');
        if (sig.contains("<")) {
            Pattern pat = PatternCache.getPattern("<[\\w\\s\\?,]+>");
            Matcher mat = pat.matcher(sig);
            while (mat.find()) {
                sig = mat.replaceAll(" ");
                mat = pat.matcher(sig);
            }
        }
        sig = FastStringUtils.replaceFirst(sig, "\\s(extends|implements)\\s.*", " ");
        sig = " " + sig + " ";
        sig = FastStringUtils.replaceAll(sig, "(\\(|\\)|,)", " $1 ");
        sig = FastStringUtils.replaceAll(sig, " +", " ");
        if ((sig = FastStringUtils.replaceAll(sig, " (\\w+?\\.)+", " ")).contains("(")) {
            sig = FastStringUtils.replace(sig, " final ", " ");
            sig = FastStringUtils.replace(sig, " []", "[]");
            sig = FastStringUtils.replaceAll(sig, " \\w+?( ,| \\)|\\[\\] (,|\\)))", "$1");
        }
        this.shortClassName = FastStringUtils.replaceFirst(className, ".+\\.", "");
        String classRegex = ".*? (class|interface|@interface|enum) (\\w+) .*";
        if (FastStringUtils.matches(sig, classRegex) && !(declaClassName = FastStringUtils.replaceFirst(sig, classRegex, "$2")).equals(this.shortClassName)) {
            this.declareInnerClass = true;
            this.shortClassName = declaClassName;
        }
        sig = FastStringUtils.replaceFirst(sig, ".* (\\w+?(| \\(.*?\\)))(|\\[\\]) $", "$1");
        sig = FastStringUtils.replaceAll(sig, " +", "");
        this.methodName = FastStringUtils.replaceFirst(sig, "(\\w+).*", "$1");
        this.arguments = FastStringUtils.replaceFirst(sig, "\\w+(.*)", "$1");
    }

    public boolean isDeclareInnerClass() {
        return this.declareInnerClass;
    }

    public String getClassName() {
        return this.shortClassName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.shortClassName + "#" + this.methodName + this.arguments;
    }
}

