/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.geom.Dimension2D;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class ComponentFactory {
    private static final Dimension maxDimension = new Dimension(3200, 2400){

        public void setSize(Dimension d) {
        }

        public void setSize(double width, double height) {
        }

        public void setSize(int width, int height) {
        }

        public void setSize(Dimension2D d) {
        }
    };

    private ComponentFactory() {
    }

    public static Dimension createMaxDimension() {
        return maxDimension;
    }

    public static JComponent createSpacer(int width, int hight) {
        JLabel label = new JLabel();
        ComponentFactory.ensureSize(label, width, hight);
        return label;
    }

    public static void ensureSize(JComponent compo, int width, int hight) {
        Dimension dim = new Dimension(width, hight);
        compo.setPreferredSize(dim);
        compo.setMinimumSize(dim);
        compo.setMaximumSize(dim);
    }

    public static JScrollPane createScrollPane(JComponent compo) {
        JScrollPane scrollPane = new JScrollPane(compo);
        ComponentFactory.setupVerticalScrollPane(scrollPane);
        return scrollPane;
    }

    public static void setupVerticalScrollPane(JScrollPane scrollPane) {
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
    }

    public static void ensureMaxFontWidth(JComponent[] compos) {
        int maxWidth = 0;
        for (JComponent compo : compos) {
            FontMetrics metrics = compo.getFontMetrics(compo.getFont());
            int width = 0;
            if (compo instanceof JLabel) {
                width = metrics.stringWidth(((JLabel)compo).getText());
            } else if (compo instanceof JComboBox) {
                ComboBoxModel model = ((JComboBox)compo).getModel();
                for (int j = 0; j < model.getSize(); ++j) {
                    width = metrics.stringWidth(model.getElementAt(j).toString());
                    if ((width += 30) <= maxWidth) continue;
                    maxWidth = width;
                }
            } else {
                throw new IllegalArgumentException("\u5f15\u6570\u306f JLabel[] \u307e\u305f\u306f JComboBox[] \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            }
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        for (JComponent compo : compos) {
            ComponentFactory.ensureSize(compo, maxWidth, 20);
        }
    }
}

