/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import mergedoc.ui.ComponentFactory;

public class ProgressPanel
extends JPanel {
    private JProgressBar progressBar = new JProgressBar();
    private JTextArea textArea = new JTextArea(3, 100);

    public ProgressPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(ComponentFactory.createMaxDimension());
        int maxWidth = (int)ComponentFactory.createMaxDimension().getWidth();
        this.progressBar.setMaximumSize(new Dimension(maxWidth, 10));
        this.progressBar.setStringPainted(true);
        this.textArea.setMaximumSize(ComponentFactory.createMaxDimension());
        this.textArea.setEditable(false);
        this.add(this.progressBar);
        this.add(ComponentFactory.createSpacer(0, 5));
        this.add(ComponentFactory.createScrollPane(this.textArea));
    }

    public void init() {
        this.progressBar.setString(null);
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(true);
        this.textArea.setText(null);
    }

    public void setMaximum(int max) {
        this.progressBar.setMaximum(max);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressPanel.this.progressBar.setIndeterminate(false);
            }
        });
    }

    public void addListText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int value = ProgressPanel.this.progressBar.getValue() + 1;
                ProgressPanel.this.progressBar.setValue(value);
                if (value > 1) {
                    ProgressPanel.this.textArea.append("\n");
                }
                ProgressPanel.this.textArea.append(text);
            }
        });
    }

    public void setBarText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressPanel.this.progressBar.setIndeterminate(false);
                ProgressPanel.this.progressBar.setString(text);
            }
        });
    }

    public String getBarText() {
        return this.progressBar.getString();
    }
}

