/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;

import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint.EditPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut.Timing;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * |󏈗NXEIuWFNgɖߍރGfB^[łB
 * <p>
 * ΏۂƂȂWCgE|CgAhoCX
 * {@link jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping}
 * 擾܂B
 * <p>
 * @author C/pHeR
 */
public class TranslationEditor extends ExprEditor {

	/** K[ */
	@SuppressWarnings("unused")
	private static final Logger log = Logger.getLogger(TranslationEditor.class);

	/** ҏWΏۂƂȂ CtClass IuWFNg */
	private final CtClass ctClass;

	/** ҏWς݂̏ꍇ true */
	private boolean isEdited;

	/**
	 * |GfB^[\z܂B
	 * <p>
	 * @param ctClass CtClass IuWFNg
	 */
	public TranslationEditor(CtClass ctClass) {
		this.ctClass = ctClass;
	}

	/**
	 * RXgN^܂̓\bhĂяoҏW܂B
	 */
	@Override
	public void edit(MethodCall methodCall) throws CannotCompileException {
		
		String className = methodCall.getClassName();
		String methodName = methodCall.getMethodName();
		AspectMapping mapping = AspectMapping.getInstance();
		if (!mapping.containesMethodCall(className, methodName)) {
			return;
		}
		
		JointPoint jointPoint = new JointPoint();
		jointPoint.setEditPoint(EditPoint.CALL);
		jointPoint.setClassName(className);
		jointPoint.setMethodName(methodName);
		try {
			CtMethod calledMethod = methodCall.getMethod();
			jointPoint.setDescriptor(calledMethod.getMethodInfo().getDescriptor());
			jointPoint.setModifier(calledMethod.getModifiers());
		} catch (NotFoundException e) {
			// NXpXɌĂяo悪܂܂ĂȂꍇ͖
			log.warn("NXpXȂB" + className + "  " + ctClass.getName());
			return;
		}
		PointCut pointCut = mapping.getPointCut(jointPoint);
		if (pointCut == null) {
			return;
		}
		
		// Ăяȍꏊɂ鏜O
		//  includeAexclude  modefierAdescriptor ͖T|[g
		CtBehavior where = methodCall.where();
		JointPoint whereJointPoint = new JointPoint();
		whereJointPoint.setClassName(where.getDeclaringClass().getName());
		whereJointPoint.setMethodName(where.getName());
		List<JointPoint> excludeWheres = pointCut.getExcludeWheres();
		if (excludeWheres.contains(whereJointPoint)) {
			return;
		}
		
		// Ăяȍꏊɂ
		List<JointPoint> includeWheres = pointCut.getIncludeWheres();
		if (includeWheres.size() > 0 && !includeWheres.contains(whereJointPoint)) {
			return;
		}
		
		String advice = pointCut.getAdvice();
		methodCall.replace(advice);
		isEdited = true;
	}
	
	/**
	 * RXgN^܂̓\bhҏW܂B
	 * <p>
	 * @param ctBehavior RXgN^܂̓\bhEIuWFNg
	 * @throws CannotCompileException RpCłȂꍇ
	 */
	public void editBehavior(CtBehavior ctBehavior) throws CannotCompileException {
		
		String className = ctClass.getName();
		String methodName = ctBehavior.getName();
		
		JointPoint jointPoint = new JointPoint();
		jointPoint.setEditPoint(EditPoint.EXECUTION);
		jointPoint.setClassName(className);
		jointPoint.setMethodName(methodName);
		jointPoint.setDescriptor(ctBehavior.getMethodInfo().getDescriptor());
		jointPoint.setModifier(ctBehavior.getModifiers());
		
		AspectMapping mapping = AspectMapping.getInstance();
		PointCut pointCut = mapping.getPointCut(jointPoint);
		if (pointCut == null) {
			return;
		}
		
		Timing timing = pointCut.getTiming();
		String advice = pointCut.getAdvice();
		
		if (advice.contains("?{JOINT_POINT}")) {
			String replacement = Matcher.quoteReplacement(
					"new " + JointPoint.class.getName() + "(" +
					EditPoint.class.getName() + ".EXECUTION," +
					"\"" + className + "\"," +
					"\"" + methodName + "\"," +
					"\"" + jointPoint.getDescriptor() + "\"," +
					ctBehavior.getModifiers() +
					")");
			advice = advice.replaceAll("\\?\\{JOINT_POINT\\}", replacement);
		}
		
		if (timing == Timing.BEFORE) {
			ctBehavior.insertBefore(advice);
		} else if (timing == Timing.AFTER) {
			ctBehavior.insertAfter(advice);
		} else {
			throw new IllegalStateException(
			"ҏW|Cg execution ̏ꍇAtiming  before ܂ after " +
			"łKv܂B" + jointPoint);
		}
		isEdited = true;
	}
	
	/**
	 * ҏWʂoCgR[hŎ擾܂B
	 * <p>
	 * @return oCgR[hBҏW̏ꍇ nullB
	 * @throws IOException o͗Oꍇ
	 * @throws CannotCompileException RpCłȂꍇ
	 */
	public byte[] toBytecode() throws IOException, CannotCompileException {
		return isEdited ? ctClass.toBytecode() : null;
	}
}
