/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import jp.sourceforge.mergedoc.pleiades.aspect.Agent;
import jp.sourceforge.mergedoc.pleiades.aspect.AgentOption;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * t@Ng[łB
 * <p>
 * @author C/pHeR
 */
public class DictionaryFactory {
	
	/** K[ */
	private static final Logger log = Logger.getLogger(DictionaryFactory.class);

	/**  */
	private static IDictionary dictionary;
	
	// ̏
	static {
		AgentOption agentOption = Agent.getInstance().getAgentOption();
		try {
			if (agentOption.isNoCache()) {
				// LbVgpȂiʏ͎gpȂj
				dictionary = new NoCacheDictionary();
			} else if (agentOption.isClean()) {
				// LbVɕۑ鎫iNȂǂŎgpj
				dictionary = new InitialDictionary();
			} else {
				// LbVgp鎫i2 ڈȍ~̋NȂǂŎgpj
				dictionary = new CachedDictionary();
			}
		} catch (Exception e) {
			log.error(e.toString(), e);
		}
		log.info(" " +
				dictionary.getClass().getName().replaceFirst("(\\w+\\.)+", "") +
				" 𐶐܂B");
	}
	
	/**
	 * 쐬܂B
	 * <p>
	 * @return 
	 */
	public static IDictionary create() {
		return dictionary;
	}
	
	/**
	 * LbVɕۑ܂B
	 */
	public static void storeCache() {
		if (dictionary instanceof InitialDictionary) {
			((InitialDictionary) dictionary).storeCache();
		}
	}
}
