/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.io.IOUtils;

/**
 * -clean [hŎgp鎫łB
 * <p>
 * @author C/pHeR
 */
public class InitialDictionary extends AbstractDictionary {

	/** K[ */
	private static final Logger log = Logger.getLogger(InitialDictionary.class);

	/** |LbV */
	//private final Map<String, String> cache = new HashMap<String, String>();
	
	/**
	 * ̎\z܂B
	 */
	InitialDictionary() {
		super();
	}

	/*
	 * ( Javadoc)
	 * @see AbstractDictionary#lookup(String, String)
	 */
	// ȑO͖|󌋉ʂLbVĂAĂяopbP[Wɂ
	// |󏜊Oł邽߁ALbVȂB
	// ʏ̖|vpeB[̂݃LbVB
	//@Override
	//protected String lookup(String enValue, String enValueNonMnemonic) {
	//	String result = super.lookup(enValue, enValueNonMnemonic);
	//	cache.put(enValue, result);
	//	return result;
	//}
	
	/**
	 * ̓eLbVt@Cɕۑ܂B
	 */
	public void storeCache() {

		Properties prop = new Properties();
		prop.putAll(getMap());	// ʏ̖|vpeB[
		//prop.putAll(cache);		// |LbV
		ZipOutputStream out = null;
		
		try {
			out = new ZipOutputStream(new BufferedOutputStream(
					new FileOutputStream(CachedDictionary.cacheFile)));
            out.setLevel(Deflater.BEST_SPEED);
			out.putNextEntry(new ZipEntry("entry"));
			prop.store(out, null);
			log.info("|󎫏LbVۊǂ܂B" + prop.size());
			
		} catch (IOException e) {
			log.error("|󎫏LbV̕ۊǂɎs܂B", e);
			
		} finally {
			IOUtils.closeQuietly(out);
		}
	}
}
