/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.io.FileUtils;

/**
 * ϊONXLbVłB
 * <p>
 * @author cypher256
 */
public class ExcludesClassNameCache {

	/** K[ */
	private static final Logger log = Logger.getLogger(ExcludesClassNameCache.class);

	/** ϊONXLbVEt@C */
	private static final File file = new File(Pleiades.getConfigurationPath(), "excludes-class.list");

	/** ̃NX̃VOgECX^X */
	private static final ExcludesClassNameCache singleton = new ExcludesClassNameCache();

	/**
	 * ϊONXLbVEIuWFNg擾܂B
	 * <p>
	 * @return ϊONXLbVEIuWFNg
	 */
	public static ExcludesClassNameCache getInstance() {
		return singleton;
	}

	/** ϊONXEZbg */
	private Set<String> excludeSet = new HashSet<String>();

	/** [h̎TCY */
	private int loadedSize;

	/**
	 * ϊONXLbV\z܂B
	 */
	@SuppressWarnings("unchecked")
	private ExcludesClassNameCache() {

		if (Pleiades.getPleiadesOption().isClean()) {
			log.info("-clean ɂϊONXLbV̓[h܂B");

		} else  if (!file.exists()) {
			log.info("ϊONXLbV݂܂B");

		} else {
			try {
				excludeSet.addAll(FileUtils.readLines(file, null));
				log.info("ϊONXLbV[h܂B" + excludeSet.size());
			} catch (IOException e) {
				String msg = "ϊONXLbṼ[hɎs܂B";
				Exception ise = new IllegalStateException(msg, e);
				Pleiades.abort(ise);
			}
		}
		// [h̎TCYۑ
		loadedSize = excludeSet.size();
	}

	/**
	 * ǉꂽNXLbVƂĉi܂B
	 */
	public void store() {

		if (excludeSet.size() > loadedSize) {
			try {
				FileUtils.writeLines(file, null, excludeSet);
				log.info("ϊONXLbVۊǂ܂B" +
						loadedSize + " -> " + excludeSet.size());
			} catch (IOException e) {
				log.error("ϊONXLbV̕ۊǂɎs܂B", e);
			}
		}
	}

	/**
	 * AXyNg珜ONXǉ܂B
	 * <p>
	 * @param className NX
	 */
	public void add(String className) {
		excludeSet.add(className);
	}

	/**
	 * AXyNg珜ONX݂邩肵܂B
	 * <p>
	 * @param className NX
	 * @return w肳ꂽNX݂ꍇ true
	 */
	public boolean contains(String className) {
		return excludeSet.contains(className);
	}
}
