/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/**
 * Eclipse ÑoCgR[hϊsgXtH[}[łB
 * <p>
 * @author cypher256
 */
public class LauncherTransformer extends AbstractTransformer {

	/** K[ */
	private static final Logger log = Logger.getLogger(LauncherTransformer.class);

	/**
	 * NgXtH[}[\z܂B
	 */
	public LauncherTransformer() {
		load();
	}
	
	/**
	 * vpeB[[h܂B
	 */
	protected void load() {

		// AXyNg`[h
		// ) ʃXbhŏ SAXParser ŃfbhbN
		AspectMapping.getInstance();

		// -clean ɈˑȂ̂[h (񓯊s)
		// -clean Ɉˑ TranslationTransformer Ń[h
		Pleiades.getExecutorService().execute(new Runnable(){
			public void run() {

				// |󏜊OvpeB[[h
				TranslationExcludeProperties.getInstance();
				
				// K\|vpeB[[h
				RegexDictionary.getInstance();
			}
		});
	}

	/**
	 * oCgR[hϊs܂B
	 */
	@Override
	protected byte[] transform(
			ClassLoader loader,
			String className,
			ProtectionDomain protectionDomain,
			byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {

		//-------------------------------------------------
		// Main NX̕ϊ
		// 3.2 ȑOF org.eclipse.core.launcher.Main
		// 3.3 ȍ~F org.eclipse.equinox.launcher.Main
		//-------------------------------------------------
		if (className.endsWith(".launcher.Main")) {

			// ̃gXtH[}[G[WFg폜
			// OxfobOłȂꍇ (̃Op̕ϊ͍sȂ)
			if (!log.isDebugEnabled()) {
				Pleiades.getInstrumentation().removeTransformer(this);
			}

			// ϊ
			return transformMainClass(protectionDomain, bytecode);
		}
		//-------------------------------------------------
		// Workbench NX̕ϊ
		//-------------------------------------------------
		else if (className.equals("org.eclipse.ui.internal.Workbench")) {

			// ̃gXtH[}[G[WFg폜
			Pleiades.getInstrumentation().removeTransformer(this);

			// ϊ
			return transformWorkbenchClass(protectionDomain, bytecode);
		}

		return null;
	}

	/**
	 * Main NXϊ܂B
	 * <p>
	 * @param protectionDomain veNVEhC
	 * @param bytecode oCgR[h
	 * @return ϊ̃oCgR[h
	 */
	protected byte[] transformMainClass(ProtectionDomain protectionDomain, byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {

		// Eclipse Main NXɊJnǉ
		CtClass clazz = createCtClass(bytecode, protectionDomain);
		CtMethod method = clazz.getMethod("basicRun", "([Ljava/lang/String;)V");
		String className = getClass().getName();
		method.insertBefore("$1 = " + className + ".startTranslationTransformer($$);");

		// Eclipse Main NXɏIǉ
		method.insertAfter(className + ".destroy();", true);

		// XvbV摜pXύX
		PleiadesOption agentOption = Pleiades.getPleiadesOption();
		if (!agentOption.isDefaultSplash()) {
			System.setProperty("osgi.splashLocation", getSplashLocation());
		}
		return clazz.toBytecode();
	}

	/**
	 * Workbench NXϊ܂B
	 * <p>
	 * @param protectionDomain veNVEhC
	 * @param bytecode oCgR[h
	 * @return ϊ̃oCgR[h
	 */
	protected byte[] transformWorkbenchClass(ProtectionDomain protectionDomain, byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {

		return null;
	}

	/**
	 * |gXtH[}[Jn܂B
	 * <p>
	 * @param args Eclipse NIvVz
	 * @return NIvVz
	 */
	public static String[] startTranslationTransformer(String... args) {

		try {
			List<String> argList = new LinkedList<String>(Arrays.asList(args));

			// N -clean 擾
			PleiadesOption option = Pleiades.getPleiadesOption();
			option.setClean(argList.contains("-clean"));
			log.info("Eclipse ̋NJn܂B-clean:" + option.isClean());

			// |gXtH[}[Jn
			Instrumentation inst = Pleiades.getInstrumentation();
			if (log.isDebugEnabled()) {
				inst.addTransformer(new TranslationLoggingTransformer());
			} else {
				inst.addTransformer(new TranslationTransformer());
			}

			// ȑO -clean tĂA݂ -clean NłȂĂ
			// LbV̂߁AȂB
			// ߂lƂĕԂKv͂ȂÂ܂܎cĂB
			return argList.toArray(new String[0]);

		} catch (Throwable e) {

			String msg = "|gXtH[}[̊JnɎs܂B";
			Exception ise = new IllegalStateException(msg, e);
			Pleiades.abort(ise);
			return null;
		}
	}

	/**
	 * gXtH[}[j܂B
	 */
	public static void destroy() {

		TranslationTransformer.destroy();
	}

	/**
	 * XvbV摜pX擾܂B
	 * @return XvbV摜pX
	 */
	public static String getSplashLocation() {

		String version = "";

		File pluginsFolder = FileSystem.resourceRoot.getParentFile().getParentFile();
		for (File folder : pluginsFolder.listFiles()) {
			String folderName = folder.getName();
			if (folderName.startsWith("org.eclipse.osgi_")) {
				version = folderName.replaceFirst(".*?_(\\d+\\.\\d+).*", "$1");
				break;
			}
		}
		String fileName = "splash" + version + ".bmp";

		File file = FileSystem.getResourceFile(fileName);
		if (!file.exists()) {
			fileName = "splash.bmp";
		}
		File splashFile = FileSystem.getResourceFile(fileName);
		return splashFile.getAbsolutePath().replace('\\', '/');
	}
}
