/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * Sȃ^XNsT[rXłB
 * <p>
 * JDK ftHg ThreadPoolExecutor ̓^XNspɎ󂯓邱Ƃ
 * łȂꍇARejectedExecutionException X[܂A
 * ̃NX̗͂OꍇA񓯊sɓsɐ؂ւ
 * s܂B
 * <p>
 * @author cypher256
 */
public class SafetyExecutorService extends ThreadPoolExecutor {

	/** K[ */
	private static Logger log = Logger.getLogger(SafetyExecutorService.class);
	
	/**
	 * RXgN^B
	 * <p>
	 * ݒ肳Xbh^CAEgԂ Executors.newCachedThreadPool()
	 * ƓłB
	 */
	public SafetyExecutorService() {
		super(0, Integer.MAX_VALUE,
                60L, TimeUnit.SECONDS,
                new SynchronousQueue<Runnable>());
	}

	@Override
	public void execute(Runnable command) {
		try {
			super.execute(command);
		} catch (RejectedExecutionException e) {
			log.debug("RejectedExecutionException ߁As܂B");
			command.run();
		}
	}
}
