/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * ԌvO@\t TranslationTransformer łB
 * <p>
 * @author cypher256
 */
public class TranslationLoggingTransformer extends TranslationTransformer implements ITimingLogger {

	/** K[ */
	private static final Logger log = Logger.getLogger(TranslationLoggingTransformer.class);

	/** load \bh̏v */
	private volatile int loadTime;

	/** load \bȟĂяo */
	private volatile int loadCall;

	/** transform (ۃNX) \bh̏v */
	private volatile int transformAbstractTime;

	/** transform (ۃNX) \bȟĂяo */
	private volatile int transformAbstractCall;

	/** createCtClass (ۃNX) \bh̏v */
	private volatile int createCtClassTime;

	/** createCtClass (ۃNX) \bȟĂяo */
	private volatile int createCtClassCall;

	/** transform \bh̏v */
	private volatile int transformTime;

	/** transform \bȟĂяo */
	private volatile int transformCall;

	/** weaveTranslationAspect \bh̏v */
	private volatile int transformClassTime;

	/** weaveTranslationAspect \bȟĂяo */
	private volatile int transformClassCall;

	/**
	 * |gXtH[}[\z܂B
	 */
	public TranslationLoggingTransformer() {
		Pleiades.registTimingLogger(this);
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected void load() {

		long startTime = System.currentTimeMillis();
		super.load();
		synchronized (this) {
			loadTime += System.currentTimeMillis() - startTime;
			loadCall++;
		}
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	public byte[] transform(
			ClassLoader loader,
			String internalName,
			Class<?> classBeingRedefined,
			ProtectionDomain protectionDomain,
			byte[] bytecode) throws IllegalClassFormatException {

		long startTime = System.currentTimeMillis();
		byte[] result = super.transform(loader, internalName, classBeingRedefined, protectionDomain, bytecode);
		synchronized (this) {
			transformAbstractTime += System.currentTimeMillis() - startTime;
			transformAbstractCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected byte[] transform(
			ClassLoader loader,
			String className,
			ProtectionDomain protectionDomain,
			byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {

		long startTime = System.currentTimeMillis();
		byte[] result = super.transform(loader, className, protectionDomain, bytecode);
		synchronized (this) {
			transformTime += System.currentTimeMillis() - startTime;
			transformCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected byte[] transformClass(CtClass ctClass)
		throws CannotCompileException, NotFoundException, IOException {

		long startTime = System.currentTimeMillis();
		byte[] result = super.transformClass(ctClass);
		synchronized (this) {
			transformClassTime += System.currentTimeMillis() - startTime;
			transformClassCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected CtClass createCtClass(
			byte[] bytecode,
			ProtectionDomain protectionDomain) throws IOException, NotFoundException {

		long startTime = System.currentTimeMillis();
		CtClass result = super.createCtClass(bytecode, protectionDomain);
		synchronized (this) {
			createCtClassTime += System.currentTimeMillis() - startTime;
			createCtClassCall++;
		}
		return result;
	}

	/**
	 * ԌvOo͂܂B
	 * @return vԍv (b)
	 */
	public long logTime() {

		String msg = "%-30s %8d ďov %6.3f b";

		log.debug(String.format(msg, "load",
				loadCall, loadTime / 1000d));
		log.debug(String.format(msg, "transform (Abstract)",
				transformAbstractCall, transformAbstractTime / 1000d));
		log.debug(String.format(msg, "  transform",
				transformCall, transformTime / 1000d));
		log.debug(String.format(msg, "    createCtClass (Abstract)",
				createCtClassCall, createCtClassTime / 1000d));
		log.debug(String.format(msg, "    transformClass",
				transformClassCall, transformClassTime / 1000d));

		long summuryTime =
			loadTime + transformAbstractTime + transformTime +
			createCtClassTime + transformClassTime;

		log.debug(String.format("NXv %6.3f b", summuryTime / 1000d));

		return summuryTime;
	}

	/**
	 * vlZbg܂B
	 */
	public void reset() {

		synchronized (this) {
			Field[] fields = getClass().getDeclaredFields();
			for (int i = 0; i < fields.length; i++) {
				Field field = fields[i];
				if (field.getType() == Integer.TYPE) {
					try {
						field.setAccessible(true);
						field.set(this, 0);
					} catch (Exception e) {
						log.error("tB[h̏Ɏs܂B", e);
					}
				}
			}
		}
	}
}
