/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Map.Entry;

import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.AbstractTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;
import jp.sourceforge.mergedoc.pleiades.util.UnMnemonicProperties;

/**
 * ̌pbNvpeB[Et@C}[WA1 
 * vpeB[Et@C (translation.properties) 쐬邽߂
 * WFl[^[łB
 * <p>
 * @author cypher256
 */
public class Generator {

	/** K[ */
	private static final Logger log = Logger.getLogger(Generator.class);

	/** Zς݌pbNvpeB[Et@C */
	private static final String NLS_CUSTOMIZED_PROP = "props/nls-customized.properties";

	/** ǉvpeB[Et@C */
	private static final String ADDITIONS_ALL_PROP = "props/additions-all.properties";

	/** K\L[vtBbNX */
	private static final String REGEX_KEY_PREFIX = "%REGEX%";

	/** |󏜊OL[vtBbNX */
	private static final String EXCLUDE_KEY_PREFIX = "%EXCLUDE%";
	
	/**
	 * WFl[^[Jn邽߂ main \bhłB
	 * <p>
	 * @param args N
	 * @throws IOException o͗Oꍇ
	 */
	public static void main(String... args) throws IOException {
		new Generator().run();
	}

	/**
	 * WFl[^[s܂B
	 * <p>
	 * @throws IOException o͗Oꍇ
	 */
	private void run() throws IOException {
		
		// Zς݌pbNvpeB[
		Properties nlsCustomizedProp = new UnMnemonicProperties(NLS_CUSTOMIZED_PROP);
		// ǉvpeB[
		Properties additionsAllProp = new Properties();
		// K\vpeB[
		Properties regexProp = new Properties();
		// OvpeB[
		Properties excludeProp = new Properties();
		
		// of[^[
		Validator validator = new Validator(nlsCustomizedProp);

		// ǉ̐U蕪
		File[] files = FileSystem.getResourceFile("props/additions").listFiles();
		Arrays.sort(files); // 

		for (File file : files) {
			if (file.isFile() && file.getName().endsWith(".properties")) {

				Properties prop = new UnMnemonicProperties(file);

				// % Ŏn܂vpeB𒊏oAʃvpeB֐U蕪
				for (Entry<Object, Object> entry : prop.entrySet()) {

					String key = entry.getKey().toString();
					String value = entry.getValue().toString();

					if (key.startsWith(REGEX_KEY_PREFIX)) {

						// K\vpeB
						String newKey = key.replaceFirst("^" + REGEX_KEY_PREFIX, "");
						regexProp.put(newKey, value);

					} else if (key.startsWith(EXCLUDE_KEY_PREFIX)) {

						// |󏜊OvpeB
						String newKey = key.replaceFirst("^" + EXCLUDE_KEY_PREFIX, "");
						Object existsValue = excludeProp.get(newKey);
						if (existsValue != null) {
							value = existsValue + "," + value;
						}
						excludeProp.put(newKey, value);

					} else {

						// ̌
						validator.validate(file.getName(),
								key, value);

						// |󎫏
						additionsAllProp.put(key, value);
					}
				}
			}
		}
		if (validator.getErrorCount() > 0) {
			log.error(
				"̃}[W " + validator.getErrorCount() +
				" ̃G[oꂽ߁A𒆎~܂B");
			System.exit(-1);
		}
		
		// ǉۊ (QƗp)
		FileSystem.storeProperties(additionsAllProp, ADDITIONS_ALL_PROP,
			"ǉvpeB[\n\n" +
			"  ڎQƗpɃvOCʂ̒ǉ}[ŴłB\n" +
			"  VXeIɂ͕svȃt@CłB\n" +
			"  ͌t@CFconf/props/addtions/*.properties");

		// }[W (dȂƂof[^[Ń`FbNς)
		Properties resultProp = new Properties();
		resultProp.putAll(nlsCustomizedProp);
		resultProp.putAll(additionsAllProp);

		// ۊ
		FileSystem.storeProperties(resultProp, AbstractTranslationDictionary.PROP_FILE_NAME,
			"|󎫏vpeB[\n\n" +
			"  pbNƑSǉ}[ŴŁAPleiades sɎQƂ܂B\n" +
			"  ͌t@CFnls-customized.propertiesAconf/props/addtions/*.properties");
		FileSystem.storeProperties(regexProp, RegexDictionary.PROP_FILE_NAME,
			"K\vpeB[\n\n" +
			"  K\Ŗ|󂷂邽߂̎ŁAPleiades sɎQƂ܂B\n" +
			"  ͌t@CFconf/props/addtions/*.properties ̃L[擪 " + REGEX_KEY_PREFIX + " 鍀");
		FileSystem.storeProperties(excludeProp, TranslationExcludeProperties.PROP_FILE_NAME,
			"|󏜊OvpeB[\n\n" +
			"  | Java pbP[WPʂŏO󂷂邽߂̎ŁAPleiades sɎQƂ܂B\n" +
			"  ͌t@CFconf/props/addtions/*.properties ̃L[擪 " + EXCLUDE_KEY_PREFIX + " 鍀");

		// Oo
		String msg = "%-35s %5d";
		log.info(String.format(msg, ADDITIONS_ALL_PROP,
				additionsAllProp.size()));
		log.info(String.format(msg, NLS_CUSTOMIZED_PROP,
				nlsCustomizedProp.size()));
		log.info(String.format(msg, AbstractTranslationDictionary.PROP_FILE_NAME,
				resultProp.size()));
		log.info(String.format(msg, RegexDictionary.PROP_FILE_NAME,
				regexProp.size()));
		log.info(String.format(msg, TranslationExcludeProperties.PROP_FILE_NAME,
				excludeProp.size()));
	}
}
