/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Map.Entry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;
import jp.sourceforge.mergedoc.pleiades.util.UnMnemonicProperties;

/**
 * ؂AʂOo͂܂B
 * <p>
 * @author cypher256
 */
public class Validator {

	/** K[ */
	private static final Logger log = Logger.getLogger(Validator.class);

	/** ؏OZbg */
	private static final Set<Object> validationExcludeSet =
		FileSystem.loadProperties("props/validation-exclude.properties").keySet();

	/** |󏜊OZbg */
	private static final Set<Object> translationExcludeSet =
		FileSystem.loadProperties("props/translation-exclude.properties").keySet();

	/** [EvpeB[ */
	private static final Properties ruleProp =
		FileSystem.loadProperties("props/rule.properties");

	/** eclipse.org pbNSvpeB[ */
	private final Properties nlsAllProp;

	/** ؍ς݂̃vpeB[ */
	private static class ValidatedItem {
		/** t@CȂǂ̎ʎq */
		public String name;
		/** {ꕶ */
		public String ja;
	}

	/** ؍ς݂̃vpeB[̃}bv (L[Fpꕶ) */
	private final Map<String, ValidatedItem> validatedMap = new HashMap<String, ValidatedItem>();

	/** G[ */
	private int errorCount;

	/**
	 * RXgN^B
	 * @param nlsAllProp d`FbNp eclipse.org pbNSvpeB[
	 */
	public Validator(Properties nlsAllProp) {
		this.nlsAllProp = nlsAllProp;
	}

	/**
	 * G[Oo͂܂B
	 * @param name t@CȂǂ̎ʎq
	 * @param en pꕶ
	 * @param ja {ꕶ
	 * @param message bZ[W
	 */
	private void error(String name, String en, String ja, String message) {

		String m =
			name + "\n" +
			UnMnemonicProperties.toPropertyKey(en) + "=" +
			UnMnemonicProperties.toPropertyValue(ja) + "\n" +
			message;

		String indent = "      ";
		m = m.replace("\n", "\n" + indent);

		log.error(m);
		errorCount++;
	}

	/**
	 * G[擾܂B
	 * @return G[
	 */
	public int getErrorCount() {
		return errorCount;
	}

	/**
	 * ؂܂B
	 * @param name t@CȂǂ̎ʎq
	 * @param en pꕶ
	 * @param ja {ꕶ
	 */
	public void validate(String name, String en, String ja) {

		String e = en.trim();
		String j = ja.trim();
		if (validationExcludeSet.contains(e)) {
			return;
		}
		StringBuilder message = new StringBuilder();

		//---------------------------------------------------------------------
		// ̓ꐫ`FbN
		//---------------------------------------------------------------------

		// ́u...v`FbN
		if (e.endsWith("...") && !j.endsWith("...")) {
			message.append("̖Ɂu...vꍇ́A󕶂̖ɂu...vKvłB\n");
		}

		// ́u..v`FbN
		else if (e.endsWith("..") && !j.endsWith("..")) {
			message.append("̖Ɂu..vꍇ́A󕶂̖ɂu..vKvłB\n");
		}

		// ́u.v`FbN
		else if (!e.endsWith("..") && e.endsWith(".") && !j.endsWith("B")) {

			// E1 P̏ꍇ̓`FbNȂ
			// ErɁu:v܂܂ꍇ̓`FbNȂ
			// jIncompatible\ file\ format.\ Workspace\ was\ saved\ with\ an\ incompatible\ version\:\ {0}.
			if (e.contains(" ") && !e.contains(":")) {
				message.append("ɂu.v_\ꍇ́A󕶂̖ɂuBvKvłB\n");
			}
		}

		// ́u:v`FbN
		else if (e.endsWith(":") && !j.endsWith(":")) {
			message.append("̖Ɂu:vꍇ́A󕶂̖Ɂu:vKvłB\n");
		}

		//---------------------------------------------------------------------
		// o`FbN
		//---------------------------------------------------------------------

		// {0} Ȃǂ̖ߍݐ`FbN
		Matcher mat = Pattern.compile("\\{[0-9]\\}").matcher(e);
		while (mat.find()) {
			String group = mat.group();
			if (!j.contains(group)) {
				message.append("Ɋ܂܂ " + group + " 󕶂ɂKvłB\n");
			}
		}

		// s`FbN
		int eCount = en.length() - en.replace("\n", "").length();
		int jCount = ja.length() - ja.replace("\n", "").length();
		if (eCount != jCount) {
			message.append("s \\n ̐قȂ܂B:" + eCount + " :" + jCount + "\n");
		}

		//---------------------------------------------------------------------
		// ꓝ`FbN
		//---------------------------------------------------------------------
		
		for (Entry<Object, Object> rep : ruleProp.entrySet()) {

			String ng = (String) rep.getKey();
			String ok = (String) rep.getValue();
			
			if (ja.contains(ng)) {
				if (ok.equals("")) {
					message.append("\"" + ng + "\" ͎gp֎~łB\n");
				} else {
					message.append("\"" + ng + "\" ͎gp֎~łB\"" + ok + "\" gpĂB\n");
				}
			}
		}

		//---------------------------------------------------------------------
		// d`FbN
		//---------------------------------------------------------------------

		// |󏜊O`FbN
		if (translationExcludeSet.contains(en)) {
			
			message.append(
				"̖ Eclipse ̓ɖ肪邽߁AĂ܂B" +
				"̃Gg[폜ĂB\n");
		}
		
		// pbNd`FbN
		String nlsJa = nlsAllProp.getProperty(en);
		if (nlsJa != null) {
			
			if (nlsJa.equals(ja)) {
				message.append(
					"̍Zς݌pbNɂ܂̖󂪑݂܂B" +
					"̃Gg[폜ĂB\n");
			} else {
				message.append(
					"̍Zς݌pbNɊɖ󂪑݂܂B" +
					"荞ޏꍇ 150 ȏ̃vOCɉe邱ƂlKv܂B\n" +
					"̍Zς݌pbN [" + nlsJa + "]\n");
			}
		}

		// ǉd`FbN
		ValidatedItem validatedItem = validatedMap.get(en);
		if (validatedItem != null) {

			if (ja.equals(validatedItem.ja)) {

				message.append(
					"̒ǉ " + validatedItem.name + " ɂ܂󂪊ɑ݂܂B" +
					"̃Gg[͕svȂߍ폜ĂB\n");
			} else {

				message.append(
					"̒ǉɈقȂ󂪊ɑ݂܂B" +
					"荞ޏꍇ 150 ȏ̃vOCɉe邱ƂlKv܂B\n" +
					"̒ǉ̖ " + validatedItem.name + ": " + validatedItem.ja + "\n");
			}

		} else {
			validatedItem = new ValidatedItem();
			validatedItem.name = name;
			validatedItem.ja = ja;
			validatedMap.put(en, validatedItem);
		}

		// G[Ȍo
		if (message.length() > 0) {
			error(name, en, ja, message.toString());
		}
	}
}
