/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.generator.nls;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Map.Entry;

import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;
import jp.sourceforge.mergedoc.pleiades.util.UnMnemonicProperties;

import org.apache.commons.lang.StringUtils;

/**
 * Eclipse 3.2 ܂ eclipse.org zzĂpbNA
 * {𒊏oAPleiades `̃vpeB[Et@Cɏo͂܂B
 * <p>
 * @author cypher256
 */
public class Extractor {

	/** K[ */
	private static final Logger log = Logger.getLogger(Extractor.class);

	/** NLS 擾vOCmFfobOEOo͗p̉pꃊ\[X */
	private static String debugEnValue;

	/**
	 * oJn邽߂ main \bhłB
	 * <p>
	 * @param args NLS 擾vOCmFfobOEOo͗p̉pꃊ\[X
	 * @throws IOException o͗Oꍇ
	 */
	public static void main(String... args) throws IOException {
		
		if (args.length != 0) {
			debugEnValue = args[0];
			log.info("Ɏw肳ꂽ [" + debugEnValue +
					"]  NLS 擾vOCmF܂BvpeB[͏o͂܂B");
		}
		new Extractor().run();
	}

	/** pbNƂ̃vOC{̂i[ꂽtH_[ */
	private final File inFolder = FileSystem.getResourceFile("../nls");
	
	/** o͐tH_[ */
	private final File outFolder = FileSystem.getResourceFile("props/nls");

	/** NLS }[Wɓ{vpeB[Gg[i[vpeB[ */
	private final Properties nlsMissingProp = new UnMnemonicProperties();

	/**
	 * os܂B
	 * <p>
	 * @throws IOException o͗Oꍇ
	 */
	private void run() throws IOException {
		
		// fobO񂪐ݒ肳ĂȂꍇ
		if (StringUtils.isBlank(debugEnValue)) {
			
			// o͐tH_[̃vpeB[Et@Cׂč폜
			// (.svn 폜Ȃ悤ɒ)
			File[] files = outFolder.listFiles();
			for (File file : files) {
				if (file.getPath().endsWith(".properties")) {
					file.delete();
				}
			}
		}
		
		// pbNvpeB[𒊏oAo͐tH_[ɏo
		generate(inFolder);
		
		// ovpeB[[hA|󃋁[Kp
		Properties nlsAllProp = new UnMnemonicProperties("props/nls");
		Optimizer optimizer = new Optimizer();
		optimizer.apply(nlsAllProp);

		// o͂vpeB[Et@C
		String nlsAllPropPath = "props/temp/nls-all.properties";
		String nlsMissingPropPath = "props/temp/nls-all-missing.properties";
		
		// fobO񂪐ݒ肳ĂȂꍇ͏o
		if (StringUtils.isBlank(debugEnValue)) {

			// 1 ̃vpeB[Et@CƂĕۊ
			FileSystem.storeProperties(nlsAllProp, nlsAllPropPath,
				"eclipse.org pbNovpeB[\n\n" +
				"  vOCʂ̌pbN}[ŴłB\n" +
				"  ͌t@CFconf/props/nls/*.properties");
			
			// 󂪌ȂvpeB[ۊ
			FileSystem.storeProperties(nlsMissingProp, nlsMissingPropPath,
				"eclipse.org pbNo|vpeB[\n\n" +
				"  pbNoɖ󂪌Ȃڂ̃vpeB[łB\n" +
				"  ͌t@CFnls/*/*/*");
		}
		
		log.info(nlsAllPropPath + " " + nlsAllProp.size());
		log.info(nlsMissingPropPath + " " + nlsMissingProp.size());
	}

	/**
	 * w肳ꂽtH_[ɑ݂錾pbNċAIɃ[hA
	 * vpeB[𐶐܂B
	 * <p>
	 * @param nlsFolder NLS tH_[
	 * @throws IOException o͗Oꍇ
	 */
	private void generate(File nlsFolder) throws IOException {

		File[] files = nlsFolder.listFiles();
		Arrays.sort(files); // 

		for (File file : files) {

			if (file.isFile()) continue;
			String name = file.getName();
			if (name.equals("plugins") || name.equals("features")) {
				generateProperties(file);
			} else {
				generate(file); // ċA
			}
		}
	}

	/**
	 * w肳ꂽvOCEtH_[ɑ݂錾pbN[hA
	 * vpeB[𐶐܂B
	 * <p>
	 * @param pluginFolder vOCEtH_[
	 * @throws IOException o͗Oꍇ
	 */
	private void generateProperties(File pluginFolder) throws IOException {

		Map<String, PropertiesUnit> pluginMap =
			new HashMap<String, PropertiesUnit>();

		File[] files = pluginFolder.listFiles();
		Arrays.sort(files); // 

		// {Ɖp̃vpeB[[h
		for (File file : files) {

			Plugin plugin = (pluginFolder.getName().equals("plugins"))
				? new Plugin(file) : new Feature(file);

			String msg = "%-46s en:%4d ja:%4d %s";
			log.debug(String.format(msg,
					plugin.getId(),
					plugin.getEnProperties().size(),
					plugin.getJaProperties().size(),
					FileSystem.relativePath(inFolder, file)));

			String pluginId = plugin.getId();
			PropertiesUnit propUnit = pluginMap.get(pluginId);
			if (propUnit == null) {
				propUnit = new PropertiesUnit();
				pluginMap.put(pluginId, propUnit);
			}
			propUnit.getEnProperties().putAll(plugin.getEnProperties());
			propUnit.getJaProperties().putAll(plugin.getJaProperties());
		}

		String pluginPath = FileSystem.relativePath(inFolder, pluginFolder);

		// {Ɖp̃vpeB[ŃL[v̂vpeB[쐬
		for (Entry<String, PropertiesUnit> entry : pluginMap.entrySet()) {

			PropertiesUnit propUnit = entry.getValue();
			Properties enProp = propUnit.getEnProperties();
			Properties jaProp = propUnit.getJaProperties();
			Properties outProp = new UnMnemonicProperties();

			for (Entry<?, ?> jaEntry : jaProp.entrySet()) {

				String key = (String) jaEntry.getKey();
				String enValue = (String) enProp.get(key);
				String jaValue = (String) jaEntry.getValue();

				if (StringUtils.isNotEmpty(enValue) && !enValue.equals(jaValue)) {

					if (jaValue.matches("\\p{ASCII}+")) {
						continue;
					}
					// ɂȂ NLS ŗL̖󒍂܂܂Ă̂͏O
					if (jaValue.contains("̖|łł") || jaValue.contains("̂߂̃hCc")) {
						continue;
					}
					outProp.put(enValue, jaValue);

					if (StringUtils.isNotBlank(debugEnValue) &&
						debugEnValue.equals(UnMnemonicProperties.removeEnMnemonic(enValue))) {
						String pluginBaseName = pluginFolder.getPath().replace("\\", "/");
						pluginBaseName = pluginBaseName.replaceFirst(".+/([^/]+?/[^/]+?)", "$1");
						log.info("擾vOC: " +
								pluginBaseName + "/" + key + "=" + jaValue);
					}
				}
			}

			// vpeB[Et@C֏o
			if (outProp.size() > 0) {
				
				// fobO񂪐ݒ肳ĂȂꍇ͏o
				if (StringUtils.isBlank(debugEnValue)) {
					
					String pluginId = entry.getKey();
					String outFileName = pluginPath.replace('\\', '@') + "@" + pluginId + ".properties";
					File outFile = new File(outFolder, outFileName);
					FileSystem.storeProperties(outProp, outFile,
						"eclipse.org pbNovpeB[ (vOC)");
					log.info(outFileName + " " + outProp.size());
				}
			}

			// {vpeB݂Ȃꍇ̃vpeB[쐬
			for (Entry<?, ?> enEntry : enProp.entrySet()) {

				String jaValue = (String) jaProp.get(enEntry.getKey());
				String enValue = enEntry.getValue().toString();

				if (jaValue == null &&
					enValue.matches(".*[a-zA-Z].*") &&
					enValue.length() > 1) {

					nlsMissingProp.put(enValue, "");
				}
			}
		}
	}
}
