/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import jp.sourceforge.mergedoc.pleiades.util.UnMnemonicProperties;

/**
 * |󎫏NXłB
 * ͐ÓIȌpbNEWFl[^[Ȃǂ̊O̗pz肵NXłB
 * Eclipse s DynamicTranslationDictionary gp܂B
 * <p>
 * @author cypher256
 */
public class TranslationDictionary extends AbstractTranslationDictionary {

	/**
	 * w肵pꃊ\[X񂩂{ꃊ\[XT܂B
	 * j[jbN͓{ɕϊ܂B
	 * <pre>
	 * ELabel		 x
	 * EL&abel		 x(&A)	--- QƂOɃj[jbNU
	 * ECVS		 CVS			--- ɖꍇ͂̂܂
	 * EC&VS		 CVS(&V)		--- ɖj[jbN͕ϊ
	 * </pre>
	 * Ή󂪎ɑ݂Ȃꍇ́A߂l {@link TranslationResult}
	 *  isFound  false ݒ肳܂B
	 * <p>
	 * <b>j</b>ɑ݂ȂĂj[jbNϊ͍s邽߁A
	 * ݗL̔sꍇ́A̒lƌʂ̒lr̂ł͂ȂA
	 * ߂l isFound gp悤ɂĂB
	 * 
	 * @param en pꃊ\[X
	 * @return |󌋉
	 */
	public TranslationResult lookup(String en) {

		// pꃊ\[X񂩂j[jbN䕶 & 
		String enNoMnemonic = UnMnemonicProperties.removeEnMnemonic(en);
		
		// |vpeB[Ζ擾
		String jaNoMnemonic = getValue(enNoMnemonic);
		
		// j[jbN{pɕϊB
		// ̕ϊ͖ꂪȂꍇsBFC&VS  CVS(&V)
		String value = editMnemonicEnToJa(en, enNoMnemonic, jaNoMnemonic);
		
		// |󌋉ʂ쐬
		TranslationResult result = new TranslationResult();
		result.setValue(value);
		result.setFound(!jaNoMnemonic.equals(enNoMnemonic));
		return result;
	}

	/**
	 * w肵pꃊ\[X񂩂{ꃊ\[XT܂B
	 * j[jbN͏܂B̃\bh͈Ɋ܂܂ & 
	 * j[jbNƂďȂꍇɎgp܂B
	 * <pre>
	 * ELabel		 x
	 * EL&abel		 L&abel		--- QƂOɃj[jbN͏Ȃ
	 * ECVS		 CVS			--- ɖꍇ͂̂܂
	 * EC&VS		 C&VS			--- ɖBj[jbNϊB
	 * </pre>
	 * @param en pꃊ\[X
	 * @return |󌋉
	 */
	public TranslationResult lookupIgnoreMnemonic(String en) {
		
		// |vpeB[Ζ擾
		String value = getValue(en);
		
		// |󌋉ʂ쐬
		TranslationResult result = new TranslationResult();
		result.setValue(value);
		result.setFound(!value.equals(en));
		return result;
	}
}
