/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/**
 * t@C샆[eBeB[łB
 * <p>
 * @author cypher256
 */
public class FileSystem {

	/** \[XE[g */
	public static final File resourceRoot;

	// [g̎擾
	static {
		String markResource = "/.marker";
		URL url = FileSystem.class.getResource(markResource);
		if (url == null) {

			// jK[̓OݒOɏĂ܂ߎgpȂ
			String msg = "NXpXɃt@C܂B" + markResource;
			Exception e = new FileNotFoundException(msg);
			System.err.println(msg + " " + e);
			throw new IllegalStateException(msg, e);
		}
		String path = new File(url.getPath()).getParent();
		String unicodePath = decodePath(path);
		resourceRoot = new File(unicodePath);
	}

	/**
	 * CX^Xł܂B
	 */
	private FileSystem() {
	}

	/**
	 * application/x-www-form-urlencoded fR[h܂B<br>
	 * j%e3%81%82 -> 
	 * <p>
	 * @param path fR[hÕpX
	 * @return fR[h̃pX
	 */
	public static String decodePath(String path) {
		try {
			return URLDecoder.decode(path, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new IllegalStateException(e);
		}
	}

	/**
	 * \[XE[g̑΃pXw肵AFile IuWFNg擾܂B
	 * <p>
	 * @param resourcePath \[XEpX
	 * @return \[X File IuWFNg
	 */
	public static File getResourceFile(String resourcePath) {
		return new File(resourceRoot, resourcePath);
	}

	/**
	 * w肵tH_[t@Cւ̑΃pX擾܂B
	 * <p>
	 * @param folder tH_[
	 * @param file t@C
	 * @return ΃pX
	 */
	public static String relativePath(File folder, File file) {

		try {
			String folderPath = folder.getCanonicalPath();
			String filePath = file.getCanonicalPath();
			return filePath.replace(folderPath, "");

		} catch (IOException e) {
			throw new IllegalArgumentException(folder + ", " + file, e);
		}
	}

	/**
	 * w肳ꂽvpeB[Et@C[h܂B
	 * <p>
	 * @param file vpeB[Et@C
	 * @return vpeB[
	 */
	public static Properties loadProperties(File file) {

		Properties prop = new Properties();
		if (!file.exists()) {
			return prop;
		}

		InputStream is = null;
		try {
			is = new BufferedInputStream(new FileInputStream(file));
			prop.load(is);

		} catch (IOException e) {
			throw new IllegalArgumentException(file.toString(), e);

		} finally {
			IOUtils.closeQuietly(is);
		}
		return prop;
	}

	/**
	 * w肳ꂽvpeB[Et@C[h܂B
	 * <p>
	 * @param resourcePath \[XEpX
	 * @return vpeB[
	 */
	public static Properties loadProperties(String resourcePath) {

		return loadProperties(getResourceFile(resourcePath));
	}

	/**
	 * w肳ꂽvpeB[\[găt@Cɕۊǂ܂B
	 * <p>
	 * @param prop vpeB[
	 * @param file t@C
	 * @param title wb_[ɏo͂^Cg
	 */
	@SuppressWarnings("unchecked")
	public static void storeProperties(Properties prop, File file, String title) {

		// t@CƓełΕۑȂ (Rg̓tXV}~)
		Properties propOld = FileSystem.loadProperties(file);
		if (propOld.equals(prop)) {
			System.out.println("t@CƓeł邽ߕۑ܂B" + file);
			// jK[̓OݒOɏĂ܂ߎgpȂ
			return;
		}
		
		OutputStream os = null;
		try {
			os = new BufferedOutputStream(new FileOutputStream(file));
			
			List<String> headerList = new LinkedList<String>();
			headerList.add("̃t@C Pleiades ɂ萶܂B" + prop.size() + " Gg[B");
			headerList.add("###############################################################################");
			headerList.add("# ");
			for (String s : title.split("\\n")) {
				headerList.add("# " + s);
			}
			headerList.add("# ");
			headerList.add("###############################################################################");
			String header = StringUtils.join(headerList, "\n");
			prop.store(os, header);

			List<String> list = FileUtils.readLines(file, "ISO-8859-1");
			List<String> resultList = new LinkedList<String>();
			for (int i = 0; i < headerList.size() + 2; i++) {
				resultList.add(list.remove(0));
			}
			Collections.<String>sort(list, String.CASE_INSENSITIVE_ORDER);
			resultList.addAll(list);
			FileUtils.writeLines(file, "ISO-8859-1", resultList);

		} catch (IOException e) {
			throw new IllegalArgumentException(file.toString(), e);

		} finally {
			IOUtils.closeQuietly(os);
		}
	}

	/**
	 * w肳ꂽvpeB[\[găt@Cɕۊǂ܂B
	 * <p>
	 * @param prop vpeB[
	 * @param resourcePath \[XEpX
	 * @param title wb_[ɏo͂^Cg
	 */
	public static void storeProperties(Properties prop, String resourcePath, String title) {

		File resourceFile = getResourceFile(resourcePath);
		storeProperties(prop, resourceFile, title);
	}
}
