/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

/**
 * |󎫏NX̃eXgENXłB
 * <p>
 * @author cypher256
 */
public class TranslationDictionaryTest extends junit.framework.TestCase {

	/** ^[Qbg */
	private final TranslationDictionary target = new TranslationDictionary();

	/**
	 * eXg
	 */
	public void testLookup() {

		TranslationResult result = null;
		String input = null;

		// lookup
		input = "... undefined string in dictionary ...";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals(input, result.getValue());
		assertEquals(false, result.isFound());

		input = "Label";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("x", result.getValue());
		assertEquals(true, result.isFound());

		input = "L&abel";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("x(&A)", result.getValue());
		assertEquals(true, result.isFound());

		input = "&Left";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("(&L)", result.getValue());
		assertEquals(true, result.isFound());

		input = "Search results for {0}:";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("{0} ̌:", result.getValue());
		assertEquals(true, result.isFound());

		input = "Remo&ve Buildfile";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("rhEt@C̏(&V)", result.getValue());
		assertEquals(true, result.isFound());

		input = "Error reading configuration";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("\̓ǂݎ蒆ɃG[܂", result.getValue());
		assertEquals(true, result.isFound());

		input = "&Extension....";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("g(&E)....", result.getValue());
		assertEquals(true, result.isFound());

		// lookupIgnoreMnemonic
		result = target.lookupIgnoreMnemonic("Label");
		System.out.println(input + "=" + result.getValue());
		assertEquals("x", result.getValue());
		assertEquals(true, result.isFound());

		input = "L&abel";
		result = target.lookupIgnoreMnemonic(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals(input, result.getValue());
		assertEquals(false, result.isFound());
	}
}
