/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationNotFoundProperties;

import org.apache.commons.lang.StringUtils;

/**
 * Pleiades 起動オプションです。
 * <p>
 * @author cypher256
 */
public class PleiadesOption {
	
	/** Eclipse の -clean オプション */
	private boolean isClean;
	
	/** デフォルト・スプラッシュ画面表示オプション */
	private final boolean isDefaultSplash;
	
	/** ニーモニック表示オプション */
	private final boolean isNoMnemonic;
	
	/** ログ・レベル */
	private String logLevel;
	
	/**
	 * 起動オプションを構築します。
	 * <p>
	 * @param agentArg エージェント起動引数
	 */
	PleiadesOption(String agentArg) {
		
		String arg = (agentArg == null) ? "" : "," + agentArg.replace(" ", "") + ",";
		
		isDefaultSplash = arg.contains(",default.splash,");
		isNoMnemonic = arg.contains(",no.mnemonic,");
		
		// 辞書に訳が無い場合のログ出力をするか
		boolean isEnabledNotFoundLog = arg.contains(",enabled.not.found.log,");
		if (isEnabledNotFoundLog) {
			System.setProperty(TranslationNotFoundProperties.NOT_FOUND_PROPERTIES_ENABELD, "true");
		}
		
		// ログ・レベルの取得
		if (arg.contains("log.level=")) {
			logLevel = arg.replaceFirst("^.*?log\\.level=", "").replaceFirst(",.*$", "");
			try {
				Logger.Level.valueOf(logLevel.toUpperCase());
			} catch (IllegalArgumentException e) {
				throw new IllegalArgumentException(
					"起動オプション log.level の値 [" + logLevel + "] が不正です。" +
					StringUtils.join(Logger.Level.values(), ",") +
					" のいずれかである必要があります。");
			}
		} else {
			logLevel = Logger.Level.INFO.toString();
		}
	}
	
	/**
	 * Eclipse の -clean オプションをセットします。
	 * <p>
	 * @param isClean 起動時に -clean が指定されている場合は true
	 */
	public void setClean(boolean isClean) {
		this.isClean = isClean;
	}
	
	/**
	 * Eclipse の -clean オプションを取得します。
	 * <p>
	 * @return 起動時に -clean が指定されている場合は true
	 */
	public boolean isClean() {
		return isClean;
	}
	
	/**
	 * Eclipse のデフォルト・スプラッシュ画面を使用するか判定します。
	 * <p>
	 * @return 使用する場合は true
	 */
	public boolean isDefaultSplash() {
		return isDefaultSplash;
	}
	
	/**
	 * ニーモニックを表示しないか判定します。
	 * <p>
	 * @return 使用しない場合は true
	 */
	public boolean isNoMnemonic() {
		return isNoMnemonic;
	}
	
	/**
	 * ログ・レベルを取得します。
	 * <p>
	 * @return ログ・レベル
	 */
	public String getLogLevel() {
		return logLevel;
	}
}
