/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FastProperties;
import jp.sourceforge.mergedoc.pleiades.util.Files;

/**
 * 翻訳除外プロパティーです。
 * <p>
 * @author cypher256
 */
public class TranslationExcludeProperties {

	/** ロガー */
	private static final Logger log = Logger.getLogger(TranslationExcludeProperties.class);

	/** 翻訳除外プロパティー・ファイル名 */
	public static final String PROP_FILE_NAME = "translation-exclude.properties";

	/** このクラスのシングルトン・インスタンス */
	private static final TranslationExcludeProperties singleton = new TranslationExcludeProperties();

	/**
	 * 翻訳除外プロパティー・オブジェクトを取得します。
	 * <p>
	 * @return 翻訳除外プロパティー・オブジェクト
	 */
	public static TranslationExcludeProperties getInstance() {
		return singleton;
	}

	/** 翻訳除外マップ */
	private final Map<String, Set<String>> map = new HashMap<String, Set<String>>();

	/**
	 * 翻訳除外プロパティーを構築します。
	 */
	private TranslationExcludeProperties() {

		File file = Files.getResourceFile(PROP_FILE_NAME);
		if (!file.exists()) {
			String msg = "翻訳除外プロパティーが見つかりません。";
			Exception e = new FileNotFoundException(file.getPath());
			Exception ise = new IllegalStateException(msg, e);
			Pleiades.abort(ise);
		}

		FastProperties prop = new FastProperties(file);
		for (Entry<String, String> entry : prop.entrySet()) {
			map.put(
				(String) entry.getKey(),
				new HashSet<String>(Arrays.asList(entry.getValue().toString().split("\\s*,\\s*"))));
		}
		log.info("翻訳除外プロパティーをロードしました。" + map.size());
	}

	/**
	 * 指定した英語リソース文字列から翻訳除外パス・エントリーを取得します。
	 * <p>
	 * @param enValue 英語リソース文字列
	 * @return 翻訳除外パス・エントリー。存在しない場合は null。
	 */
	public Set<String> getPathEntries(String enValue) {

		Set<String> pathEntries = map.get(enValue);
		if (pathEntries != null && pathEntries.contains("")) {
			log.info(
					"[" + enValue + "] の翻訳呼び出しスタックトレース。",
					new IllegalStateException());
			return null;
		}
		return pathEntries;
	}
}
