/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import java.io.IOException;
import java.util.Map.Entry;

import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FastProperties;

/**
 * プロパティー・ファイル調査検索用のクラスです。
 * <p>
 * @author cypher256
 */
public class Walker {

	/** ロガー */
	private static final Logger log = Logger.getLogger(Walker.class);

	/** 辞書プロパティー・ファイル名 */
	private static final String IN_PROP = "props/_a.properties";

	/** 辞書プロパティー・ファイル名 */
	private static final String OUT_PROP = "props/_a_out.properties";
	
	/**
	 * 開始するための main メソッドです。
	 * <p>
	 * @param args 起動引数
	 * @throws IOException 入出力例外が発生した場合
	 */
	public static void main(String... args) throws IOException {
		new Walker().run();
	}

	/**
	 * 実行します。
	 * <p>
	 * @throws IOException 入出力例外が発生した場合
	 */
	private void run() throws IOException {
		
		FastProperties inProp = new FastProperties(IN_PROP);
		FastProperties outProp = new FastProperties();
		
		for (Entry<String, String> entry : inProp.entrySet()) {

			String e = entry.getKey();
			String j = entry.getValue();
			String eResult = entry.getKey();
			String jResult = entry.getValue();
			
			if (e.endsWith(":") && !j.endsWith(":")) {
				jResult = j + ":";
				log.info("英: " + e);
				log.info("日: " + jResult);
			}
			
			outProp.put(eResult, jResult);
		}
		
		outProp.store(OUT_PROP, "");
	}
}
