/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import org.apache.commons.io.IOUtils;

/**
 * ファイルに出力するロガーです。
 * <p>
 * @author cypher256
 */
public class FileLogger extends Logger {

	/** ログ・ファイル名を示すシステム・プロパティーのキー */
	public static final String LOG_FILE_NAME = "pleiades.log.file.name";

	/** ファイル PrintStream */
	private static PrintStream out;

	/** ファイル PrintStream の初期化 */
	static {

		String logFileName = System.getProperty(LOG_FILE_NAME);
		try {
			File logFile = new File(logFileName);
			logFile.getParentFile().mkdirs();
			logFile.delete();
			out = new PrintStream(
					new BufferedOutputStream(new FileOutputStream(logFile)),
					true);

		} catch (FileNotFoundException e) {

			throw new RuntimeException("プロパティに指定された " + LOG_FILE_NAME +
					"=" + logFileName + " が不正です。", e);
		}

		// VM シャットダウン・フックとしてファイル PrintStream のクローズを登録
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				IOUtils.closeQuietly(out);
			}
		});
	}

	/**
	 * ファイル・ロガーを構築します。
	 * <p>
	 * @param clazz クラス
	 */
	protected FileLogger(Class<?> clazz) {
		super(clazz);
	}

	/*
	 * (非 Javadoc)
	 * @see jp.sourceforge.mergedoc.pleiades.log.Logger#getOut()
	 */
	protected PrintStream getOut() {
		return out;
	}

	/*
	 * (非 Javadoc)
	 * @see jp.sourceforge.mergedoc.pleiades.log.Logger#error(java.lang.String, java.lang.Throwable)
	 */
	public void error(String message, Throwable e) {
		super.error(message, e);
		System.err.println(message);
		if (e != null) System.err.println(e);
	}

	/*
	 * (非 Javadoc)
	 * @see jp.sourceforge.mergedoc.pleiades.log.Logger#fatal(java.lang.String, java.lang.Throwable)
	 */
	public void fatal(String message, Throwable e) {
		super.fatal(message, e);
		System.err.println(message);
		if (e != null) System.err.println(e);
	}
}
