/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.log;

import javax.swing.JDialog;
import javax.swing.JOptionPane;

/**
 * ポップアップ付きのファイル・ロガーです。
 * <p>
 * @author cypher256
 */
public class PopupFileLogger extends FileLogger {

	/**
	 * ポップアップ付きファイル・ロガーを構築します。
	 * <p>
	 * @param clazz クラス
	 */
	protected PopupFileLogger(Class<?> clazz) {
		super(clazz);
	}

	/**
	 * 致命的エラー・ログを出力します。
	 * 通常のログ出力に加え、画面にポップアップ・メッセージ (Swing) を表示します。
	 * <p>
	 * @param message メッセージ
	 * @param e 例外
	 */
	@Override
	public void fatal(String message, Throwable e) {

		if (message == null) {
			message = "";
		}

		// ログ出力
		super.fatal(message, e);

		if (e != null) {
			message +=
				"\n原因：" + e + "\n\n" +
				"詳細は以下のログ・ファイルを参照してください。\n" +
				System.getProperty(FileLogger.LOG_FILE_NAME);
		}

		// ポップアップ・メッセージの表示
		JOptionPane pane = new JOptionPane(message, JOptionPane.ERROR_MESSAGE);
		JDialog dialog = pane.createDialog(null, "Pleiades でエラーが発生しました。");
		dialog.setAlwaysOnTop(true);
		dialog.setVisible(true);
		dialog.dispose();
	}
}
