/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * 非同期実行ユーティリティーです。
 * <p>
 * @author cypher256
 */
public class Asyncs {

	/** ロガー */
	private static final Logger log = Logger.getLogger(Asyncs.class);
	
	/** スレッド・プール */
	private static ExecutorService threadPool = Executors.newCachedThreadPool();
	
	/**
	 * 生成できません。
	 */
	private Asyncs() {
	}
	
	/**
	 * 非同期実行します。
	 * @param command コマンド
	 */
	public static void execute(Runnable command) {
		
		long start = System.nanoTime();
		
		if (threadPool == null) {
			String msg = "非同期実行はすでにシャットダウンされています。";
			log.fatal(msg);
			throw new IllegalStateException(msg);
		}
		try {
			threadPool.execute(command);
		} catch (RejectedExecutionException e) {
			log.warn("RejectedExecutionException が発生したため、同期実行します。");
			command.run();
		}
		Analyses.end(Asyncs.class, "execute", start);
	}
	
	/**
	 * 非同期実行をシャットダウンします。
	 * すでにシャットダウンされている場合は何も行いません。
	 */
	public static void shutdown() {
		// AOP 計測自動
		
		if (threadPool != null) {
			
			log.debug("非同期実行をシャットダウンします。");
			threadPool.shutdown();
			threadPool = null;
		}
	}
}
