/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator.nls;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.mergedoc.pleiades.generator.nls.HelpTocHandler;
import jp.sourceforge.mergedoc.pleiades.generator.nls.HtmlFragmentList;
import jp.sourceforge.mergedoc.pleiades.generator.nls.HtmlFragmentListUnit;
import jp.sourceforge.mergedoc.pleiades.generator.nls.Plugin;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.HelpHtmlParser;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import org.apache.commons.io.IOUtils;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpPlugin
extends Plugin {
    private static final Logger log = Logger.getLogger(HelpPlugin.class);
    private HtmlFragmentListUnit htmlListUnit;

    public HelpPlugin(File pluginFile) {
        super(pluginFile);
    }

    public HtmlFragmentListUnit getHtmlListUnit() {
        if (this.htmlListUnit == null) {
            this.htmlListUnit = new HtmlFragmentListUnit();
        }
        return this.htmlListUnit;
    }

    @Override
    protected void setupProperties(String path, Object in) {
        if (path.contains("/nl/") && !path.contains("/nl/ja/")) {
            return;
        }
        if (path.endsWith(".xml") && !path.matches(".*?/(plugin.xml|feature.xml|fragment.xml)")) {
            if (path.contains("/nl/ja/")) {
                this.processTocXml(this.getJaPropertySet(), in, path);
            } else {
                this.processTocXml(this.getEnPropertySet(), in, path);
            }
        } else if (!(!path.matches(".*?\\.(html|htm)") || path.matches(".+/javadoc/.+") || path.matches(".+/reference/api/.+") || path.matches(".+/reference/osgi/.+") || path.matches(".+/doc.zip/api/.+") || path.matches(".+\\.birt\\..+"))) {
            if (path.contains("/nl/ja/")) {
                this.processDocHtml(this.getHtmlListUnit().jaHtmlMap, in, path);
            } else {
                this.processDocHtml(this.getHtmlListUnit().enHtmlMap, in, path);
            }
        }
    }

    private void processTocXml(PropertySet resultProp, Object in, String path) {
        PropertySet tocProp;
        block6: {
            tocProp = new PropertySet();
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                HelpTocHandler handler = new HelpTocHandler(tocProp);
                if (in instanceof File) {
                    parser.parse((File)in, (DefaultHandler)handler);
                    break block6;
                }
                if (in instanceof InputStream) {
                    ByteArrayInputStream is = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)((InputStream)in)));
                    parser.parse((InputStream)is, (DefaultHandler)handler);
                    break block6;
                }
                throw new IllegalArgumentException("\u4e88\u671f\u3057\u306a\u3044\u578b\uff1a" + in.getClass().getName() + " " + path);
            }
            catch (Exception e) {
                String msg = "\u30d8\u30eb\u30d7 xml \u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + path + " " + e;
                log.warn(msg, new Object[0]);
            }
        }
        String keyPrefix = String.valueOf(this.getLocation(path)) + "@";
        for (Property p : tocProp) {
            String key = String.valueOf(keyPrefix) + p.key;
            if (resultProp.containsKey(key)) {
                throw new IllegalStateException("\u540c\u4e00\u30ad\u30fc:" + key);
            }
            resultProp.put(key, p.value);
        }
    }

    private void processDocHtml(Map<String, HtmlFragmentList> htmlMap, Object in, String path) {
        HtmlFragmentList list;
        String key;
        block14: {
            key = this.getLocation(path);
            if (htmlMap.containsKey(key)) {
                throw new IllegalStateException("\u540c\u4e00\u30ad\u30fc:" + key);
            }
            list = new HtmlFragmentList(path);
            htmlMap.put(key, list);
            InputStream is = null;
            try {
                try {
                    if (in instanceof InputStream) {
                        is = (InputStream)in;
                    } else if (in instanceof File) {
                        is = new FileInputStream((File)in);
                    } else {
                        throw new IllegalArgumentException("\u4e88\u671f\u3057\u306a\u3044\u578b\uff1a" + in.getClass().getName() + " " + path);
                    }
                    for (HelpHtmlParser.HtmlFragment f : new HelpHtmlParser(is)) {
                        list.add(f);
                    }
                }
                catch (Exception e) {
                    String msg = "\u30d8\u30eb\u30d7 html \u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + path + " " + e;
                    log.warn(msg, new Object[0]);
                    if (in instanceof File) {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (in instanceof File) {
                    IOUtils.closeQuietly((InputStream)is);
                }
                throw throwable;
            }
            if (in instanceof File) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        log.debug("%3d\u3001%-40s - %s", list.size(), key, path);
    }

    private String getLocation(String path) {
        return path.replaceFirst("^[^/]+", "").replace("/nl/ja/", "/").replaceFirst("^/doc(|\\.zip)/", "/");
    }
}

