/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.DefaultContent;
import org.eclipse.swt.custom.DefaultLineStyler;
import org.eclipse.swt.custom.DisplayRenderer;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.PrintRenderer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.custom.WrappedContent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class StyledText
extends Canvas {
    static final char TAB = '\t';
    static final String PlatformLineDelimiter = System.getProperty("line.separator");
    static final int BIDI_CARET_WIDTH = 3;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int ExtendedModify = 3000;
    static final int LineGetBackground = 3001;
    static final int LineGetStyle = 3002;
    static final int TextChanging = 3003;
    static final int TextSet = 3004;
    static final int VerifyKey = 3005;
    static final int TextChanged = 3006;
    static final int LineGetSegments = 3007;
    Color selectionBackground;
    Color selectionForeground;
    StyledTextContent logicalContent;
    StyledTextContent content;
    DisplayRenderer renderer;
    Listener listener;
    TextChangeListener textChangeListener;
    DefaultLineStyler defaultLineStyler;
    LineCache lineCache;
    boolean userLineStyle = false;
    boolean userLineBackground = false;
    int verticalScrollOffset = 0;
    int horizontalScrollOffset = 0;
    int topIndex = 0;
    int lastPaintTopIndex = -1;
    int topOffset = 0;
    int clientAreaHeight = 0;
    int clientAreaWidth = 0;
    int lineHeight;
    int tabLength = 4;
    int leftMargin;
    int topMargin;
    int rightMargin;
    int bottomMargin;
    Cursor ibeamCursor;
    int columnX;
    int caretOffset = 0;
    Point selection = new Point(0, 0);
    Point clipboardSelection;
    int selectionAnchor;
    Point doubleClickSelection;
    boolean editable = true;
    boolean wordWrap = false;
    boolean doubleClickEnabled = true;
    boolean overwrite = false;
    int textLimit = -1;
    Hashtable keyActionMap = new Hashtable();
    Color background = null;
    Color foreground = null;
    Clipboard clipboard;
    boolean mouseDown = false;
    boolean mouseDoubleClick = false;
    int autoScrollDirection = 0;
    int autoScrollDistance = 0;
    int lastTextChangeStart;
    int lastTextChangeNewLineCount;
    int lastTextChangeNewCharCount;
    int lastTextChangeReplaceLineCount;
    int lastTextChangeReplaceCharCount;
    boolean isMirrored;
    boolean bidiColoring = false;
    Image leftCaretBitmap = null;
    Image rightCaretBitmap = null;
    int caretDirection = 0;
    boolean advancing = true;
    Caret defaultCaret = null;
    boolean updateCaretDirection = true;
    static final boolean IS_CARBON;
    static final boolean IS_GTK;
    static final boolean IS_MOTIF;
    static final boolean DOUBLE_BUFFER;
    private static Set styledTexts;

    static {
        String platform = SWT.getPlatform();
        IS_CARBON = "carbon".equals(platform);
        IS_GTK = "gtk".equals(platform);
        IS_MOTIF = "motif".equals(platform);
        DOUBLE_BUFFER = !IS_CARBON;
        styledTexts = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledText(Composite parent, int style) {
        super(parent, StyledText.checkStyle(style | 0x100000 | 0x40000));
        super.setForeground(this.getForeground());
        super.setBackground(this.getBackground());
        Display display = this.getDisplay();
        boolean bl = this.isMirrored = (super.getStyle() & 0x8000000) != 0;
        if ((style & 8) != 0) {
            this.setEditable(false);
        }
        this.rightMargin = this.isBidiCaret() ? 2 : 0;
        this.leftMargin = this.rightMargin;
        if ((style & 4) != 0 && (style & 0x800) != 0) {
            this.bottomMargin = 2;
            this.rightMargin = 2;
            this.topMargin = 2;
            this.leftMargin = 2;
        }
        this.clipboard = new Clipboard(display);
        this.installDefaultContent();
        this.initializeRenderer();
        if ((style & 0x40) != 0) {
            this.setWordWrap(true);
        } else {
            this.lineCache = new ContentWidthCache(this, this.content);
        }
        this.defaultCaret = new Caret((Canvas)this, 0);
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
            Runnable runnable = new Runnable(){

                public void run() {
                    int direction;
                    int n = direction = BidiUtil.getKeyboardLanguage() == 1 ? 131072 : 16384;
                    if (direction == StyledText.this.caretDirection) {
                        return;
                    }
                    if (StyledText.this.getCaret() != StyledText.this.defaultCaret) {
                        return;
                    }
                    int lineIndex = StyledText.this.getCaretLine();
                    String line = StyledText.this.content.getLine(lineIndex);
                    int lineOffset = StyledText.this.content.getOffsetAtLine(lineIndex);
                    int offsetInLine = StyledText.this.caretOffset - lineOffset;
                    int newCaretX = StyledText.this.getXAtOffset(line, lineIndex, offsetInLine);
                    StyledText.this.setCaretLocation(newCaretX, StyledText.this.getCaretLine(), direction);
                }
            };
            BidiUtil.addLanguageListener((int)this.handle, (Runnable)runnable);
        }
        this.setCaret(this.defaultCaret);
        this.calculateScrollBars();
        this.createKeyBindings();
        this.ibeamCursor = new Cursor((Device)display, 19);
        this.setCursor(this.ibeamCursor);
        this.installListeners();
        this.installDefaultLineStyler();
        this.initializeAccessible();
        Set set = styledTexts;
        synchronized (set) {
            HashSet<StyledText> newStyledTexts = new HashSet<StyledText>();
            Iterator it = styledTexts.iterator();
            while (it.hasNext()) {
                StyledText styledText = (StyledText)((Object)it.next());
                if (styledText.isDisposed()) continue;
                newStyledTexts.add(styledText);
            }
            styledTexts = newStyledTexts;
            styledTexts.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redrawJStyle() {
        Set set = styledTexts;
        synchronized (set) {
            Iterator it = styledTexts.iterator();
            while (it.hasNext()) {
                StyledText styledText = (StyledText)((Object)it.next());
                if (styledText.isDisposed()) continue;
                styledText.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        StyledText.this.redraw();
                    }
                });
            }
        }
    }

    public void addExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error((int)4);
        }
        StyledTextListener typedListener = new StyledTextListener((SWTEventListener)extendedModifyListener);
        this.addListener(3000, (Listener)typedListener);
    }

    public void setKeyBinding(int key, int action) {
        this.checkWidget();
        int keyValue = key & 0x100FFFF;
        int modifierValue = key & SWT.MODIFIER_MASK;
        char keyChar = (char)keyValue;
        if (Compatibility.isLetter((char)keyChar)) {
            char ch = Character.toUpperCase(keyChar);
            int newKey = ch | modifierValue;
            if (action == 0) {
                this.keyActionMap.remove(new Integer(newKey));
            } else {
                this.keyActionMap.put(new Integer(newKey), new Integer(action));
            }
            ch = Character.toLowerCase(keyChar);
            newKey = ch | modifierValue;
            if (action == 0) {
                this.keyActionMap.remove(new Integer(newKey));
            } else {
                this.keyActionMap.put(new Integer(newKey), new Integer(action));
            }
        } else if (action == 0) {
            this.keyActionMap.remove(new Integer(key));
        } else {
            this.keyActionMap.put(new Integer(key), new Integer(action));
        }
    }

    public void addBidiSegmentListener(BidiSegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        StyledTextListener typedListener = new StyledTextListener((SWTEventListener)listener);
        this.addListener(3007, (Listener)typedListener);
    }

    public void addLineBackgroundListener(LineBackgroundListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (!this.userLineBackground) {
            this.removeLineBackgroundListener((LineBackgroundListener)this.defaultLineStyler);
            this.defaultLineStyler.setLineBackground(0, this.logicalContent.getLineCount(), null);
            this.userLineBackground = true;
        }
        StyledTextListener typedListener = new StyledTextListener((SWTEventListener)listener);
        this.addListener(3001, (Listener)typedListener);
    }

    public void addLineStyleListener(LineStyleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (!this.userLineStyle) {
            this.removeLineStyleListener((LineStyleListener)this.defaultLineStyler);
            this.defaultLineStyler.setStyleRange(null);
            this.userLineStyle = true;
        }
        StyledTextListener typedListener = new StyledTextListener((SWTEventListener)listener);
        this.addListener(3002, (Listener)typedListener);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)modifyListener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
    }

    public void addVerifyKeyListener(VerifyKeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        StyledTextListener typedListener = new StyledTextListener((SWTEventListener)listener);
        this.addListener(3005, (Listener)typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)verifyListener);
        this.addListener(25, (Listener)typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int lastChar = Math.max(this.getCharCount(), 0);
        this.replaceTextRange(lastChar, 0, string);
    }

    void calculateContentWidth() {
        this.lineCache = this.getLineCache(this.content);
        this.lineCache.calculate(this.topIndex, this.getPartialBottomIndex() - this.topIndex + 1);
    }

    void calculateScrollBars() {
        ScrollBar horizontalBar = this.getHorizontalBar();
        ScrollBar verticalBar = this.getVerticalBar();
        this.setScrollBars();
        if (verticalBar != null) {
            verticalBar.setIncrement(this.getVerticalIncrement());
        }
        if (horizontalBar != null) {
            horizontalBar.setIncrement(this.getHorizontalIncrement());
        }
    }

    void calculateTopIndex() {
        int oldTopIndex = this.topIndex;
        int verticalIncrement = this.getVerticalIncrement();
        int clientAreaHeight = this.getClientArea().height;
        if (verticalIncrement == 0) {
            return;
        }
        this.topIndex = Compatibility.ceil((int)this.verticalScrollOffset, (int)verticalIncrement);
        if (this.topIndex > 0) {
            if (clientAreaHeight > 0) {
                int bottomPixel = this.verticalScrollOffset + clientAreaHeight;
                int fullLineTopPixel = this.topIndex * verticalIncrement;
                int fullLineVisibleHeight = bottomPixel - fullLineTopPixel;
                if (fullLineVisibleHeight < verticalIncrement) {
                    --this.topIndex;
                }
            } else if (this.topIndex >= this.content.getLineCount()) {
                this.topIndex = this.content.getLineCount() - 1;
            }
        }
        if (this.topIndex != oldTopIndex) {
            this.topOffset = this.content.getOffsetAtLine(this.topIndex);
            this.lineCache.calculate(this.topIndex, this.getPartialBottomIndex() - this.topIndex + 1);
            this.setHorizontalScrollBar();
        }
    }

    static int checkStyle(int style) {
        if ((style & 4) != 0) {
            style &= 0xFFFFFCBD;
        } else if (((style |= 2) & 0x40) != 0) {
            style &= 0xFFFFFEFF;
        }
        return style;
    }

    void claimBottomFreeSpace() {
        int newVerticalOffset = Math.max(0, this.content.getLineCount() * this.lineHeight - this.getClientArea().height);
        if (newVerticalOffset < this.verticalScrollOffset) {
            this.setVerticalScrollOffset(newVerticalOffset, true);
        }
    }

    void claimRightFreeSpace() {
        int newHorizontalOffset = Math.max(0, this.lineCache.getWidth() - (this.getClientArea().width - this.leftMargin - this.rightMargin));
        if (newHorizontalOffset < this.horizontalScrollOffset) {
            this.scrollHorizontalBar(newHorizontalOffset - this.horizontalScrollOffset);
        }
    }

    void clearMargin(GC gc, Color background, Rectangle clientArea, int y) {
        gc.setBackground(background);
        if (this.topMargin > 0) {
            gc.fillRectangle(0, -y, clientArea.width, this.topMargin);
        }
        if (this.bottomMargin > 0) {
            gc.fillRectangle(0, clientArea.height - this.bottomMargin - y, clientArea.width, this.bottomMargin);
        }
        if (this.leftMargin > 0) {
            gc.fillRectangle(0, -y, this.leftMargin, clientArea.height);
        }
        if (this.rightMargin > 0) {
            gc.fillRectangle(clientArea.width - this.rightMargin, -y, this.rightMargin, clientArea.height);
        }
    }

    void clearSelection(boolean sendEvent) {
        int selectionStart = this.selection.x;
        int selectionEnd = this.selection.y;
        int length = this.content.getCharCount();
        this.resetSelection();
        if (selectionEnd - selectionStart > 0) {
            int redrawStart = Math.min(selectionStart, length);
            int redrawEnd = Math.min(selectionEnd, length);
            if (redrawEnd - redrawStart > 0) {
                this.internalRedrawRange(redrawStart, redrawEnd - redrawStart, true);
            }
            if (sendEvent) {
                this.sendSelectionEvent();
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        boolean singleLine = (this.getStyle() & 4) != 0;
        int count = singleLine ? 1 : this.content.getLineCount();
        int width = wHint != -1 ? wHint : 64;
        if (wHint == -1) {
            LineCache computeLineCache = this.lineCache;
            if (this.wordWrap) {
                computeLineCache = new ContentWidthCache(this, this.logicalContent);
                if (!singleLine) {
                    count = this.logicalContent.getLineCount();
                }
            }
            int visibleCount = Math.min(count, this.getDisplay().getBounds().height / this.lineHeight);
            computeLineCache.calculate(0, visibleCount);
            width = computeLineCache.getWidth() + this.leftMargin + this.rightMargin;
        } else if (this.wordWrap && !singleLine) {
            WrappedContent wrappedContent = new WrappedContent((StyledTextRenderer)this.renderer, this.logicalContent);
            wrappedContent.wrapLines(width);
            count = wrappedContent.getLineCount();
        }
        int height = hHint != -1 ? hHint : count * this.lineHeight + this.topMargin + this.bottomMargin;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = singleLine ? this.lineHeight : 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new Point(rect.width, rect.height);
    }

    public void copy() {
        this.checkWidget();
        this.copy(1);
    }

    public void copy(int clipboardType) {
        block4: {
            this.checkWidget();
            if (clipboardType != 1 && clipboardType != 2) {
                return;
            }
            int length = this.selection.y - this.selection.x;
            if (length > 0) {
                try {
                    this.setClipboardContent(this.selection.x, length, clipboardType);
                }
                catch (SWTError error) {
                    if (error.code == 2002) break block4;
                    throw error;
                }
            }
        }
    }

    String getModelDelimitedText(String text) {
        String delimiter = this.getLineDelimiter();
        int length = text.length();
        int crIndex = 0;
        int lfIndex = 0;
        int i = 0;
        if (length == 0) {
            return text;
        }
        StringBuffer convertedText = new StringBuffer(length);
        while (i < length) {
            if (crIndex != -1) {
                crIndex = text.indexOf(13, i);
            }
            if (lfIndex != -1) {
                lfIndex = text.indexOf(10, i);
            }
            if (lfIndex == -1 && crIndex == -1) break;
            if (crIndex < lfIndex && crIndex != -1 || lfIndex == -1) {
                convertedText.append(text.substring(i, crIndex));
                i = lfIndex == crIndex + 1 ? lfIndex + 1 : crIndex + 1;
            } else {
                convertedText.append(text.substring(i, lfIndex));
                i = lfIndex + 1;
            }
            if (this.isSingleLine()) break;
            convertedText.append(delimiter);
        }
        if (!(i >= length || this.isSingleLine() && convertedText.length() != 0)) {
            convertedText.append(text.substring(i));
        }
        return convertedText.toString();
    }

    void createKeyBindings() {
        this.setKeyBinding(0x1000001, 0x1000001);
        this.setKeyBinding(0x1000002, 0x1000002);
        this.setKeyBinding(0x1000007, 0x1000007);
        this.setKeyBinding(0x1000008, 0x1000008);
        this.setKeyBinding(0x1000005, 0x1000005);
        this.setKeyBinding(0x1000006, 0x1000006);
        this.setKeyBinding(0x1000007 | SWT.MOD1, 17039367);
        this.setKeyBinding(0x1000008 | SWT.MOD1, 17039368);
        this.setKeyBinding(0x1000005 | SWT.MOD1, 17039365);
        this.setKeyBinding(0x1000006 | SWT.MOD1, 17039366);
        if (this.isMirrored()) {
            this.setKeyBinding(0x1000003, 0x1000004);
            this.setKeyBinding(0x1000004, 0x1000003);
            this.setKeyBinding(0x1000003 | SWT.MOD1, 0x1040004);
            this.setKeyBinding(0x1000004 | SWT.MOD1, 17039363);
        } else {
            this.setKeyBinding(0x1000003, 0x1000003);
            this.setKeyBinding(0x1000004, 0x1000004);
            this.setKeyBinding(0x1000003 | SWT.MOD1, 17039363);
            this.setKeyBinding(0x1000004 | SWT.MOD1, 0x1040004);
        }
        this.setKeyBinding(0x1000001 | SWT.MOD2, 0x1020001);
        this.setKeyBinding(0x1000002 | SWT.MOD2, 0x1020002);
        this.setKeyBinding(0x1000007 | SWT.MOD2, 16908295);
        this.setKeyBinding(0x1000008 | SWT.MOD2, 16908296);
        this.setKeyBinding(0x1000005 | SWT.MOD2, 16908293);
        this.setKeyBinding(0x1000006 | SWT.MOD2, 16908294);
        this.setKeyBinding(0x1000007 | SWT.MOD1 | SWT.MOD2, 17170439);
        this.setKeyBinding(0x1000008 | SWT.MOD1 | SWT.MOD2, 17170440);
        this.setKeyBinding(0x1000005 | SWT.MOD1 | SWT.MOD2, 17170437);
        this.setKeyBinding(0x1000006 | SWT.MOD1 | SWT.MOD2, 0x1060006);
        if (this.isMirrored()) {
            this.setKeyBinding(0x1000003 | SWT.MOD2, 16908292);
            this.setKeyBinding(0x1000004 | SWT.MOD2, 16908291);
            this.setKeyBinding(0x1000003 | SWT.MOD1 | SWT.MOD2, 17170436);
            this.setKeyBinding(0x1000004 | SWT.MOD1 | SWT.MOD2, 17170435);
        } else {
            this.setKeyBinding(0x1000003 | SWT.MOD2, 16908291);
            this.setKeyBinding(0x1000004 | SWT.MOD2, 16908292);
            this.setKeyBinding(0x1000003 | SWT.MOD1 | SWT.MOD2, 17170435);
            this.setKeyBinding(0x1000004 | SWT.MOD1 | SWT.MOD2, 17170436);
        }
        this.setKeyBinding(0x58 | SWT.MOD1, 131199);
        this.setKeyBinding(0x43 | SWT.MOD1, 17039369);
        this.setKeyBinding(0x56 | SWT.MOD1, 16908297);
        this.setKeyBinding(0x7F | SWT.MOD2, 131199);
        this.setKeyBinding(0x1000009 | SWT.MOD1, 17039369);
        this.setKeyBinding(0x1000009 | SWT.MOD2, 16908297);
        this.setKeyBinding(8 | SWT.MOD2, 8);
        this.setKeyBinding(8, 8);
        this.setKeyBinding(127, 127);
        this.setKeyBinding(8 | SWT.MOD1, 262152);
        this.setKeyBinding(0x7F | SWT.MOD1, 262271);
        this.setKeyBinding(0x1000009, 0x1000009);
    }

    void createCaretBitmaps() {
        int caretWidth = 3;
        Display display = this.getDisplay();
        if (this.leftCaretBitmap != null) {
            if (this.defaultCaret != null && this.leftCaretBitmap.equals((Object)this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.leftCaretBitmap.dispose();
        }
        this.leftCaretBitmap = new Image((Device)display, caretWidth, this.lineHeight);
        GC gc = new GC((Drawable)this.leftCaretBitmap);
        gc.setBackground(display.getSystemColor(2));
        gc.fillRectangle(0, 0, caretWidth, this.lineHeight);
        gc.setForeground(display.getSystemColor(1));
        gc.drawLine(0, 0, 0, this.lineHeight);
        gc.drawLine(0, 0, caretWidth - 1, 0);
        gc.drawLine(0, 1, 1, 1);
        gc.dispose();
        if (this.rightCaretBitmap != null) {
            if (this.defaultCaret != null && this.rightCaretBitmap.equals((Object)this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.rightCaretBitmap.dispose();
        }
        this.rightCaretBitmap = new Image((Device)display, caretWidth, this.lineHeight);
        gc = new GC((Drawable)this.rightCaretBitmap);
        gc.setBackground(display.getSystemColor(2));
        gc.fillRectangle(0, 0, caretWidth, this.lineHeight);
        gc.setForeground(display.getSystemColor(1));
        gc.drawLine(caretWidth - 1, 0, caretWidth - 1, this.lineHeight);
        gc.drawLine(0, 0, caretWidth - 1, 0);
        gc.drawLine(caretWidth - 1, 1, 1, 1);
        gc.dispose();
    }

    public void cut() {
        this.checkWidget();
        int length = this.selection.y - this.selection.x;
        if (length > 0) {
            try {
                this.setClipboardContent(this.selection.x, length, 1);
            }
            catch (SWTError error) {
                if (error.code != 2002) {
                    throw error;
                }
                return;
            }
            this.doDelete();
        }
    }

    void doAutoScroll(Event event) {
        Rectangle area = this.getClientArea();
        if (event.y > area.height) {
            this.doAutoScroll(1024, event.y - area.height);
        } else if (event.y < 0) {
            this.doAutoScroll(128, -event.y);
        } else if (event.x < this.leftMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000003, this.leftMargin - event.x);
        } else if (event.x > area.width - this.leftMargin - this.rightMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000004, event.x - (area.width - this.leftMargin - this.rightMargin));
        } else {
            this.endAutoScroll();
        }
    }

    void doAutoScroll(int direction, int distance) {
        Runnable timer = null;
        int TIMER_INTERVAL = 50;
        this.autoScrollDistance = distance;
        if (this.autoScrollDirection == direction) {
            return;
        }
        final Display display = this.getDisplay();
        if (direction == 128) {
            timer = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 128) {
                        int lines = StyledText.this.autoScrollDistance / StyledText.this.getLineHeight() + 1;
                        StyledText.this.doSelectionPageUp(lines);
                        display.timerExec(50, (Runnable)this);
                    }
                }
            };
        } else if (direction == 1024) {
            timer = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 1024) {
                        int lines = StyledText.this.autoScrollDistance / StyledText.this.getLineHeight() + 1;
                        StyledText.this.doSelectionPageDown(lines);
                        display.timerExec(50, (Runnable)this);
                    }
                }
            };
        } else if (direction == 0x1000004) {
            timer = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000004) {
                        StyledText.this.doVisualNext();
                        StyledText.this.setMouseWordSelectionAnchor();
                        StyledText.this.doMouseSelection();
                        display.timerExec(50, (Runnable)this);
                    }
                }
            };
        } else if (direction == 0x1000003) {
            timer = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000003) {
                        StyledText.this.doVisualPrevious();
                        StyledText.this.setMouseWordSelectionAnchor();
                        StyledText.this.doMouseSelection();
                        display.timerExec(50, (Runnable)this);
                    }
                }
            };
        }
        if (timer != null) {
            this.autoScrollDirection = direction;
            display.timerExec(50, timer);
        }
    }

    void doBackspace() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset > 0) {
            int line = this.content.getLineAtOffset(this.caretOffset);
            int lineOffset = this.content.getOffsetAtLine(line);
            if (this.caretOffset == lineOffset) {
                lineOffset = this.content.getOffsetAtLine(line - 1);
                event.start = lineOffset + this.content.getLine(line - 1).length();
                event.end = this.caretOffset;
            } else {
                String lineText = this.content.getLine(line);
                TextLayout layout = this.renderer.getTextLayout(lineText, lineOffset);
                int start = layout.getPreviousOffset(this.caretOffset - lineOffset, 1);
                this.renderer.disposeTextLayout(layout);
                event.start = start + lineOffset;
                event.end = this.caretOffset;
            }
            this.sendKeyEvent(event);
        }
    }

    void doContent(char key) {
        if (this.textLimit > 0 && this.content.getCharCount() - (this.selection.y - this.selection.x) >= this.textLimit) {
            return;
        }
        Event event = new Event();
        event.start = this.selection.x;
        event.end = this.selection.y;
        if (key == '\r' || key == '\n') {
            if (!this.isSingleLine()) {
                event.text = this.getLineDelimiter();
            }
        } else if (this.selection.x == this.selection.y && this.overwrite && key != '\t') {
            String line;
            int lineIndex = this.content.getLineAtOffset(event.end);
            int lineOffset = this.content.getOffsetAtLine(lineIndex);
            if (event.end < lineOffset + (line = this.content.getLine(lineIndex)).length()) {
                ++event.end;
            }
            event.text = new String(new char[]{key});
        } else {
            event.text = new String(new char[]{key});
        }
        if (event.text != null) {
            this.sendKeyEvent(event);
        }
    }

    void doContentEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int length = this.content.getCharCount();
            if (this.caretOffset < length) {
                this.caretOffset = length;
                this.showCaret();
            }
        }
    }

    void doContentStart() {
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.showCaret();
        }
    }

    void doCursorPrevious() {
        this.advancing = false;
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            int caretLine = this.getCaretLine();
            this.showCaret(caretLine);
        } else {
            this.doSelectionCursorPrevious();
        }
    }

    void doCursorNext() {
        this.advancing = true;
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            int caretLine = this.getCaretLine();
            this.showCaret(caretLine);
        } else {
            this.doSelectionCursorNext();
        }
    }

    void doDelete() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset < this.content.getCharCount()) {
            int lineLength;
            int line = this.content.getLineAtOffset(this.caretOffset);
            int lineOffset = this.content.getOffsetAtLine(line);
            if (this.caretOffset == lineOffset + (lineLength = this.content.getLine(line).length())) {
                event.start = this.caretOffset;
                event.end = this.content.getOffsetAtLine(line + 1);
            } else {
                event.start = this.caretOffset;
                event.end = this.getClusterNext(this.caretOffset, line);
            }
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordNext() {
        if (this.selection.x != this.selection.y) {
            this.doDelete();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.caretOffset;
            event.end = this.getWordEnd(this.caretOffset);
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordPrevious() {
        if (this.selection.x != this.selection.y) {
            this.doBackspace();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.getWordStart(this.caretOffset);
            event.end = this.caretOffset;
            this.sendKeyEvent(event);
        }
    }

    int doLineDown() {
        if (this.isSingleLine()) {
            return 0;
        }
        int caretLine = this.getCaretLine();
        if (caretLine < this.content.getLineCount() - 1) {
            this.caretOffset = this.getOffsetAtMouseLocation(this.columnX, ++caretLine);
        }
        return caretLine;
    }

    void doLineEnd() {
        int lineLength;
        int caretLine = this.getCaretLine();
        int lineOffset = this.content.getOffsetAtLine(caretLine);
        int lineEndOffset = lineOffset + (lineLength = this.content.getLine(caretLine).length());
        if (this.caretOffset < lineEndOffset) {
            this.caretOffset = lineEndOffset;
            this.showCaret();
        }
    }

    void doLineStart() {
        int caretLine = this.getCaretLine();
        int lineOffset = this.content.getOffsetAtLine(caretLine);
        if (this.caretOffset > lineOffset) {
            this.caretOffset = lineOffset;
            this.showCaret(caretLine);
        }
    }

    int doLineUp() {
        int caretLine = this.getCaretLine();
        if (caretLine > 0) {
            this.caretOffset = this.getOffsetAtMouseLocation(this.columnX, --caretLine);
        }
        return caretLine;
    }

    void doMouseLocationChange(int x, int y, boolean select) {
        int line = (y + this.verticalScrollOffset) / this.lineHeight;
        int lineCount = this.content.getLineCount();
        boolean oldAdvancing = this.advancing;
        this.updateCaretDirection = true;
        if (line > lineCount - 1) {
            line = lineCount - 1;
        }
        if (line < 0 || this.isSingleLine() && line > 0) {
            return;
        }
        int newCaretOffset = this.getOffsetAtMouseLocation(x, line);
        if (this.mouseDoubleClick) {
            newCaretOffset = this.doMouseWordSelect(x, newCaretOffset, line);
        }
        int newCaretLine = this.content.getLineAtOffset(newCaretOffset);
        if (y >= 0 && y < this.getClientArea().height && (x >= 0 && x < this.getClientArea().width || this.wordWrap || newCaretLine != this.content.getLineAtOffset(this.caretOffset)) && (newCaretOffset != this.caretOffset || this.advancing != oldAdvancing)) {
            this.caretOffset = newCaretOffset;
            if (select) {
                this.doMouseSelection();
            }
            this.showCaret();
        }
        if (!select) {
            this.caretOffset = newCaretOffset;
            this.clearSelection(true);
        }
    }

    void doMouseSelection() {
        if (this.caretOffset <= this.selection.x || this.caretOffset > this.selection.x && this.caretOffset < this.selection.y && this.selectionAnchor == this.selection.x) {
            this.doSelection(0x1000003);
        } else {
            this.doSelection(0x1000004);
        }
    }

    int doMouseWordSelect(int x, int newCaretOffset, int line) {
        int wordOffset;
        if (newCaretOffset < this.selectionAnchor && this.selectionAnchor == this.selection.x) {
            this.selectionAnchor = this.doubleClickSelection.y;
        } else if (newCaretOffset > this.selectionAnchor && this.selectionAnchor == this.selection.y) {
            this.selectionAnchor = this.doubleClickSelection.x;
        }
        if (x >= 0 && x < this.getClientArea().width && this.content.getLineAtOffset(wordOffset = this.caretOffset == this.selection.x ? this.getWordStart(newCaretOffset) : this.getWordEndNoSpaces(newCaretOffset)) == line) {
            newCaretOffset = wordOffset;
        }
        return newCaretOffset;
    }

    void doPageDown(boolean select, int lines) {
        int lineCount = this.content.getLineCount();
        int oldColumnX = this.columnX;
        int oldHScrollOffset = this.horizontalScrollOffset;
        if (this.isSingleLine()) {
            return;
        }
        int caretLine = this.getCaretLine();
        if (caretLine < lineCount - 1) {
            int scrollOffset;
            int verticalMaximum = lineCount * this.getVerticalIncrement();
            int pageSize = this.getClientArea().height;
            int scrollLines = Math.min(lineCount - caretLine - 1, lines);
            scrollLines = Math.max(1, scrollLines);
            this.caretOffset = this.getOffsetAtMouseLocation(this.columnX, caretLine += scrollLines);
            if (select) {
                this.doSelection(0x1000004);
            }
            if ((scrollOffset = this.verticalScrollOffset + scrollLines * this.getVerticalIncrement()) + pageSize > verticalMaximum) {
                scrollOffset = verticalMaximum - pageSize;
            }
            if (scrollOffset > this.verticalScrollOffset) {
                this.setVerticalScrollOffset(scrollOffset, true);
            }
        }
        this.showCaret(caretLine);
        int hScrollChange = oldHScrollOffset - this.horizontalScrollOffset;
        this.columnX = oldColumnX + hScrollChange;
    }

    void doPageEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int line = this.getBottomIndex();
            int bottomCaretOffset = this.content.getOffsetAtLine(line) + this.content.getLine(line).length();
            if (this.caretOffset < bottomCaretOffset) {
                this.caretOffset = bottomCaretOffset;
                this.showCaret();
            }
        }
    }

    void doPageStart() {
        int topCaretOffset = this.content.getOffsetAtLine(this.topIndex);
        if (this.caretOffset > topCaretOffset) {
            this.caretOffset = topCaretOffset;
            this.showCaret(this.topIndex);
        }
    }

    void doPageUp(boolean select, int lines) {
        int oldColumnX = this.columnX;
        int oldHScrollOffset = this.horizontalScrollOffset;
        int caretLine = this.getCaretLine();
        if (caretLine > 0) {
            int scrollOffset;
            int scrollLines = Math.max(1, Math.min(caretLine, lines));
            this.caretOffset = this.getOffsetAtMouseLocation(this.columnX, caretLine -= scrollLines);
            if (select) {
                this.doSelection(0x1000003);
            }
            if ((scrollOffset = Math.max(0, this.verticalScrollOffset - scrollLines * this.getVerticalIncrement())) < this.verticalScrollOffset) {
                this.setVerticalScrollOffset(scrollOffset, true);
            }
        }
        this.showCaret(caretLine);
        int hScrollChange = oldHScrollOffset - this.horizontalScrollOffset;
        this.columnX = oldColumnX + hScrollChange;
    }

    void doSelection(int direction) {
        int redrawStart = -1;
        int redrawEnd = -1;
        if (this.selectionAnchor == -1) {
            this.selectionAnchor = this.selection.x;
        }
        if (direction == 0x1000003) {
            if (this.caretOffset < this.selection.x) {
                redrawEnd = this.selection.x;
                redrawStart = this.selection.x = this.caretOffset;
                if (this.selection.y != this.selectionAnchor) {
                    redrawEnd = this.selection.y;
                    this.selection.y = this.selectionAnchor;
                }
            } else if (this.selectionAnchor == this.selection.x && this.caretOffset < this.selection.y) {
                redrawEnd = this.selection.y;
                redrawStart = this.selection.y = this.caretOffset;
            }
        } else if (this.caretOffset > this.selection.y) {
            redrawStart = this.selection.y;
            redrawEnd = this.selection.y = this.caretOffset;
            if (this.selection.x != this.selectionAnchor) {
                redrawStart = this.selection.x;
                this.selection.x = this.selectionAnchor;
            }
        } else if (this.selectionAnchor == this.selection.y && this.caretOffset > this.selection.x) {
            redrawStart = this.selection.x;
            redrawEnd = this.selection.x = this.caretOffset;
        }
        if (redrawStart != -1 && redrawEnd != -1) {
            this.internalRedrawRange(redrawStart, redrawEnd - redrawStart, true);
            this.sendSelectionEvent();
        }
    }

    void doSelectionCursorNext() {
        int caretLine = this.getCaretLine();
        int lineOffset = this.content.getOffsetAtLine(caretLine);
        int offsetInLine = this.caretOffset - lineOffset;
        this.advancing = true;
        if (offsetInLine < this.content.getLine(caretLine).length()) {
            this.caretOffset = this.getClusterNext(this.caretOffset, caretLine);
            this.showCaret();
        } else if (caretLine < this.content.getLineCount() - 1 && !this.isSingleLine()) {
            this.caretOffset = this.content.getOffsetAtLine(++caretLine);
            this.showCaret(caretLine);
        }
    }

    void doSelectionCursorPrevious() {
        int caretLine = this.getCaretLine();
        int lineOffset = this.content.getOffsetAtLine(caretLine);
        int offsetInLine = this.caretOffset - lineOffset;
        this.advancing = false;
        if (offsetInLine > 0) {
            this.caretOffset = this.getClusterPrevious(this.caretOffset, caretLine);
            this.showCaret(caretLine);
        } else if (caretLine > 0) {
            lineOffset = this.content.getOffsetAtLine(--caretLine);
            this.caretOffset = lineOffset + this.content.getLine(caretLine).length();
            this.showCaret();
        }
    }

    void doSelectionLineDown() {
        if (this.isSingleLine()) {
            return;
        }
        int caretLine = this.getCaretLine();
        int lineStartOffset = this.content.getOffsetAtLine(caretLine);
        int oldColumnX = this.columnX = this.getXAtOffset(this.content.getLine(caretLine), caretLine, this.caretOffset - lineStartOffset);
        if (caretLine == this.content.getLineCount() - 1) {
            this.caretOffset = this.content.getCharCount();
        } else {
            caretLine = this.doLineDown();
        }
        this.setMouseWordSelectionAnchor();
        this.doSelection(0x1000004);
        this.showCaret(caretLine);
        this.columnX = oldColumnX;
    }

    void doSelectionLineUp() {
        int caretLine = this.getCaretLine();
        int lineStartOffset = this.content.getOffsetAtLine(caretLine);
        int oldColumnX = this.columnX = this.getXAtOffset(this.content.getLine(caretLine), caretLine, this.caretOffset - lineStartOffset);
        if (caretLine == 0) {
            this.caretOffset = 0;
        } else {
            caretLine = this.doLineUp();
        }
        this.setMouseWordSelectionAnchor();
        this.showCaret(caretLine);
        this.doSelection(0x1000003);
        this.columnX = oldColumnX;
    }

    void doSelectionPageDown(int lines) {
        int caretLine = this.getCaretLine();
        int lineStartOffset = this.content.getOffsetAtLine(caretLine);
        int oldColumnX = this.columnX = this.getXAtOffset(this.content.getLine(caretLine), caretLine, this.caretOffset - lineStartOffset);
        this.doPageDown(true, lines);
        this.columnX = oldColumnX;
    }

    void doSelectionPageUp(int lines) {
        int caretLine = this.getCaretLine();
        int lineStartOffset = this.content.getOffsetAtLine(caretLine);
        int oldColumnX = this.columnX = this.getXAtOffset(this.content.getLine(caretLine), caretLine, this.caretOffset - lineStartOffset);
        this.doPageUp(true, lines);
        this.columnX = oldColumnX;
    }

    void doSelectionWordNext() {
        int newCaretOffset = this.getWordEnd(this.caretOffset);
        this.advancing = false;
        if (!this.isSingleLine() || this.content.getLineAtOffset(this.caretOffset) == this.content.getLineAtOffset(newCaretOffset)) {
            this.caretOffset = newCaretOffset;
            this.showCaret();
        }
    }

    void doSelectionWordPrevious() {
        this.advancing = false;
        this.caretOffset = this.getWordStart(this.caretOffset);
        int caretLine = this.content.getLineAtOffset(this.caretOffset);
        if (this.wordWrap && caretLine < this.content.getLineCount() - 1 && this.caretOffset == this.content.getOffsetAtLine(caretLine + 1)) {
            ++caretLine;
        }
        this.showCaret(caretLine);
    }

    void doVisualPrevious() {
        this.caretOffset = this.getClusterPrevious(this.caretOffset, this.getCaretLine());
        this.showCaret();
    }

    void doVisualNext() {
        this.caretOffset = this.getClusterNext(this.caretOffset, this.getCaretLine());
        this.showCaret();
    }

    void doWordNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            int caretLine = this.getCaretLine();
            this.showCaret(caretLine);
        } else {
            this.doSelectionWordNext();
        }
    }

    void doWordPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            int caretLine = this.getCaretLine();
            this.showCaret(caretLine);
        } else {
            this.doSelectionWordPrevious();
        }
    }

    void draw(int x, int y, int width, int height, boolean clearBackground) {
        if (clearBackground) {
            this.redraw(x + this.leftMargin, y + this.topMargin, width, height, true);
        } else {
            int startLine = (y + this.verticalScrollOffset) / this.lineHeight;
            int endY = y + height;
            int paintYFromTopLine = (startLine - this.topIndex) * this.lineHeight;
            int topLineOffset = this.topIndex * this.lineHeight - this.verticalScrollOffset;
            int paintY = paintYFromTopLine + topLineOffset + this.topMargin;
            int lineCount = this.content.getLineCount();
            Color background = this.getBackground();
            Color foreground = this.getForeground();
            GC gc = this.getGC();
            if (this.isSingleLine()) {
                lineCount = 1;
            }
            int i = startLine;
            while (paintY < endY && i < lineCount) {
                String line = this.content.getLine(i);
                TextLayout.ControlCharRenderer ccRender = new TextLayout.ControlCharRenderer();
                if (i < lineCount - 1) {
                    int start = this.content.getOffsetAtLine(i);
                    int end = this.content.getOffsetAtLine(i + 1);
                    String fullLine = this.content.getTextRange(start, end - start);
                    String delimiter = fullLine.substring(line.length());
                    ccRender.setLineDelimiter(delimiter);
                }
                this.renderer.drawLine(line, i, paintY, gc, background, foreground, clearBackground, ccRender);
                ++i;
                paintY += this.lineHeight;
            }
            gc.dispose();
        }
    }

    void endAutoScroll() {
        this.autoScrollDirection = 0;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.background;
    }

    public int getBaseline() {
        this.checkWidget();
        return this.renderer.getBaseline();
    }

    public boolean getBidiColoring() {
        this.checkWidget();
        return this.bidiColoring;
    }

    int getBottomIndex() {
        int lineCount = 1;
        if (this.lineHeight != 0) {
            int partialTopLineHeight = this.topIndex * this.lineHeight - this.verticalScrollOffset;
            lineCount = (this.getClientArea().height - partialTopLineHeight) / this.lineHeight;
        }
        return Math.min(this.content.getLineCount() - 1, this.topIndex + Math.max(0, lineCount - 1));
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.caretOffset;
    }

    int getOffsetAtX(String line, int lineOffset, int lineXOffset) {
        int x = lineXOffset - this.leftMargin + this.horizontalScrollOffset;
        TextLayout layout = this.renderer.getTextLayout(line, lineOffset);
        int[] trailing = new int[1];
        int offsetInLine = layout.getOffset(x, 0, trailing);
        this.advancing = false;
        if (trailing[0] != 0) {
            int lineLength = line.length();
            if (offsetInLine + trailing[0] >= lineLength) {
                offsetInLine = lineLength;
                this.advancing = true;
            } else {
                int offset = offsetInLine;
                while (offset > 0 && Character.isDigit(line.charAt(offset))) {
                    --offset;
                }
                int level = offset == 0 && Character.isDigit(line.charAt(offset)) ? (this.isMirrored() ? 1 : 0) : layout.getLevel(offset) & 1;
                int trailingLevel = layout.getLevel(offsetInLine += trailing[0]) & 1;
                this.advancing = (level ^ trailingLevel) != 0;
            }
        }
        this.renderer.disposeTextLayout(layout);
        return offsetInLine;
    }

    int getCaretWidth() {
        Caret caret = this.getCaret();
        if (caret == null) {
            return 0;
        }
        return caret.getSize().x;
    }

    Object getClipboardContent(int clipboardType) {
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        return this.clipboard.getContents((Transfer)plainTextTransfer, clipboardType);
    }

    int getClusterNext(int offset, int lineIndex) {
        String line = this.content.getLine(lineIndex);
        int lineOffset = this.content.getOffsetAtLine(lineIndex);
        TextLayout layout = this.renderer.getTextLayout(line, lineOffset);
        offset -= lineOffset;
        offset = layout.getNextOffset(offset, 2);
        this.renderer.disposeTextLayout(layout);
        return offset += lineOffset;
    }

    int getClusterPrevious(int offset, int lineIndex) {
        String line = this.content.getLine(lineIndex);
        int lineOffset = this.content.getOffsetAtLine(lineIndex);
        TextLayout layout = this.renderer.getTextLayout(line, lineOffset);
        offset -= lineOffset;
        offset = layout.getPreviousOffset(offset, 2);
        this.renderer.disposeTextLayout(layout);
        return offset += lineOffset;
    }

    public StyledTextContent getContent() {
        this.checkWidget();
        return this.logicalContent;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClickEnabled;
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.foreground;
    }

    GC getGC() {
        return new GC((Drawable)this);
    }

    int getHorizontalIncrement() {
        GC gc = this.getGC();
        int increment = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        return increment;
    }

    public int getHorizontalIndex() {
        this.checkWidget();
        return this.horizontalScrollOffset / this.getHorizontalIncrement();
    }

    public int getHorizontalPixel() {
        this.checkWidget();
        return this.horizontalScrollOffset;
    }

    public int getKeyBinding(int key) {
        this.checkWidget();
        Integer action = (Integer)this.keyActionMap.get(new Integer(key));
        int intAction = action == null ? 0 : action;
        return intAction;
    }

    public int getCharCount() {
        this.checkWidget();
        return this.content.getCharCount();
    }

    public Color getLineBackground(int index) {
        this.checkWidget();
        Color lineBackground = null;
        if (index < 0 || index > this.logicalContent.getLineCount()) {
            SWT.error((int)5);
        }
        if (!this.userLineBackground) {
            lineBackground = this.defaultLineStyler.getLineBackground(index);
        }
        return lineBackground;
    }

    StyledTextEvent getLineBackgroundData(int lineOffset, String line) {
        return this.sendLineEvent(3001, lineOffset, line);
    }

    public int getLineCount() {
        this.checkWidget();
        return this.getLineAtOffset(this.getCharCount()) + 1;
    }

    int getLineCountWhole() {
        int lineCount = this.lineHeight != 0 ? this.getClientArea().height / this.lineHeight : 1;
        return lineCount;
    }

    public int getLineAtOffset(int offset) {
        this.checkWidget();
        if (offset < 0 || offset > this.getCharCount()) {
            SWT.error((int)6);
        }
        return this.logicalContent.getLineAtOffset(offset);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return this.content.getLineDelimiter();
    }

    StyledTextEvent sendLineEvent(int eventType, int lineOffset, String line) {
        StyledTextEvent event = null;
        if (this.isListening(eventType)) {
            event = new StyledTextEvent(this.logicalContent);
            if (this.wordWrap) {
                int lineIndex = this.logicalContent.getLineAtOffset(lineOffset);
                event.detail = this.logicalContent.getOffsetAtLine(lineIndex);
                event.text = this.logicalContent.getLine(lineIndex);
            } else {
                event.detail = lineOffset;
                event.text = line;
            }
            this.notifyListeners(eventType, (Event)event);
        }
        return event;
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.lineHeight;
    }

    LineCache getLineCache(StyledTextContent content) {
        LineCache lineCache = this.wordWrap ? new WordWrapCache(this, (WrappedContent)content) : new ContentWidthCache(this, content);
        return lineCache;
    }

    StyledTextEvent getLineStyleData(int lineOffset, String line) {
        return this.sendLineEvent(3002, lineOffset, line);
    }

    public Point getLocationAtOffset(int offset) {
        this.checkWidget();
        if (offset < 0 || offset > this.getCharCount()) {
            SWT.error((int)6);
        }
        int line = this.content.getLineAtOffset(offset);
        int lineOffset = this.content.getOffsetAtLine(line);
        String lineContent = this.content.getLine(line);
        int x = this.getXAtOffset(lineContent, line, offset - lineOffset);
        int y = line * this.lineHeight - this.verticalScrollOffset;
        return new Point(x, y);
    }

    public int getOffsetAtLine(int lineIndex) {
        this.checkWidget();
        if (lineIndex < 0 || lineIndex > 0 && lineIndex >= this.logicalContent.getLineCount()) {
            SWT.error((int)6);
        }
        return this.logicalContent.getOffsetAtLine(lineIndex);
    }

    public int getOffsetAtLocation(Point point) {
        int[] trailing;
        int offsetInLine;
        int line;
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        if (point.y + this.verticalScrollOffset < 0 || point.x + this.horizontalScrollOffset < 0) {
            SWT.error((int)5);
        }
        if ((line = (this.getTopPixel() + point.y) / this.lineHeight) >= this.content.getLineCount()) {
            SWT.error((int)5);
        }
        String lineText = this.content.getLine(line);
        int lineOffset = this.content.getOffsetAtLine(line);
        int x = point.x - this.leftMargin + this.horizontalScrollOffset;
        TextLayout layout = this.renderer.getTextLayout(lineText, lineOffset);
        Rectangle rect = layout.getLineBounds(0);
        if (x > rect.x + rect.width) {
            this.renderer.disposeTextLayout(layout);
            SWT.error((int)5);
        }
        if ((offsetInLine = layout.getOffset(x, 0, trailing = new int[1])) != lineText.length() - 1) {
            offsetInLine = Math.min(lineText.length(), offsetInLine + trailing[0]);
        }
        this.renderer.disposeTextLayout(layout);
        return lineOffset + offsetInLine;
    }

    int getOffsetAtMouseLocation(int x, int line) {
        String lineText = this.content.getLine(line);
        int lineOffset = this.content.getOffsetAtLine(line);
        return this.getOffsetAtX(lineText, lineOffset, x) + lineOffset;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.isMirrored() ? 0x4000000 : 0x2000000;
    }

    int getPartialBottomIndex() {
        int partialLineCount = Compatibility.ceil((int)this.getClientArea().height, (int)this.lineHeight);
        return Math.min(this.content.getLineCount(), this.topIndex + partialLineCount) - 1;
    }

    String getPlatformDelimitedText(TextWriter writer) {
        int end = writer.getStart() + writer.getCharCount();
        int startLine = this.logicalContent.getLineAtOffset(writer.getStart());
        int endLine = this.logicalContent.getLineAtOffset(end);
        String endLineText = this.logicalContent.getLine(endLine);
        int endLineOffset = this.logicalContent.getOffsetAtLine(endLine);
        int i = startLine;
        while (i <= endLine) {
            writer.writeLine(this.logicalContent.getLine(i), this.logicalContent.getOffsetAtLine(i));
            if (i < endLine) {
                writer.writeLineDelimiter(PlatformLineDelimiter);
            }
            ++i;
        }
        if (end > endLineOffset + endLineText.length()) {
            writer.writeLineDelimiter(PlatformLineDelimiter);
        }
        writer.close();
        return writer.toString();
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public Point getSelectionRange() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y - this.selection.x);
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        if (this.selectionBackground == null) {
            return this.getDisplay().getSystemColor(26);
        }
        return this.selectionBackground;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.getSelectionRange().y;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        if (this.selectionForeground == null) {
            return this.getDisplay().getSystemColor(27);
        }
        return this.selectionForeground;
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.content.getTextRange(this.selection.x, this.selection.y - this.selection.x);
    }

    public int getStyle() {
        int style = super.getStyle();
        style &= 0xF1FFFFFF;
        style = this.isMirrored() ? (style |= 0xC000000) : (style |= 0x2000000);
        return style;
    }

    int[] getBidiSegments(int lineOffset, String line) {
        int[] segments;
        if (!this.isListening(3007)) {
            return this.getBidiSegmentsCompatibility(line, lineOffset);
        }
        StyledTextEvent event = this.sendLineEvent(3007, lineOffset, line);
        int lineLength = line.length();
        if (event == null || event.segments == null || event.segments.length == 0) {
            int[] nArray = new int[2];
            nArray[1] = lineLength;
            segments = nArray;
        } else {
            int segmentCount = event.segments.length;
            if (event.segments[0] != 0) {
                SWT.error((int)5);
            }
            int i = 1;
            while (i < segmentCount) {
                if (event.segments[i] <= event.segments[i - 1] || event.segments[i] > lineLength) {
                    SWT.error((int)5);
                }
                ++i;
            }
            if (event.segments[segmentCount - 1] != lineLength) {
                segments = new int[segmentCount + 1];
                System.arraycopy(event.segments, 0, segments, 0, segmentCount);
                segments[segmentCount] = lineLength;
            } else {
                segments = event.segments;
            }
        }
        return segments;
    }

    int[] getBidiSegmentsCompatibility(String line, int lineOffset) {
        StyleRange[] styles = new StyleRange[]{};
        int lineLength = line.length();
        if (!this.bidiColoring) {
            int[] nArray = new int[2];
            nArray[1] = lineLength;
            return nArray;
        }
        StyledTextEvent event = this.renderer.getLineStyleData(lineOffset, line);
        if (event != null) {
            styles = event.styles;
        }
        if (styles.length == 0) {
            int[] nArray = new int[2];
            nArray[1] = lineLength;
            return nArray;
        }
        int k = 0;
        int count = 1;
        while (k < styles.length && styles[k].start == 0 && styles[k].length == lineLength) {
            ++k;
        }
        int[] offsets = new int[(styles.length - k) * 2 + 2];
        int i = k;
        while (i < styles.length) {
            StyleRange style = styles[i];
            int styleLineStart = Math.max(style.start - lineOffset, 0);
            int styleLineEnd = Math.max(style.start + style.length - lineOffset, styleLineStart);
            styleLineEnd = Math.min(styleLineEnd, line.length());
            if (i > 0 && count > 1 && (styleLineStart >= offsets[count - 2] && styleLineStart <= offsets[count - 1] || styleLineEnd >= offsets[count - 2] && styleLineEnd <= offsets[count - 1]) && style.similarTo(styles[i - 1])) {
                offsets[count - 2] = Math.min(offsets[count - 2], styleLineStart);
                offsets[count - 1] = Math.max(offsets[count - 1], styleLineEnd);
            } else {
                if (styleLineStart > offsets[count - 1]) {
                    offsets[count] = styleLineStart;
                    ++count;
                }
                offsets[count] = styleLineEnd;
                ++count;
            }
            ++i;
        }
        if (lineLength > offsets[count - 1]) {
            offsets[count] = lineLength;
            ++count;
        }
        if (count == offsets.length) {
            return offsets;
        }
        int[] result = new int[count];
        System.arraycopy(offsets, 0, result, 0, count);
        return result;
    }

    public StyleRange getStyleRangeAtOffset(int offset) {
        this.checkWidget();
        if (offset < 0 || offset >= this.getCharCount()) {
            SWT.error((int)5);
        }
        if (!this.userLineStyle) {
            return this.defaultLineStyler.getStyleRangeAtOffset(offset);
        }
        return null;
    }

    public StyleRange[] getStyleRanges() {
        this.checkWidget();
        StyleRange[] styles = !this.userLineStyle ? this.defaultLineStyler.getStyleRanges() : new StyleRange[]{};
        return styles;
    }

    public StyleRange[] getStyleRanges(int start, int length) {
        StyleRange[] styles;
        this.checkWidget();
        int contentLength = this.getCharCount();
        int end = start + length;
        if (start > end || start < 0 || end > contentLength) {
            SWT.error((int)6);
        }
        if (!this.userLineStyle) {
            styles = this.defaultLineStyler.getStyleRangesFor(start, length);
            if (styles == null) {
                return new StyleRange[0];
            }
            if (styles.length == 1) {
                StyleRange newStyle;
                StyleRange style = styles[0];
                if (style.start < start) {
                    newStyle = (StyleRange)styles[0].clone();
                    newStyle.length -= start - newStyle.start;
                    newStyle.start = start;
                    styles[0] = newStyle;
                }
                if (style.start + style.length > start + length) {
                    newStyle = (StyleRange)styles[0].clone();
                    newStyle.length = start + length - newStyle.start;
                    styles[0] = newStyle;
                }
            } else if (styles.length > 1) {
                StyleRange newStyle;
                StyleRange style = styles[0];
                if (style.start < start) {
                    newStyle = (StyleRange)styles[0].clone();
                    newStyle.length -= start - newStyle.start;
                    newStyle.start = start;
                    styles[0] = newStyle;
                }
                style = styles[styles.length - 1];
                if (style.start + style.length > start + length) {
                    newStyle = (StyleRange)styles[styles.length - 1].clone();
                    newStyle.length = start + length - newStyle.start;
                    styles[styles.length - 1] = newStyle;
                }
            }
        } else {
            styles = new StyleRange[]{};
        }
        return styles;
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabLength;
    }

    public String getText() {
        this.checkWidget();
        return this.content.getTextRange(0, this.getCharCount());
    }

    public String getText(int start, int end) {
        this.checkWidget();
        int contentLength = this.getCharCount();
        if (start < 0 || start >= contentLength || end < 0 || end >= contentLength || start > end) {
            SWT.error((int)6);
        }
        return this.content.getTextRange(start, end - start + 1);
    }

    public Rectangle getTextBounds(int start, int end) {
        Rectangle rect;
        this.checkWidget();
        int contentLength = this.getCharCount();
        if (start < 0 || start >= contentLength || end < 0 || end >= contentLength || start > end) {
            SWT.error((int)6);
        }
        int lineStart = this.content.getLineAtOffset(start);
        int lineEnd = this.content.getLineAtOffset(end);
        int y = lineStart * this.lineHeight;
        int height = (lineEnd + 1) * this.lineHeight - y;
        int left = Integer.MAX_VALUE;
        int right = 0;
        int i = lineStart;
        while (i <= lineEnd) {
            int lineOffset = this.content.getOffsetAtLine(i);
            String line = this.content.getLine(i);
            TextLayout layout = this.renderer.getTextLayout(line, lineOffset);
            rect = i == lineStart && i == lineEnd ? layout.getBounds(start - lineOffset, end - lineOffset) : (i == lineStart ? layout.getBounds(start - lineOffset, line.length()) : (i == lineEnd ? layout.getBounds(0, end - lineOffset) : layout.getLineBounds(0)));
            left = Math.min(left, rect.x);
            right = Math.max(right, rect.x + rect.width);
            this.renderer.disposeTextLayout(layout);
            ++i;
        }
        rect = new Rectangle(left, y, right - left, height);
        rect.x += this.leftMargin - this.horizontalScrollOffset;
        rect.y -= this.verticalScrollOffset;
        return rect;
    }

    public String getTextRange(int start, int length) {
        this.checkWidget();
        int contentLength = this.getCharCount();
        int end = start + length;
        if (start > end || start < 0 || end > contentLength) {
            SWT.error((int)6);
        }
        return this.content.getTextRange(start, length);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        int logicalTopIndex = this.topIndex;
        if (this.wordWrap) {
            int visualLineOffset = this.content.getOffsetAtLine(this.topIndex);
            logicalTopIndex = this.logicalContent.getLineAtOffset(visualLineOffset);
        }
        return logicalTopIndex;
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.verticalScrollOffset;
    }

    int getVerticalIncrement() {
        return this.lineHeight;
    }

    int getCaretDirection() {
        if (!this.isBidiCaret()) {
            return -1;
        }
        if (!this.updateCaretDirection && this.caretDirection != 0) {
            return this.caretDirection;
        }
        this.updateCaretDirection = false;
        int caretLine = this.getCaretLine();
        int lineOffset = this.content.getOffsetAtLine(caretLine);
        String line = this.content.getLine(caretLine);
        int offset = this.caretOffset - lineOffset;
        int lineLength = line.length();
        if (lineLength == 0) {
            return this.isMirrored() ? 131072 : 16384;
        }
        if (this.advancing && offset > 0) {
            --offset;
        }
        if (offset == lineLength && offset > 0) {
            --offset;
        }
        while (offset > 0 && Character.isDigit(line.charAt(offset))) {
            --offset;
        }
        if (offset == 0 && Character.isDigit(line.charAt(offset))) {
            return this.isMirrored() ? 131072 : 16384;
        }
        TextLayout layout = this.renderer.getTextLayout(line, lineOffset);
        int level = layout.getLevel(offset);
        this.renderer.disposeTextLayout(layout);
        return (level & 1) != 0 ? 131072 : 16384;
    }

    int getCaretLine() {
        int caretLine = this.content.getLineAtOffset(this.caretOffset);
        int leftColumnX = this.leftMargin;
        if (this.wordWrap && this.columnX <= leftColumnX && caretLine < this.content.getLineCount() - 1 && this.caretOffset == this.content.getOffsetAtLine(caretLine + 1)) {
            ++caretLine;
        }
        return caretLine;
    }

    int getWordEnd(int offset) {
        int line = this.logicalContent.getLineAtOffset(offset);
        int lineOffset = this.logicalContent.getOffsetAtLine(line);
        String lineText = this.logicalContent.getLine(line);
        int lineLength = lineText.length();
        if (offset >= this.getCharCount()) {
            return offset;
        }
        if (offset == lineOffset + lineLength) {
            offset = this.logicalContent.getOffsetAtLine(++line);
        } else {
            TextLayout layout = this.renderer.getTextLayout(lineText, lineOffset);
            offset -= lineOffset;
            offset = layout.getNextOffset(offset, 4);
            offset += lineOffset;
            this.renderer.disposeTextLayout(layout);
        }
        return offset;
    }

    int getWordEndNoSpaces(int offset) {
        int line = this.logicalContent.getLineAtOffset(offset);
        int lineOffset = this.logicalContent.getOffsetAtLine(line);
        String lineText = this.logicalContent.getLine(line);
        int lineLength = lineText.length();
        if (offset >= this.getCharCount()) {
            return offset;
        }
        if (offset == lineOffset + lineLength) {
            offset = this.logicalContent.getOffsetAtLine(++line);
        } else {
            char ch = lineText.charAt(offset -= lineOffset);
            boolean letterOrDigit = Compatibility.isLetterOrDigit((char)ch);
            while (offset < lineLength - 1 && Compatibility.isLetterOrDigit((char)ch) == letterOrDigit && !Compatibility.isSpaceChar((char)ch)) {
                ch = lineText.charAt(++offset);
            }
            if (offset == lineLength - 1 && Compatibility.isLetterOrDigit((char)ch) == letterOrDigit && !Compatibility.isSpaceChar((char)ch)) {
                ++offset;
            }
            offset += lineOffset;
        }
        return offset;
    }

    int getWordStart(int offset) {
        int line = this.logicalContent.getLineAtOffset(offset);
        int lineOffset = this.logicalContent.getOffsetAtLine(line);
        String lineText = this.logicalContent.getLine(line);
        if (offset <= 0) {
            return offset;
        }
        if (offset == lineOffset) {
            lineText = this.logicalContent.getLine(--line);
            offset = this.logicalContent.getOffsetAtLine(line) + lineText.length();
        } else {
            TextLayout layout = this.renderer.getTextLayout(lineText, lineOffset);
            offset -= lineOffset;
            offset = layout.getPreviousOffset(offset, 4);
            offset += lineOffset;
            this.renderer.disposeTextLayout(layout);
        }
        return offset;
    }

    public boolean getWordWrap() {
        this.checkWidget();
        return this.wordWrap;
    }

    int getXAtOffset(String line, int lineIndex, int offsetInLine) {
        int x = 0;
        int lineLength = line.length();
        if (lineIndex < this.content.getLineCount() - 1) {
            int endLineOffset = this.content.getOffsetAtLine(lineIndex + 1) - 1;
            if (lineLength < offsetInLine && offsetInLine <= endLineOffset) {
                offsetInLine = lineLength;
            }
        }
        if (lineLength != 0 && offsetInLine <= lineLength) {
            int lineOffset = this.content.getOffsetAtLine(lineIndex);
            TextLayout layout = this.renderer.getTextLayout(line, lineOffset);
            x = !this.advancing || offsetInLine == 0 ? layout.getLocation((int)offsetInLine, (boolean)false).x : layout.getLocation((int)(offsetInLine - 1), (boolean)true).x;
            this.renderer.disposeTextLayout(layout);
        }
        return x + this.leftMargin - this.horizontalScrollOffset;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        Point sel = this.getSelectionRange();
        this.replaceTextRange(sel.x, sel.y, string);
    }

    void installDefaultContent() {
        this.textChangeListener = new TextChangeListener(){

            public void textChanging(TextChangingEvent event) {
                StyledText.this.handleTextChanging(event);
            }

            public void textChanged(TextChangedEvent event) {
                StyledText.this.handleTextChanged(event);
            }

            public void textSet(TextChangedEvent event) {
                StyledText.this.handleTextSet(event);
            }
        };
        this.logicalContent = this.content = new DefaultContent();
        this.content.addTextChangeListener(this.textChangeListener);
    }

    void installDefaultLineStyler() {
        this.defaultLineStyler = new DefaultLineStyler(this.logicalContent);
        StyledTextListener typedListener = new StyledTextListener((SWTEventListener)this.defaultLineStyler);
        if (!this.userLineStyle) {
            this.addListener(3002, (Listener)typedListener);
        }
        if (!this.userLineBackground) {
            this.addListener(3001, (Listener)typedListener);
        }
    }

    void installListeners() {
        ScrollBar verticalBar = this.getVerticalBar();
        ScrollBar horizontalBar = this.getHorizontalBar();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        StyledText.this.handleDispose(event);
                        break;
                    }
                    case 1: {
                        StyledText.this.handleKeyDown(event);
                        break;
                    }
                    case 2: {
                        StyledText.this.handleKeyUp(event);
                        break;
                    }
                    case 3: {
                        StyledText.this.handleMouseDown(event);
                        break;
                    }
                    case 4: {
                        StyledText.this.handleMouseUp(event);
                        break;
                    }
                    case 8: {
                        StyledText.this.handleMouseDoubleClick(event);
                        break;
                    }
                    case 5: {
                        StyledText.this.handleMouseMove(event);
                        break;
                    }
                    case 9: {
                        StyledText.this.handlePaint(event);
                        break;
                    }
                    case 11: {
                        StyledText.this.handleResize(event);
                        break;
                    }
                    case 31: {
                        StyledText.this.handleTraverse(event);
                    }
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(1, this.listener);
        this.addListener(2, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(8, this.listener);
        this.addListener(5, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(31, this.listener);
        if (verticalBar != null) {
            verticalBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleVerticalScroll(event);
                }
            });
        }
        if (horizontalBar != null) {
            horizontalBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleHorizontalScroll(event);
                }
            });
        }
    }

    StyledTextContent internalGetContent() {
        return this.content;
    }

    int internalGetHorizontalPixel() {
        return this.horizontalScrollOffset;
    }

    LineCache internalGetLineCache() {
        return this.lineCache;
    }

    Point internalGetSelection() {
        return this.selection;
    }

    boolean internalGetWordWrap() {
        return this.wordWrap;
    }

    void internalRedraw() {
        super.redraw();
    }

    void internalRedrawRange(int start, int length, boolean clearBackground) {
        int offsetInFirstLine;
        int end = start + length;
        int firstLine = this.content.getLineAtOffset(start);
        int lastLine = this.content.getLineAtOffset(end);
        int partialBottomIndex = this.getPartialBottomIndex();
        int partialTopIndex = this.verticalScrollOffset / this.lineHeight;
        if (firstLine > partialBottomIndex || lastLine < partialTopIndex) {
            return;
        }
        if (partialTopIndex > firstLine) {
            firstLine = partialTopIndex;
            offsetInFirstLine = 0;
        } else {
            offsetInFirstLine = start - this.content.getOffsetAtLine(firstLine);
        }
        if (partialBottomIndex + 1 < lastLine) {
            lastLine = partialBottomIndex + 1;
            end = this.content.getOffsetAtLine(lastLine);
        }
        this.redrawLines(firstLine, offsetInFirstLine, lastLine, end, clearBackground);
        if (lastLine - firstLine > 1) {
            Rectangle clientArea = this.getClientArea();
            int redrawStopY = lastLine * this.lineHeight - this.verticalScrollOffset;
            int redrawY = (firstLine + 1) * this.lineHeight - this.verticalScrollOffset;
            this.draw(0, redrawY, clientArea.width, redrawStopY - redrawY, clearBackground);
        }
    }

    String getRtf() {
        this.checkWidget();
        RTFWriter rtfWriter = new RTFWriter(0, this.getCharCount());
        return this.getPlatformDelimitedText(rtfWriter);
    }

    void handleDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.clipboard.dispose();
        this.ibeamCursor.dispose();
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
            this.content = null;
        }
        if (this.defaultCaret != null) {
            this.defaultCaret.dispose();
            this.defaultCaret = null;
        }
        if (this.leftCaretBitmap != null) {
            this.leftCaretBitmap.dispose();
            this.leftCaretBitmap = null;
        }
        if (this.rightCaretBitmap != null) {
            this.rightCaretBitmap.dispose();
            this.rightCaretBitmap = null;
        }
        if (this.defaultLineStyler != null) {
            this.defaultLineStyler.release();
            this.defaultLineStyler = null;
        }
        if (this.isBidiCaret()) {
            BidiUtil.removeLanguageListener((int)this.handle);
        }
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.logicalContent = null;
        this.textChangeListener = null;
        this.lineCache = null;
        this.ibeamCursor = null;
        this.selection = null;
        this.doubleClickSelection = null;
        this.keyActionMap = null;
        this.background = null;
        this.foreground = null;
        this.clipboard = null;
    }

    void handleHorizontalScroll(Event event) {
        int scrollPixel = this.getHorizontalBar().getSelection() - this.horizontalScrollOffset;
        this.scrollHorizontal(scrollPixel);
    }

    void handleKey(Event event) {
        int action;
        this.advancing = true;
        if (event.keyCode != 0) {
            action = this.getKeyBinding(event.keyCode | event.stateMask);
        } else {
            action = this.getKeyBinding(event.character | event.stateMask);
            if (action == 0 && (event.stateMask & 0x40000) != 0 && event.character >= '\u0000' && event.character <= '\u001f') {
                int c = event.character + 64;
                action = this.getKeyBinding(c | event.stateMask);
            }
        }
        if (action == 0) {
            boolean ignore = false;
            if (IS_CARBON) {
                ignore = (event.stateMask ^ 0x400000) == 0 || (event.stateMask ^ 0x420000) == 0;
            } else if (IS_MOTIF) {
                ignore = (event.stateMask ^ 0x40000) == 0 || (event.stateMask ^ 0x60000) == 0;
            } else {
                boolean bl = ignore = (event.stateMask ^ 0x10000) == 0 || (event.stateMask ^ 0x40000) == 0 || (event.stateMask ^ 0x30000) == 0 || (event.stateMask ^ 0x60000) == 0;
            }
            if (!ignore && event.character > '\u001f' && event.character != '\u007f' || event.character == '\r' || event.character == '\n' || event.character == '\t') {
                this.doContent(event.character);
            }
        } else {
            this.invokeAction(action);
        }
    }

    void handleKeyDown(Event event) {
        if (this.clipboardSelection == null) {
            this.clipboardSelection = new Point(this.selection.x, this.selection.y);
        }
        Event verifyEvent = new Event();
        verifyEvent.character = event.character;
        verifyEvent.keyCode = event.keyCode;
        verifyEvent.stateMask = event.stateMask;
        verifyEvent.doit = true;
        this.notifyListeners(3005, verifyEvent);
        if (verifyEvent.doit) {
            this.handleKey(event);
        }
    }

    void handleKeyUp(Event event) {
        block4: {
            if (this.clipboardSelection != null && (this.clipboardSelection.x != this.selection.x || this.clipboardSelection.y != this.selection.y)) {
                try {
                    if (this.selection.y - this.selection.x > 0) {
                        this.setClipboardContent(this.selection.x, this.selection.y - this.selection.x, 2);
                    }
                }
                catch (SWTError error) {
                    if (error.code == 2002) break block4;
                    throw error;
                }
            }
        }
        this.clipboardSelection = null;
    }

    void handleMouseDoubleClick(Event event) {
        if (event.button != 1 || !this.doubleClickEnabled) {
            return;
        }
        event.y -= this.topMargin;
        this.mouseDoubleClick = true;
        this.caretOffset = this.getWordStart(this.caretOffset);
        this.resetSelection();
        this.caretOffset = this.getWordEndNoSpaces(this.caretOffset);
        this.showCaret();
        this.doMouseSelection();
        this.doubleClickSelection = new Point(this.selection.x, this.selection.y);
    }

    void handleMouseDown(Event event) {
        String text;
        this.mouseDown = true;
        this.mouseDoubleClick = false;
        if (event.button == 2 && (text = (String)this.getClipboardContent(2)) != null && text.length() > 0) {
            int x = event.x;
            int y = event.y - this.topMargin;
            this.doMouseLocationChange(x, y, false);
            Event e = new Event();
            e.start = this.selection.x;
            e.end = this.selection.y;
            e.text = this.getModelDelimitedText(text);
            this.sendKeyEvent(e);
        }
        if (event.button != 1 || IS_CARBON && (event.stateMask & SWT.MOD4) != 0) {
            return;
        }
        boolean select = (event.stateMask & SWT.MOD2) != 0;
        event.y -= this.topMargin;
        this.doMouseLocationChange(event.x, event.y, select);
    }

    void handleMouseMove(Event event) {
        if (!this.mouseDown) {
            return;
        }
        if ((event.stateMask & 0x80000) == 0) {
            return;
        }
        event.y -= this.topMargin;
        this.doMouseLocationChange(event.x, event.y, true);
        this.update();
        this.doAutoScroll(event);
    }

    void handleMouseUp(Event event) {
        block4: {
            this.mouseDown = false;
            this.mouseDoubleClick = false;
            event.y -= this.topMargin;
            this.endAutoScroll();
            if (event.button == 1) {
                try {
                    if (this.selection.y - this.selection.x > 0) {
                        this.setClipboardContent(this.selection.x, this.selection.y - this.selection.x, 2);
                    }
                }
                catch (SWTError error) {
                    if (error.code == 2002) break block4;
                    throw error;
                }
            }
        }
    }

    void handlePaint(Event event) {
        int startLine = Math.max(0, (event.y - this.topMargin + this.verticalScrollOffset) / this.lineHeight);
        int paintYFromTopLine = (startLine - this.topIndex) * this.lineHeight;
        int topLineOffset = this.topIndex * this.lineHeight - this.verticalScrollOffset;
        int startY = paintYFromTopLine + topLineOffset + this.topMargin;
        int renderHeight = event.y + event.height - startY;
        if (event.height == 0) {
            return;
        }
        this.performPaint(event.gc, startLine, startY, renderHeight);
    }

    void handleResize(Event event) {
        int oldHeight = this.clientAreaHeight;
        int oldWidth = this.clientAreaWidth;
        Rectangle clientArea = this.getClientArea();
        this.clientAreaHeight = clientArea.height;
        this.clientAreaWidth = clientArea.width;
        if (oldWidth != this.clientAreaWidth && this.rightMargin > 0) {
            int x = (oldWidth < this.clientAreaWidth ? oldWidth : this.clientAreaWidth) - this.rightMargin;
            this.redraw(x, 0, this.rightMargin, oldHeight, false);
        }
        if (oldHeight != this.clientAreaHeight && this.bottomMargin > 0) {
            int y = (oldHeight < this.clientAreaHeight ? oldHeight : this.clientAreaHeight) - this.bottomMargin;
            this.redraw(0, y, oldWidth, this.bottomMargin, false);
        }
        if (this.wordWrap) {
            if (oldWidth != this.clientAreaWidth) {
                this.wordWrapResize(oldWidth);
            }
        } else if (this.clientAreaHeight > oldHeight) {
            int lineCount = this.content.getLineCount();
            int oldBottomIndex = this.topIndex + oldHeight / this.lineHeight;
            int newItemCount = Compatibility.ceil((int)(this.clientAreaHeight - oldHeight), (int)this.lineHeight);
            oldBottomIndex = Math.min(oldBottomIndex, lineCount);
            newItemCount = Math.min(newItemCount, lineCount - oldBottomIndex);
            this.lineCache.calculate(oldBottomIndex, newItemCount);
        }
        this.setScrollBars();
        this.claimBottomFreeSpace();
        this.claimRightFreeSpace();
        if (oldHeight != this.clientAreaHeight) {
            this.calculateTopIndex();
        }
    }

    void handleTextChanged(TextChangedEvent event) {
        this.lineCache.textChanged(this.lastTextChangeStart, this.lastTextChangeNewLineCount, this.lastTextChangeReplaceLineCount, this.lastTextChangeNewCharCount, this.lastTextChangeReplaceCharCount);
        this.setScrollBars();
        this.updateSelection(this.lastTextChangeStart, this.lastTextChangeReplaceCharCount, this.lastTextChangeNewCharCount);
        if (this.lastTextChangeReplaceLineCount > 0) {
            this.claimBottomFreeSpace();
        }
        if (this.lastTextChangeReplaceCharCount > 0) {
            this.claimRightFreeSpace();
        }
        if (this.lastTextChangeNewLineCount == 0 && this.lastTextChangeReplaceLineCount == 0) {
            int startLine = this.content.getLineAtOffset(this.lastTextChangeStart);
            int startY = startLine * this.lineHeight - this.verticalScrollOffset + this.topMargin;
            if (DOUBLE_BUFFER) {
                GC gc = this.getGC();
                Caret caret = this.getCaret();
                boolean caretVisible = false;
                if (caret != null) {
                    caretVisible = caret.getVisible();
                    caret.setVisible(false);
                }
                this.performPaint(gc, startLine, startY, this.lineHeight);
                if (caret != null) {
                    caret.setVisible(caretVisible);
                }
                gc.dispose();
            } else {
                this.redraw(0, startY, this.getClientArea().width, this.lineHeight, false);
                this.update();
            }
        }
    }

    void handleTextChanging(TextChangingEvent event) {
        int newEndOfText;
        boolean isMultiLineChange;
        boolean bl = isMultiLineChange = event.replaceLineCount > 0 || event.newLineCount > 0;
        if (event.replaceCharCount < 0) {
            event.start += event.replaceCharCount;
            event.replaceCharCount *= -1;
        }
        this.lastTextChangeStart = event.start;
        this.lastTextChangeNewLineCount = event.newLineCount;
        this.lastTextChangeNewCharCount = event.newCharCount;
        this.lastTextChangeReplaceLineCount = event.replaceLineCount;
        this.lastTextChangeReplaceCharCount = event.replaceCharCount;
        int firstLine = this.content.getLineAtOffset(event.start);
        int textChangeY = firstLine * this.lineHeight - this.verticalScrollOffset + this.topMargin;
        if (isMultiLineChange) {
            this.redrawMultiLineChange(textChangeY, event.newLineCount, event.replaceLineCount);
        }
        if (this.defaultLineStyler != null) {
            this.defaultLineStyler.textChanging(event);
        }
        if (this.caretOffset > (newEndOfText = this.content.getCharCount() - event.replaceCharCount + event.newCharCount)) {
            this.caretOffset = newEndOfText;
        }
    }

    void handleTextSet(TextChangedEvent event) {
        this.reset();
    }

    void handleTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 256: 
            case 512: {
                event.doit = true;
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                if ((this.getStyle() & 4) != 0) {
                    event.doit = true;
                    break;
                }
                if (this.editable && (event.stateMask & SWT.MODIFIER_MASK) == 0) break;
                event.doit = true;
            }
        }
    }

    void handleVerticalScroll(Event event) {
        this.setVerticalScrollOffset(this.getVerticalBar().getSelection(), false);
    }

    void initializeAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = StyledText.this.getToolTipText();
            }
        });
        accessible.addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = StyledText.this.getCaretOffset();
            }

            public void getSelectionRange(AccessibleTextEvent e) {
                Point selection = StyledText.this.getSelectionRange();
                e.offset = selection.x;
                e.length = selection.y;
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                int state = 0;
                if (StyledText.this.isEnabled()) {
                    state |= 0x100000;
                }
                if (StyledText.this.isFocusControl()) {
                    state |= 4;
                }
                if (!StyledText.this.isVisible()) {
                    state |= 0x8000;
                }
                if (!StyledText.this.getEditable()) {
                    state |= 0x40;
                }
                e.detail = state;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = StyledText.this.getText();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    void initializeRenderer() {
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.renderer = new DisplayRenderer((Device)this.getDisplay(), this.getFont(), this, this.tabLength);
        this.lineHeight = this.renderer.getLineHeight();
        if (this.wordWrap) {
            this.content = new WrappedContent((StyledTextRenderer)this.renderer, this.logicalContent);
        }
    }

    public void invokeAction(int action) {
        this.checkWidget();
        this.updateCaretDirection = true;
        switch (action) {
            case 0x1000001: {
                int caretLine = this.doLineUp();
                int oldColumnX = this.columnX;
                int oldHScrollOffset = this.horizontalScrollOffset;
                this.showCaret(caretLine);
                int hScrollChange = oldHScrollOffset - this.horizontalScrollOffset;
                this.columnX = oldColumnX + hScrollChange;
                this.clearSelection(true);
                break;
            }
            case 0x1000002: {
                int caretLine = this.doLineDown();
                int oldColumnX = this.columnX;
                int oldHScrollOffset = this.horizontalScrollOffset;
                this.showCaret(caretLine);
                int hScrollChange = oldHScrollOffset - this.horizontalScrollOffset;
                this.columnX = oldColumnX + hScrollChange;
                this.clearSelection(true);
                break;
            }
            case 0x1000007: {
                this.doLineStart();
                this.clearSelection(true);
                break;
            }
            case 0x1000008: {
                this.doLineEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1000003: {
                this.doCursorPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1000004: {
                this.doCursorNext();
                this.clearSelection(true);
                break;
            }
            case 0x1000005: {
                this.doPageUp(false, this.getLineCountWhole());
                this.clearSelection(true);
                break;
            }
            case 0x1000006: {
                this.doPageDown(false, this.getLineCountWhole());
                this.clearSelection(true);
                break;
            }
            case 17039363: {
                this.doWordPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1040004: {
                this.doWordNext();
                this.clearSelection(true);
                break;
            }
            case 17039367: {
                this.doContentStart();
                this.clearSelection(true);
                break;
            }
            case 17039368: {
                this.doContentEnd();
                this.clearSelection(true);
                break;
            }
            case 17039365: {
                this.doPageStart();
                this.clearSelection(true);
                break;
            }
            case 17039366: {
                this.doPageEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1020001: {
                this.doSelectionLineUp();
                break;
            }
            case 262209: {
                this.selectAll();
                break;
            }
            case 0x1020002: {
                this.doSelectionLineDown();
                break;
            }
            case 16908295: {
                this.doLineStart();
                this.doSelection(0x1000003);
                break;
            }
            case 16908296: {
                this.doLineEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 16908291: {
                this.doSelectionCursorPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 16908292: {
                this.doSelectionCursorNext();
                this.doSelection(0x1000004);
                break;
            }
            case 16908293: {
                this.doSelectionPageUp(this.getLineCountWhole());
                break;
            }
            case 16908294: {
                this.doSelectionPageDown(this.getLineCountWhole());
                break;
            }
            case 17170435: {
                this.doSelectionWordPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 17170436: {
                this.doSelectionWordNext();
                this.doSelection(0x1000004);
                break;
            }
            case 17170439: {
                this.doContentStart();
                this.doSelection(0x1000003);
                break;
            }
            case 17170440: {
                this.doContentEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 17170437: {
                this.doPageStart();
                this.doSelection(0x1000003);
                break;
            }
            case 0x1060006: {
                this.doPageEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 131199: {
                this.cut();
                break;
            }
            case 17039369: {
                this.copy();
                break;
            }
            case 16908297: {
                this.paste();
                break;
            }
            case 8: {
                this.doBackspace();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
            case 262152: {
                this.doDeleteWordPrevious();
                break;
            }
            case 262271: {
                this.doDeleteWordNext();
                break;
            }
            case 0x1000009: {
                this.overwrite = !this.overwrite;
            }
        }
    }

    boolean isBidi() {
        return IS_GTK || BidiUtil.isBidiPlatform() || this.isMirrored;
    }

    boolean isLineDelimiter(int offset) {
        int line = this.content.getLineAtOffset(offset);
        int lineOffset = this.content.getOffsetAtLine(line);
        int offsetInLine = offset - lineOffset;
        return offsetInLine > this.content.getLine(line).length();
    }

    boolean isMirrored() {
        return this.isMirrored;
    }

    boolean isAreaVisible(int firstLine, int lastLine) {
        int partialBottomIndex = this.getPartialBottomIndex();
        int partialTopIndex = this.verticalScrollOffset / this.lineHeight;
        boolean notVisible = firstLine > partialBottomIndex || lastLine < partialTopIndex;
        return !notVisible;
    }

    boolean isSingleLine() {
        return (this.getStyle() & 4) != 0;
    }

    void modifyContent(Event event, boolean updateCaret) {
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            int replacedLength = event.end - event.start;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.logicalContent);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, replacedLength);
            }
            if (updateCaret && event.text.length() == 0) {
                int lineIndex = this.content.getLineAtOffset(event.start);
                int lineOffset = this.content.getOffsetAtLine(lineIndex);
                String lineText = this.content.getLine(lineIndex);
                TextLayout layout = this.renderer.getTextLayout(lineText, lineOffset);
                int levelStart = layout.getLevel(event.start - lineOffset);
                int lineIndexEnd = this.content.getLineAtOffset(event.end);
                if (lineIndex != lineIndexEnd) {
                    this.renderer.disposeTextLayout(layout);
                    lineOffset = this.content.getOffsetAtLine(lineIndexEnd);
                    lineText = this.content.getLine(lineIndexEnd);
                    layout = this.renderer.getTextLayout(lineText, lineOffset);
                }
                int levelEnd = layout.getLevel(event.end - lineOffset);
                this.renderer.disposeTextLayout(layout);
                this.advancing = levelStart != levelEnd;
            }
            this.content.replaceTextRange(event.start, replacedLength, event.text);
            if (updateCaret) {
                this.internalSetSelection(event.start + event.text.length(), 0, true);
                this.showCaret();
            }
            this.sendModifyEvent(event);
            if (this.isListening(3000)) {
                this.notifyListeners(3000, (Event)styledTextEvent);
            }
        }
    }

    public void paste() {
        this.checkWidget();
        String text = (String)this.getClipboardContent(1);
        if (text != null && text.length() > 0) {
            Event event = new Event();
            event.start = this.selection.x;
            event.end = this.selection.y;
            event.text = this.getModelDelimitedText(text);
            this.sendKeyEvent(event);
        }
    }

    void performPaint(GC gc, int startLine, int startY, int renderHeight) {
        Rectangle clientArea = this.getClientArea();
        Color background = this.getBackground();
        if (clientArea.width == 0) {
            return;
        }
        if (renderHeight > 0) {
            GC lineGC;
            Image lineBuffer;
            int paintHeight;
            int paintY;
            int gcStyle;
            Color foreground = this.getForeground();
            int lineCount = this.content.getLineCount();
            int n = gcStyle = this.isMirrored() ? 0x4000000 : 0x2000000;
            if (this.isSingleLine()) {
                lineCount = 1;
            }
            boolean doubleBuffer = DOUBLE_BUFFER && this.lastPaintTopIndex == this.topIndex;
            this.lastPaintTopIndex = this.topIndex;
            if (doubleBuffer) {
                paintY = 0;
                paintHeight = renderHeight;
                lineBuffer = new Image((Device)this.getDisplay(), clientArea.width, renderHeight);
                lineGC = new GC((Drawable)lineBuffer, gcStyle);
                lineGC.setFont(this.getFont());
                lineGC.setForeground(foreground);
                lineGC.setBackground(background);
            } else {
                paintY = startY;
                paintHeight = startY + renderHeight;
                lineBuffer = null;
                lineGC = gc;
            }
            int i = startLine;
            while (paintY < paintHeight && i < lineCount) {
                String line = this.content.getLine(i);
                TextLayout.ControlCharRenderer ccRender = new TextLayout.ControlCharRenderer();
                if (i < lineCount - 1) {
                    int start = this.content.getOffsetAtLine(i);
                    int end = this.content.getOffsetAtLine(i + 1);
                    String fullLine = this.content.getTextRange(start, end - start);
                    String delimiter = fullLine.substring(line.length());
                    ccRender.setLineDelimiter(delimiter);
                }
                this.renderer.drawLine(line, i, paintY, lineGC, background, foreground, true, ccRender);
                ++i;
                paintY += this.lineHeight;
            }
            if (paintY < paintHeight) {
                lineGC.setBackground(background);
                lineGC.fillRectangle(0, paintY, clientArea.width, paintHeight - paintY);
            }
            if (doubleBuffer) {
                this.clearMargin(lineGC, background, clientArea, startY);
                gc.drawImage(lineBuffer, 0, startY);
                lineGC.dispose();
                lineBuffer.dispose();
            }
        }
        this.clearMargin(gc, background, clientArea, 0);
    }

    public void print() {
        this.checkWidget();
        Printer printer = new Printer();
        StyledTextPrintOptions options = new StyledTextPrintOptions();
        options.printTextForeground = true;
        options.printTextBackground = true;
        options.printTextFontStyle = true;
        options.printLineBackground = true;
        new Printing(this, printer, options).run();
        printer.dispose();
    }

    public Runnable print(Printer printer) {
        this.checkWidget();
        StyledTextPrintOptions options = new StyledTextPrintOptions();
        options.printTextForeground = true;
        options.printTextBackground = true;
        options.printTextFontStyle = true;
        options.printLineBackground = true;
        if (printer == null) {
            SWT.error((int)4);
        }
        return this.print(printer, options);
    }

    public Runnable print(Printer printer, StyledTextPrintOptions options) {
        this.checkWidget();
        if (printer == null || options == null) {
            SWT.error((int)4);
        }
        return new Printing(this, printer, options);
    }

    public void redraw() {
        super.redraw();
        int itemCount = this.getPartialBottomIndex() - this.topIndex + 1;
        this.lineCache.redrawReset(this.topIndex, itemCount, true);
        this.lineCache.calculate(this.topIndex, itemCount);
        this.setHorizontalScrollBar();
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, all);
        if (height > 0) {
            int lineCount = this.content.getLineCount();
            int startLine = (this.getTopPixel() + y) / this.lineHeight;
            int endLine = startLine + Compatibility.ceil((int)height, (int)this.lineHeight);
            startLine = Math.min(startLine, lineCount);
            int itemCount = Math.min(endLine, lineCount) - startLine;
            this.lineCache.reset(startLine, itemCount, true);
            itemCount = this.getPartialBottomIndex() - this.topIndex + 1;
            this.lineCache.calculate(this.topIndex, itemCount);
            this.setHorizontalScrollBar();
        }
    }

    void redrawLine(int line, int offset) {
        int redrawX = 0;
        if (offset > 0) {
            String lineText = this.content.getLine(line);
            redrawX = this.getXAtOffset(lineText, line, offset);
        }
        int redrawY = line * this.lineHeight - this.verticalScrollOffset;
        super.redraw(redrawX + this.leftMargin, redrawY + this.topMargin, this.getClientArea().width - this.leftMargin - this.rightMargin, this.lineHeight, true);
    }

    void redrawLines(int firstLine, int offsetInFirstLine, int lastLine, int endOffset, boolean clearBackground) {
        int offsetInLastLine;
        boolean fullLineRedraw;
        String line = this.content.getLine(firstLine);
        int lineCount = lastLine - firstLine + 1;
        int lineOffset = this.content.getOffsetAtLine(firstLine);
        Rectangle clientArea = this.getClientArea();
        boolean bl = fullLineRedraw = (this.getStyle() & 0x10000) != 0 && lastLine > firstLine;
        if (clearBackground && endOffset - lineOffset >= line.length()) {
            fullLineRedraw = true;
        }
        TextLayout layout = this.renderer.getTextLayout(line, lineOffset);
        Rectangle rect = layout.getBounds(offsetInFirstLine, Math.min(endOffset, line.length()) - 1);
        this.renderer.disposeTextLayout(layout);
        rect.x -= this.horizontalScrollOffset;
        rect.intersect(clientArea);
        int redrawY = firstLine * this.lineHeight - this.verticalScrollOffset;
        int redrawWidth = fullLineRedraw ? clientArea.width - this.leftMargin - this.rightMargin : rect.width;
        this.draw(rect.x, redrawY, redrawWidth, this.lineHeight, clearBackground);
        if (lineCount > 1 && (offsetInLastLine = endOffset - (lineOffset = this.content.getOffsetAtLine(lastLine))) > 0) {
            line = this.content.getLine(lastLine);
            if (clearBackground && offsetInLastLine >= line.length()) {
                fullLineRedraw = true;
            }
            line = this.content.getLine(lastLine);
            layout = this.renderer.getTextLayout(line, lineOffset);
            rect = layout.getBounds(0, offsetInLastLine - 1);
            this.renderer.disposeTextLayout(layout);
            rect.x -= this.horizontalScrollOffset;
            rect.intersect(clientArea);
            redrawY = lastLine * this.lineHeight - this.verticalScrollOffset;
            redrawWidth = fullLineRedraw ? clientArea.width - this.leftMargin - this.rightMargin : rect.width;
            this.draw(rect.x, redrawY, redrawWidth, this.lineHeight, clearBackground);
        }
    }

    void redrawMultiLineChange(int y, int newLineCount, int replacedLineCount) {
        int redrawHeight;
        int redrawStartY;
        int destinationY;
        int sourceY;
        Rectangle clientArea = this.getClientArea();
        int lineCount = newLineCount - replacedLineCount;
        if (lineCount > 0) {
            sourceY = Math.max(0, y + this.lineHeight);
            destinationY = sourceY + lineCount * this.lineHeight;
        } else {
            destinationY = Math.max(0, y + this.lineHeight);
            sourceY = destinationY - lineCount * this.lineHeight;
        }
        this.scroll(0, destinationY, 0, sourceY, clientArea.width, clientArea.height, true);
        if (y + this.lineHeight > 0 && y <= clientArea.height) {
            super.redraw(0, y, clientArea.width, this.lineHeight, true);
        }
        if (newLineCount > 0 && (redrawStartY = y + this.lineHeight) + (redrawHeight = newLineCount * this.lineHeight) > 0 && redrawStartY <= clientArea.height) {
            super.redraw(0, redrawStartY, clientArea.width, redrawHeight, true);
        }
    }

    public void redrawRange(int start, int length, boolean clearBackground) {
        this.checkWidget();
        int end = start + length;
        int contentLength = this.content.getCharCount();
        if (start > end || start < 0 || end > contentLength) {
            SWT.error((int)6);
        }
        int firstLine = this.content.getLineAtOffset(start);
        int lastLine = this.content.getLineAtOffset(end);
        this.lineCache.reset(firstLine, lastLine - firstLine + 1, true);
        this.internalRedrawRange(start, length, clearBackground);
    }

    public void removeBidiSegmentListener(BidiSegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(3007, (SWTEventListener)listener);
    }

    public void removeExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error((int)4);
        }
        this.removeListener(3000, (SWTEventListener)extendedModifyListener);
    }

    public void removeLineBackgroundListener(LineBackgroundListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(3001, (SWTEventListener)listener);
        if (!this.isListening(3001) && this.userLineBackground) {
            StyledTextListener typedListener = new StyledTextListener((SWTEventListener)this.defaultLineStyler);
            this.addListener(3001, (Listener)typedListener);
            this.userLineBackground = false;
        }
    }

    public void removeLineStyleListener(LineStyleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(3002, (SWTEventListener)listener);
        if (!this.isListening(3002) && this.userLineStyle) {
            StyledTextListener typedListener = new StyledTextListener((SWTEventListener)this.defaultLineStyler);
            this.addListener(3002, (Listener)typedListener);
            this.userLineStyle = false;
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)modifyListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error((int)4);
        }
        this.removeListener(25, (SWTEventListener)verifyListener);
    }

    public void removeVerifyKeyListener(VerifyKeyListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(3005, (SWTEventListener)listener);
    }

    public void replaceStyleRanges(int start, int length, StyleRange[] ranges) {
        this.checkWidget();
        if (this.userLineStyle) {
            return;
        }
        if (ranges == null) {
            SWT.error((int)4);
        }
        if (ranges.length == 0) {
            this.setStyleRange(new StyleRange(start, length, null, null));
            return;
        }
        int end = start + length;
        if (start > end || start < 0 || end > this.getCharCount()) {
            SWT.error((int)6);
        }
        int firstLine = this.content.getLineAtOffset(start);
        int lastLine = this.content.getLineAtOffset(end);
        this.defaultLineStyler.replaceStyleRanges(start, length, ranges);
        this.lineCache.reset(firstLine, lastLine - firstLine + 1, true);
        if (this.isAreaVisible(firstLine, lastLine)) {
            int redrawY = firstLine * this.lineHeight - this.verticalScrollOffset;
            int redrawStopY = (lastLine + 1) * this.lineHeight - this.verticalScrollOffset;
            this.draw(0, redrawY, this.getClientArea().width, redrawStopY - redrawY, true);
        }
        this.setCaretLocation();
    }

    public void replaceTextRange(int start, int length, String text) {
        this.checkWidget();
        int contentLength = this.getCharCount();
        int end = start + length;
        Event event = new Event();
        if (start > end || start < 0 || end > contentLength) {
            SWT.error((int)6);
        }
        if (text == null) {
            SWT.error((int)4);
        }
        event.start = start;
        event.end = end;
        event.text = text;
        this.modifyContent(event, false);
    }

    void reset() {
        ScrollBar verticalBar = this.getVerticalBar();
        ScrollBar horizontalBar = this.getHorizontalBar();
        this.caretOffset = 0;
        this.topIndex = 0;
        this.topOffset = 0;
        this.verticalScrollOffset = 0;
        this.horizontalScrollOffset = 0;
        this.resetSelection();
        if (this.defaultLineStyler != null) {
            this.removeLineBackgroundListener((LineBackgroundListener)this.defaultLineStyler);
            this.removeLineStyleListener((LineStyleListener)this.defaultLineStyler);
            this.installDefaultLineStyler();
        }
        this.calculateContentWidth();
        if (verticalBar != null) {
            verticalBar.setSelection(0);
        }
        if (horizontalBar != null) {
            horizontalBar.setSelection(0);
        }
        this.setScrollBars();
        this.setCaretLocation();
        super.redraw();
    }

    void resetSelection() {
        this.selection.x = this.selection.y = this.caretOffset;
        this.selectionAnchor = -1;
    }

    void scrollHorizontal(int pixels) {
        if (pixels == 0) {
            return;
        }
        Rectangle clientArea = this.getClientArea();
        if (pixels > 0) {
            int sourceX = this.leftMargin + pixels;
            int scrollWidth = clientArea.width - sourceX - this.rightMargin;
            int scrollHeight = clientArea.height - this.topMargin - this.bottomMargin;
            this.scroll(this.leftMargin, this.topMargin, sourceX, this.topMargin, scrollWidth, scrollHeight, true);
            if (sourceX > scrollWidth) {
                super.redraw(this.leftMargin + scrollWidth, this.topMargin, pixels - scrollWidth, scrollHeight, true);
            }
        } else {
            int destinationX = this.leftMargin - pixels;
            int scrollWidth = clientArea.width - destinationX - this.rightMargin;
            int scrollHeight = clientArea.height - this.topMargin - this.bottomMargin;
            this.scroll(destinationX, this.topMargin, this.leftMargin, this.topMargin, scrollWidth, scrollHeight, true);
            if (destinationX > scrollWidth) {
                super.redraw(this.leftMargin + scrollWidth, this.topMargin, -pixels - scrollWidth, scrollHeight, true);
            }
        }
        this.horizontalScrollOffset += pixels;
        int oldColumnX = this.columnX - pixels;
        this.setCaretLocation();
        this.columnX = oldColumnX;
    }

    boolean scrollHorizontalBar(int pixels) {
        if (pixels == 0) {
            return false;
        }
        ScrollBar horizontalBar = this.getHorizontalBar();
        if (horizontalBar != null) {
            horizontalBar.setSelection(this.horizontalScrollOffset + pixels);
        }
        this.scrollHorizontal(pixels);
        return true;
    }

    public void selectAll() {
        this.checkWidget();
        this.setSelection(0, Math.max(this.getCharCount(), 0));
    }

    void sendKeyEvent(Event event) {
        if (!this.editable) {
            return;
        }
        this.modifyContent(event, true);
    }

    void sendModifyEvent(Event event) {
        Accessible accessible = this.getAccessible();
        if (event.text.length() == 0) {
            accessible.textChanged(1, event.start, event.end - event.start);
        } else if (event.start == event.end) {
            accessible.textChanged(0, event.start, event.text.length());
        } else {
            accessible.textChanged(1, event.start, event.end - event.start);
            accessible.textChanged(0, event.start, event.text.length());
        }
        this.notifyListeners(24, event);
    }

    void sendSelectionEvent() {
        this.getAccessible().textSelectionChanged();
        Event event = new Event();
        event.x = this.selection.x;
        event.y = this.selection.y;
        this.notifyListeners(13, event);
    }

    public void setWordWrap(boolean wrap) {
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        if (wrap != this.wordWrap) {
            ScrollBar horizontalBar = this.getHorizontalBar();
            this.wordWrap = wrap;
            if (this.wordWrap) {
                this.logicalContent = this.content;
                this.content = new WrappedContent((StyledTextRenderer)this.renderer, this.logicalContent);
            } else {
                this.content = this.logicalContent;
            }
            this.calculateContentWidth();
            this.horizontalScrollOffset = 0;
            if (horizontalBar != null) {
                horizontalBar.setVisible(!this.wordWrap);
            }
            this.setScrollBars();
            this.setCaretLocation();
            super.redraw();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        super.setCaret(caret);
        this.caretDirection = 0;
        if (caret != null) {
            this.setCaretLocation();
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.background = color;
        super.setBackground(this.getBackground());
        this.redraw();
    }

    public void setBidiColoring(boolean mode) {
        this.checkWidget();
        this.bidiColoring = mode;
    }

    void setCaretLocation(int newCaretX, int line, int direction) {
        Caret caret = this.getCaret();
        if (caret != null) {
            boolean updateImage = caret == this.defaultCaret;
            int imageDirection = direction;
            if (this.isMirrored()) {
                if (imageDirection == 16384) {
                    imageDirection = 131072;
                } else if (imageDirection == 131072) {
                    imageDirection = 16384;
                }
            }
            if (updateImage && imageDirection == 131072) {
                newCaretX -= caret.getSize().x - 1;
            }
            int newCaretY = line * this.lineHeight - this.verticalScrollOffset + this.topMargin;
            caret.setLocation(newCaretX, newCaretY);
            this.getAccessible().textCaretMoved(this.getCaretOffset());
            if (direction != this.caretDirection) {
                this.caretDirection = direction;
                if (updateImage) {
                    if (imageDirection == -1) {
                        this.defaultCaret.setImage(null);
                    } else if (imageDirection == 16384) {
                        this.defaultCaret.setImage(this.leftCaretBitmap);
                    } else if (imageDirection == 131072) {
                        this.defaultCaret.setImage(this.rightCaretBitmap);
                    }
                }
                caret.setSize(caret.getSize().x, this.lineHeight);
                if (this.caretDirection == 16384) {
                    BidiUtil.setKeyboardLanguage((int)0);
                } else if (this.caretDirection == 131072) {
                    BidiUtil.setKeyboardLanguage((int)1);
                }
            }
        }
        this.columnX = newCaretX;
    }

    void setCaretLocation() {
        int lineIndex = this.getCaretLine();
        String line = this.content.getLine(lineIndex);
        int lineOffset = this.content.getOffsetAtLine(lineIndex);
        int offsetInLine = this.caretOffset - lineOffset;
        int newCaretX = this.getXAtOffset(line, lineIndex, offsetInLine);
        this.setCaretLocation(newCaretX, lineIndex, this.getCaretDirection());
    }

    public void setCaretOffset(int offset) {
        this.checkWidget();
        int length = this.getCharCount();
        if (length > 0 && offset != this.caretOffset) {
            if (offset < 0) {
                this.caretOffset = 0;
            } else if (offset > length) {
                this.caretOffset = length;
            } else {
                if (this.isLineDelimiter(offset)) {
                    SWT.error((int)5);
                }
                this.caretOffset = offset;
            }
            this.clearSelection(false);
        }
        this.setCaretLocation();
    }

    void setClipboardContent(int start, int length, int clipboardType) throws SWTError {
        Transfer[] types;
        Object[] data;
        if (clipboardType == 2 && !IS_MOTIF && !IS_GTK) {
            return;
        }
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        TextWriter plainTextWriter = new TextWriter(start, length);
        String plainText = this.getPlatformDelimitedText(plainTextWriter);
        if (clipboardType == 2) {
            data = new Object[]{plainText};
            types = new Transfer[]{plainTextTransfer};
        } else {
            RTFTransfer rtfTransfer = RTFTransfer.getInstance();
            RTFWriter rtfWriter = new RTFWriter(start, length);
            String rtfText = this.getPlatformDelimitedText(rtfWriter);
            data = new Object[]{rtfText, plainText};
            types = new Transfer[]{rtfTransfer, plainTextTransfer};
        }
        this.clipboard.setContents(data, types, clipboardType);
    }

    public void setContent(StyledTextContent newContent) {
        this.checkWidget();
        if (newContent == null) {
            SWT.error((int)4);
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
        }
        this.logicalContent = newContent;
        this.content = this.wordWrap ? new WrappedContent((StyledTextRenderer)this.renderer, this.logicalContent) : this.logicalContent;
        this.content.addTextChangeListener(this.textChangeListener);
        this.reset();
    }

    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            super.setCursor(this.ibeamCursor);
        } else {
            super.setCursor(cursor);
        }
    }

    public void setDoubleClickEnabled(boolean enable) {
        this.checkWidget();
        this.doubleClickEnabled = enable;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.editable = editable;
    }

    public void setFont(Font font) {
        this.checkWidget();
        int oldLineHeight = this.lineHeight;
        super.setFont(font);
        this.initializeRenderer();
        if (this.lineHeight != oldLineHeight) {
            this.setVerticalScrollOffset(this.verticalScrollOffset * this.lineHeight / oldLineHeight, true);
            this.claimBottomFreeSpace();
        }
        this.calculateContentWidth();
        this.calculateScrollBars();
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
        }
        this.caretDirection = 0;
        this.setCaretLocation();
        super.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.foreground = color;
        super.setForeground(this.getForeground());
        this.redraw();
    }

    public void setHorizontalIndex(int offset) {
        int width;
        this.checkWidget();
        int clientAreaWidth = this.getClientArea().width;
        if (this.getCharCount() == 0) {
            return;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (clientAreaWidth > 0 && (offset *= this.getHorizontalIncrement()) > (width = this.lineCache.getWidth()) - clientAreaWidth) {
            offset = Math.max(0, width - clientAreaWidth);
        }
        this.scrollHorizontalBar(offset - this.horizontalScrollOffset);
    }

    public void setHorizontalPixel(int pixel) {
        int width;
        this.checkWidget();
        int clientAreaWidth = this.getClientArea().width;
        if (this.getCharCount() == 0) {
            return;
        }
        if (pixel < 0) {
            pixel = 0;
        }
        if (clientAreaWidth > 0 && pixel > (width = this.lineCache.getWidth()) - clientAreaWidth) {
            pixel = Math.max(0, width - clientAreaWidth);
        }
        this.scrollHorizontalBar(pixel - this.horizontalScrollOffset);
    }

    void setHorizontalScrollBar() {
        ScrollBar horizontalBar = this.getHorizontalBar();
        if (horizontalBar != null && horizontalBar.getVisible()) {
            boolean INACTIVE = true;
            Rectangle clientArea = this.getClientArea();
            if (clientArea.width < this.lineCache.getWidth()) {
                horizontalBar.setValues(horizontalBar.getSelection(), horizontalBar.getMinimum(), this.lineCache.getWidth(), clientArea.width - this.leftMargin - this.rightMargin, horizontalBar.getIncrement(), clientArea.width - this.leftMargin - this.rightMargin);
            } else if (horizontalBar.getThumb() != 1 || horizontalBar.getMaximum() != 1) {
                horizontalBar.setValues(horizontalBar.getSelection(), horizontalBar.getMinimum(), 1, 1, horizontalBar.getIncrement(), 1);
            }
        }
    }

    public void setLineBackground(int startLine, int lineCount, Color background) {
        this.checkWidget();
        int partialBottomIndex = this.getPartialBottomIndex();
        if (this.userLineBackground) {
            return;
        }
        if (startLine < 0 || startLine + lineCount > this.logicalContent.getLineCount()) {
            SWT.error((int)5);
        }
        this.defaultLineStyler.setLineBackground(startLine, lineCount, background);
        if (startLine > partialBottomIndex || startLine + lineCount - 1 < this.topIndex) {
            return;
        }
        if (startLine < this.topIndex) {
            lineCount -= this.topIndex - startLine;
            startLine = this.topIndex;
        }
        if (startLine + lineCount - 1 > partialBottomIndex) {
            lineCount = partialBottomIndex - startLine + 1;
        }
        super.redraw(this.leftMargin, (startLine -= this.topIndex) * this.lineHeight + this.topMargin, this.getClientArea().width - this.leftMargin - this.rightMargin, lineCount * this.lineHeight, true);
    }

    void setMouseWordSelectionAnchor() {
        if (!this.mouseDoubleClick) {
            return;
        }
        if (this.caretOffset < this.doubleClickSelection.x) {
            this.selectionAnchor = this.doubleClickSelection.y;
        } else if (this.caretOffset > this.doubleClickSelection.y) {
            this.selectionAnchor = this.doubleClickSelection.x;
        }
    }

    public void setOrientation(int orientation) {
        if ((orientation & 0x6000000) == 0) {
            return;
        }
        if ((orientation & 0x4000000) != 0 && (orientation & 0x2000000) != 0) {
            return;
        }
        if ((orientation & 0x4000000) != 0 && this.isMirrored()) {
            return;
        }
        if ((orientation & 0x2000000) != 0 && !this.isMirrored()) {
            return;
        }
        if (!BidiUtil.setOrientation((int)this.handle, (int)orientation)) {
            return;
        }
        this.isMirrored = (orientation & 0x4000000) != 0;
        this.initializeRenderer();
        this.caretDirection = 0;
        this.setCaretLocation();
        this.keyActionMap.clear();
        this.createKeyBindings();
        super.redraw();
    }

    void setScrollBars() {
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null) {
            Rectangle clientArea = this.getClientArea();
            boolean INACTIVE = true;
            int maximum = this.content.getLineCount() * this.getVerticalIncrement();
            if (clientArea.height < maximum) {
                verticalBar.setValues(verticalBar.getSelection(), verticalBar.getMinimum(), maximum, clientArea.height, verticalBar.getIncrement(), clientArea.height);
            } else if (verticalBar.getThumb() != 1 || verticalBar.getMaximum() != 1) {
                verticalBar.setValues(verticalBar.getSelection(), verticalBar.getMinimum(), 1, 1, verticalBar.getIncrement(), 1);
            }
        }
        this.setHorizontalScrollBar();
    }

    public void setSelection(int start) {
        this.setSelection(start, start);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.selectionBackground = color;
        this.redraw();
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.selectionForeground = color;
        this.redraw();
    }

    public void setSelection(int start, int end) {
        this.setSelectionRange(start, end - start);
        this.showSelection();
    }

    public void setSelectionRange(int start, int length) {
        this.checkWidget();
        int contentLength = this.getCharCount();
        start = Math.max(0, Math.min(start, contentLength));
        int end = start + length;
        if (end < 0) {
            length = -start;
        } else if (end > contentLength) {
            length = contentLength - start;
        }
        if (this.isLineDelimiter(start) || this.isLineDelimiter(start + length)) {
            SWT.error((int)5);
        }
        this.internalSetSelection(start, length, false);
        this.setCaretLocation();
    }

    void internalSetSelection(int start, int length, boolean sendEvent) {
        int end = start + length;
        if (start > end) {
            int temp = end;
            end = start;
            start = temp;
        }
        if (this.selection.x != start || this.selection.y != end || length > 0 && this.selectionAnchor != this.selection.x || length < 0 && this.selectionAnchor != this.selection.y) {
            this.clearSelection(sendEvent);
            if (length < 0) {
                this.selectionAnchor = this.selection.y = end;
                this.caretOffset = this.selection.x = start;
            } else {
                this.selectionAnchor = this.selection.x = start;
                this.caretOffset = this.selection.y = end;
            }
            this.internalRedrawRange(this.selection.x, this.selection.y - this.selection.x, true);
        }
    }

    public void setStyleRange(StyleRange range) {
        this.checkWidget();
        if (this.userLineStyle) {
            return;
        }
        if (range != null && range.start + range.length > this.content.getCharCount()) {
            SWT.error((int)6);
        }
        this.defaultLineStyler.setStyleRange(range);
        if (range != null) {
            int firstLine = this.content.getLineAtOffset(range.start);
            int lastLine = this.content.getLineAtOffset(range.start + range.length);
            this.lineCache.reset(firstLine, lastLine - firstLine + 1, true);
            if (this.isAreaVisible(firstLine, lastLine)) {
                int redrawY = firstLine * this.lineHeight - this.verticalScrollOffset;
                int redrawStopY = (lastLine + 1) * this.lineHeight - this.verticalScrollOffset;
                this.draw(0, redrawY, this.getClientArea().width, redrawStopY - redrawY, true);
            }
        } else {
            this.lineCache.reset(0, this.content.getLineCount(), false);
            this.redraw();
        }
        this.setCaretLocation();
    }

    public void setStyleRanges(StyleRange[] ranges) {
        this.checkWidget();
        if (this.userLineStyle) {
            return;
        }
        if (ranges == null) {
            SWT.error((int)4);
        }
        if (ranges.length != 0) {
            StyleRange last = ranges[ranges.length - 1];
            int lastEnd = last.start + last.length;
            int firstLine = this.content.getLineAtOffset(ranges[0].start);
            if (lastEnd > this.content.getCharCount()) {
                SWT.error((int)6);
            }
            int lastLine = this.content.getLineAtOffset(lastEnd);
            this.lineCache.reset(firstLine, lastLine - firstLine + 1, true);
        } else {
            this.lineCache.reset(0, this.content.getLineCount(), false);
        }
        this.defaultLineStyler.setStyleRanges(ranges);
        this.redraw();
        this.setCaretLocation();
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        this.tabLength = tabs;
        this.renderer.setTabLength(this.tabLength);
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.showCaret();
            this.clearSelection(false);
        }
        this.lineCache.reset(0, this.content.getLineCount(), false);
        this.redraw();
    }

    public void setText(String text) {
        this.checkWidget();
        Event event = new Event();
        if (text == null) {
            SWT.error((int)4);
        }
        event.start = 0;
        event.end = this.getCharCount();
        event.text = text;
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.logicalContent);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, event.end - event.start);
            }
            this.content.setText(event.text);
            this.sendModifyEvent(event);
            if (styledTextEvent != null) {
                this.notifyListeners(3000, (Event)styledTextEvent);
            }
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            SWT.error((int)7);
        }
        this.textLimit = limit;
    }

    public void setTopIndex(int topIndex) {
        this.checkWidget();
        int lineCount = this.logicalContent.getLineCount();
        int pageSize = Math.max(1, Math.min(lineCount, this.getLineCountWhole()));
        if (this.getCharCount() == 0) {
            return;
        }
        if (topIndex < 0) {
            topIndex = 0;
        } else if (topIndex > lineCount - pageSize) {
            topIndex = lineCount - pageSize;
        }
        if (this.wordWrap) {
            int logicalLineOffset = this.logicalContent.getOffsetAtLine(topIndex);
            topIndex = this.content.getLineAtOffset(logicalLineOffset);
        }
        this.setVerticalScrollOffset(topIndex * this.getVerticalIncrement(), true);
    }

    public void setTopPixel(int pixel) {
        this.checkWidget();
        int lineCount = this.content.getLineCount();
        int height = this.getClientArea().height;
        int maxTopPixel = Math.max(0, lineCount * this.getVerticalIncrement() - height);
        if (this.getCharCount() == 0) {
            return;
        }
        if (pixel < 0) {
            pixel = 0;
        } else if (pixel > maxTopPixel) {
            pixel = maxTopPixel;
        }
        this.setVerticalScrollOffset(pixel, true);
    }

    boolean setVerticalScrollOffset(int pixelOffset, boolean adjustScrollBar) {
        ScrollBar verticalBar = this.getVerticalBar();
        if (pixelOffset == this.verticalScrollOffset) {
            return false;
        }
        if (verticalBar != null && adjustScrollBar) {
            verticalBar.setSelection(pixelOffset);
        }
        Rectangle clientArea = this.getClientArea();
        this.scroll(0, 0, 0, pixelOffset - this.verticalScrollOffset, clientArea.width, clientArea.height, true);
        this.verticalScrollOffset = pixelOffset;
        this.calculateTopIndex();
        int oldColumnX = this.columnX;
        this.setCaretLocation();
        this.columnX = oldColumnX;
        return true;
    }

    boolean showLocation(int x, int line) {
        int clientAreaWidth = this.getClientArea().width - this.leftMargin;
        int verticalIncrement = this.getVerticalIncrement();
        int horizontalIncrement = clientAreaWidth / 4;
        boolean scrolled = false;
        if (x < this.leftMargin) {
            x = Math.max(this.horizontalScrollOffset * -1, x - horizontalIncrement);
            scrolled = this.scrollHorizontalBar(x);
        } else if (x >= clientAreaWidth) {
            x = Math.min(this.lineCache.getWidth() - this.horizontalScrollOffset, x + horizontalIncrement);
            scrolled = this.scrollHorizontalBar(x - clientAreaWidth);
        }
        if (line < this.topIndex) {
            scrolled = this.setVerticalScrollOffset(line * verticalIncrement, true);
        } else if (line > this.getBottomIndex()) {
            scrolled = this.setVerticalScrollOffset((line + 1) * verticalIncrement - this.getClientArea().height, true);
        }
        return scrolled;
    }

    void showCaret() {
        int caretLine = this.content.getLineAtOffset(this.caretOffset);
        this.showCaret(caretLine);
    }

    void showCaret(int caretLine) {
        int caretY;
        int lineOffset = this.content.getOffsetAtLine(caretLine);
        String line = this.content.getLine(caretLine);
        int offsetInLine = this.caretOffset - lineOffset;
        int newCaretX = this.getXAtOffset(line, caretLine, offsetInLine);
        boolean scrolled = this.showLocation(newCaretX, caretLine);
        boolean setWrapCaretLocation = false;
        Caret caret = this.getCaret();
        if (this.wordWrap && caret != null && ((caretY = caret.getLocation().y) + this.verticalScrollOffset) / this.getVerticalIncrement() - 1 != caretLine) {
            setWrapCaretLocation = true;
        }
        if (!scrolled || setWrapCaretLocation) {
            this.setCaretLocation(newCaretX, caretLine, this.getCaretDirection());
        }
    }

    void showOffset(int offset) {
        int line = this.content.getLineAtOffset(offset);
        int lineOffset = this.content.getOffsetAtLine(line);
        int offsetInLine = offset - lineOffset;
        String lineText = this.content.getLine(line);
        int xAtOffset = this.getXAtOffset(lineText, line, offsetInLine);
        this.showLocation(xAtOffset, line);
    }

    public void showSelection() {
        boolean selectionFits;
        int endOffset;
        int startOffset;
        boolean rightToLeft;
        this.checkWidget();
        boolean bl = rightToLeft = this.caretOffset == this.selection.x;
        if (rightToLeft) {
            startOffset = this.selection.y;
            endOffset = this.selection.x;
        } else {
            startOffset = this.selection.x;
            endOffset = this.selection.y;
        }
        int startLine = this.content.getLineAtOffset(startOffset);
        int offsetInLine = startOffset - this.content.getOffsetAtLine(startLine);
        int startX = this.getXAtOffset(this.content.getLine(startLine), startLine, offsetInLine);
        int endLine = this.content.getLineAtOffset(endOffset);
        offsetInLine = endOffset - this.content.getOffsetAtLine(endLine);
        int endX = this.getXAtOffset(this.content.getLine(endLine), endLine, offsetInLine);
        int w = this.getClientArea().width;
        if (rightToLeft) {
            selectionFits = startX - endX <= w;
        } else {
            boolean bl2 = selectionFits = endX - startX <= w;
        }
        if (selectionFits) {
            this.showLocation(startX, startLine);
            endX = this.getXAtOffset(this.content.getLine(endLine), endLine, offsetInLine);
            this.showLocation(endX, endLine);
        } else {
            this.showLocation(endX, endLine);
        }
    }

    boolean isBidiCaret() {
        return BidiUtil.isBidiPlatform();
    }

    void updateSelection(int startOffset, int replacedLength, int newLength) {
        if (this.selection.y <= startOffset) {
            return;
        }
        if (this.selection.x < startOffset) {
            this.internalRedrawRange(this.selection.x, startOffset - this.selection.x, true);
        }
        if (this.selection.y > startOffset + replacedLength && this.selection.x < startOffset + replacedLength) {
            int netNewLength = newLength - replacedLength;
            int redrawStart = startOffset + newLength;
            this.internalRedrawRange(redrawStart, this.selection.y + netNewLength - redrawStart, true);
        }
        if (this.selection.y > startOffset && this.selection.x < startOffset + replacedLength) {
            this.internalSetSelection(startOffset + newLength, 0, true);
            this.setCaretLocation();
        } else {
            this.internalSetSelection(this.selection.x + newLength - replacedLength, this.selection.y - this.selection.x, true);
            this.setCaretLocation();
        }
    }

    void wordWrapResize(int oldClientAreaWidth) {
        WrappedContent wrappedContent = (WrappedContent)this.content;
        if (oldClientAreaWidth != 0 && this.clientAreaWidth > oldClientAreaWidth && wrappedContent.getLineCount() == this.logicalContent.getLineCount()) {
            return;
        }
        wrappedContent.wrapLines();
        int newTopIndex = this.content.getLineAtOffset(this.topOffset);
        if (newTopIndex < this.content.getLineCount() - 1 && this.topOffset == this.content.getOffsetAtLine(newTopIndex + 1)) {
            ++newTopIndex;
        }
        if (newTopIndex != this.topIndex) {
            ScrollBar verticalBar = this.getVerticalBar();
            this.verticalScrollOffset += (newTopIndex - this.topIndex) * this.getVerticalIncrement();
            if (this.verticalScrollOffset < 0) {
                this.verticalScrollOffset = 0;
            }
            this.topIndex = newTopIndex;
            this.topOffset = this.content.getOffsetAtLine(this.topIndex);
            if (verticalBar != null) {
                verticalBar.setSelection(this.verticalScrollOffset);
            }
        }
        this.setCaretLocation();
        super.redraw();
    }

    static class Printing
    implements Runnable {
        static final int LEFT = 0;
        static final int CENTER = 1;
        static final int RIGHT = 2;
        StyledText parent;
        Printer printer;
        PrintRenderer renderer;
        StyledTextPrintOptions printOptions;
        StyledTextContent printerContent;
        Rectangle clientArea;
        Font printerFont;
        FontData displayFontData;
        Hashtable printerColors;
        Hashtable lineBackgrounds = new Hashtable();
        Hashtable lineStyles = new Hashtable();
        Hashtable bidiSegments = new Hashtable();
        GC gc;
        int pageWidth;
        int startPage;
        int endPage;
        int pageSize;
        int startLine;
        int endLine;
        boolean singleLine;
        Point selection = null;
        boolean mirrored;

        Printing(StyledText parent, Printer printer, StyledTextPrintOptions printOptions) {
            PrinterData data = printer.getPrinterData();
            this.parent = parent;
            this.printer = printer;
            this.printOptions = printOptions;
            this.mirrored = (parent.getStyle() & 0x8000000) != 0;
            this.singleLine = parent.isSingleLine();
            this.startPage = 1;
            this.endPage = Integer.MAX_VALUE;
            if (data.scope == 1) {
                this.startPage = data.startPage;
                this.endPage = data.endPage;
                if (this.endPage < this.startPage) {
                    int temp = this.endPage;
                    this.endPage = this.startPage;
                    this.startPage = temp;
                }
            } else if (data.scope == 2) {
                this.selection = parent.getSelectionRange();
            }
            this.displayFontData = parent.getFont().getFontData()[0];
            this.copyContent(parent.getContent());
            this.cacheLineData(this.printerContent);
        }

        void cacheBidiSegments(int lineOffset, String line) {
            int[] segments = this.parent.getBidiSegments(lineOffset, line);
            if (segments != null) {
                this.bidiSegments.put(new Integer(lineOffset), segments);
            }
        }

        void cacheLineBackground(int lineOffset, String line) {
            StyledTextEvent event = this.parent.getLineBackgroundData(lineOffset, line);
            if (event != null) {
                this.lineBackgrounds.put(new Integer(lineOffset), event);
            }
        }

        void cacheLineData(StyledTextContent printerContent) {
            int i = 0;
            while (i < printerContent.getLineCount()) {
                int lineOffset = printerContent.getOffsetAtLine(i);
                String line = printerContent.getLine(i);
                if (this.printOptions.printLineBackground) {
                    this.cacheLineBackground(lineOffset, line);
                }
                if (this.printOptions.printTextBackground || this.printOptions.printTextForeground || this.printOptions.printTextFontStyle) {
                    this.cacheLineStyle(lineOffset, line);
                }
                if (this.parent.isBidi()) {
                    this.cacheBidiSegments(lineOffset, line);
                }
                ++i;
            }
        }

        void cacheLineStyle(int lineOffset, String line) {
            StyledTextEvent event = this.parent.getLineStyleData(lineOffset, line);
            if (event != null) {
                StyleRange[] styles = event.styles;
                int i = 0;
                while (i < styles.length) {
                    StyleRange styleCopy = null;
                    if (!this.printOptions.printTextBackground && styles[i].background != null) {
                        styleCopy = (StyleRange)styles[i].clone();
                        styleCopy.background = null;
                    }
                    if (!this.printOptions.printTextForeground && styles[i].foreground != null) {
                        if (styleCopy == null) {
                            styleCopy = (StyleRange)styles[i].clone();
                        }
                        styleCopy.foreground = null;
                    }
                    if (!this.printOptions.printTextFontStyle && styles[i].fontStyle != 0) {
                        if (styleCopy == null) {
                            styleCopy = (StyleRange)styles[i].clone();
                        }
                        styleCopy.fontStyle = 0;
                    }
                    if (styleCopy != null) {
                        styles[i] = styleCopy;
                    }
                    ++i;
                }
                this.lineStyles.put(new Integer(lineOffset), event);
            }
        }

        void copyContent(StyledTextContent original) {
            int insertOffset = 0;
            this.printerContent = new DefaultContent();
            int i = 0;
            while (i < original.getLineCount()) {
                int insertEndOffset = i < original.getLineCount() - 1 ? original.getOffsetAtLine(i + 1) : original.getCharCount();
                this.printerContent.replaceTextRange(insertOffset, 0, original.getTextRange(insertOffset, insertEndOffset - insertOffset));
                insertOffset = insertEndOffset;
                ++i;
            }
        }

        void createPrinterColors() {
            StyledTextEvent event;
            Enumeration values = this.lineBackgrounds.elements();
            this.printerColors = new Hashtable();
            while (values.hasMoreElements()) {
                event = (StyledTextEvent)values.nextElement();
                event.lineBackground = this.getPrinterColor(event.lineBackground);
            }
            values = this.lineStyles.elements();
            while (values.hasMoreElements()) {
                event = (StyledTextEvent)values.nextElement();
                int i = 0;
                while (i < event.styles.length) {
                    StyleRange style = event.styles[i];
                    Color printerBackground = this.getPrinterColor(style.background);
                    Color printerForeground = this.getPrinterColor(style.foreground);
                    if (printerBackground != style.background || printerForeground != style.foreground) {
                        style = (StyleRange)style.clone();
                        style.background = printerBackground;
                        style.foreground = printerForeground;
                        event.styles[i] = style;
                    }
                    ++i;
                }
            }
        }

        void dispose() {
            if (this.printerColors != null) {
                Enumeration colors = this.printerColors.elements();
                while (colors.hasMoreElements()) {
                    Color color = (Color)colors.nextElement();
                    color.dispose();
                }
                this.printerColors = null;
            }
            if (this.gc != null) {
                this.gc.dispose();
                this.gc = null;
            }
            if (this.printerFont != null) {
                this.printerFont.dispose();
                this.printerFont = null;
            }
            if (this.renderer != null) {
                this.renderer.dispose();
                this.renderer = null;
            }
        }

        void endPage(int page) {
            this.printDecoration(page, false);
            this.printer.endPage();
        }

        void initializeRenderer() {
            Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
            Point dpi = this.printer.getDPI();
            this.printerFont = new Font((Device)this.printer, this.displayFontData.getName(), this.displayFontData.getHeight(), 0);
            this.clientArea = this.printer.getClientArea();
            this.pageWidth = this.clientArea.width;
            this.clientArea.x = dpi.x + trim.x;
            this.clientArea.y = dpi.y + trim.y;
            this.clientArea.width -= this.clientArea.x + trim.width;
            this.clientArea.height -= this.clientArea.y + trim.height;
            int style = this.mirrored ? 0x4000000 : 0x2000000;
            this.gc = new GC((Drawable)this.printer, style);
            this.gc.setFont(this.printerFont);
            this.renderer = new PrintRenderer((Device)this.printer, this.printerFont, this.gc, this.printerContent, this.lineBackgrounds, this.lineStyles, this.bidiSegments, this.parent.tabLength, this.clientArea);
            if (this.printOptions.header != null) {
                int lineHeight = this.renderer.getLineHeight();
                this.clientArea.y += lineHeight * 2;
                this.clientArea.height -= lineHeight * 2;
            }
            if (this.printOptions.footer != null) {
                this.clientArea.height -= this.renderer.getLineHeight() * 2;
            }
            this.pageSize = this.clientArea.height / this.renderer.getLineHeight();
            StyledTextContent content = this.renderer.getContent();
            this.startLine = 0;
            this.endLine = this.singleLine ? 0 : content.getLineCount() - 1;
            PrinterData data = this.printer.getPrinterData();
            if (data.scope == 1) {
                this.startLine = (this.startPage - 1) * this.pageSize;
            } else if (data.scope == 2) {
                this.startLine = content.getLineAtOffset(this.selection.x);
                this.endLine = this.selection.y > 0 ? content.getLineAtOffset(this.selection.x + this.selection.y - 1) : this.startLine - 1;
            }
        }

        Color getPrinterColor(Color color) {
            Color printerColor = null;
            if (color != null && (printerColor = (Color)this.printerColors.get(color)) == null) {
                printerColor = new Color((Device)this.printer, color.getRGB());
                this.printerColors.put(color, printerColor);
            }
            return printerColor;
        }

        void print() {
            StyledTextContent content = this.renderer.getContent();
            Color background = this.gc.getBackground();
            Color foreground = this.gc.getForeground();
            int lineHeight = this.renderer.getLineHeight();
            int paintY = this.clientArea.y;
            int page = this.startPage;
            int i = this.startLine;
            while (i <= this.endLine && page <= this.endPage) {
                String line = content.getLine(i);
                if (paintY == this.clientArea.y) {
                    this.startPage(page);
                }
                TextLayout.ControlCharRenderer ccRender = TextLayout.NullControlCharRenderer.getInstance();
                this.renderer.drawLine(line, i, paintY, this.gc, background, foreground, true, ccRender);
                if (paintY + lineHeight * 2 > this.clientArea.y + this.clientArea.height) {
                    this.endPage(page);
                    paintY = this.clientArea.y - lineHeight;
                    ++page;
                }
                ++i;
                paintY += lineHeight;
            }
            if (paintY > this.clientArea.y) {
                this.endPage(page);
            }
        }

        void printDecoration(int page, boolean header) {
            int lastSegmentIndex = 0;
            int SegmentCount = 3;
            String text = header ? this.printOptions.header : this.printOptions.footer;
            if (text == null) {
                return;
            }
            int i = 0;
            while (i < 3) {
                String segment;
                int segmentIndex = text.indexOf("\t", lastSegmentIndex);
                if (segmentIndex == -1) {
                    segment = text.substring(lastSegmentIndex);
                    this.printDecorationSegment(segment, i, page, header);
                    break;
                }
                segment = text.substring(lastSegmentIndex, segmentIndex);
                this.printDecorationSegment(segment, i, page, header);
                lastSegmentIndex = segmentIndex + "\t".length();
                ++i;
            }
        }

        void printDecorationSegment(String segment, int alignment, int page, boolean header) {
            int pageIndex = segment.indexOf("<page>");
            if (pageIndex != -1) {
                int PageTagLength = "<page>".length();
                StringBuffer buffer = new StringBuffer(segment.substring(0, pageIndex));
                buffer.append(page);
                buffer.append(segment.substring(pageIndex + PageTagLength));
                segment = buffer.toString();
            }
            if (segment.length() > 0) {
                int drawX = 0;
                int drawY = 0;
                TextLayout layout = new TextLayout((Device)this.printer);
                layout.setText(segment);
                layout.setFont(this.printerFont);
                int segmentWidth = layout.getLineBounds((int)0).width;
                drawY = header ? this.clientArea.y - this.renderer.getLineHeight() * 2 : this.clientArea.y + this.clientArea.height + this.renderer.getLineHeight();
                if (alignment == 0) {
                    drawX = this.clientArea.x;
                } else if (alignment == 1) {
                    drawX = (this.pageWidth - segmentWidth) / 2;
                } else if (alignment == 2) {
                    drawX = this.clientArea.x + this.clientArea.width - segmentWidth;
                }
                TextLayout.ControlCharRenderer ccRender = TextLayout.NullControlCharRenderer.getInstance();
                layout.draw(this.gc, drawX, drawY, ccRender);
                layout.dispose();
            }
        }

        public void run() {
            String jobName = this.printOptions.jobName;
            if (jobName == null) {
                jobName = "Printing";
            }
            if (this.printer.startJob(jobName)) {
                this.createPrinterColors();
                this.initializeRenderer();
                this.print();
                this.dispose();
                this.printer.endJob();
            }
        }

        void startPage(int page) {
            this.printer.startPage();
            this.printDecoration(page, true);
        }
    }

    class RTFWriter
    extends TextWriter {
        static final int DEFAULT_FOREGROUND = 0;
        static final int DEFAULT_BACKGROUND = 1;
        Vector colorTable = new Vector();
        boolean WriteUnicode;

        public RTFWriter(int start, int length) {
            super(start, length);
            this.colorTable.addElement(StyledText.this.getForeground());
            this.colorTable.addElement(StyledText.this.getBackground());
            this.setUnicode();
        }

        public void close() {
            if (!this.isClosed()) {
                this.writeHeader();
                this.write("\n}}\u0000");
                super.close();
            }
        }

        int getColorIndex(Color color, int defaultIndex) {
            int index;
            if (color == null) {
                index = defaultIndex;
            } else {
                index = this.colorTable.indexOf(color);
                if (index == -1) {
                    index = this.colorTable.size();
                    this.colorTable.addElement(color);
                }
            }
            return index;
        }

        void setUnicode() {
            int majorIndex;
            String Win95 = "windows 95";
            String Win98 = "windows 98";
            String WinME = "windows me";
            String WinNT = "windows nt";
            String osName = System.getProperty("os.name").toLowerCase();
            String osVersion = System.getProperty("os.version");
            int majorVersion = 0;
            if (osName.startsWith("windows nt") && osVersion != null && (majorIndex = osVersion.indexOf(46)) != -1) {
                osVersion = osVersion.substring(0, majorIndex);
                try {
                    majorVersion = Integer.parseInt(osVersion);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.WriteUnicode = !osName.startsWith("windows 95") && !osName.startsWith("windows 98") && !osName.startsWith("windows me") && (!osName.startsWith("windows nt") || majorVersion > 4);
        }

        void write(String string, int start, int end) {
            int index = start;
            while (index < end) {
                char ch = string.charAt(index);
                if (ch > '\u00ff' && this.WriteUnicode) {
                    if (index > start) {
                        this.write(string.substring(start, index));
                    }
                    this.write("\\u");
                    this.write(Integer.toString((short)ch));
                    this.write(' ');
                    start = index + 1;
                } else if (ch == '}' || ch == '{' || ch == '\\') {
                    if (index > start) {
                        this.write(string.substring(start, index));
                    }
                    this.write('\\');
                    this.write(ch);
                    start = index + 1;
                }
                ++index;
            }
            if (start < end) {
                this.write(string.substring(start, end));
            }
        }

        void writeHeader() {
            StringBuffer header = new StringBuffer();
            FontData fontData = StyledText.this.getFont().getFontData()[0];
            header.append("{\\rtf1\\ansi");
            String cpg = System.getProperty("file.encoding").toLowerCase();
            if (cpg.startsWith("cp") || cpg.startsWith("ms")) {
                cpg = cpg.substring(2, cpg.length());
                header.append("\\ansicpg");
                header.append(cpg);
            }
            header.append("\\uc0\\deff0{\\fonttbl{\\f0\\fnil ");
            header.append(fontData.getName());
            header.append(";}}\n{\\colortbl");
            int i = 0;
            while (i < this.colorTable.size()) {
                Color color = (Color)this.colorTable.elementAt(i);
                header.append("\\red");
                header.append(color.getRed());
                header.append("\\green");
                header.append(color.getGreen());
                header.append("\\blue");
                header.append(color.getBlue());
                header.append(";");
                ++i;
            }
            header.append("}\n{\\f0\\fs");
            header.append(fontData.getHeight() * 2);
            header.append(" ");
            this.write(header.toString(), 0);
        }

        public void writeLine(String line, int lineOffset) {
            StyledTextEvent event;
            StyleRange[] styles = new StyleRange[]{};
            Color lineBackground = null;
            if (this.isClosed()) {
                SWT.error((int)39);
            }
            if ((event = StyledText.this.renderer.getLineStyleData(lineOffset, line)) != null) {
                styles = event.styles;
            }
            if ((event = StyledText.this.renderer.getLineBackgroundData(lineOffset, line)) != null) {
                lineBackground = event.lineBackground;
            }
            if (lineBackground == null) {
                lineBackground = StyledText.this.getBackground();
            }
            this.writeStyledLine(line, lineOffset, styles, lineBackground);
        }

        public void writeLineDelimiter(String lineDelimiter) {
            if (this.isClosed()) {
                SWT.error((int)39);
            }
            this.write(lineDelimiter, 0, lineDelimiter.length());
            this.write("\\par ");
        }

        void writeStyledLine(String line, int lineOffset, StyleRange[] styles, Color lineBackground) {
            int lineLength = line.length();
            int startOffset = this.getStart();
            int endOffset = startOffset + super.getCharCount();
            int lineEndOffset = Math.min(lineLength, endOffset - lineOffset);
            int writeOffset = startOffset - lineOffset;
            if (writeOffset >= line.length()) {
                return;
            }
            int lineIndex = writeOffset > 0 ? writeOffset : 0;
            if (lineBackground != null) {
                this.write("{\\highlight");
                this.write(this.getColorIndex(lineBackground, 1));
                this.write(" ");
            }
            int i = 0;
            while (i < styles.length) {
                StyleRange style = styles[i];
                int start = style.start - lineOffset;
                int end = start + style.length;
                if (end >= writeOffset) {
                    if (start >= lineEndOffset) break;
                    if (lineIndex < start) {
                        this.write(line, lineIndex, start);
                        lineIndex = start;
                    }
                    int colorIndex = this.getColorIndex(style.background, 1);
                    this.write("{\\cf");
                    this.write(this.getColorIndex(style.foreground, 0));
                    if (colorIndex != 1) {
                        this.write("\\highlight");
                        this.write(colorIndex);
                    }
                    if ((style.fontStyle & 1) != 0) {
                        this.write("\\b");
                    }
                    if ((style.fontStyle & 2) != 0) {
                        this.write("\\i");
                    }
                    if (style.underline) {
                        this.write("\\ul");
                    }
                    if (style.strikeout) {
                        this.write("\\strike");
                    }
                    this.write(" ");
                    int copyEnd = Math.min(end, lineEndOffset);
                    copyEnd = Math.max(copyEnd, lineIndex);
                    this.write(line, lineIndex, copyEnd);
                    if ((style.fontStyle & 1) != 0) {
                        this.write("\\b0");
                    }
                    if ((style.fontStyle & 2) != 0) {
                        this.write("\\i0");
                    }
                    if (style.underline) {
                        this.write("\\ul0");
                    }
                    if (style.strikeout) {
                        this.write("\\strike0");
                    }
                    this.write("}");
                    lineIndex = copyEnd;
                }
                ++i;
            }
            if (lineIndex < lineEndOffset) {
                this.write(line, lineIndex, lineEndOffset);
            }
            if (lineBackground != null) {
                this.write("}");
            }
        }
    }

    class TextWriter {
        private StringBuffer buffer;
        private int startOffset;
        private int endOffset;
        private boolean isClosed = false;

        public TextWriter(int start, int length) {
            this.buffer = new StringBuffer(length);
            this.startOffset = start;
            this.endOffset = start + length;
        }

        public void close() {
            if (!this.isClosed) {
                this.isClosed = true;
            }
        }

        public int getCharCount() {
            return this.endOffset - this.startOffset;
        }

        public int getStart() {
            return this.startOffset;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public String toString() {
            return this.buffer.toString();
        }

        void write(String string) {
            this.buffer.append(string);
        }

        void write(String string, int offset) {
            if (offset < 0 || offset > this.buffer.length()) {
                return;
            }
            this.buffer.insert(offset, string);
        }

        void write(int i) {
            this.buffer.append(i);
        }

        void write(char i) {
            this.buffer.append(i);
        }

        public void writeLine(String line, int lineOffset) {
            int copyEnd;
            int lineLength = line.length();
            int writeOffset = this.startOffset - lineOffset;
            if (this.isClosed) {
                SWT.error((int)39);
            }
            if (writeOffset >= lineLength) {
                return;
            }
            int lineIndex = writeOffset > 0 ? writeOffset : 0;
            if (lineIndex < (copyEnd = Math.min(lineLength, this.endOffset - lineOffset))) {
                this.write(line.substring(lineIndex, copyEnd));
            }
        }

        public void writeLineDelimiter(String lineDelimiter) {
            if (this.isClosed) {
                SWT.error((int)39);
            }
            this.write(lineDelimiter);
        }
    }

    static interface LineCache {
        public void calculate(int var1, int var2);

        public int getWidth();

        public void redrawReset(int var1, int var2, boolean var3);

        public void reset(int var1, int var2, boolean var3);

        public void textChanged(int var1, int var2, int var3, int var4, int var5);
    }

    class ContentWidthCache
    implements LineCache {
        StyledText parent;
        int[] lineWidth;
        StyledTextContent content;
        int lineCount;
        int maxWidth;
        int maxWidthLineIndex;

        public ContentWidthCache(StyledText parent, StyledTextContent content) {
            this.parent = parent;
            this.content = content;
            this.lineCount = content.getLineCount();
            this.lineWidth = new int[this.lineCount];
            this.reset(0, this.lineCount, false);
        }

        public void calculate(int startLine, int lineCount) {
            int caretWidth = 0;
            int endLine = startLine + lineCount;
            if (startLine < 0 || endLine > this.lineWidth.length) {
                return;
            }
            caretWidth = StyledText.this.getCaretWidth();
            int i = startLine;
            while (i < endLine) {
                if (this.lineWidth[i] == -1) {
                    String line = this.content.getLine(i);
                    int lineOffset = this.content.getOffsetAtLine(i);
                    this.lineWidth[i] = this.contentWidth(line, lineOffset) + caretWidth;
                }
                if (this.lineWidth[i] > this.maxWidth) {
                    this.maxWidth = this.lineWidth[i];
                    this.maxWidthLineIndex = i;
                }
                ++i;
            }
        }

        void calculateVisible(int startLine, int newLineCount) {
            int topIndex = this.parent.getTopIndex();
            int bottomLine = Math.min(StyledText.this.getPartialBottomIndex(), startLine + newLineCount);
            startLine = Math.max(startLine, topIndex);
            this.calculate(startLine, bottomLine - startLine + 1);
        }

        int contentWidth(String line, int lineOffset) {
            TextLayout layout = StyledText.this.renderer.getTextLayout(line, lineOffset);
            Rectangle rect = layout.getLineBounds(0);
            StyledText.this.renderer.disposeTextLayout(layout);
            return rect.x + rect.width + StyledText.this.leftMargin + StyledText.this.rightMargin;
        }

        void expandLines(int numLines) {
            int size = this.lineWidth.length;
            if (size - this.lineCount >= numLines) {
                return;
            }
            int[] newLines = new int[Math.max(size * 2, size + numLines)];
            System.arraycopy(this.lineWidth, 0, newLines, 0, size);
            this.lineWidth = newLines;
            this.reset(size, this.lineWidth.length - size, false);
        }

        public int getWidth() {
            return this.maxWidth;
        }

        void linesChanged(int startLine, int delta) {
            boolean inserting;
            boolean bl = inserting = delta > 0;
            if (delta == 0) {
                return;
            }
            if (inserting) {
                this.expandLines(delta);
                int i = this.lineCount - 1;
                while (i >= startLine) {
                    this.lineWidth[i + delta] = this.lineWidth[i];
                    --i;
                }
                i = startLine + 1;
                while (i <= startLine + delta && i < this.lineWidth.length) {
                    this.lineWidth[i] = -1;
                    ++i;
                }
                if (this.maxWidthLineIndex >= startLine) {
                    this.maxWidthLineIndex += delta;
                }
            } else {
                int i = startLine - delta;
                while (i < this.lineCount) {
                    this.lineWidth[i + delta] = this.lineWidth[i];
                    ++i;
                }
                if (this.maxWidthLineIndex > startLine && this.maxWidthLineIndex <= startLine - delta) {
                    this.maxWidth = 0;
                    this.maxWidthLineIndex = -1;
                } else if (this.maxWidthLineIndex >= startLine - delta) {
                    this.maxWidthLineIndex += delta;
                }
            }
            this.lineCount += delta;
        }

        public void redrawReset(int startLine, int lineCount, boolean calculateMaxWidth) {
            this.reset(startLine, lineCount, calculateMaxWidth);
        }

        public void reset(int startLine, int lineCount, boolean calculateMaxWidth) {
            int endLine = startLine + lineCount;
            if (startLine < 0 || endLine > this.lineWidth.length) {
                return;
            }
            int i = startLine;
            while (i < endLine) {
                this.lineWidth[i] = -1;
                ++i;
            }
            if (this.maxWidthLineIndex >= startLine && this.maxWidthLineIndex < endLine) {
                this.maxWidth = 0;
                this.maxWidthLineIndex = -1;
                if (calculateMaxWidth) {
                    i = 0;
                    while (i < lineCount) {
                        if (this.lineWidth[i] > this.maxWidth) {
                            this.maxWidth = this.lineWidth[i];
                            this.maxWidthLineIndex = i;
                        }
                        ++i;
                    }
                }
            }
        }

        public void textChanged(int startOffset, int newLineCount, int replaceLineCount, int newCharCount, int replaceCharCount) {
            boolean removedMaxLine;
            int startLine = this.parent.getLineAtOffset(startOffset);
            boolean bl = removedMaxLine = this.maxWidthLineIndex > startLine && this.maxWidthLineIndex <= startLine + replaceLineCount;
            if (startLine == 0 && replaceLineCount == this.lineCount) {
                this.lineCount = newLineCount;
                this.lineWidth = new int[this.lineCount];
                this.reset(0, this.lineCount, false);
                this.maxWidth = 0;
            } else {
                this.linesChanged(startLine, -replaceLineCount);
                this.linesChanged(startLine, newLineCount);
                this.lineWidth[startLine] = -1;
            }
            this.calculateVisible(startLine, newLineCount);
            if (removedMaxLine || this.maxWidthLineIndex != -1 && this.lineWidth[this.maxWidthLineIndex] < this.maxWidth) {
                this.maxWidth = 0;
                int i = 0;
                while (i < this.lineCount) {
                    if (this.lineWidth[i] > this.maxWidth) {
                        this.maxWidth = this.lineWidth[i];
                        this.maxWidthLineIndex = i;
                    }
                    ++i;
                }
            }
        }
    }

    class WordWrapCache
    implements LineCache {
        StyledText parent;
        WrappedContent visualContent;

        public WordWrapCache(StyledText parent, WrappedContent content) {
            this.parent = parent;
            this.visualContent = content;
            this.visualContent.wrapLines();
        }

        public void calculate(int startLine, int lineCount) {
        }

        public int getWidth() {
            return this.parent.getClientArea().width;
        }

        public void redrawReset(int startLine, int lineCount, boolean calculateMaxWidth) {
            if (lineCount == this.visualContent.getLineCount()) {
                this.visualContent.wrapLines();
            } else {
                this.visualContent.reset(startLine, lineCount);
            }
        }

        public void reset(int startLine, int lineCount, boolean calculateMaxWidth) {
            int itemCount = StyledText.this.getPartialBottomIndex() - StyledText.this.topIndex + 1;
            int[] oldLineOffsets = new int[itemCount];
            int i = 0;
            while (i < itemCount) {
                oldLineOffsets[i] = this.visualContent.getOffsetAtLine(i + StyledText.this.topIndex);
                ++i;
            }
            this.redrawReset(startLine, lineCount, calculateMaxWidth);
            if (StyledText.this.getPartialBottomIndex() - StyledText.this.topIndex + 1 != itemCount) {
                this.parent.internalRedraw();
            } else {
                i = 0;
                while (i < itemCount) {
                    if (this.visualContent.getOffsetAtLine(i + StyledText.this.topIndex) != oldLineOffsets[i]) {
                        this.parent.internalRedraw();
                        break;
                    }
                    ++i;
                }
            }
        }

        public void textChanged(int startOffset, int newLineCount, int replaceLineCount, int newCharCount, int replaceCharCount) {
            int lineCount;
            int startLine = this.visualContent.getLineAtOffset(startOffset);
            this.visualContent.textChanged(startOffset, newLineCount, replaceLineCount, newCharCount, replaceCharCount);
            if (StyledText.this.wordWrap && startLine >= (lineCount = StyledText.this.content.getLineCount())) {
                startLine = lineCount - 1;
            }
            if (startLine <= StyledText.this.getPartialBottomIndex()) {
                this.parent.internalRedraw();
            }
        }
    }
}

