/*
 * Decompiled with CFR 0.152.
 */
package jp.sorceforge.mergedoc.jstyle;

import jp.sorceforge.mergedoc.jstyle.JStyleConstants;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JStylePlugin
extends AbstractUIPlugin
implements IStartup {
    private static JStylePlugin plugin;

    public JStylePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static JStylePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"JStyle3.1.2", (String)path);
    }

    public void earlyStartup() {
        this.applySWT();
    }

    public void applySWT() {
        TextLayout.JStyleSWTBridge.lineBreakRGB = this.getRGBPreference("LineBreakPreference");
        TextLayout.JStyleSWTBridge.tabRGB = this.getRGBPreference("TabPreference");
        TextLayout.JStyleSWTBridge.fullWidthSpaceRGB = this.getRGBPreference("FullWidthSpacePreference");
        TextLayout.JStyleSWTBridge.halfWidthSpaceRGB = this.getRGBPreference("HalfWidthSpacePreference");
        TextLayout.JStyleSWTBridge.forceMonospace = this.getBooleanPreference("ForceMonospacePreference");
        StyledText.redrawJStyle();
    }

    private RGB getRGBPreference(String key) {
        try {
            String value;
            IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
            if (store.getBoolean(key + "_SHOW") && (value = store.getString(key + "_COLOR")) != null) {
                return StringConverter.asRGB((String)value);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, this.getBundle().getSymbolicName(), 0, "Unable to get RGB preference. key:" + key, (Throwable)e);
            plugin.getLog().log((IStatus)status);
            return StringConverter.asRGB((String)JStyleConstants.DEFAULT_RGB_STRING);
        }
        return null;
    }

    private boolean getBooleanPreference(String key) {
        IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
        return store.getBoolean(key);
    }
}

